/*
nitroxcalc
Copyright (C) 2015-2024 Salvo "LtWorf" Tomaselli

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

author Salvo "LtWorf" Tomaselli <tiposchi@tiscali.it>
*/

import QtQuick 2.5

import QtQuick.Layouts 1.2


Background {
    GridLayout {
        columns: 2
        anchors.fill: parent

        FormLabel {
            Layout.columnSpan: 2
            text: 'nitroxcalc'
            horizontalAlignment: Text.AlignHCenter
            font.pointSize: 42

            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        FormLabel {
            text: 'Ean:'
            Layout.fillHeight: true
        }

        TextInput {
            id: ean
            inputMethodHints: Qt.ImhDigitsOnly
            text: '21'
            color: 'white'
            font.pointSize: 28
            validator: IntValidator{bottom: 21; top: 40;}
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        FormLabel {
            text: 'Max depth'
            Layout.fillHeight: true
            //Layout.fillWidth: true
        }

        FormLabel {
            text: calc.mod(ean.text)
            Layout.fillHeight: true
        }

        FormLabel {
            text: 'Best depth'
            Layout.fillHeight: true
            //Layout.fillWidth: true
        }

        FormLabel {
            text: calc.bod(ean.text)
            Layout.fillHeight: true
        }

        FormLabel {
            text: 'Depth'
            Layout.fillHeight: true
            //Layout.fillWidth: true
        }

        TextInput {
            id: depth
            text: '15'
            color: 'white'
            inputMethodHints: Qt.ImhDigitsOnly
            font.pointSize: 28
            validator: IntValidator{bottom: 5; top: 66;}
            Layout.fillHeight: true
            Layout.fillWidth: true
        }

        FormLabel {
            text: 'Equiv. depth'
            Layout.fillHeight: true
            //Layout.fillWidth: true
        }

        FormLabel {
            text: calc.ead(ean.text, depth.text)
            Layout.fillHeight: true
        }

    }


}
