<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Frame](./puppeteer.frame.md) &gt; [type](./puppeteer.frame.type.md)

## Frame.type() method

Sends a `keydown`, `keypress`/`input`, and `keyup` event for each character in the text.

<b>Signature:</b>

```typescript
type(selector: string, text: string, options?: {
        delay: number;
    }): Promise<void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  selector | string | the selector for the element to type into. If there are multiple the first will be used. |
|  text | string | text to type into the element |
|  options | { delay: number; } | takes one option, <code>delay</code>, which sets the time to wait between key presses in milliseconds. Defaults to <code>0</code>. |

<b>Returns:</b>

Promise&lt;void&gt;

a promise that resolves when the typing is complete.

## Remarks

To press a special key, like `Control` or `ArrowDown`, use [Keyboard.press()](./puppeteer.keyboard.press.md).

## Example


```js
await frame.type('#mytextarea', 'Hello'); // Types instantly
await frame.type('#mytextarea', 'World', {delay: 100}); // Types slower, like a user

```

