/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.core.component;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.User;
import org.chefproject.exception.EmptyException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.EmptyIterator;
import org.chefproject.util.EnumerationIterator;
import org.chefproject.util.Time;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseResourceProperties
implements ResourceProperties {
    protected Hashtable m_props = new Hashtable();

    public BaseResourceProperties() {
    }

    public BaseResourceProperties(Element el) {
        this();
        NodeList children = el.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Element element;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("property")) {
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                if ("list".equals(element.getAttribute("list"))) {
                    Object current = this.m_props.get(name);
                    if (current == null) {
                        Vector<String> values = new Vector<String>();
                        this.m_props.put(name, values);
                        values.add(value);
                    } else if (current instanceof List) {
                        ((List)current).add(value);
                    } else {
                        Log.warn("chef", this + "construct(el): value set not a list: " + name);
                    }
                } else {
                    this.m_props.put(name, value);
                }
            }
            ++i;
        }
    }

    public Element toXml(Document doc, Stack stack) {
        Element properties = doc.createElement("properties");
        ((Element)stack.peek()).appendChild(properties);
        Enumeration props = this.m_props.keys();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object value = this.m_props.get(name);
            if (value instanceof String) {
                Element propElement = doc.createElement("property");
                properties.appendChild(propElement);
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", (String)value);
                continue;
            }
            if (value instanceof List) {
                Iterator iValues = ((List)value).iterator();
                while (iValues.hasNext()) {
                    Object val = iValues.next();
                    if (val instanceof String) {
                        Element propElement = doc.createElement("property");
                        properties.appendChild(propElement);
                        propElement.setAttribute("name", name);
                        propElement.setAttribute("value", (String)val);
                        propElement.setAttribute("list", "list");
                        continue;
                    }
                    Log.warn("chef", this + ".toXml: in list not string: " + name);
                }
                continue;
            }
            Log.warn("chef", this + ".toXml: not a string, not a value: " + name);
        }
        return properties;
    }

    public Iterator getPropertyNames() {
        if (this.m_props.size() == 0) {
            return new EmptyIterator();
        }
        return new EnumerationIterator(this.m_props.keys());
    }

    public String getProperty(String name) {
        Object value = this.m_props.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public List getPropertyList(String name) {
        Object value = this.m_props.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            Vector rv = new Vector();
            rv.add(value);
            return rv;
        }
        if (value instanceof List) {
            Vector rv = new Vector();
            rv.addAll((List)value);
            return rv;
        }
        return null;
    }

    public boolean isLiveProperty(String name) {
        return name.equals("CHEF:creator") || name.equals("CHEF:modifiedby") || name.equals("DAV:creationdate") || name.equals("DAV:getcontentlength") || name.equals("DAV:getcontenttype") || name.equals("DAV:getlastmodified") || name.equals("CHEF:is-collection");
    }

    public String getPropertyFormatted(String name) {
        String value = this.getProperty(name);
        if (value == null) {
            return "";
        }
        try {
            ContentTypeImageService cts;
            if (name.equals("CHEF:creator") || name.equals("CHEF:modifiedby") || name.equals("CHEF:to")) {
                return this.getUserProperty(name).getDisplayName();
            }
            if (name.equals("DAV:creationdate") || name.equals("DAV:getlastmodified")) {
                return this.getTimeProperty(name).toStringLocalFull();
            }
            if (name.equals("DAV:getcontentlength")) {
                long len = this.getLongProperty(name);
                String[] byteString = new String[]{"KB", "KB", "MB", "GB"};
                int count = 0;
                long newLen = 0L;
                long lenBytesExtra = len;
                while (len > 1024L) {
                    newLen = len / 1024L;
                    lenBytesExtra = len - newLen * 1024L;
                    len = newLen;
                    ++count;
                }
                if (lenBytesExtra >= 512L || lenBytesExtra > 0L && newLen == 0L) {
                    ++newLen;
                }
                return Long.toString(newLen) + " " + byteString[count];
            }
            if (name.equals("DAV:getcontenttype") && (cts = (ContentTypeImageService)((Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME))) != null) {
                return cts.getContentTypeDisplayName(value);
            }
        }
        catch (EmptyException e) {
            return "";
        }
        catch (TypeException e) {
            // empty catch block
        }
        return value;
    }

    public boolean getBooleanProperty(String name) throws EmptyException, TypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EmptyException();
        }
        try {
            return Boolean.valueOf(p);
        }
        catch (Exception any) {
            throw new TypeException(name);
        }
    }

    public long getLongProperty(String name) throws EmptyException, TypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EmptyException();
        }
        try {
            return Long.parseLong(p);
        }
        catch (Exception any) {
            throw new TypeException(name);
        }
    }

    public Time getTimeProperty(String name) throws EmptyException, TypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EmptyException();
        }
        try {
            return new Time(p);
        }
        catch (Exception any) {
            throw new TypeException(name);
        }
    }

    public User getUserProperty(String name) throws EmptyException, TypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EmptyException();
        }
        try {
            return UserDirectoryService.getUser(p);
        }
        catch (Exception any) {
            throw new TypeException(name);
        }
    }

    public String getNamePropCreator() {
        return "CHEF:creator";
    }

    public String getNamePropModifiedBy() {
        return "CHEF:modifiedby";
    }

    public String getNamePropCreationDate() {
        return "DAV:creationdate";
    }

    public String getNamePropDisplayName() {
        return "DAV:displayname";
    }

    public String getNamePropCopyright() {
        return "CHEF:copyright";
    }

    public String getNamePropContentLength() {
        return "DAV:getcontentlength";
    }

    public String getNamePropContentType() {
        return "DAV:getcontenttype";
    }

    public String getNamePropModifiedDate() {
        return "DAV:getlastmodified";
    }

    public String getNamePropIsCollection() {
        return "CHEF:is-collection";
    }

    public String getNamePropCollectionBodyQuota() {
        return "CHEF:collection-body-quota";
    }

    public String getNamePropChatRoom() {
        return "CHEF:chat-room";
    }

    public String getNamePropSiteType() {
        return "CHEF:site-type";
    }

    public String getNamePropTo() {
        return "CHEF:to";
    }

    public String getNamePropDescription() {
        return "CHEF:description";
    }

    public String getNamePropCalendarType() {
        return "CHEF:calendar-type";
    }

    public String getNamePropCalendarLocation() {
        return "CHEF:calendar-location";
    }

    public String getNamePropOpenNewWindow() {
        return "CHEF:open-newwindow";
    }

    public String getNamePropReplyStyle() {
        return "CHEF:discussion-reply-style";
    }

    public String getNamePropNewAssignmentCheckAddDueDate() {
        return "new_assignment_check_add_due_date";
    }

    public String getNamePropNewAssignmentCheckAutoAnnounce() {
        return "new_assignment_check_auto_announce";
    }
}

