/* Autogenerated: '../fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery' --static --use-value-barrier --inline-internal np384 32 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 mul add opp from_montgomery to_montgomery one msat divstep_precomp divstep to_bytes from_bytes selectznz */
/* curve description: np384 */
/* machine_wordsize = 32 (from "32") */
/* requested operations: mul, add, opp, from_montgomery, to_montgomery, one, msat, divstep_precomp, divstep, to_bytes, from_bytes, selectznz */
/* m = 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 (from "0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/*   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) */
/*   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in */
/*                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384 */

#include <stdint.h>
typedef unsigned char fiat_np384_uint1;
typedef signed char fiat_np384_int1;
#ifdef __GNUC__
#  define FIAT_NP384_FIAT_INLINE __inline__
#else
#  define FIAT_NP384_FIAT_INLINE
#endif

/* The type fiat_np384_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_np384_montgomery_domain_field_element[12];

/* The type fiat_np384_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_np384_non_montgomery_domain_field_element[12];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_NP384_NO_ASM) && (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t fiat_np384_value_barrier_u32(uint32_t a) {
  __asm__("" : "+r"(a) : /* no inputs */);
  return a;
}
#else
#  define fiat_np384_value_barrier_u32(x) (x)
#endif


/*
 * The function fiat_np384_addcarryx_u32 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_NP384_FIAT_INLINE void fiat_np384_addcarryx_u32(uint32_t* out1, fiat_np384_uint1* out2, fiat_np384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1;
  uint32_t x2;
  fiat_np384_uint1 x3;
  x1 = ((arg1 + (uint64_t)arg2) + arg3);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (fiat_np384_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_np384_subborrowx_u32 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_NP384_FIAT_INLINE void fiat_np384_subborrowx_u32(uint32_t* out1, fiat_np384_uint1* out2, fiat_np384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1;
  fiat_np384_int1 x2;
  uint32_t x3;
  x1 = ((arg2 - (int64_t)arg1) - arg3);
  x2 = (fiat_np384_int1)(x1 >> 32);
  x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_np384_uint1)(0x0 - x2);
}

/*
 * The function fiat_np384_mulx_u32 is a multiplication, returning the full double-width result.
 *
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static FIAT_NP384_FIAT_INLINE void fiat_np384_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1;
  uint32_t x2;
  uint32_t x3;
  x1 = ((uint64_t)arg1 * arg2);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_np384_cmovznz_u32 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static FIAT_NP384_FIAT_INLINE void fiat_np384_cmovznz_u32(uint32_t* out1, fiat_np384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_np384_uint1 x1;
  uint32_t x2;
  uint32_t x3;
  x1 = (!(!arg1));
  x2 = ((fiat_np384_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  x3 = ((fiat_np384_value_barrier_u32(x2) & arg3) | (fiat_np384_value_barrier_u32((~x2)) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_np384_mul multiplies two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_mul(fiat_np384_montgomery_domain_field_element out1, const fiat_np384_montgomery_domain_field_element arg1, const fiat_np384_montgomery_domain_field_element arg2) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  fiat_np384_uint1 x38;
  uint32_t x39;
  fiat_np384_uint1 x40;
  uint32_t x41;
  fiat_np384_uint1 x42;
  uint32_t x43;
  fiat_np384_uint1 x44;
  uint32_t x45;
  fiat_np384_uint1 x46;
  uint32_t x47;
  fiat_np384_uint1 x48;
  uint32_t x49;
  fiat_np384_uint1 x50;
  uint32_t x51;
  fiat_np384_uint1 x52;
  uint32_t x53;
  fiat_np384_uint1 x54;
  uint32_t x55;
  fiat_np384_uint1 x56;
  uint32_t x57;
  fiat_np384_uint1 x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  uint32_t x85;
  uint32_t x86;
  fiat_np384_uint1 x87;
  uint32_t x88;
  fiat_np384_uint1 x89;
  uint32_t x90;
  fiat_np384_uint1 x91;
  uint32_t x92;
  fiat_np384_uint1 x93;
  uint32_t x94;
  fiat_np384_uint1 x95;
  uint32_t x96;
  fiat_np384_uint1 x97;
  uint32_t x98;
  fiat_np384_uint1 x99;
  uint32_t x100;
  fiat_np384_uint1 x101;
  uint32_t x102;
  fiat_np384_uint1 x103;
  uint32_t x104;
  fiat_np384_uint1 x105;
  uint32_t x106;
  fiat_np384_uint1 x107;
  uint32_t x108;
  uint32_t x109;
  fiat_np384_uint1 x110;
  uint32_t x111;
  fiat_np384_uint1 x112;
  uint32_t x113;
  fiat_np384_uint1 x114;
  uint32_t x115;
  fiat_np384_uint1 x116;
  uint32_t x117;
  fiat_np384_uint1 x118;
  uint32_t x119;
  fiat_np384_uint1 x120;
  uint32_t x121;
  fiat_np384_uint1 x122;
  uint32_t x123;
  fiat_np384_uint1 x124;
  uint32_t x125;
  fiat_np384_uint1 x126;
  uint32_t x127;
  fiat_np384_uint1 x128;
  uint32_t x129;
  fiat_np384_uint1 x130;
  uint32_t x131;
  fiat_np384_uint1 x132;
  uint32_t x133;
  fiat_np384_uint1 x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  uint32_t x140;
  uint32_t x141;
  uint32_t x142;
  uint32_t x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  uint32_t x148;
  uint32_t x149;
  uint32_t x150;
  uint32_t x151;
  uint32_t x152;
  uint32_t x153;
  uint32_t x154;
  uint32_t x155;
  uint32_t x156;
  uint32_t x157;
  uint32_t x158;
  uint32_t x159;
  fiat_np384_uint1 x160;
  uint32_t x161;
  fiat_np384_uint1 x162;
  uint32_t x163;
  fiat_np384_uint1 x164;
  uint32_t x165;
  fiat_np384_uint1 x166;
  uint32_t x167;
  fiat_np384_uint1 x168;
  uint32_t x169;
  fiat_np384_uint1 x170;
  uint32_t x171;
  fiat_np384_uint1 x172;
  uint32_t x173;
  fiat_np384_uint1 x174;
  uint32_t x175;
  fiat_np384_uint1 x176;
  uint32_t x177;
  fiat_np384_uint1 x178;
  uint32_t x179;
  fiat_np384_uint1 x180;
  uint32_t x181;
  uint32_t x182;
  fiat_np384_uint1 x183;
  uint32_t x184;
  fiat_np384_uint1 x185;
  uint32_t x186;
  fiat_np384_uint1 x187;
  uint32_t x188;
  fiat_np384_uint1 x189;
  uint32_t x190;
  fiat_np384_uint1 x191;
  uint32_t x192;
  fiat_np384_uint1 x193;
  uint32_t x194;
  fiat_np384_uint1 x195;
  uint32_t x196;
  fiat_np384_uint1 x197;
  uint32_t x198;
  fiat_np384_uint1 x199;
  uint32_t x200;
  fiat_np384_uint1 x201;
  uint32_t x202;
  fiat_np384_uint1 x203;
  uint32_t x204;
  fiat_np384_uint1 x205;
  uint32_t x206;
  fiat_np384_uint1 x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  uint32_t x225;
  uint32_t x226;
  uint32_t x227;
  uint32_t x228;
  uint32_t x229;
  uint32_t x230;
  uint32_t x231;
  uint32_t x232;
  uint32_t x233;
  uint32_t x234;
  fiat_np384_uint1 x235;
  uint32_t x236;
  fiat_np384_uint1 x237;
  uint32_t x238;
  fiat_np384_uint1 x239;
  uint32_t x240;
  fiat_np384_uint1 x241;
  uint32_t x242;
  fiat_np384_uint1 x243;
  uint32_t x244;
  fiat_np384_uint1 x245;
  uint32_t x246;
  fiat_np384_uint1 x247;
  uint32_t x248;
  fiat_np384_uint1 x249;
  uint32_t x250;
  fiat_np384_uint1 x251;
  uint32_t x252;
  fiat_np384_uint1 x253;
  uint32_t x254;
  fiat_np384_uint1 x255;
  uint32_t x256;
  uint32_t x257;
  fiat_np384_uint1 x258;
  uint32_t x259;
  fiat_np384_uint1 x260;
  uint32_t x261;
  fiat_np384_uint1 x262;
  uint32_t x263;
  fiat_np384_uint1 x264;
  uint32_t x265;
  fiat_np384_uint1 x266;
  uint32_t x267;
  fiat_np384_uint1 x268;
  uint32_t x269;
  fiat_np384_uint1 x270;
  uint32_t x271;
  fiat_np384_uint1 x272;
  uint32_t x273;
  fiat_np384_uint1 x274;
  uint32_t x275;
  fiat_np384_uint1 x276;
  uint32_t x277;
  fiat_np384_uint1 x278;
  uint32_t x279;
  fiat_np384_uint1 x280;
  uint32_t x281;
  fiat_np384_uint1 x282;
  uint32_t x283;
  uint32_t x284;
  uint32_t x285;
  uint32_t x286;
  uint32_t x287;
  uint32_t x288;
  uint32_t x289;
  uint32_t x290;
  uint32_t x291;
  uint32_t x292;
  uint32_t x293;
  uint32_t x294;
  uint32_t x295;
  uint32_t x296;
  uint32_t x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  fiat_np384_uint1 x309;
  uint32_t x310;
  fiat_np384_uint1 x311;
  uint32_t x312;
  fiat_np384_uint1 x313;
  uint32_t x314;
  fiat_np384_uint1 x315;
  uint32_t x316;
  fiat_np384_uint1 x317;
  uint32_t x318;
  fiat_np384_uint1 x319;
  uint32_t x320;
  fiat_np384_uint1 x321;
  uint32_t x322;
  fiat_np384_uint1 x323;
  uint32_t x324;
  fiat_np384_uint1 x325;
  uint32_t x326;
  fiat_np384_uint1 x327;
  uint32_t x328;
  fiat_np384_uint1 x329;
  uint32_t x330;
  uint32_t x331;
  fiat_np384_uint1 x332;
  uint32_t x333;
  fiat_np384_uint1 x334;
  uint32_t x335;
  fiat_np384_uint1 x336;
  uint32_t x337;
  fiat_np384_uint1 x338;
  uint32_t x339;
  fiat_np384_uint1 x340;
  uint32_t x341;
  fiat_np384_uint1 x342;
  uint32_t x343;
  fiat_np384_uint1 x344;
  uint32_t x345;
  fiat_np384_uint1 x346;
  uint32_t x347;
  fiat_np384_uint1 x348;
  uint32_t x349;
  fiat_np384_uint1 x350;
  uint32_t x351;
  fiat_np384_uint1 x352;
  uint32_t x353;
  fiat_np384_uint1 x354;
  uint32_t x355;
  fiat_np384_uint1 x356;
  uint32_t x357;
  uint32_t x358;
  uint32_t x359;
  uint32_t x360;
  uint32_t x361;
  uint32_t x362;
  uint32_t x363;
  uint32_t x364;
  uint32_t x365;
  uint32_t x366;
  uint32_t x367;
  uint32_t x368;
  uint32_t x369;
  uint32_t x370;
  uint32_t x371;
  uint32_t x372;
  uint32_t x373;
  uint32_t x374;
  uint32_t x375;
  uint32_t x376;
  uint32_t x377;
  uint32_t x378;
  uint32_t x379;
  uint32_t x380;
  uint32_t x381;
  uint32_t x382;
  uint32_t x383;
  fiat_np384_uint1 x384;
  uint32_t x385;
  fiat_np384_uint1 x386;
  uint32_t x387;
  fiat_np384_uint1 x388;
  uint32_t x389;
  fiat_np384_uint1 x390;
  uint32_t x391;
  fiat_np384_uint1 x392;
  uint32_t x393;
  fiat_np384_uint1 x394;
  uint32_t x395;
  fiat_np384_uint1 x396;
  uint32_t x397;
  fiat_np384_uint1 x398;
  uint32_t x399;
  fiat_np384_uint1 x400;
  uint32_t x401;
  fiat_np384_uint1 x402;
  uint32_t x403;
  fiat_np384_uint1 x404;
  uint32_t x405;
  uint32_t x406;
  fiat_np384_uint1 x407;
  uint32_t x408;
  fiat_np384_uint1 x409;
  uint32_t x410;
  fiat_np384_uint1 x411;
  uint32_t x412;
  fiat_np384_uint1 x413;
  uint32_t x414;
  fiat_np384_uint1 x415;
  uint32_t x416;
  fiat_np384_uint1 x417;
  uint32_t x418;
  fiat_np384_uint1 x419;
  uint32_t x420;
  fiat_np384_uint1 x421;
  uint32_t x422;
  fiat_np384_uint1 x423;
  uint32_t x424;
  fiat_np384_uint1 x425;
  uint32_t x426;
  fiat_np384_uint1 x427;
  uint32_t x428;
  fiat_np384_uint1 x429;
  uint32_t x430;
  fiat_np384_uint1 x431;
  uint32_t x432;
  uint32_t x433;
  uint32_t x434;
  uint32_t x435;
  uint32_t x436;
  uint32_t x437;
  uint32_t x438;
  uint32_t x439;
  uint32_t x440;
  uint32_t x441;
  uint32_t x442;
  uint32_t x443;
  uint32_t x444;
  uint32_t x445;
  uint32_t x446;
  uint32_t x447;
  uint32_t x448;
  uint32_t x449;
  uint32_t x450;
  uint32_t x451;
  uint32_t x452;
  uint32_t x453;
  uint32_t x454;
  uint32_t x455;
  uint32_t x456;
  uint32_t x457;
  fiat_np384_uint1 x458;
  uint32_t x459;
  fiat_np384_uint1 x460;
  uint32_t x461;
  fiat_np384_uint1 x462;
  uint32_t x463;
  fiat_np384_uint1 x464;
  uint32_t x465;
  fiat_np384_uint1 x466;
  uint32_t x467;
  fiat_np384_uint1 x468;
  uint32_t x469;
  fiat_np384_uint1 x470;
  uint32_t x471;
  fiat_np384_uint1 x472;
  uint32_t x473;
  fiat_np384_uint1 x474;
  uint32_t x475;
  fiat_np384_uint1 x476;
  uint32_t x477;
  fiat_np384_uint1 x478;
  uint32_t x479;
  uint32_t x480;
  fiat_np384_uint1 x481;
  uint32_t x482;
  fiat_np384_uint1 x483;
  uint32_t x484;
  fiat_np384_uint1 x485;
  uint32_t x486;
  fiat_np384_uint1 x487;
  uint32_t x488;
  fiat_np384_uint1 x489;
  uint32_t x490;
  fiat_np384_uint1 x491;
  uint32_t x492;
  fiat_np384_uint1 x493;
  uint32_t x494;
  fiat_np384_uint1 x495;
  uint32_t x496;
  fiat_np384_uint1 x497;
  uint32_t x498;
  fiat_np384_uint1 x499;
  uint32_t x500;
  fiat_np384_uint1 x501;
  uint32_t x502;
  fiat_np384_uint1 x503;
  uint32_t x504;
  fiat_np384_uint1 x505;
  uint32_t x506;
  uint32_t x507;
  uint32_t x508;
  uint32_t x509;
  uint32_t x510;
  uint32_t x511;
  uint32_t x512;
  uint32_t x513;
  uint32_t x514;
  uint32_t x515;
  uint32_t x516;
  uint32_t x517;
  uint32_t x518;
  uint32_t x519;
  uint32_t x520;
  uint32_t x521;
  uint32_t x522;
  uint32_t x523;
  uint32_t x524;
  uint32_t x525;
  uint32_t x526;
  uint32_t x527;
  uint32_t x528;
  uint32_t x529;
  uint32_t x530;
  uint32_t x531;
  uint32_t x532;
  fiat_np384_uint1 x533;
  uint32_t x534;
  fiat_np384_uint1 x535;
  uint32_t x536;
  fiat_np384_uint1 x537;
  uint32_t x538;
  fiat_np384_uint1 x539;
  uint32_t x540;
  fiat_np384_uint1 x541;
  uint32_t x542;
  fiat_np384_uint1 x543;
  uint32_t x544;
  fiat_np384_uint1 x545;
  uint32_t x546;
  fiat_np384_uint1 x547;
  uint32_t x548;
  fiat_np384_uint1 x549;
  uint32_t x550;
  fiat_np384_uint1 x551;
  uint32_t x552;
  fiat_np384_uint1 x553;
  uint32_t x554;
  uint32_t x555;
  fiat_np384_uint1 x556;
  uint32_t x557;
  fiat_np384_uint1 x558;
  uint32_t x559;
  fiat_np384_uint1 x560;
  uint32_t x561;
  fiat_np384_uint1 x562;
  uint32_t x563;
  fiat_np384_uint1 x564;
  uint32_t x565;
  fiat_np384_uint1 x566;
  uint32_t x567;
  fiat_np384_uint1 x568;
  uint32_t x569;
  fiat_np384_uint1 x570;
  uint32_t x571;
  fiat_np384_uint1 x572;
  uint32_t x573;
  fiat_np384_uint1 x574;
  uint32_t x575;
  fiat_np384_uint1 x576;
  uint32_t x577;
  fiat_np384_uint1 x578;
  uint32_t x579;
  fiat_np384_uint1 x580;
  uint32_t x581;
  uint32_t x582;
  uint32_t x583;
  uint32_t x584;
  uint32_t x585;
  uint32_t x586;
  uint32_t x587;
  uint32_t x588;
  uint32_t x589;
  uint32_t x590;
  uint32_t x591;
  uint32_t x592;
  uint32_t x593;
  uint32_t x594;
  uint32_t x595;
  uint32_t x596;
  uint32_t x597;
  uint32_t x598;
  uint32_t x599;
  uint32_t x600;
  uint32_t x601;
  uint32_t x602;
  uint32_t x603;
  uint32_t x604;
  uint32_t x605;
  uint32_t x606;
  fiat_np384_uint1 x607;
  uint32_t x608;
  fiat_np384_uint1 x609;
  uint32_t x610;
  fiat_np384_uint1 x611;
  uint32_t x612;
  fiat_np384_uint1 x613;
  uint32_t x614;
  fiat_np384_uint1 x615;
  uint32_t x616;
  fiat_np384_uint1 x617;
  uint32_t x618;
  fiat_np384_uint1 x619;
  uint32_t x620;
  fiat_np384_uint1 x621;
  uint32_t x622;
  fiat_np384_uint1 x623;
  uint32_t x624;
  fiat_np384_uint1 x625;
  uint32_t x626;
  fiat_np384_uint1 x627;
  uint32_t x628;
  uint32_t x629;
  fiat_np384_uint1 x630;
  uint32_t x631;
  fiat_np384_uint1 x632;
  uint32_t x633;
  fiat_np384_uint1 x634;
  uint32_t x635;
  fiat_np384_uint1 x636;
  uint32_t x637;
  fiat_np384_uint1 x638;
  uint32_t x639;
  fiat_np384_uint1 x640;
  uint32_t x641;
  fiat_np384_uint1 x642;
  uint32_t x643;
  fiat_np384_uint1 x644;
  uint32_t x645;
  fiat_np384_uint1 x646;
  uint32_t x647;
  fiat_np384_uint1 x648;
  uint32_t x649;
  fiat_np384_uint1 x650;
  uint32_t x651;
  fiat_np384_uint1 x652;
  uint32_t x653;
  fiat_np384_uint1 x654;
  uint32_t x655;
  uint32_t x656;
  uint32_t x657;
  uint32_t x658;
  uint32_t x659;
  uint32_t x660;
  uint32_t x661;
  uint32_t x662;
  uint32_t x663;
  uint32_t x664;
  uint32_t x665;
  uint32_t x666;
  uint32_t x667;
  uint32_t x668;
  uint32_t x669;
  uint32_t x670;
  uint32_t x671;
  uint32_t x672;
  uint32_t x673;
  uint32_t x674;
  uint32_t x675;
  uint32_t x676;
  uint32_t x677;
  uint32_t x678;
  uint32_t x679;
  uint32_t x680;
  uint32_t x681;
  fiat_np384_uint1 x682;
  uint32_t x683;
  fiat_np384_uint1 x684;
  uint32_t x685;
  fiat_np384_uint1 x686;
  uint32_t x687;
  fiat_np384_uint1 x688;
  uint32_t x689;
  fiat_np384_uint1 x690;
  uint32_t x691;
  fiat_np384_uint1 x692;
  uint32_t x693;
  fiat_np384_uint1 x694;
  uint32_t x695;
  fiat_np384_uint1 x696;
  uint32_t x697;
  fiat_np384_uint1 x698;
  uint32_t x699;
  fiat_np384_uint1 x700;
  uint32_t x701;
  fiat_np384_uint1 x702;
  uint32_t x703;
  uint32_t x704;
  fiat_np384_uint1 x705;
  uint32_t x706;
  fiat_np384_uint1 x707;
  uint32_t x708;
  fiat_np384_uint1 x709;
  uint32_t x710;
  fiat_np384_uint1 x711;
  uint32_t x712;
  fiat_np384_uint1 x713;
  uint32_t x714;
  fiat_np384_uint1 x715;
  uint32_t x716;
  fiat_np384_uint1 x717;
  uint32_t x718;
  fiat_np384_uint1 x719;
  uint32_t x720;
  fiat_np384_uint1 x721;
  uint32_t x722;
  fiat_np384_uint1 x723;
  uint32_t x724;
  fiat_np384_uint1 x725;
  uint32_t x726;
  fiat_np384_uint1 x727;
  uint32_t x728;
  fiat_np384_uint1 x729;
  uint32_t x730;
  uint32_t x731;
  uint32_t x732;
  uint32_t x733;
  uint32_t x734;
  uint32_t x735;
  uint32_t x736;
  uint32_t x737;
  uint32_t x738;
  uint32_t x739;
  uint32_t x740;
  uint32_t x741;
  uint32_t x742;
  uint32_t x743;
  uint32_t x744;
  uint32_t x745;
  uint32_t x746;
  uint32_t x747;
  uint32_t x748;
  uint32_t x749;
  uint32_t x750;
  uint32_t x751;
  uint32_t x752;
  uint32_t x753;
  uint32_t x754;
  uint32_t x755;
  fiat_np384_uint1 x756;
  uint32_t x757;
  fiat_np384_uint1 x758;
  uint32_t x759;
  fiat_np384_uint1 x760;
  uint32_t x761;
  fiat_np384_uint1 x762;
  uint32_t x763;
  fiat_np384_uint1 x764;
  uint32_t x765;
  fiat_np384_uint1 x766;
  uint32_t x767;
  fiat_np384_uint1 x768;
  uint32_t x769;
  fiat_np384_uint1 x770;
  uint32_t x771;
  fiat_np384_uint1 x772;
  uint32_t x773;
  fiat_np384_uint1 x774;
  uint32_t x775;
  fiat_np384_uint1 x776;
  uint32_t x777;
  uint32_t x778;
  fiat_np384_uint1 x779;
  uint32_t x780;
  fiat_np384_uint1 x781;
  uint32_t x782;
  fiat_np384_uint1 x783;
  uint32_t x784;
  fiat_np384_uint1 x785;
  uint32_t x786;
  fiat_np384_uint1 x787;
  uint32_t x788;
  fiat_np384_uint1 x789;
  uint32_t x790;
  fiat_np384_uint1 x791;
  uint32_t x792;
  fiat_np384_uint1 x793;
  uint32_t x794;
  fiat_np384_uint1 x795;
  uint32_t x796;
  fiat_np384_uint1 x797;
  uint32_t x798;
  fiat_np384_uint1 x799;
  uint32_t x800;
  fiat_np384_uint1 x801;
  uint32_t x802;
  fiat_np384_uint1 x803;
  uint32_t x804;
  uint32_t x805;
  uint32_t x806;
  uint32_t x807;
  uint32_t x808;
  uint32_t x809;
  uint32_t x810;
  uint32_t x811;
  uint32_t x812;
  uint32_t x813;
  uint32_t x814;
  uint32_t x815;
  uint32_t x816;
  uint32_t x817;
  uint32_t x818;
  uint32_t x819;
  uint32_t x820;
  uint32_t x821;
  uint32_t x822;
  uint32_t x823;
  uint32_t x824;
  uint32_t x825;
  uint32_t x826;
  uint32_t x827;
  uint32_t x828;
  uint32_t x829;
  uint32_t x830;
  fiat_np384_uint1 x831;
  uint32_t x832;
  fiat_np384_uint1 x833;
  uint32_t x834;
  fiat_np384_uint1 x835;
  uint32_t x836;
  fiat_np384_uint1 x837;
  uint32_t x838;
  fiat_np384_uint1 x839;
  uint32_t x840;
  fiat_np384_uint1 x841;
  uint32_t x842;
  fiat_np384_uint1 x843;
  uint32_t x844;
  fiat_np384_uint1 x845;
  uint32_t x846;
  fiat_np384_uint1 x847;
  uint32_t x848;
  fiat_np384_uint1 x849;
  uint32_t x850;
  fiat_np384_uint1 x851;
  uint32_t x852;
  uint32_t x853;
  fiat_np384_uint1 x854;
  uint32_t x855;
  fiat_np384_uint1 x856;
  uint32_t x857;
  fiat_np384_uint1 x858;
  uint32_t x859;
  fiat_np384_uint1 x860;
  uint32_t x861;
  fiat_np384_uint1 x862;
  uint32_t x863;
  fiat_np384_uint1 x864;
  uint32_t x865;
  fiat_np384_uint1 x866;
  uint32_t x867;
  fiat_np384_uint1 x868;
  uint32_t x869;
  fiat_np384_uint1 x870;
  uint32_t x871;
  fiat_np384_uint1 x872;
  uint32_t x873;
  fiat_np384_uint1 x874;
  uint32_t x875;
  fiat_np384_uint1 x876;
  uint32_t x877;
  fiat_np384_uint1 x878;
  uint32_t x879;
  uint32_t x880;
  uint32_t x881;
  uint32_t x882;
  uint32_t x883;
  uint32_t x884;
  uint32_t x885;
  uint32_t x886;
  uint32_t x887;
  uint32_t x888;
  uint32_t x889;
  uint32_t x890;
  uint32_t x891;
  uint32_t x892;
  uint32_t x893;
  uint32_t x894;
  uint32_t x895;
  uint32_t x896;
  uint32_t x897;
  uint32_t x898;
  uint32_t x899;
  uint32_t x900;
  uint32_t x901;
  uint32_t x902;
  uint32_t x903;
  uint32_t x904;
  fiat_np384_uint1 x905;
  uint32_t x906;
  fiat_np384_uint1 x907;
  uint32_t x908;
  fiat_np384_uint1 x909;
  uint32_t x910;
  fiat_np384_uint1 x911;
  uint32_t x912;
  fiat_np384_uint1 x913;
  uint32_t x914;
  fiat_np384_uint1 x915;
  uint32_t x916;
  fiat_np384_uint1 x917;
  uint32_t x918;
  fiat_np384_uint1 x919;
  uint32_t x920;
  fiat_np384_uint1 x921;
  uint32_t x922;
  fiat_np384_uint1 x923;
  uint32_t x924;
  fiat_np384_uint1 x925;
  uint32_t x926;
  uint32_t x927;
  fiat_np384_uint1 x928;
  uint32_t x929;
  fiat_np384_uint1 x930;
  uint32_t x931;
  fiat_np384_uint1 x932;
  uint32_t x933;
  fiat_np384_uint1 x934;
  uint32_t x935;
  fiat_np384_uint1 x936;
  uint32_t x937;
  fiat_np384_uint1 x938;
  uint32_t x939;
  fiat_np384_uint1 x940;
  uint32_t x941;
  fiat_np384_uint1 x942;
  uint32_t x943;
  fiat_np384_uint1 x944;
  uint32_t x945;
  fiat_np384_uint1 x946;
  uint32_t x947;
  fiat_np384_uint1 x948;
  uint32_t x949;
  fiat_np384_uint1 x950;
  uint32_t x951;
  fiat_np384_uint1 x952;
  uint32_t x953;
  uint32_t x954;
  uint32_t x955;
  uint32_t x956;
  uint32_t x957;
  uint32_t x958;
  uint32_t x959;
  uint32_t x960;
  uint32_t x961;
  uint32_t x962;
  uint32_t x963;
  uint32_t x964;
  uint32_t x965;
  uint32_t x966;
  uint32_t x967;
  uint32_t x968;
  uint32_t x969;
  uint32_t x970;
  uint32_t x971;
  uint32_t x972;
  uint32_t x973;
  uint32_t x974;
  uint32_t x975;
  uint32_t x976;
  uint32_t x977;
  uint32_t x978;
  uint32_t x979;
  fiat_np384_uint1 x980;
  uint32_t x981;
  fiat_np384_uint1 x982;
  uint32_t x983;
  fiat_np384_uint1 x984;
  uint32_t x985;
  fiat_np384_uint1 x986;
  uint32_t x987;
  fiat_np384_uint1 x988;
  uint32_t x989;
  fiat_np384_uint1 x990;
  uint32_t x991;
  fiat_np384_uint1 x992;
  uint32_t x993;
  fiat_np384_uint1 x994;
  uint32_t x995;
  fiat_np384_uint1 x996;
  uint32_t x997;
  fiat_np384_uint1 x998;
  uint32_t x999;
  fiat_np384_uint1 x1000;
  uint32_t x1001;
  uint32_t x1002;
  fiat_np384_uint1 x1003;
  uint32_t x1004;
  fiat_np384_uint1 x1005;
  uint32_t x1006;
  fiat_np384_uint1 x1007;
  uint32_t x1008;
  fiat_np384_uint1 x1009;
  uint32_t x1010;
  fiat_np384_uint1 x1011;
  uint32_t x1012;
  fiat_np384_uint1 x1013;
  uint32_t x1014;
  fiat_np384_uint1 x1015;
  uint32_t x1016;
  fiat_np384_uint1 x1017;
  uint32_t x1018;
  fiat_np384_uint1 x1019;
  uint32_t x1020;
  fiat_np384_uint1 x1021;
  uint32_t x1022;
  fiat_np384_uint1 x1023;
  uint32_t x1024;
  fiat_np384_uint1 x1025;
  uint32_t x1026;
  fiat_np384_uint1 x1027;
  uint32_t x1028;
  uint32_t x1029;
  uint32_t x1030;
  uint32_t x1031;
  uint32_t x1032;
  uint32_t x1033;
  uint32_t x1034;
  uint32_t x1035;
  uint32_t x1036;
  uint32_t x1037;
  uint32_t x1038;
  uint32_t x1039;
  uint32_t x1040;
  uint32_t x1041;
  uint32_t x1042;
  uint32_t x1043;
  uint32_t x1044;
  uint32_t x1045;
  uint32_t x1046;
  uint32_t x1047;
  uint32_t x1048;
  uint32_t x1049;
  uint32_t x1050;
  uint32_t x1051;
  uint32_t x1052;
  uint32_t x1053;
  fiat_np384_uint1 x1054;
  uint32_t x1055;
  fiat_np384_uint1 x1056;
  uint32_t x1057;
  fiat_np384_uint1 x1058;
  uint32_t x1059;
  fiat_np384_uint1 x1060;
  uint32_t x1061;
  fiat_np384_uint1 x1062;
  uint32_t x1063;
  fiat_np384_uint1 x1064;
  uint32_t x1065;
  fiat_np384_uint1 x1066;
  uint32_t x1067;
  fiat_np384_uint1 x1068;
  uint32_t x1069;
  fiat_np384_uint1 x1070;
  uint32_t x1071;
  fiat_np384_uint1 x1072;
  uint32_t x1073;
  fiat_np384_uint1 x1074;
  uint32_t x1075;
  uint32_t x1076;
  fiat_np384_uint1 x1077;
  uint32_t x1078;
  fiat_np384_uint1 x1079;
  uint32_t x1080;
  fiat_np384_uint1 x1081;
  uint32_t x1082;
  fiat_np384_uint1 x1083;
  uint32_t x1084;
  fiat_np384_uint1 x1085;
  uint32_t x1086;
  fiat_np384_uint1 x1087;
  uint32_t x1088;
  fiat_np384_uint1 x1089;
  uint32_t x1090;
  fiat_np384_uint1 x1091;
  uint32_t x1092;
  fiat_np384_uint1 x1093;
  uint32_t x1094;
  fiat_np384_uint1 x1095;
  uint32_t x1096;
  fiat_np384_uint1 x1097;
  uint32_t x1098;
  fiat_np384_uint1 x1099;
  uint32_t x1100;
  fiat_np384_uint1 x1101;
  uint32_t x1102;
  uint32_t x1103;
  uint32_t x1104;
  uint32_t x1105;
  uint32_t x1106;
  uint32_t x1107;
  uint32_t x1108;
  uint32_t x1109;
  uint32_t x1110;
  uint32_t x1111;
  uint32_t x1112;
  uint32_t x1113;
  uint32_t x1114;
  uint32_t x1115;
  uint32_t x1116;
  uint32_t x1117;
  uint32_t x1118;
  uint32_t x1119;
  uint32_t x1120;
  uint32_t x1121;
  uint32_t x1122;
  uint32_t x1123;
  uint32_t x1124;
  uint32_t x1125;
  uint32_t x1126;
  uint32_t x1127;
  uint32_t x1128;
  fiat_np384_uint1 x1129;
  uint32_t x1130;
  fiat_np384_uint1 x1131;
  uint32_t x1132;
  fiat_np384_uint1 x1133;
  uint32_t x1134;
  fiat_np384_uint1 x1135;
  uint32_t x1136;
  fiat_np384_uint1 x1137;
  uint32_t x1138;
  fiat_np384_uint1 x1139;
  uint32_t x1140;
  fiat_np384_uint1 x1141;
  uint32_t x1142;
  fiat_np384_uint1 x1143;
  uint32_t x1144;
  fiat_np384_uint1 x1145;
  uint32_t x1146;
  fiat_np384_uint1 x1147;
  uint32_t x1148;
  fiat_np384_uint1 x1149;
  uint32_t x1150;
  uint32_t x1151;
  fiat_np384_uint1 x1152;
  uint32_t x1153;
  fiat_np384_uint1 x1154;
  uint32_t x1155;
  fiat_np384_uint1 x1156;
  uint32_t x1157;
  fiat_np384_uint1 x1158;
  uint32_t x1159;
  fiat_np384_uint1 x1160;
  uint32_t x1161;
  fiat_np384_uint1 x1162;
  uint32_t x1163;
  fiat_np384_uint1 x1164;
  uint32_t x1165;
  fiat_np384_uint1 x1166;
  uint32_t x1167;
  fiat_np384_uint1 x1168;
  uint32_t x1169;
  fiat_np384_uint1 x1170;
  uint32_t x1171;
  fiat_np384_uint1 x1172;
  uint32_t x1173;
  fiat_np384_uint1 x1174;
  uint32_t x1175;
  fiat_np384_uint1 x1176;
  uint32_t x1177;
  uint32_t x1178;
  uint32_t x1179;
  uint32_t x1180;
  uint32_t x1181;
  uint32_t x1182;
  uint32_t x1183;
  uint32_t x1184;
  uint32_t x1185;
  uint32_t x1186;
  uint32_t x1187;
  uint32_t x1188;
  uint32_t x1189;
  uint32_t x1190;
  uint32_t x1191;
  uint32_t x1192;
  uint32_t x1193;
  uint32_t x1194;
  uint32_t x1195;
  uint32_t x1196;
  uint32_t x1197;
  uint32_t x1198;
  uint32_t x1199;
  uint32_t x1200;
  uint32_t x1201;
  uint32_t x1202;
  fiat_np384_uint1 x1203;
  uint32_t x1204;
  fiat_np384_uint1 x1205;
  uint32_t x1206;
  fiat_np384_uint1 x1207;
  uint32_t x1208;
  fiat_np384_uint1 x1209;
  uint32_t x1210;
  fiat_np384_uint1 x1211;
  uint32_t x1212;
  fiat_np384_uint1 x1213;
  uint32_t x1214;
  fiat_np384_uint1 x1215;
  uint32_t x1216;
  fiat_np384_uint1 x1217;
  uint32_t x1218;
  fiat_np384_uint1 x1219;
  uint32_t x1220;
  fiat_np384_uint1 x1221;
  uint32_t x1222;
  fiat_np384_uint1 x1223;
  uint32_t x1224;
  uint32_t x1225;
  fiat_np384_uint1 x1226;
  uint32_t x1227;
  fiat_np384_uint1 x1228;
  uint32_t x1229;
  fiat_np384_uint1 x1230;
  uint32_t x1231;
  fiat_np384_uint1 x1232;
  uint32_t x1233;
  fiat_np384_uint1 x1234;
  uint32_t x1235;
  fiat_np384_uint1 x1236;
  uint32_t x1237;
  fiat_np384_uint1 x1238;
  uint32_t x1239;
  fiat_np384_uint1 x1240;
  uint32_t x1241;
  fiat_np384_uint1 x1242;
  uint32_t x1243;
  fiat_np384_uint1 x1244;
  uint32_t x1245;
  fiat_np384_uint1 x1246;
  uint32_t x1247;
  fiat_np384_uint1 x1248;
  uint32_t x1249;
  fiat_np384_uint1 x1250;
  uint32_t x1251;
  uint32_t x1252;
  uint32_t x1253;
  uint32_t x1254;
  uint32_t x1255;
  uint32_t x1256;
  uint32_t x1257;
  uint32_t x1258;
  uint32_t x1259;
  uint32_t x1260;
  uint32_t x1261;
  uint32_t x1262;
  uint32_t x1263;
  uint32_t x1264;
  uint32_t x1265;
  uint32_t x1266;
  uint32_t x1267;
  uint32_t x1268;
  uint32_t x1269;
  uint32_t x1270;
  uint32_t x1271;
  uint32_t x1272;
  uint32_t x1273;
  uint32_t x1274;
  uint32_t x1275;
  uint32_t x1276;
  uint32_t x1277;
  fiat_np384_uint1 x1278;
  uint32_t x1279;
  fiat_np384_uint1 x1280;
  uint32_t x1281;
  fiat_np384_uint1 x1282;
  uint32_t x1283;
  fiat_np384_uint1 x1284;
  uint32_t x1285;
  fiat_np384_uint1 x1286;
  uint32_t x1287;
  fiat_np384_uint1 x1288;
  uint32_t x1289;
  fiat_np384_uint1 x1290;
  uint32_t x1291;
  fiat_np384_uint1 x1292;
  uint32_t x1293;
  fiat_np384_uint1 x1294;
  uint32_t x1295;
  fiat_np384_uint1 x1296;
  uint32_t x1297;
  fiat_np384_uint1 x1298;
  uint32_t x1299;
  uint32_t x1300;
  fiat_np384_uint1 x1301;
  uint32_t x1302;
  fiat_np384_uint1 x1303;
  uint32_t x1304;
  fiat_np384_uint1 x1305;
  uint32_t x1306;
  fiat_np384_uint1 x1307;
  uint32_t x1308;
  fiat_np384_uint1 x1309;
  uint32_t x1310;
  fiat_np384_uint1 x1311;
  uint32_t x1312;
  fiat_np384_uint1 x1313;
  uint32_t x1314;
  fiat_np384_uint1 x1315;
  uint32_t x1316;
  fiat_np384_uint1 x1317;
  uint32_t x1318;
  fiat_np384_uint1 x1319;
  uint32_t x1320;
  fiat_np384_uint1 x1321;
  uint32_t x1322;
  fiat_np384_uint1 x1323;
  uint32_t x1324;
  fiat_np384_uint1 x1325;
  uint32_t x1326;
  uint32_t x1327;
  uint32_t x1328;
  uint32_t x1329;
  uint32_t x1330;
  uint32_t x1331;
  uint32_t x1332;
  uint32_t x1333;
  uint32_t x1334;
  uint32_t x1335;
  uint32_t x1336;
  uint32_t x1337;
  uint32_t x1338;
  uint32_t x1339;
  uint32_t x1340;
  uint32_t x1341;
  uint32_t x1342;
  uint32_t x1343;
  uint32_t x1344;
  uint32_t x1345;
  uint32_t x1346;
  uint32_t x1347;
  uint32_t x1348;
  uint32_t x1349;
  uint32_t x1350;
  uint32_t x1351;
  fiat_np384_uint1 x1352;
  uint32_t x1353;
  fiat_np384_uint1 x1354;
  uint32_t x1355;
  fiat_np384_uint1 x1356;
  uint32_t x1357;
  fiat_np384_uint1 x1358;
  uint32_t x1359;
  fiat_np384_uint1 x1360;
  uint32_t x1361;
  fiat_np384_uint1 x1362;
  uint32_t x1363;
  fiat_np384_uint1 x1364;
  uint32_t x1365;
  fiat_np384_uint1 x1366;
  uint32_t x1367;
  fiat_np384_uint1 x1368;
  uint32_t x1369;
  fiat_np384_uint1 x1370;
  uint32_t x1371;
  fiat_np384_uint1 x1372;
  uint32_t x1373;
  uint32_t x1374;
  fiat_np384_uint1 x1375;
  uint32_t x1376;
  fiat_np384_uint1 x1377;
  uint32_t x1378;
  fiat_np384_uint1 x1379;
  uint32_t x1380;
  fiat_np384_uint1 x1381;
  uint32_t x1382;
  fiat_np384_uint1 x1383;
  uint32_t x1384;
  fiat_np384_uint1 x1385;
  uint32_t x1386;
  fiat_np384_uint1 x1387;
  uint32_t x1388;
  fiat_np384_uint1 x1389;
  uint32_t x1390;
  fiat_np384_uint1 x1391;
  uint32_t x1392;
  fiat_np384_uint1 x1393;
  uint32_t x1394;
  fiat_np384_uint1 x1395;
  uint32_t x1396;
  fiat_np384_uint1 x1397;
  uint32_t x1398;
  fiat_np384_uint1 x1399;
  uint32_t x1400;
  uint32_t x1401;
  uint32_t x1402;
  uint32_t x1403;
  uint32_t x1404;
  uint32_t x1405;
  uint32_t x1406;
  uint32_t x1407;
  uint32_t x1408;
  uint32_t x1409;
  uint32_t x1410;
  uint32_t x1411;
  uint32_t x1412;
  uint32_t x1413;
  uint32_t x1414;
  uint32_t x1415;
  uint32_t x1416;
  uint32_t x1417;
  uint32_t x1418;
  uint32_t x1419;
  uint32_t x1420;
  uint32_t x1421;
  uint32_t x1422;
  uint32_t x1423;
  uint32_t x1424;
  uint32_t x1425;
  uint32_t x1426;
  fiat_np384_uint1 x1427;
  uint32_t x1428;
  fiat_np384_uint1 x1429;
  uint32_t x1430;
  fiat_np384_uint1 x1431;
  uint32_t x1432;
  fiat_np384_uint1 x1433;
  uint32_t x1434;
  fiat_np384_uint1 x1435;
  uint32_t x1436;
  fiat_np384_uint1 x1437;
  uint32_t x1438;
  fiat_np384_uint1 x1439;
  uint32_t x1440;
  fiat_np384_uint1 x1441;
  uint32_t x1442;
  fiat_np384_uint1 x1443;
  uint32_t x1444;
  fiat_np384_uint1 x1445;
  uint32_t x1446;
  fiat_np384_uint1 x1447;
  uint32_t x1448;
  uint32_t x1449;
  fiat_np384_uint1 x1450;
  uint32_t x1451;
  fiat_np384_uint1 x1452;
  uint32_t x1453;
  fiat_np384_uint1 x1454;
  uint32_t x1455;
  fiat_np384_uint1 x1456;
  uint32_t x1457;
  fiat_np384_uint1 x1458;
  uint32_t x1459;
  fiat_np384_uint1 x1460;
  uint32_t x1461;
  fiat_np384_uint1 x1462;
  uint32_t x1463;
  fiat_np384_uint1 x1464;
  uint32_t x1465;
  fiat_np384_uint1 x1466;
  uint32_t x1467;
  fiat_np384_uint1 x1468;
  uint32_t x1469;
  fiat_np384_uint1 x1470;
  uint32_t x1471;
  fiat_np384_uint1 x1472;
  uint32_t x1473;
  fiat_np384_uint1 x1474;
  uint32_t x1475;
  uint32_t x1476;
  uint32_t x1477;
  uint32_t x1478;
  uint32_t x1479;
  uint32_t x1480;
  uint32_t x1481;
  uint32_t x1482;
  uint32_t x1483;
  uint32_t x1484;
  uint32_t x1485;
  uint32_t x1486;
  uint32_t x1487;
  uint32_t x1488;
  uint32_t x1489;
  uint32_t x1490;
  uint32_t x1491;
  uint32_t x1492;
  uint32_t x1493;
  uint32_t x1494;
  uint32_t x1495;
  uint32_t x1496;
  uint32_t x1497;
  uint32_t x1498;
  uint32_t x1499;
  uint32_t x1500;
  fiat_np384_uint1 x1501;
  uint32_t x1502;
  fiat_np384_uint1 x1503;
  uint32_t x1504;
  fiat_np384_uint1 x1505;
  uint32_t x1506;
  fiat_np384_uint1 x1507;
  uint32_t x1508;
  fiat_np384_uint1 x1509;
  uint32_t x1510;
  fiat_np384_uint1 x1511;
  uint32_t x1512;
  fiat_np384_uint1 x1513;
  uint32_t x1514;
  fiat_np384_uint1 x1515;
  uint32_t x1516;
  fiat_np384_uint1 x1517;
  uint32_t x1518;
  fiat_np384_uint1 x1519;
  uint32_t x1520;
  fiat_np384_uint1 x1521;
  uint32_t x1522;
  uint32_t x1523;
  fiat_np384_uint1 x1524;
  uint32_t x1525;
  fiat_np384_uint1 x1526;
  uint32_t x1527;
  fiat_np384_uint1 x1528;
  uint32_t x1529;
  fiat_np384_uint1 x1530;
  uint32_t x1531;
  fiat_np384_uint1 x1532;
  uint32_t x1533;
  fiat_np384_uint1 x1534;
  uint32_t x1535;
  fiat_np384_uint1 x1536;
  uint32_t x1537;
  fiat_np384_uint1 x1538;
  uint32_t x1539;
  fiat_np384_uint1 x1540;
  uint32_t x1541;
  fiat_np384_uint1 x1542;
  uint32_t x1543;
  fiat_np384_uint1 x1544;
  uint32_t x1545;
  fiat_np384_uint1 x1546;
  uint32_t x1547;
  fiat_np384_uint1 x1548;
  uint32_t x1549;
  uint32_t x1550;
  uint32_t x1551;
  uint32_t x1552;
  uint32_t x1553;
  uint32_t x1554;
  uint32_t x1555;
  uint32_t x1556;
  uint32_t x1557;
  uint32_t x1558;
  uint32_t x1559;
  uint32_t x1560;
  uint32_t x1561;
  uint32_t x1562;
  uint32_t x1563;
  uint32_t x1564;
  uint32_t x1565;
  uint32_t x1566;
  uint32_t x1567;
  uint32_t x1568;
  uint32_t x1569;
  uint32_t x1570;
  uint32_t x1571;
  uint32_t x1572;
  uint32_t x1573;
  uint32_t x1574;
  uint32_t x1575;
  fiat_np384_uint1 x1576;
  uint32_t x1577;
  fiat_np384_uint1 x1578;
  uint32_t x1579;
  fiat_np384_uint1 x1580;
  uint32_t x1581;
  fiat_np384_uint1 x1582;
  uint32_t x1583;
  fiat_np384_uint1 x1584;
  uint32_t x1585;
  fiat_np384_uint1 x1586;
  uint32_t x1587;
  fiat_np384_uint1 x1588;
  uint32_t x1589;
  fiat_np384_uint1 x1590;
  uint32_t x1591;
  fiat_np384_uint1 x1592;
  uint32_t x1593;
  fiat_np384_uint1 x1594;
  uint32_t x1595;
  fiat_np384_uint1 x1596;
  uint32_t x1597;
  uint32_t x1598;
  fiat_np384_uint1 x1599;
  uint32_t x1600;
  fiat_np384_uint1 x1601;
  uint32_t x1602;
  fiat_np384_uint1 x1603;
  uint32_t x1604;
  fiat_np384_uint1 x1605;
  uint32_t x1606;
  fiat_np384_uint1 x1607;
  uint32_t x1608;
  fiat_np384_uint1 x1609;
  uint32_t x1610;
  fiat_np384_uint1 x1611;
  uint32_t x1612;
  fiat_np384_uint1 x1613;
  uint32_t x1614;
  fiat_np384_uint1 x1615;
  uint32_t x1616;
  fiat_np384_uint1 x1617;
  uint32_t x1618;
  fiat_np384_uint1 x1619;
  uint32_t x1620;
  fiat_np384_uint1 x1621;
  uint32_t x1622;
  fiat_np384_uint1 x1623;
  uint32_t x1624;
  uint32_t x1625;
  uint32_t x1626;
  uint32_t x1627;
  uint32_t x1628;
  uint32_t x1629;
  uint32_t x1630;
  uint32_t x1631;
  uint32_t x1632;
  uint32_t x1633;
  uint32_t x1634;
  uint32_t x1635;
  uint32_t x1636;
  uint32_t x1637;
  uint32_t x1638;
  uint32_t x1639;
  uint32_t x1640;
  uint32_t x1641;
  uint32_t x1642;
  uint32_t x1643;
  uint32_t x1644;
  uint32_t x1645;
  uint32_t x1646;
  uint32_t x1647;
  uint32_t x1648;
  uint32_t x1649;
  fiat_np384_uint1 x1650;
  uint32_t x1651;
  fiat_np384_uint1 x1652;
  uint32_t x1653;
  fiat_np384_uint1 x1654;
  uint32_t x1655;
  fiat_np384_uint1 x1656;
  uint32_t x1657;
  fiat_np384_uint1 x1658;
  uint32_t x1659;
  fiat_np384_uint1 x1660;
  uint32_t x1661;
  fiat_np384_uint1 x1662;
  uint32_t x1663;
  fiat_np384_uint1 x1664;
  uint32_t x1665;
  fiat_np384_uint1 x1666;
  uint32_t x1667;
  fiat_np384_uint1 x1668;
  uint32_t x1669;
  fiat_np384_uint1 x1670;
  uint32_t x1671;
  uint32_t x1672;
  fiat_np384_uint1 x1673;
  uint32_t x1674;
  fiat_np384_uint1 x1675;
  uint32_t x1676;
  fiat_np384_uint1 x1677;
  uint32_t x1678;
  fiat_np384_uint1 x1679;
  uint32_t x1680;
  fiat_np384_uint1 x1681;
  uint32_t x1682;
  fiat_np384_uint1 x1683;
  uint32_t x1684;
  fiat_np384_uint1 x1685;
  uint32_t x1686;
  fiat_np384_uint1 x1687;
  uint32_t x1688;
  fiat_np384_uint1 x1689;
  uint32_t x1690;
  fiat_np384_uint1 x1691;
  uint32_t x1692;
  fiat_np384_uint1 x1693;
  uint32_t x1694;
  fiat_np384_uint1 x1695;
  uint32_t x1696;
  fiat_np384_uint1 x1697;
  uint32_t x1698;
  uint32_t x1699;
  uint32_t x1700;
  uint32_t x1701;
  uint32_t x1702;
  uint32_t x1703;
  uint32_t x1704;
  uint32_t x1705;
  uint32_t x1706;
  uint32_t x1707;
  uint32_t x1708;
  uint32_t x1709;
  uint32_t x1710;
  uint32_t x1711;
  uint32_t x1712;
  uint32_t x1713;
  uint32_t x1714;
  uint32_t x1715;
  uint32_t x1716;
  uint32_t x1717;
  uint32_t x1718;
  uint32_t x1719;
  uint32_t x1720;
  uint32_t x1721;
  uint32_t x1722;
  uint32_t x1723;
  uint32_t x1724;
  fiat_np384_uint1 x1725;
  uint32_t x1726;
  fiat_np384_uint1 x1727;
  uint32_t x1728;
  fiat_np384_uint1 x1729;
  uint32_t x1730;
  fiat_np384_uint1 x1731;
  uint32_t x1732;
  fiat_np384_uint1 x1733;
  uint32_t x1734;
  fiat_np384_uint1 x1735;
  uint32_t x1736;
  fiat_np384_uint1 x1737;
  uint32_t x1738;
  fiat_np384_uint1 x1739;
  uint32_t x1740;
  fiat_np384_uint1 x1741;
  uint32_t x1742;
  fiat_np384_uint1 x1743;
  uint32_t x1744;
  fiat_np384_uint1 x1745;
  uint32_t x1746;
  uint32_t x1747;
  fiat_np384_uint1 x1748;
  uint32_t x1749;
  fiat_np384_uint1 x1750;
  uint32_t x1751;
  fiat_np384_uint1 x1752;
  uint32_t x1753;
  fiat_np384_uint1 x1754;
  uint32_t x1755;
  fiat_np384_uint1 x1756;
  uint32_t x1757;
  fiat_np384_uint1 x1758;
  uint32_t x1759;
  fiat_np384_uint1 x1760;
  uint32_t x1761;
  fiat_np384_uint1 x1762;
  uint32_t x1763;
  fiat_np384_uint1 x1764;
  uint32_t x1765;
  fiat_np384_uint1 x1766;
  uint32_t x1767;
  fiat_np384_uint1 x1768;
  uint32_t x1769;
  fiat_np384_uint1 x1770;
  uint32_t x1771;
  fiat_np384_uint1 x1772;
  uint32_t x1773;
  uint32_t x1774;
  fiat_np384_uint1 x1775;
  uint32_t x1776;
  fiat_np384_uint1 x1777;
  uint32_t x1778;
  fiat_np384_uint1 x1779;
  uint32_t x1780;
  fiat_np384_uint1 x1781;
  uint32_t x1782;
  fiat_np384_uint1 x1783;
  uint32_t x1784;
  fiat_np384_uint1 x1785;
  uint32_t x1786;
  fiat_np384_uint1 x1787;
  uint32_t x1788;
  fiat_np384_uint1 x1789;
  uint32_t x1790;
  fiat_np384_uint1 x1791;
  uint32_t x1792;
  fiat_np384_uint1 x1793;
  uint32_t x1794;
  fiat_np384_uint1 x1795;
  uint32_t x1796;
  fiat_np384_uint1 x1797;
  uint32_t x1798;
  fiat_np384_uint1 x1799;
  uint32_t x1800;
  uint32_t x1801;
  uint32_t x1802;
  uint32_t x1803;
  uint32_t x1804;
  uint32_t x1805;
  uint32_t x1806;
  uint32_t x1807;
  uint32_t x1808;
  uint32_t x1809;
  uint32_t x1810;
  uint32_t x1811;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[7]);
  x8 = (arg1[8]);
  x9 = (arg1[9]);
  x10 = (arg1[10]);
  x11 = (arg1[11]);
  x12 = (arg1[0]);
  fiat_np384_mulx_u32(&x13, &x14, x12, (arg2[11]));
  fiat_np384_mulx_u32(&x15, &x16, x12, (arg2[10]));
  fiat_np384_mulx_u32(&x17, &x18, x12, (arg2[9]));
  fiat_np384_mulx_u32(&x19, &x20, x12, (arg2[8]));
  fiat_np384_mulx_u32(&x21, &x22, x12, (arg2[7]));
  fiat_np384_mulx_u32(&x23, &x24, x12, (arg2[6]));
  fiat_np384_mulx_u32(&x25, &x26, x12, (arg2[5]));
  fiat_np384_mulx_u32(&x27, &x28, x12, (arg2[4]));
  fiat_np384_mulx_u32(&x29, &x30, x12, (arg2[3]));
  fiat_np384_mulx_u32(&x31, &x32, x12, (arg2[2]));
  fiat_np384_mulx_u32(&x33, &x34, x12, (arg2[1]));
  fiat_np384_mulx_u32(&x35, &x36, x12, (arg2[0]));
  fiat_np384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  fiat_np384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  fiat_np384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  fiat_np384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  fiat_np384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  fiat_np384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  fiat_np384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  fiat_np384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  fiat_np384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  fiat_np384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  fiat_np384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  x59 = (x58 + x14);
  fiat_np384_mulx_u32(&x60, &x61, x35, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x62, &x63, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x64, &x65, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x66, &x67, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x68, &x69, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x70, &x71, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x72, &x73, x60, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x74, &x75, x60, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x76, &x77, x60, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x78, &x79, x60, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x80, &x81, x60, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x82, &x83, x60, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x84, &x85, x60, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x86, &x87, 0x0, x85, x82);
  fiat_np384_addcarryx_u32(&x88, &x89, x87, x83, x80);
  fiat_np384_addcarryx_u32(&x90, &x91, x89, x81, x78);
  fiat_np384_addcarryx_u32(&x92, &x93, x91, x79, x76);
  fiat_np384_addcarryx_u32(&x94, &x95, x93, x77, x74);
  fiat_np384_addcarryx_u32(&x96, &x97, x95, x75, x72);
  fiat_np384_addcarryx_u32(&x98, &x99, x97, x73, x70);
  fiat_np384_addcarryx_u32(&x100, &x101, x99, x71, x68);
  fiat_np384_addcarryx_u32(&x102, &x103, x101, x69, x66);
  fiat_np384_addcarryx_u32(&x104, &x105, x103, x67, x64);
  fiat_np384_addcarryx_u32(&x106, &x107, x105, x65, x62);
  x108 = (x107 + x63);
  fiat_np384_addcarryx_u32(&x109, &x110, 0x0, x35, x84);
  fiat_np384_addcarryx_u32(&x111, &x112, x110, x37, x86);
  fiat_np384_addcarryx_u32(&x113, &x114, x112, x39, x88);
  fiat_np384_addcarryx_u32(&x115, &x116, x114, x41, x90);
  fiat_np384_addcarryx_u32(&x117, &x118, x116, x43, x92);
  fiat_np384_addcarryx_u32(&x119, &x120, x118, x45, x94);
  fiat_np384_addcarryx_u32(&x121, &x122, x120, x47, x96);
  fiat_np384_addcarryx_u32(&x123, &x124, x122, x49, x98);
  fiat_np384_addcarryx_u32(&x125, &x126, x124, x51, x100);
  fiat_np384_addcarryx_u32(&x127, &x128, x126, x53, x102);
  fiat_np384_addcarryx_u32(&x129, &x130, x128, x55, x104);
  fiat_np384_addcarryx_u32(&x131, &x132, x130, x57, x106);
  fiat_np384_addcarryx_u32(&x133, &x134, x132, x59, x108);
  fiat_np384_mulx_u32(&x135, &x136, x1, (arg2[11]));
  fiat_np384_mulx_u32(&x137, &x138, x1, (arg2[10]));
  fiat_np384_mulx_u32(&x139, &x140, x1, (arg2[9]));
  fiat_np384_mulx_u32(&x141, &x142, x1, (arg2[8]));
  fiat_np384_mulx_u32(&x143, &x144, x1, (arg2[7]));
  fiat_np384_mulx_u32(&x145, &x146, x1, (arg2[6]));
  fiat_np384_mulx_u32(&x147, &x148, x1, (arg2[5]));
  fiat_np384_mulx_u32(&x149, &x150, x1, (arg2[4]));
  fiat_np384_mulx_u32(&x151, &x152, x1, (arg2[3]));
  fiat_np384_mulx_u32(&x153, &x154, x1, (arg2[2]));
  fiat_np384_mulx_u32(&x155, &x156, x1, (arg2[1]));
  fiat_np384_mulx_u32(&x157, &x158, x1, (arg2[0]));
  fiat_np384_addcarryx_u32(&x159, &x160, 0x0, x158, x155);
  fiat_np384_addcarryx_u32(&x161, &x162, x160, x156, x153);
  fiat_np384_addcarryx_u32(&x163, &x164, x162, x154, x151);
  fiat_np384_addcarryx_u32(&x165, &x166, x164, x152, x149);
  fiat_np384_addcarryx_u32(&x167, &x168, x166, x150, x147);
  fiat_np384_addcarryx_u32(&x169, &x170, x168, x148, x145);
  fiat_np384_addcarryx_u32(&x171, &x172, x170, x146, x143);
  fiat_np384_addcarryx_u32(&x173, &x174, x172, x144, x141);
  fiat_np384_addcarryx_u32(&x175, &x176, x174, x142, x139);
  fiat_np384_addcarryx_u32(&x177, &x178, x176, x140, x137);
  fiat_np384_addcarryx_u32(&x179, &x180, x178, x138, x135);
  x181 = (x180 + x136);
  fiat_np384_addcarryx_u32(&x182, &x183, 0x0, x111, x157);
  fiat_np384_addcarryx_u32(&x184, &x185, x183, x113, x159);
  fiat_np384_addcarryx_u32(&x186, &x187, x185, x115, x161);
  fiat_np384_addcarryx_u32(&x188, &x189, x187, x117, x163);
  fiat_np384_addcarryx_u32(&x190, &x191, x189, x119, x165);
  fiat_np384_addcarryx_u32(&x192, &x193, x191, x121, x167);
  fiat_np384_addcarryx_u32(&x194, &x195, x193, x123, x169);
  fiat_np384_addcarryx_u32(&x196, &x197, x195, x125, x171);
  fiat_np384_addcarryx_u32(&x198, &x199, x197, x127, x173);
  fiat_np384_addcarryx_u32(&x200, &x201, x199, x129, x175);
  fiat_np384_addcarryx_u32(&x202, &x203, x201, x131, x177);
  fiat_np384_addcarryx_u32(&x204, &x205, x203, x133, x179);
  fiat_np384_addcarryx_u32(&x206, &x207, x205, x134, x181);
  fiat_np384_mulx_u32(&x208, &x209, x182, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x210, &x211, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x212, &x213, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x214, &x215, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x216, &x217, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x218, &x219, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x220, &x221, x208, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x222, &x223, x208, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x224, &x225, x208, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x226, &x227, x208, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x228, &x229, x208, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x230, &x231, x208, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x232, &x233, x208, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x234, &x235, 0x0, x233, x230);
  fiat_np384_addcarryx_u32(&x236, &x237, x235, x231, x228);
  fiat_np384_addcarryx_u32(&x238, &x239, x237, x229, x226);
  fiat_np384_addcarryx_u32(&x240, &x241, x239, x227, x224);
  fiat_np384_addcarryx_u32(&x242, &x243, x241, x225, x222);
  fiat_np384_addcarryx_u32(&x244, &x245, x243, x223, x220);
  fiat_np384_addcarryx_u32(&x246, &x247, x245, x221, x218);
  fiat_np384_addcarryx_u32(&x248, &x249, x247, x219, x216);
  fiat_np384_addcarryx_u32(&x250, &x251, x249, x217, x214);
  fiat_np384_addcarryx_u32(&x252, &x253, x251, x215, x212);
  fiat_np384_addcarryx_u32(&x254, &x255, x253, x213, x210);
  x256 = (x255 + x211);
  fiat_np384_addcarryx_u32(&x257, &x258, 0x0, x182, x232);
  fiat_np384_addcarryx_u32(&x259, &x260, x258, x184, x234);
  fiat_np384_addcarryx_u32(&x261, &x262, x260, x186, x236);
  fiat_np384_addcarryx_u32(&x263, &x264, x262, x188, x238);
  fiat_np384_addcarryx_u32(&x265, &x266, x264, x190, x240);
  fiat_np384_addcarryx_u32(&x267, &x268, x266, x192, x242);
  fiat_np384_addcarryx_u32(&x269, &x270, x268, x194, x244);
  fiat_np384_addcarryx_u32(&x271, &x272, x270, x196, x246);
  fiat_np384_addcarryx_u32(&x273, &x274, x272, x198, x248);
  fiat_np384_addcarryx_u32(&x275, &x276, x274, x200, x250);
  fiat_np384_addcarryx_u32(&x277, &x278, x276, x202, x252);
  fiat_np384_addcarryx_u32(&x279, &x280, x278, x204, x254);
  fiat_np384_addcarryx_u32(&x281, &x282, x280, x206, x256);
  x283 = ((uint32_t)x282 + x207);
  fiat_np384_mulx_u32(&x284, &x285, x2, (arg2[11]));
  fiat_np384_mulx_u32(&x286, &x287, x2, (arg2[10]));
  fiat_np384_mulx_u32(&x288, &x289, x2, (arg2[9]));
  fiat_np384_mulx_u32(&x290, &x291, x2, (arg2[8]));
  fiat_np384_mulx_u32(&x292, &x293, x2, (arg2[7]));
  fiat_np384_mulx_u32(&x294, &x295, x2, (arg2[6]));
  fiat_np384_mulx_u32(&x296, &x297, x2, (arg2[5]));
  fiat_np384_mulx_u32(&x298, &x299, x2, (arg2[4]));
  fiat_np384_mulx_u32(&x300, &x301, x2, (arg2[3]));
  fiat_np384_mulx_u32(&x302, &x303, x2, (arg2[2]));
  fiat_np384_mulx_u32(&x304, &x305, x2, (arg2[1]));
  fiat_np384_mulx_u32(&x306, &x307, x2, (arg2[0]));
  fiat_np384_addcarryx_u32(&x308, &x309, 0x0, x307, x304);
  fiat_np384_addcarryx_u32(&x310, &x311, x309, x305, x302);
  fiat_np384_addcarryx_u32(&x312, &x313, x311, x303, x300);
  fiat_np384_addcarryx_u32(&x314, &x315, x313, x301, x298);
  fiat_np384_addcarryx_u32(&x316, &x317, x315, x299, x296);
  fiat_np384_addcarryx_u32(&x318, &x319, x317, x297, x294);
  fiat_np384_addcarryx_u32(&x320, &x321, x319, x295, x292);
  fiat_np384_addcarryx_u32(&x322, &x323, x321, x293, x290);
  fiat_np384_addcarryx_u32(&x324, &x325, x323, x291, x288);
  fiat_np384_addcarryx_u32(&x326, &x327, x325, x289, x286);
  fiat_np384_addcarryx_u32(&x328, &x329, x327, x287, x284);
  x330 = (x329 + x285);
  fiat_np384_addcarryx_u32(&x331, &x332, 0x0, x259, x306);
  fiat_np384_addcarryx_u32(&x333, &x334, x332, x261, x308);
  fiat_np384_addcarryx_u32(&x335, &x336, x334, x263, x310);
  fiat_np384_addcarryx_u32(&x337, &x338, x336, x265, x312);
  fiat_np384_addcarryx_u32(&x339, &x340, x338, x267, x314);
  fiat_np384_addcarryx_u32(&x341, &x342, x340, x269, x316);
  fiat_np384_addcarryx_u32(&x343, &x344, x342, x271, x318);
  fiat_np384_addcarryx_u32(&x345, &x346, x344, x273, x320);
  fiat_np384_addcarryx_u32(&x347, &x348, x346, x275, x322);
  fiat_np384_addcarryx_u32(&x349, &x350, x348, x277, x324);
  fiat_np384_addcarryx_u32(&x351, &x352, x350, x279, x326);
  fiat_np384_addcarryx_u32(&x353, &x354, x352, x281, x328);
  fiat_np384_addcarryx_u32(&x355, &x356, x354, x283, x330);
  fiat_np384_mulx_u32(&x357, &x358, x331, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x359, &x360, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x361, &x362, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x363, &x364, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x365, &x366, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x367, &x368, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x369, &x370, x357, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x371, &x372, x357, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x373, &x374, x357, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x375, &x376, x357, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x377, &x378, x357, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x379, &x380, x357, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x381, &x382, x357, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x383, &x384, 0x0, x382, x379);
  fiat_np384_addcarryx_u32(&x385, &x386, x384, x380, x377);
  fiat_np384_addcarryx_u32(&x387, &x388, x386, x378, x375);
  fiat_np384_addcarryx_u32(&x389, &x390, x388, x376, x373);
  fiat_np384_addcarryx_u32(&x391, &x392, x390, x374, x371);
  fiat_np384_addcarryx_u32(&x393, &x394, x392, x372, x369);
  fiat_np384_addcarryx_u32(&x395, &x396, x394, x370, x367);
  fiat_np384_addcarryx_u32(&x397, &x398, x396, x368, x365);
  fiat_np384_addcarryx_u32(&x399, &x400, x398, x366, x363);
  fiat_np384_addcarryx_u32(&x401, &x402, x400, x364, x361);
  fiat_np384_addcarryx_u32(&x403, &x404, x402, x362, x359);
  x405 = (x404 + x360);
  fiat_np384_addcarryx_u32(&x406, &x407, 0x0, x331, x381);
  fiat_np384_addcarryx_u32(&x408, &x409, x407, x333, x383);
  fiat_np384_addcarryx_u32(&x410, &x411, x409, x335, x385);
  fiat_np384_addcarryx_u32(&x412, &x413, x411, x337, x387);
  fiat_np384_addcarryx_u32(&x414, &x415, x413, x339, x389);
  fiat_np384_addcarryx_u32(&x416, &x417, x415, x341, x391);
  fiat_np384_addcarryx_u32(&x418, &x419, x417, x343, x393);
  fiat_np384_addcarryx_u32(&x420, &x421, x419, x345, x395);
  fiat_np384_addcarryx_u32(&x422, &x423, x421, x347, x397);
  fiat_np384_addcarryx_u32(&x424, &x425, x423, x349, x399);
  fiat_np384_addcarryx_u32(&x426, &x427, x425, x351, x401);
  fiat_np384_addcarryx_u32(&x428, &x429, x427, x353, x403);
  fiat_np384_addcarryx_u32(&x430, &x431, x429, x355, x405);
  x432 = ((uint32_t)x431 + x356);
  fiat_np384_mulx_u32(&x433, &x434, x3, (arg2[11]));
  fiat_np384_mulx_u32(&x435, &x436, x3, (arg2[10]));
  fiat_np384_mulx_u32(&x437, &x438, x3, (arg2[9]));
  fiat_np384_mulx_u32(&x439, &x440, x3, (arg2[8]));
  fiat_np384_mulx_u32(&x441, &x442, x3, (arg2[7]));
  fiat_np384_mulx_u32(&x443, &x444, x3, (arg2[6]));
  fiat_np384_mulx_u32(&x445, &x446, x3, (arg2[5]));
  fiat_np384_mulx_u32(&x447, &x448, x3, (arg2[4]));
  fiat_np384_mulx_u32(&x449, &x450, x3, (arg2[3]));
  fiat_np384_mulx_u32(&x451, &x452, x3, (arg2[2]));
  fiat_np384_mulx_u32(&x453, &x454, x3, (arg2[1]));
  fiat_np384_mulx_u32(&x455, &x456, x3, (arg2[0]));
  fiat_np384_addcarryx_u32(&x457, &x458, 0x0, x456, x453);
  fiat_np384_addcarryx_u32(&x459, &x460, x458, x454, x451);
  fiat_np384_addcarryx_u32(&x461, &x462, x460, x452, x449);
  fiat_np384_addcarryx_u32(&x463, &x464, x462, x450, x447);
  fiat_np384_addcarryx_u32(&x465, &x466, x464, x448, x445);
  fiat_np384_addcarryx_u32(&x467, &x468, x466, x446, x443);
  fiat_np384_addcarryx_u32(&x469, &x470, x468, x444, x441);
  fiat_np384_addcarryx_u32(&x471, &x472, x470, x442, x439);
  fiat_np384_addcarryx_u32(&x473, &x474, x472, x440, x437);
  fiat_np384_addcarryx_u32(&x475, &x476, x474, x438, x435);
  fiat_np384_addcarryx_u32(&x477, &x478, x476, x436, x433);
  x479 = (x478 + x434);
  fiat_np384_addcarryx_u32(&x480, &x481, 0x0, x408, x455);
  fiat_np384_addcarryx_u32(&x482, &x483, x481, x410, x457);
  fiat_np384_addcarryx_u32(&x484, &x485, x483, x412, x459);
  fiat_np384_addcarryx_u32(&x486, &x487, x485, x414, x461);
  fiat_np384_addcarryx_u32(&x488, &x489, x487, x416, x463);
  fiat_np384_addcarryx_u32(&x490, &x491, x489, x418, x465);
  fiat_np384_addcarryx_u32(&x492, &x493, x491, x420, x467);
  fiat_np384_addcarryx_u32(&x494, &x495, x493, x422, x469);
  fiat_np384_addcarryx_u32(&x496, &x497, x495, x424, x471);
  fiat_np384_addcarryx_u32(&x498, &x499, x497, x426, x473);
  fiat_np384_addcarryx_u32(&x500, &x501, x499, x428, x475);
  fiat_np384_addcarryx_u32(&x502, &x503, x501, x430, x477);
  fiat_np384_addcarryx_u32(&x504, &x505, x503, x432, x479);
  fiat_np384_mulx_u32(&x506, &x507, x480, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x508, &x509, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x510, &x511, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x512, &x513, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x514, &x515, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x516, &x517, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x518, &x519, x506, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x520, &x521, x506, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x522, &x523, x506, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x524, &x525, x506, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x526, &x527, x506, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x528, &x529, x506, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x530, &x531, x506, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x532, &x533, 0x0, x531, x528);
  fiat_np384_addcarryx_u32(&x534, &x535, x533, x529, x526);
  fiat_np384_addcarryx_u32(&x536, &x537, x535, x527, x524);
  fiat_np384_addcarryx_u32(&x538, &x539, x537, x525, x522);
  fiat_np384_addcarryx_u32(&x540, &x541, x539, x523, x520);
  fiat_np384_addcarryx_u32(&x542, &x543, x541, x521, x518);
  fiat_np384_addcarryx_u32(&x544, &x545, x543, x519, x516);
  fiat_np384_addcarryx_u32(&x546, &x547, x545, x517, x514);
  fiat_np384_addcarryx_u32(&x548, &x549, x547, x515, x512);
  fiat_np384_addcarryx_u32(&x550, &x551, x549, x513, x510);
  fiat_np384_addcarryx_u32(&x552, &x553, x551, x511, x508);
  x554 = (x553 + x509);
  fiat_np384_addcarryx_u32(&x555, &x556, 0x0, x480, x530);
  fiat_np384_addcarryx_u32(&x557, &x558, x556, x482, x532);
  fiat_np384_addcarryx_u32(&x559, &x560, x558, x484, x534);
  fiat_np384_addcarryx_u32(&x561, &x562, x560, x486, x536);
  fiat_np384_addcarryx_u32(&x563, &x564, x562, x488, x538);
  fiat_np384_addcarryx_u32(&x565, &x566, x564, x490, x540);
  fiat_np384_addcarryx_u32(&x567, &x568, x566, x492, x542);
  fiat_np384_addcarryx_u32(&x569, &x570, x568, x494, x544);
  fiat_np384_addcarryx_u32(&x571, &x572, x570, x496, x546);
  fiat_np384_addcarryx_u32(&x573, &x574, x572, x498, x548);
  fiat_np384_addcarryx_u32(&x575, &x576, x574, x500, x550);
  fiat_np384_addcarryx_u32(&x577, &x578, x576, x502, x552);
  fiat_np384_addcarryx_u32(&x579, &x580, x578, x504, x554);
  x581 = ((uint32_t)x580 + x505);
  fiat_np384_mulx_u32(&x582, &x583, x4, (arg2[11]));
  fiat_np384_mulx_u32(&x584, &x585, x4, (arg2[10]));
  fiat_np384_mulx_u32(&x586, &x587, x4, (arg2[9]));
  fiat_np384_mulx_u32(&x588, &x589, x4, (arg2[8]));
  fiat_np384_mulx_u32(&x590, &x591, x4, (arg2[7]));
  fiat_np384_mulx_u32(&x592, &x593, x4, (arg2[6]));
  fiat_np384_mulx_u32(&x594, &x595, x4, (arg2[5]));
  fiat_np384_mulx_u32(&x596, &x597, x4, (arg2[4]));
  fiat_np384_mulx_u32(&x598, &x599, x4, (arg2[3]));
  fiat_np384_mulx_u32(&x600, &x601, x4, (arg2[2]));
  fiat_np384_mulx_u32(&x602, &x603, x4, (arg2[1]));
  fiat_np384_mulx_u32(&x604, &x605, x4, (arg2[0]));
  fiat_np384_addcarryx_u32(&x606, &x607, 0x0, x605, x602);
  fiat_np384_addcarryx_u32(&x608, &x609, x607, x603, x600);
  fiat_np384_addcarryx_u32(&x610, &x611, x609, x601, x598);
  fiat_np384_addcarryx_u32(&x612, &x613, x611, x599, x596);
  fiat_np384_addcarryx_u32(&x614, &x615, x613, x597, x594);
  fiat_np384_addcarryx_u32(&x616, &x617, x615, x595, x592);
  fiat_np384_addcarryx_u32(&x618, &x619, x617, x593, x590);
  fiat_np384_addcarryx_u32(&x620, &x621, x619, x591, x588);
  fiat_np384_addcarryx_u32(&x622, &x623, x621, x589, x586);
  fiat_np384_addcarryx_u32(&x624, &x625, x623, x587, x584);
  fiat_np384_addcarryx_u32(&x626, &x627, x625, x585, x582);
  x628 = (x627 + x583);
  fiat_np384_addcarryx_u32(&x629, &x630, 0x0, x557, x604);
  fiat_np384_addcarryx_u32(&x631, &x632, x630, x559, x606);
  fiat_np384_addcarryx_u32(&x633, &x634, x632, x561, x608);
  fiat_np384_addcarryx_u32(&x635, &x636, x634, x563, x610);
  fiat_np384_addcarryx_u32(&x637, &x638, x636, x565, x612);
  fiat_np384_addcarryx_u32(&x639, &x640, x638, x567, x614);
  fiat_np384_addcarryx_u32(&x641, &x642, x640, x569, x616);
  fiat_np384_addcarryx_u32(&x643, &x644, x642, x571, x618);
  fiat_np384_addcarryx_u32(&x645, &x646, x644, x573, x620);
  fiat_np384_addcarryx_u32(&x647, &x648, x646, x575, x622);
  fiat_np384_addcarryx_u32(&x649, &x650, x648, x577, x624);
  fiat_np384_addcarryx_u32(&x651, &x652, x650, x579, x626);
  fiat_np384_addcarryx_u32(&x653, &x654, x652, x581, x628);
  fiat_np384_mulx_u32(&x655, &x656, x629, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x657, &x658, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x659, &x660, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x661, &x662, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x663, &x664, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x665, &x666, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x667, &x668, x655, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x669, &x670, x655, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x671, &x672, x655, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x673, &x674, x655, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x675, &x676, x655, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x677, &x678, x655, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x679, &x680, x655, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x681, &x682, 0x0, x680, x677);
  fiat_np384_addcarryx_u32(&x683, &x684, x682, x678, x675);
  fiat_np384_addcarryx_u32(&x685, &x686, x684, x676, x673);
  fiat_np384_addcarryx_u32(&x687, &x688, x686, x674, x671);
  fiat_np384_addcarryx_u32(&x689, &x690, x688, x672, x669);
  fiat_np384_addcarryx_u32(&x691, &x692, x690, x670, x667);
  fiat_np384_addcarryx_u32(&x693, &x694, x692, x668, x665);
  fiat_np384_addcarryx_u32(&x695, &x696, x694, x666, x663);
  fiat_np384_addcarryx_u32(&x697, &x698, x696, x664, x661);
  fiat_np384_addcarryx_u32(&x699, &x700, x698, x662, x659);
  fiat_np384_addcarryx_u32(&x701, &x702, x700, x660, x657);
  x703 = (x702 + x658);
  fiat_np384_addcarryx_u32(&x704, &x705, 0x0, x629, x679);
  fiat_np384_addcarryx_u32(&x706, &x707, x705, x631, x681);
  fiat_np384_addcarryx_u32(&x708, &x709, x707, x633, x683);
  fiat_np384_addcarryx_u32(&x710, &x711, x709, x635, x685);
  fiat_np384_addcarryx_u32(&x712, &x713, x711, x637, x687);
  fiat_np384_addcarryx_u32(&x714, &x715, x713, x639, x689);
  fiat_np384_addcarryx_u32(&x716, &x717, x715, x641, x691);
  fiat_np384_addcarryx_u32(&x718, &x719, x717, x643, x693);
  fiat_np384_addcarryx_u32(&x720, &x721, x719, x645, x695);
  fiat_np384_addcarryx_u32(&x722, &x723, x721, x647, x697);
  fiat_np384_addcarryx_u32(&x724, &x725, x723, x649, x699);
  fiat_np384_addcarryx_u32(&x726, &x727, x725, x651, x701);
  fiat_np384_addcarryx_u32(&x728, &x729, x727, x653, x703);
  x730 = ((uint32_t)x729 + x654);
  fiat_np384_mulx_u32(&x731, &x732, x5, (arg2[11]));
  fiat_np384_mulx_u32(&x733, &x734, x5, (arg2[10]));
  fiat_np384_mulx_u32(&x735, &x736, x5, (arg2[9]));
  fiat_np384_mulx_u32(&x737, &x738, x5, (arg2[8]));
  fiat_np384_mulx_u32(&x739, &x740, x5, (arg2[7]));
  fiat_np384_mulx_u32(&x741, &x742, x5, (arg2[6]));
  fiat_np384_mulx_u32(&x743, &x744, x5, (arg2[5]));
  fiat_np384_mulx_u32(&x745, &x746, x5, (arg2[4]));
  fiat_np384_mulx_u32(&x747, &x748, x5, (arg2[3]));
  fiat_np384_mulx_u32(&x749, &x750, x5, (arg2[2]));
  fiat_np384_mulx_u32(&x751, &x752, x5, (arg2[1]));
  fiat_np384_mulx_u32(&x753, &x754, x5, (arg2[0]));
  fiat_np384_addcarryx_u32(&x755, &x756, 0x0, x754, x751);
  fiat_np384_addcarryx_u32(&x757, &x758, x756, x752, x749);
  fiat_np384_addcarryx_u32(&x759, &x760, x758, x750, x747);
  fiat_np384_addcarryx_u32(&x761, &x762, x760, x748, x745);
  fiat_np384_addcarryx_u32(&x763, &x764, x762, x746, x743);
  fiat_np384_addcarryx_u32(&x765, &x766, x764, x744, x741);
  fiat_np384_addcarryx_u32(&x767, &x768, x766, x742, x739);
  fiat_np384_addcarryx_u32(&x769, &x770, x768, x740, x737);
  fiat_np384_addcarryx_u32(&x771, &x772, x770, x738, x735);
  fiat_np384_addcarryx_u32(&x773, &x774, x772, x736, x733);
  fiat_np384_addcarryx_u32(&x775, &x776, x774, x734, x731);
  x777 = (x776 + x732);
  fiat_np384_addcarryx_u32(&x778, &x779, 0x0, x706, x753);
  fiat_np384_addcarryx_u32(&x780, &x781, x779, x708, x755);
  fiat_np384_addcarryx_u32(&x782, &x783, x781, x710, x757);
  fiat_np384_addcarryx_u32(&x784, &x785, x783, x712, x759);
  fiat_np384_addcarryx_u32(&x786, &x787, x785, x714, x761);
  fiat_np384_addcarryx_u32(&x788, &x789, x787, x716, x763);
  fiat_np384_addcarryx_u32(&x790, &x791, x789, x718, x765);
  fiat_np384_addcarryx_u32(&x792, &x793, x791, x720, x767);
  fiat_np384_addcarryx_u32(&x794, &x795, x793, x722, x769);
  fiat_np384_addcarryx_u32(&x796, &x797, x795, x724, x771);
  fiat_np384_addcarryx_u32(&x798, &x799, x797, x726, x773);
  fiat_np384_addcarryx_u32(&x800, &x801, x799, x728, x775);
  fiat_np384_addcarryx_u32(&x802, &x803, x801, x730, x777);
  fiat_np384_mulx_u32(&x804, &x805, x778, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x806, &x807, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x808, &x809, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x810, &x811, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x812, &x813, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x814, &x815, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x816, &x817, x804, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x818, &x819, x804, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x820, &x821, x804, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x822, &x823, x804, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x824, &x825, x804, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x826, &x827, x804, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x828, &x829, x804, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x830, &x831, 0x0, x829, x826);
  fiat_np384_addcarryx_u32(&x832, &x833, x831, x827, x824);
  fiat_np384_addcarryx_u32(&x834, &x835, x833, x825, x822);
  fiat_np384_addcarryx_u32(&x836, &x837, x835, x823, x820);
  fiat_np384_addcarryx_u32(&x838, &x839, x837, x821, x818);
  fiat_np384_addcarryx_u32(&x840, &x841, x839, x819, x816);
  fiat_np384_addcarryx_u32(&x842, &x843, x841, x817, x814);
  fiat_np384_addcarryx_u32(&x844, &x845, x843, x815, x812);
  fiat_np384_addcarryx_u32(&x846, &x847, x845, x813, x810);
  fiat_np384_addcarryx_u32(&x848, &x849, x847, x811, x808);
  fiat_np384_addcarryx_u32(&x850, &x851, x849, x809, x806);
  x852 = (x851 + x807);
  fiat_np384_addcarryx_u32(&x853, &x854, 0x0, x778, x828);
  fiat_np384_addcarryx_u32(&x855, &x856, x854, x780, x830);
  fiat_np384_addcarryx_u32(&x857, &x858, x856, x782, x832);
  fiat_np384_addcarryx_u32(&x859, &x860, x858, x784, x834);
  fiat_np384_addcarryx_u32(&x861, &x862, x860, x786, x836);
  fiat_np384_addcarryx_u32(&x863, &x864, x862, x788, x838);
  fiat_np384_addcarryx_u32(&x865, &x866, x864, x790, x840);
  fiat_np384_addcarryx_u32(&x867, &x868, x866, x792, x842);
  fiat_np384_addcarryx_u32(&x869, &x870, x868, x794, x844);
  fiat_np384_addcarryx_u32(&x871, &x872, x870, x796, x846);
  fiat_np384_addcarryx_u32(&x873, &x874, x872, x798, x848);
  fiat_np384_addcarryx_u32(&x875, &x876, x874, x800, x850);
  fiat_np384_addcarryx_u32(&x877, &x878, x876, x802, x852);
  x879 = ((uint32_t)x878 + x803);
  fiat_np384_mulx_u32(&x880, &x881, x6, (arg2[11]));
  fiat_np384_mulx_u32(&x882, &x883, x6, (arg2[10]));
  fiat_np384_mulx_u32(&x884, &x885, x6, (arg2[9]));
  fiat_np384_mulx_u32(&x886, &x887, x6, (arg2[8]));
  fiat_np384_mulx_u32(&x888, &x889, x6, (arg2[7]));
  fiat_np384_mulx_u32(&x890, &x891, x6, (arg2[6]));
  fiat_np384_mulx_u32(&x892, &x893, x6, (arg2[5]));
  fiat_np384_mulx_u32(&x894, &x895, x6, (arg2[4]));
  fiat_np384_mulx_u32(&x896, &x897, x6, (arg2[3]));
  fiat_np384_mulx_u32(&x898, &x899, x6, (arg2[2]));
  fiat_np384_mulx_u32(&x900, &x901, x6, (arg2[1]));
  fiat_np384_mulx_u32(&x902, &x903, x6, (arg2[0]));
  fiat_np384_addcarryx_u32(&x904, &x905, 0x0, x903, x900);
  fiat_np384_addcarryx_u32(&x906, &x907, x905, x901, x898);
  fiat_np384_addcarryx_u32(&x908, &x909, x907, x899, x896);
  fiat_np384_addcarryx_u32(&x910, &x911, x909, x897, x894);
  fiat_np384_addcarryx_u32(&x912, &x913, x911, x895, x892);
  fiat_np384_addcarryx_u32(&x914, &x915, x913, x893, x890);
  fiat_np384_addcarryx_u32(&x916, &x917, x915, x891, x888);
  fiat_np384_addcarryx_u32(&x918, &x919, x917, x889, x886);
  fiat_np384_addcarryx_u32(&x920, &x921, x919, x887, x884);
  fiat_np384_addcarryx_u32(&x922, &x923, x921, x885, x882);
  fiat_np384_addcarryx_u32(&x924, &x925, x923, x883, x880);
  x926 = (x925 + x881);
  fiat_np384_addcarryx_u32(&x927, &x928, 0x0, x855, x902);
  fiat_np384_addcarryx_u32(&x929, &x930, x928, x857, x904);
  fiat_np384_addcarryx_u32(&x931, &x932, x930, x859, x906);
  fiat_np384_addcarryx_u32(&x933, &x934, x932, x861, x908);
  fiat_np384_addcarryx_u32(&x935, &x936, x934, x863, x910);
  fiat_np384_addcarryx_u32(&x937, &x938, x936, x865, x912);
  fiat_np384_addcarryx_u32(&x939, &x940, x938, x867, x914);
  fiat_np384_addcarryx_u32(&x941, &x942, x940, x869, x916);
  fiat_np384_addcarryx_u32(&x943, &x944, x942, x871, x918);
  fiat_np384_addcarryx_u32(&x945, &x946, x944, x873, x920);
  fiat_np384_addcarryx_u32(&x947, &x948, x946, x875, x922);
  fiat_np384_addcarryx_u32(&x949, &x950, x948, x877, x924);
  fiat_np384_addcarryx_u32(&x951, &x952, x950, x879, x926);
  fiat_np384_mulx_u32(&x953, &x954, x927, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x955, &x956, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x957, &x958, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x959, &x960, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x961, &x962, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x963, &x964, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x965, &x966, x953, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x967, &x968, x953, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x969, &x970, x953, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x971, &x972, x953, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x973, &x974, x953, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x975, &x976, x953, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x977, &x978, x953, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x979, &x980, 0x0, x978, x975);
  fiat_np384_addcarryx_u32(&x981, &x982, x980, x976, x973);
  fiat_np384_addcarryx_u32(&x983, &x984, x982, x974, x971);
  fiat_np384_addcarryx_u32(&x985, &x986, x984, x972, x969);
  fiat_np384_addcarryx_u32(&x987, &x988, x986, x970, x967);
  fiat_np384_addcarryx_u32(&x989, &x990, x988, x968, x965);
  fiat_np384_addcarryx_u32(&x991, &x992, x990, x966, x963);
  fiat_np384_addcarryx_u32(&x993, &x994, x992, x964, x961);
  fiat_np384_addcarryx_u32(&x995, &x996, x994, x962, x959);
  fiat_np384_addcarryx_u32(&x997, &x998, x996, x960, x957);
  fiat_np384_addcarryx_u32(&x999, &x1000, x998, x958, x955);
  x1001 = (x1000 + x956);
  fiat_np384_addcarryx_u32(&x1002, &x1003, 0x0, x927, x977);
  fiat_np384_addcarryx_u32(&x1004, &x1005, x1003, x929, x979);
  fiat_np384_addcarryx_u32(&x1006, &x1007, x1005, x931, x981);
  fiat_np384_addcarryx_u32(&x1008, &x1009, x1007, x933, x983);
  fiat_np384_addcarryx_u32(&x1010, &x1011, x1009, x935, x985);
  fiat_np384_addcarryx_u32(&x1012, &x1013, x1011, x937, x987);
  fiat_np384_addcarryx_u32(&x1014, &x1015, x1013, x939, x989);
  fiat_np384_addcarryx_u32(&x1016, &x1017, x1015, x941, x991);
  fiat_np384_addcarryx_u32(&x1018, &x1019, x1017, x943, x993);
  fiat_np384_addcarryx_u32(&x1020, &x1021, x1019, x945, x995);
  fiat_np384_addcarryx_u32(&x1022, &x1023, x1021, x947, x997);
  fiat_np384_addcarryx_u32(&x1024, &x1025, x1023, x949, x999);
  fiat_np384_addcarryx_u32(&x1026, &x1027, x1025, x951, x1001);
  x1028 = ((uint32_t)x1027 + x952);
  fiat_np384_mulx_u32(&x1029, &x1030, x7, (arg2[11]));
  fiat_np384_mulx_u32(&x1031, &x1032, x7, (arg2[10]));
  fiat_np384_mulx_u32(&x1033, &x1034, x7, (arg2[9]));
  fiat_np384_mulx_u32(&x1035, &x1036, x7, (arg2[8]));
  fiat_np384_mulx_u32(&x1037, &x1038, x7, (arg2[7]));
  fiat_np384_mulx_u32(&x1039, &x1040, x7, (arg2[6]));
  fiat_np384_mulx_u32(&x1041, &x1042, x7, (arg2[5]));
  fiat_np384_mulx_u32(&x1043, &x1044, x7, (arg2[4]));
  fiat_np384_mulx_u32(&x1045, &x1046, x7, (arg2[3]));
  fiat_np384_mulx_u32(&x1047, &x1048, x7, (arg2[2]));
  fiat_np384_mulx_u32(&x1049, &x1050, x7, (arg2[1]));
  fiat_np384_mulx_u32(&x1051, &x1052, x7, (arg2[0]));
  fiat_np384_addcarryx_u32(&x1053, &x1054, 0x0, x1052, x1049);
  fiat_np384_addcarryx_u32(&x1055, &x1056, x1054, x1050, x1047);
  fiat_np384_addcarryx_u32(&x1057, &x1058, x1056, x1048, x1045);
  fiat_np384_addcarryx_u32(&x1059, &x1060, x1058, x1046, x1043);
  fiat_np384_addcarryx_u32(&x1061, &x1062, x1060, x1044, x1041);
  fiat_np384_addcarryx_u32(&x1063, &x1064, x1062, x1042, x1039);
  fiat_np384_addcarryx_u32(&x1065, &x1066, x1064, x1040, x1037);
  fiat_np384_addcarryx_u32(&x1067, &x1068, x1066, x1038, x1035);
  fiat_np384_addcarryx_u32(&x1069, &x1070, x1068, x1036, x1033);
  fiat_np384_addcarryx_u32(&x1071, &x1072, x1070, x1034, x1031);
  fiat_np384_addcarryx_u32(&x1073, &x1074, x1072, x1032, x1029);
  x1075 = (x1074 + x1030);
  fiat_np384_addcarryx_u32(&x1076, &x1077, 0x0, x1004, x1051);
  fiat_np384_addcarryx_u32(&x1078, &x1079, x1077, x1006, x1053);
  fiat_np384_addcarryx_u32(&x1080, &x1081, x1079, x1008, x1055);
  fiat_np384_addcarryx_u32(&x1082, &x1083, x1081, x1010, x1057);
  fiat_np384_addcarryx_u32(&x1084, &x1085, x1083, x1012, x1059);
  fiat_np384_addcarryx_u32(&x1086, &x1087, x1085, x1014, x1061);
  fiat_np384_addcarryx_u32(&x1088, &x1089, x1087, x1016, x1063);
  fiat_np384_addcarryx_u32(&x1090, &x1091, x1089, x1018, x1065);
  fiat_np384_addcarryx_u32(&x1092, &x1093, x1091, x1020, x1067);
  fiat_np384_addcarryx_u32(&x1094, &x1095, x1093, x1022, x1069);
  fiat_np384_addcarryx_u32(&x1096, &x1097, x1095, x1024, x1071);
  fiat_np384_addcarryx_u32(&x1098, &x1099, x1097, x1026, x1073);
  fiat_np384_addcarryx_u32(&x1100, &x1101, x1099, x1028, x1075);
  fiat_np384_mulx_u32(&x1102, &x1103, x1076, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1104, &x1105, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1106, &x1107, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1108, &x1109, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1110, &x1111, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1112, &x1113, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1114, &x1115, x1102, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1116, &x1117, x1102, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1118, &x1119, x1102, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1120, &x1121, x1102, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1122, &x1123, x1102, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1124, &x1125, x1102, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1126, &x1127, x1102, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1128, &x1129, 0x0, x1127, x1124);
  fiat_np384_addcarryx_u32(&x1130, &x1131, x1129, x1125, x1122);
  fiat_np384_addcarryx_u32(&x1132, &x1133, x1131, x1123, x1120);
  fiat_np384_addcarryx_u32(&x1134, &x1135, x1133, x1121, x1118);
  fiat_np384_addcarryx_u32(&x1136, &x1137, x1135, x1119, x1116);
  fiat_np384_addcarryx_u32(&x1138, &x1139, x1137, x1117, x1114);
  fiat_np384_addcarryx_u32(&x1140, &x1141, x1139, x1115, x1112);
  fiat_np384_addcarryx_u32(&x1142, &x1143, x1141, x1113, x1110);
  fiat_np384_addcarryx_u32(&x1144, &x1145, x1143, x1111, x1108);
  fiat_np384_addcarryx_u32(&x1146, &x1147, x1145, x1109, x1106);
  fiat_np384_addcarryx_u32(&x1148, &x1149, x1147, x1107, x1104);
  x1150 = (x1149 + x1105);
  fiat_np384_addcarryx_u32(&x1151, &x1152, 0x0, x1076, x1126);
  fiat_np384_addcarryx_u32(&x1153, &x1154, x1152, x1078, x1128);
  fiat_np384_addcarryx_u32(&x1155, &x1156, x1154, x1080, x1130);
  fiat_np384_addcarryx_u32(&x1157, &x1158, x1156, x1082, x1132);
  fiat_np384_addcarryx_u32(&x1159, &x1160, x1158, x1084, x1134);
  fiat_np384_addcarryx_u32(&x1161, &x1162, x1160, x1086, x1136);
  fiat_np384_addcarryx_u32(&x1163, &x1164, x1162, x1088, x1138);
  fiat_np384_addcarryx_u32(&x1165, &x1166, x1164, x1090, x1140);
  fiat_np384_addcarryx_u32(&x1167, &x1168, x1166, x1092, x1142);
  fiat_np384_addcarryx_u32(&x1169, &x1170, x1168, x1094, x1144);
  fiat_np384_addcarryx_u32(&x1171, &x1172, x1170, x1096, x1146);
  fiat_np384_addcarryx_u32(&x1173, &x1174, x1172, x1098, x1148);
  fiat_np384_addcarryx_u32(&x1175, &x1176, x1174, x1100, x1150);
  x1177 = ((uint32_t)x1176 + x1101);
  fiat_np384_mulx_u32(&x1178, &x1179, x8, (arg2[11]));
  fiat_np384_mulx_u32(&x1180, &x1181, x8, (arg2[10]));
  fiat_np384_mulx_u32(&x1182, &x1183, x8, (arg2[9]));
  fiat_np384_mulx_u32(&x1184, &x1185, x8, (arg2[8]));
  fiat_np384_mulx_u32(&x1186, &x1187, x8, (arg2[7]));
  fiat_np384_mulx_u32(&x1188, &x1189, x8, (arg2[6]));
  fiat_np384_mulx_u32(&x1190, &x1191, x8, (arg2[5]));
  fiat_np384_mulx_u32(&x1192, &x1193, x8, (arg2[4]));
  fiat_np384_mulx_u32(&x1194, &x1195, x8, (arg2[3]));
  fiat_np384_mulx_u32(&x1196, &x1197, x8, (arg2[2]));
  fiat_np384_mulx_u32(&x1198, &x1199, x8, (arg2[1]));
  fiat_np384_mulx_u32(&x1200, &x1201, x8, (arg2[0]));
  fiat_np384_addcarryx_u32(&x1202, &x1203, 0x0, x1201, x1198);
  fiat_np384_addcarryx_u32(&x1204, &x1205, x1203, x1199, x1196);
  fiat_np384_addcarryx_u32(&x1206, &x1207, x1205, x1197, x1194);
  fiat_np384_addcarryx_u32(&x1208, &x1209, x1207, x1195, x1192);
  fiat_np384_addcarryx_u32(&x1210, &x1211, x1209, x1193, x1190);
  fiat_np384_addcarryx_u32(&x1212, &x1213, x1211, x1191, x1188);
  fiat_np384_addcarryx_u32(&x1214, &x1215, x1213, x1189, x1186);
  fiat_np384_addcarryx_u32(&x1216, &x1217, x1215, x1187, x1184);
  fiat_np384_addcarryx_u32(&x1218, &x1219, x1217, x1185, x1182);
  fiat_np384_addcarryx_u32(&x1220, &x1221, x1219, x1183, x1180);
  fiat_np384_addcarryx_u32(&x1222, &x1223, x1221, x1181, x1178);
  x1224 = (x1223 + x1179);
  fiat_np384_addcarryx_u32(&x1225, &x1226, 0x0, x1153, x1200);
  fiat_np384_addcarryx_u32(&x1227, &x1228, x1226, x1155, x1202);
  fiat_np384_addcarryx_u32(&x1229, &x1230, x1228, x1157, x1204);
  fiat_np384_addcarryx_u32(&x1231, &x1232, x1230, x1159, x1206);
  fiat_np384_addcarryx_u32(&x1233, &x1234, x1232, x1161, x1208);
  fiat_np384_addcarryx_u32(&x1235, &x1236, x1234, x1163, x1210);
  fiat_np384_addcarryx_u32(&x1237, &x1238, x1236, x1165, x1212);
  fiat_np384_addcarryx_u32(&x1239, &x1240, x1238, x1167, x1214);
  fiat_np384_addcarryx_u32(&x1241, &x1242, x1240, x1169, x1216);
  fiat_np384_addcarryx_u32(&x1243, &x1244, x1242, x1171, x1218);
  fiat_np384_addcarryx_u32(&x1245, &x1246, x1244, x1173, x1220);
  fiat_np384_addcarryx_u32(&x1247, &x1248, x1246, x1175, x1222);
  fiat_np384_addcarryx_u32(&x1249, &x1250, x1248, x1177, x1224);
  fiat_np384_mulx_u32(&x1251, &x1252, x1225, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1253, &x1254, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1255, &x1256, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1257, &x1258, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1259, &x1260, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1261, &x1262, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1263, &x1264, x1251, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1265, &x1266, x1251, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1267, &x1268, x1251, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1269, &x1270, x1251, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1271, &x1272, x1251, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1273, &x1274, x1251, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1275, &x1276, x1251, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1277, &x1278, 0x0, x1276, x1273);
  fiat_np384_addcarryx_u32(&x1279, &x1280, x1278, x1274, x1271);
  fiat_np384_addcarryx_u32(&x1281, &x1282, x1280, x1272, x1269);
  fiat_np384_addcarryx_u32(&x1283, &x1284, x1282, x1270, x1267);
  fiat_np384_addcarryx_u32(&x1285, &x1286, x1284, x1268, x1265);
  fiat_np384_addcarryx_u32(&x1287, &x1288, x1286, x1266, x1263);
  fiat_np384_addcarryx_u32(&x1289, &x1290, x1288, x1264, x1261);
  fiat_np384_addcarryx_u32(&x1291, &x1292, x1290, x1262, x1259);
  fiat_np384_addcarryx_u32(&x1293, &x1294, x1292, x1260, x1257);
  fiat_np384_addcarryx_u32(&x1295, &x1296, x1294, x1258, x1255);
  fiat_np384_addcarryx_u32(&x1297, &x1298, x1296, x1256, x1253);
  x1299 = (x1298 + x1254);
  fiat_np384_addcarryx_u32(&x1300, &x1301, 0x0, x1225, x1275);
  fiat_np384_addcarryx_u32(&x1302, &x1303, x1301, x1227, x1277);
  fiat_np384_addcarryx_u32(&x1304, &x1305, x1303, x1229, x1279);
  fiat_np384_addcarryx_u32(&x1306, &x1307, x1305, x1231, x1281);
  fiat_np384_addcarryx_u32(&x1308, &x1309, x1307, x1233, x1283);
  fiat_np384_addcarryx_u32(&x1310, &x1311, x1309, x1235, x1285);
  fiat_np384_addcarryx_u32(&x1312, &x1313, x1311, x1237, x1287);
  fiat_np384_addcarryx_u32(&x1314, &x1315, x1313, x1239, x1289);
  fiat_np384_addcarryx_u32(&x1316, &x1317, x1315, x1241, x1291);
  fiat_np384_addcarryx_u32(&x1318, &x1319, x1317, x1243, x1293);
  fiat_np384_addcarryx_u32(&x1320, &x1321, x1319, x1245, x1295);
  fiat_np384_addcarryx_u32(&x1322, &x1323, x1321, x1247, x1297);
  fiat_np384_addcarryx_u32(&x1324, &x1325, x1323, x1249, x1299);
  x1326 = ((uint32_t)x1325 + x1250);
  fiat_np384_mulx_u32(&x1327, &x1328, x9, (arg2[11]));
  fiat_np384_mulx_u32(&x1329, &x1330, x9, (arg2[10]));
  fiat_np384_mulx_u32(&x1331, &x1332, x9, (arg2[9]));
  fiat_np384_mulx_u32(&x1333, &x1334, x9, (arg2[8]));
  fiat_np384_mulx_u32(&x1335, &x1336, x9, (arg2[7]));
  fiat_np384_mulx_u32(&x1337, &x1338, x9, (arg2[6]));
  fiat_np384_mulx_u32(&x1339, &x1340, x9, (arg2[5]));
  fiat_np384_mulx_u32(&x1341, &x1342, x9, (arg2[4]));
  fiat_np384_mulx_u32(&x1343, &x1344, x9, (arg2[3]));
  fiat_np384_mulx_u32(&x1345, &x1346, x9, (arg2[2]));
  fiat_np384_mulx_u32(&x1347, &x1348, x9, (arg2[1]));
  fiat_np384_mulx_u32(&x1349, &x1350, x9, (arg2[0]));
  fiat_np384_addcarryx_u32(&x1351, &x1352, 0x0, x1350, x1347);
  fiat_np384_addcarryx_u32(&x1353, &x1354, x1352, x1348, x1345);
  fiat_np384_addcarryx_u32(&x1355, &x1356, x1354, x1346, x1343);
  fiat_np384_addcarryx_u32(&x1357, &x1358, x1356, x1344, x1341);
  fiat_np384_addcarryx_u32(&x1359, &x1360, x1358, x1342, x1339);
  fiat_np384_addcarryx_u32(&x1361, &x1362, x1360, x1340, x1337);
  fiat_np384_addcarryx_u32(&x1363, &x1364, x1362, x1338, x1335);
  fiat_np384_addcarryx_u32(&x1365, &x1366, x1364, x1336, x1333);
  fiat_np384_addcarryx_u32(&x1367, &x1368, x1366, x1334, x1331);
  fiat_np384_addcarryx_u32(&x1369, &x1370, x1368, x1332, x1329);
  fiat_np384_addcarryx_u32(&x1371, &x1372, x1370, x1330, x1327);
  x1373 = (x1372 + x1328);
  fiat_np384_addcarryx_u32(&x1374, &x1375, 0x0, x1302, x1349);
  fiat_np384_addcarryx_u32(&x1376, &x1377, x1375, x1304, x1351);
  fiat_np384_addcarryx_u32(&x1378, &x1379, x1377, x1306, x1353);
  fiat_np384_addcarryx_u32(&x1380, &x1381, x1379, x1308, x1355);
  fiat_np384_addcarryx_u32(&x1382, &x1383, x1381, x1310, x1357);
  fiat_np384_addcarryx_u32(&x1384, &x1385, x1383, x1312, x1359);
  fiat_np384_addcarryx_u32(&x1386, &x1387, x1385, x1314, x1361);
  fiat_np384_addcarryx_u32(&x1388, &x1389, x1387, x1316, x1363);
  fiat_np384_addcarryx_u32(&x1390, &x1391, x1389, x1318, x1365);
  fiat_np384_addcarryx_u32(&x1392, &x1393, x1391, x1320, x1367);
  fiat_np384_addcarryx_u32(&x1394, &x1395, x1393, x1322, x1369);
  fiat_np384_addcarryx_u32(&x1396, &x1397, x1395, x1324, x1371);
  fiat_np384_addcarryx_u32(&x1398, &x1399, x1397, x1326, x1373);
  fiat_np384_mulx_u32(&x1400, &x1401, x1374, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1402, &x1403, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1404, &x1405, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1406, &x1407, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1408, &x1409, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1410, &x1411, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1412, &x1413, x1400, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1414, &x1415, x1400, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1416, &x1417, x1400, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1418, &x1419, x1400, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1420, &x1421, x1400, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1422, &x1423, x1400, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1424, &x1425, x1400, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1426, &x1427, 0x0, x1425, x1422);
  fiat_np384_addcarryx_u32(&x1428, &x1429, x1427, x1423, x1420);
  fiat_np384_addcarryx_u32(&x1430, &x1431, x1429, x1421, x1418);
  fiat_np384_addcarryx_u32(&x1432, &x1433, x1431, x1419, x1416);
  fiat_np384_addcarryx_u32(&x1434, &x1435, x1433, x1417, x1414);
  fiat_np384_addcarryx_u32(&x1436, &x1437, x1435, x1415, x1412);
  fiat_np384_addcarryx_u32(&x1438, &x1439, x1437, x1413, x1410);
  fiat_np384_addcarryx_u32(&x1440, &x1441, x1439, x1411, x1408);
  fiat_np384_addcarryx_u32(&x1442, &x1443, x1441, x1409, x1406);
  fiat_np384_addcarryx_u32(&x1444, &x1445, x1443, x1407, x1404);
  fiat_np384_addcarryx_u32(&x1446, &x1447, x1445, x1405, x1402);
  x1448 = (x1447 + x1403);
  fiat_np384_addcarryx_u32(&x1449, &x1450, 0x0, x1374, x1424);
  fiat_np384_addcarryx_u32(&x1451, &x1452, x1450, x1376, x1426);
  fiat_np384_addcarryx_u32(&x1453, &x1454, x1452, x1378, x1428);
  fiat_np384_addcarryx_u32(&x1455, &x1456, x1454, x1380, x1430);
  fiat_np384_addcarryx_u32(&x1457, &x1458, x1456, x1382, x1432);
  fiat_np384_addcarryx_u32(&x1459, &x1460, x1458, x1384, x1434);
  fiat_np384_addcarryx_u32(&x1461, &x1462, x1460, x1386, x1436);
  fiat_np384_addcarryx_u32(&x1463, &x1464, x1462, x1388, x1438);
  fiat_np384_addcarryx_u32(&x1465, &x1466, x1464, x1390, x1440);
  fiat_np384_addcarryx_u32(&x1467, &x1468, x1466, x1392, x1442);
  fiat_np384_addcarryx_u32(&x1469, &x1470, x1468, x1394, x1444);
  fiat_np384_addcarryx_u32(&x1471, &x1472, x1470, x1396, x1446);
  fiat_np384_addcarryx_u32(&x1473, &x1474, x1472, x1398, x1448);
  x1475 = ((uint32_t)x1474 + x1399);
  fiat_np384_mulx_u32(&x1476, &x1477, x10, (arg2[11]));
  fiat_np384_mulx_u32(&x1478, &x1479, x10, (arg2[10]));
  fiat_np384_mulx_u32(&x1480, &x1481, x10, (arg2[9]));
  fiat_np384_mulx_u32(&x1482, &x1483, x10, (arg2[8]));
  fiat_np384_mulx_u32(&x1484, &x1485, x10, (arg2[7]));
  fiat_np384_mulx_u32(&x1486, &x1487, x10, (arg2[6]));
  fiat_np384_mulx_u32(&x1488, &x1489, x10, (arg2[5]));
  fiat_np384_mulx_u32(&x1490, &x1491, x10, (arg2[4]));
  fiat_np384_mulx_u32(&x1492, &x1493, x10, (arg2[3]));
  fiat_np384_mulx_u32(&x1494, &x1495, x10, (arg2[2]));
  fiat_np384_mulx_u32(&x1496, &x1497, x10, (arg2[1]));
  fiat_np384_mulx_u32(&x1498, &x1499, x10, (arg2[0]));
  fiat_np384_addcarryx_u32(&x1500, &x1501, 0x0, x1499, x1496);
  fiat_np384_addcarryx_u32(&x1502, &x1503, x1501, x1497, x1494);
  fiat_np384_addcarryx_u32(&x1504, &x1505, x1503, x1495, x1492);
  fiat_np384_addcarryx_u32(&x1506, &x1507, x1505, x1493, x1490);
  fiat_np384_addcarryx_u32(&x1508, &x1509, x1507, x1491, x1488);
  fiat_np384_addcarryx_u32(&x1510, &x1511, x1509, x1489, x1486);
  fiat_np384_addcarryx_u32(&x1512, &x1513, x1511, x1487, x1484);
  fiat_np384_addcarryx_u32(&x1514, &x1515, x1513, x1485, x1482);
  fiat_np384_addcarryx_u32(&x1516, &x1517, x1515, x1483, x1480);
  fiat_np384_addcarryx_u32(&x1518, &x1519, x1517, x1481, x1478);
  fiat_np384_addcarryx_u32(&x1520, &x1521, x1519, x1479, x1476);
  x1522 = (x1521 + x1477);
  fiat_np384_addcarryx_u32(&x1523, &x1524, 0x0, x1451, x1498);
  fiat_np384_addcarryx_u32(&x1525, &x1526, x1524, x1453, x1500);
  fiat_np384_addcarryx_u32(&x1527, &x1528, x1526, x1455, x1502);
  fiat_np384_addcarryx_u32(&x1529, &x1530, x1528, x1457, x1504);
  fiat_np384_addcarryx_u32(&x1531, &x1532, x1530, x1459, x1506);
  fiat_np384_addcarryx_u32(&x1533, &x1534, x1532, x1461, x1508);
  fiat_np384_addcarryx_u32(&x1535, &x1536, x1534, x1463, x1510);
  fiat_np384_addcarryx_u32(&x1537, &x1538, x1536, x1465, x1512);
  fiat_np384_addcarryx_u32(&x1539, &x1540, x1538, x1467, x1514);
  fiat_np384_addcarryx_u32(&x1541, &x1542, x1540, x1469, x1516);
  fiat_np384_addcarryx_u32(&x1543, &x1544, x1542, x1471, x1518);
  fiat_np384_addcarryx_u32(&x1545, &x1546, x1544, x1473, x1520);
  fiat_np384_addcarryx_u32(&x1547, &x1548, x1546, x1475, x1522);
  fiat_np384_mulx_u32(&x1549, &x1550, x1523, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1551, &x1552, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1553, &x1554, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1555, &x1556, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1557, &x1558, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1559, &x1560, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1561, &x1562, x1549, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1563, &x1564, x1549, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1565, &x1566, x1549, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1567, &x1568, x1549, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1569, &x1570, x1549, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1571, &x1572, x1549, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1573, &x1574, x1549, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1575, &x1576, 0x0, x1574, x1571);
  fiat_np384_addcarryx_u32(&x1577, &x1578, x1576, x1572, x1569);
  fiat_np384_addcarryx_u32(&x1579, &x1580, x1578, x1570, x1567);
  fiat_np384_addcarryx_u32(&x1581, &x1582, x1580, x1568, x1565);
  fiat_np384_addcarryx_u32(&x1583, &x1584, x1582, x1566, x1563);
  fiat_np384_addcarryx_u32(&x1585, &x1586, x1584, x1564, x1561);
  fiat_np384_addcarryx_u32(&x1587, &x1588, x1586, x1562, x1559);
  fiat_np384_addcarryx_u32(&x1589, &x1590, x1588, x1560, x1557);
  fiat_np384_addcarryx_u32(&x1591, &x1592, x1590, x1558, x1555);
  fiat_np384_addcarryx_u32(&x1593, &x1594, x1592, x1556, x1553);
  fiat_np384_addcarryx_u32(&x1595, &x1596, x1594, x1554, x1551);
  x1597 = (x1596 + x1552);
  fiat_np384_addcarryx_u32(&x1598, &x1599, 0x0, x1523, x1573);
  fiat_np384_addcarryx_u32(&x1600, &x1601, x1599, x1525, x1575);
  fiat_np384_addcarryx_u32(&x1602, &x1603, x1601, x1527, x1577);
  fiat_np384_addcarryx_u32(&x1604, &x1605, x1603, x1529, x1579);
  fiat_np384_addcarryx_u32(&x1606, &x1607, x1605, x1531, x1581);
  fiat_np384_addcarryx_u32(&x1608, &x1609, x1607, x1533, x1583);
  fiat_np384_addcarryx_u32(&x1610, &x1611, x1609, x1535, x1585);
  fiat_np384_addcarryx_u32(&x1612, &x1613, x1611, x1537, x1587);
  fiat_np384_addcarryx_u32(&x1614, &x1615, x1613, x1539, x1589);
  fiat_np384_addcarryx_u32(&x1616, &x1617, x1615, x1541, x1591);
  fiat_np384_addcarryx_u32(&x1618, &x1619, x1617, x1543, x1593);
  fiat_np384_addcarryx_u32(&x1620, &x1621, x1619, x1545, x1595);
  fiat_np384_addcarryx_u32(&x1622, &x1623, x1621, x1547, x1597);
  x1624 = ((uint32_t)x1623 + x1548);
  fiat_np384_mulx_u32(&x1625, &x1626, x11, (arg2[11]));
  fiat_np384_mulx_u32(&x1627, &x1628, x11, (arg2[10]));
  fiat_np384_mulx_u32(&x1629, &x1630, x11, (arg2[9]));
  fiat_np384_mulx_u32(&x1631, &x1632, x11, (arg2[8]));
  fiat_np384_mulx_u32(&x1633, &x1634, x11, (arg2[7]));
  fiat_np384_mulx_u32(&x1635, &x1636, x11, (arg2[6]));
  fiat_np384_mulx_u32(&x1637, &x1638, x11, (arg2[5]));
  fiat_np384_mulx_u32(&x1639, &x1640, x11, (arg2[4]));
  fiat_np384_mulx_u32(&x1641, &x1642, x11, (arg2[3]));
  fiat_np384_mulx_u32(&x1643, &x1644, x11, (arg2[2]));
  fiat_np384_mulx_u32(&x1645, &x1646, x11, (arg2[1]));
  fiat_np384_mulx_u32(&x1647, &x1648, x11, (arg2[0]));
  fiat_np384_addcarryx_u32(&x1649, &x1650, 0x0, x1648, x1645);
  fiat_np384_addcarryx_u32(&x1651, &x1652, x1650, x1646, x1643);
  fiat_np384_addcarryx_u32(&x1653, &x1654, x1652, x1644, x1641);
  fiat_np384_addcarryx_u32(&x1655, &x1656, x1654, x1642, x1639);
  fiat_np384_addcarryx_u32(&x1657, &x1658, x1656, x1640, x1637);
  fiat_np384_addcarryx_u32(&x1659, &x1660, x1658, x1638, x1635);
  fiat_np384_addcarryx_u32(&x1661, &x1662, x1660, x1636, x1633);
  fiat_np384_addcarryx_u32(&x1663, &x1664, x1662, x1634, x1631);
  fiat_np384_addcarryx_u32(&x1665, &x1666, x1664, x1632, x1629);
  fiat_np384_addcarryx_u32(&x1667, &x1668, x1666, x1630, x1627);
  fiat_np384_addcarryx_u32(&x1669, &x1670, x1668, x1628, x1625);
  x1671 = (x1670 + x1626);
  fiat_np384_addcarryx_u32(&x1672, &x1673, 0x0, x1600, x1647);
  fiat_np384_addcarryx_u32(&x1674, &x1675, x1673, x1602, x1649);
  fiat_np384_addcarryx_u32(&x1676, &x1677, x1675, x1604, x1651);
  fiat_np384_addcarryx_u32(&x1678, &x1679, x1677, x1606, x1653);
  fiat_np384_addcarryx_u32(&x1680, &x1681, x1679, x1608, x1655);
  fiat_np384_addcarryx_u32(&x1682, &x1683, x1681, x1610, x1657);
  fiat_np384_addcarryx_u32(&x1684, &x1685, x1683, x1612, x1659);
  fiat_np384_addcarryx_u32(&x1686, &x1687, x1685, x1614, x1661);
  fiat_np384_addcarryx_u32(&x1688, &x1689, x1687, x1616, x1663);
  fiat_np384_addcarryx_u32(&x1690, &x1691, x1689, x1618, x1665);
  fiat_np384_addcarryx_u32(&x1692, &x1693, x1691, x1620, x1667);
  fiat_np384_addcarryx_u32(&x1694, &x1695, x1693, x1622, x1669);
  fiat_np384_addcarryx_u32(&x1696, &x1697, x1695, x1624, x1671);
  fiat_np384_mulx_u32(&x1698, &x1699, x1672, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1700, &x1701, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1702, &x1703, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1704, &x1705, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1706, &x1707, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1708, &x1709, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1710, &x1711, x1698, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1712, &x1713, x1698, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1714, &x1715, x1698, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1716, &x1717, x1698, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1718, &x1719, x1698, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1720, &x1721, x1698, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1722, &x1723, x1698, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1724, &x1725, 0x0, x1723, x1720);
  fiat_np384_addcarryx_u32(&x1726, &x1727, x1725, x1721, x1718);
  fiat_np384_addcarryx_u32(&x1728, &x1729, x1727, x1719, x1716);
  fiat_np384_addcarryx_u32(&x1730, &x1731, x1729, x1717, x1714);
  fiat_np384_addcarryx_u32(&x1732, &x1733, x1731, x1715, x1712);
  fiat_np384_addcarryx_u32(&x1734, &x1735, x1733, x1713, x1710);
  fiat_np384_addcarryx_u32(&x1736, &x1737, x1735, x1711, x1708);
  fiat_np384_addcarryx_u32(&x1738, &x1739, x1737, x1709, x1706);
  fiat_np384_addcarryx_u32(&x1740, &x1741, x1739, x1707, x1704);
  fiat_np384_addcarryx_u32(&x1742, &x1743, x1741, x1705, x1702);
  fiat_np384_addcarryx_u32(&x1744, &x1745, x1743, x1703, x1700);
  x1746 = (x1745 + x1701);
  fiat_np384_addcarryx_u32(&x1747, &x1748, 0x0, x1672, x1722);
  fiat_np384_addcarryx_u32(&x1749, &x1750, x1748, x1674, x1724);
  fiat_np384_addcarryx_u32(&x1751, &x1752, x1750, x1676, x1726);
  fiat_np384_addcarryx_u32(&x1753, &x1754, x1752, x1678, x1728);
  fiat_np384_addcarryx_u32(&x1755, &x1756, x1754, x1680, x1730);
  fiat_np384_addcarryx_u32(&x1757, &x1758, x1756, x1682, x1732);
  fiat_np384_addcarryx_u32(&x1759, &x1760, x1758, x1684, x1734);
  fiat_np384_addcarryx_u32(&x1761, &x1762, x1760, x1686, x1736);
  fiat_np384_addcarryx_u32(&x1763, &x1764, x1762, x1688, x1738);
  fiat_np384_addcarryx_u32(&x1765, &x1766, x1764, x1690, x1740);
  fiat_np384_addcarryx_u32(&x1767, &x1768, x1766, x1692, x1742);
  fiat_np384_addcarryx_u32(&x1769, &x1770, x1768, x1694, x1744);
  fiat_np384_addcarryx_u32(&x1771, &x1772, x1770, x1696, x1746);
  x1773 = ((uint32_t)x1772 + x1697);
  fiat_np384_subborrowx_u32(&x1774, &x1775, 0x0, x1749, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x1776, &x1777, x1775, x1751, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x1778, &x1779, x1777, x1753, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x1780, &x1781, x1779, x1755, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x1782, &x1783, x1781, x1757, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x1784, &x1785, x1783, x1759, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x1786, &x1787, x1785, x1761, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1788, &x1789, x1787, x1763, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1790, &x1791, x1789, x1765, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1792, &x1793, x1791, x1767, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1794, &x1795, x1793, x1769, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1796, &x1797, x1795, x1771, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1798, &x1799, x1797, x1773, 0x0);
  fiat_np384_cmovznz_u32(&x1800, x1799, x1774, x1749);
  fiat_np384_cmovznz_u32(&x1801, x1799, x1776, x1751);
  fiat_np384_cmovznz_u32(&x1802, x1799, x1778, x1753);
  fiat_np384_cmovznz_u32(&x1803, x1799, x1780, x1755);
  fiat_np384_cmovznz_u32(&x1804, x1799, x1782, x1757);
  fiat_np384_cmovznz_u32(&x1805, x1799, x1784, x1759);
  fiat_np384_cmovznz_u32(&x1806, x1799, x1786, x1761);
  fiat_np384_cmovznz_u32(&x1807, x1799, x1788, x1763);
  fiat_np384_cmovznz_u32(&x1808, x1799, x1790, x1765);
  fiat_np384_cmovznz_u32(&x1809, x1799, x1792, x1767);
  fiat_np384_cmovznz_u32(&x1810, x1799, x1794, x1769);
  fiat_np384_cmovznz_u32(&x1811, x1799, x1796, x1771);
  out1[0] = x1800;
  out1[1] = x1801;
  out1[2] = x1802;
  out1[3] = x1803;
  out1[4] = x1804;
  out1[5] = x1805;
  out1[6] = x1806;
  out1[7] = x1807;
  out1[8] = x1808;
  out1[9] = x1809;
  out1[10] = x1810;
  out1[11] = x1811;
}

/*
 * The function fiat_np384_add adds two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_add(fiat_np384_montgomery_domain_field_element out1, const fiat_np384_montgomery_domain_field_element arg1, const fiat_np384_montgomery_domain_field_element arg2) {
  uint32_t x1;
  fiat_np384_uint1 x2;
  uint32_t x3;
  fiat_np384_uint1 x4;
  uint32_t x5;
  fiat_np384_uint1 x6;
  uint32_t x7;
  fiat_np384_uint1 x8;
  uint32_t x9;
  fiat_np384_uint1 x10;
  uint32_t x11;
  fiat_np384_uint1 x12;
  uint32_t x13;
  fiat_np384_uint1 x14;
  uint32_t x15;
  fiat_np384_uint1 x16;
  uint32_t x17;
  fiat_np384_uint1 x18;
  uint32_t x19;
  fiat_np384_uint1 x20;
  uint32_t x21;
  fiat_np384_uint1 x22;
  uint32_t x23;
  fiat_np384_uint1 x24;
  uint32_t x25;
  fiat_np384_uint1 x26;
  uint32_t x27;
  fiat_np384_uint1 x28;
  uint32_t x29;
  fiat_np384_uint1 x30;
  uint32_t x31;
  fiat_np384_uint1 x32;
  uint32_t x33;
  fiat_np384_uint1 x34;
  uint32_t x35;
  fiat_np384_uint1 x36;
  uint32_t x37;
  fiat_np384_uint1 x38;
  uint32_t x39;
  fiat_np384_uint1 x40;
  uint32_t x41;
  fiat_np384_uint1 x42;
  uint32_t x43;
  fiat_np384_uint1 x44;
  uint32_t x45;
  fiat_np384_uint1 x46;
  uint32_t x47;
  fiat_np384_uint1 x48;
  uint32_t x49;
  fiat_np384_uint1 x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  fiat_np384_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_np384_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_np384_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_np384_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_np384_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_np384_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_np384_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  fiat_np384_addcarryx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  fiat_np384_addcarryx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
  fiat_np384_addcarryx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
  fiat_np384_addcarryx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
  fiat_np384_addcarryx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
  fiat_np384_subborrowx_u32(&x25, &x26, 0x0, x1, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x27, &x28, x26, x3, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x29, &x30, x28, x5, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x31, &x32, x30, x7, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x33, &x34, x32, x9, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x35, &x36, x34, x11, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x37, &x38, x36, x13, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x39, &x40, x38, x15, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x41, &x42, x40, x17, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x43, &x44, x42, x19, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x45, &x46, x44, x21, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x47, &x48, x46, x23, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x49, &x50, x48, x24, 0x0);
  fiat_np384_cmovznz_u32(&x51, x50, x25, x1);
  fiat_np384_cmovznz_u32(&x52, x50, x27, x3);
  fiat_np384_cmovznz_u32(&x53, x50, x29, x5);
  fiat_np384_cmovznz_u32(&x54, x50, x31, x7);
  fiat_np384_cmovznz_u32(&x55, x50, x33, x9);
  fiat_np384_cmovznz_u32(&x56, x50, x35, x11);
  fiat_np384_cmovznz_u32(&x57, x50, x37, x13);
  fiat_np384_cmovznz_u32(&x58, x50, x39, x15);
  fiat_np384_cmovznz_u32(&x59, x50, x41, x17);
  fiat_np384_cmovznz_u32(&x60, x50, x43, x19);
  fiat_np384_cmovznz_u32(&x61, x50, x45, x21);
  fiat_np384_cmovznz_u32(&x62, x50, x47, x23);
  out1[0] = x51;
  out1[1] = x52;
  out1[2] = x53;
  out1[3] = x54;
  out1[4] = x55;
  out1[5] = x56;
  out1[6] = x57;
  out1[7] = x58;
  out1[8] = x59;
  out1[9] = x60;
  out1[10] = x61;
  out1[11] = x62;
}

/*
 * The function fiat_np384_opp negates a field element in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_opp(fiat_np384_montgomery_domain_field_element out1, const fiat_np384_montgomery_domain_field_element arg1) {
  uint32_t x1;
  fiat_np384_uint1 x2;
  uint32_t x3;
  fiat_np384_uint1 x4;
  uint32_t x5;
  fiat_np384_uint1 x6;
  uint32_t x7;
  fiat_np384_uint1 x8;
  uint32_t x9;
  fiat_np384_uint1 x10;
  uint32_t x11;
  fiat_np384_uint1 x12;
  uint32_t x13;
  fiat_np384_uint1 x14;
  uint32_t x15;
  fiat_np384_uint1 x16;
  uint32_t x17;
  fiat_np384_uint1 x18;
  uint32_t x19;
  fiat_np384_uint1 x20;
  uint32_t x21;
  fiat_np384_uint1 x22;
  uint32_t x23;
  fiat_np384_uint1 x24;
  uint32_t x25;
  uint32_t x26;
  fiat_np384_uint1 x27;
  uint32_t x28;
  fiat_np384_uint1 x29;
  uint32_t x30;
  fiat_np384_uint1 x31;
  uint32_t x32;
  fiat_np384_uint1 x33;
  uint32_t x34;
  fiat_np384_uint1 x35;
  uint32_t x36;
  fiat_np384_uint1 x37;
  uint32_t x38;
  fiat_np384_uint1 x39;
  uint32_t x40;
  fiat_np384_uint1 x41;
  uint32_t x42;
  fiat_np384_uint1 x43;
  uint32_t x44;
  fiat_np384_uint1 x45;
  uint32_t x46;
  fiat_np384_uint1 x47;
  uint32_t x48;
  fiat_np384_uint1 x49;
  fiat_np384_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  fiat_np384_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  fiat_np384_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  fiat_np384_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  fiat_np384_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  fiat_np384_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  fiat_np384_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  fiat_np384_subborrowx_u32(&x15, &x16, x14, 0x0, (arg1[7]));
  fiat_np384_subborrowx_u32(&x17, &x18, x16, 0x0, (arg1[8]));
  fiat_np384_subborrowx_u32(&x19, &x20, x18, 0x0, (arg1[9]));
  fiat_np384_subborrowx_u32(&x21, &x22, x20, 0x0, (arg1[10]));
  fiat_np384_subborrowx_u32(&x23, &x24, x22, 0x0, (arg1[11]));
  fiat_np384_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
  fiat_np384_addcarryx_u32(&x26, &x27, 0x0, x1, (x25 & UINT32_C(0xccc52973)));
  fiat_np384_addcarryx_u32(&x28, &x29, x27, x3, (x25 & UINT32_C(0xecec196a)));
  fiat_np384_addcarryx_u32(&x30, &x31, x29, x5, (x25 & UINT32_C(0x48b0a77a)));
  fiat_np384_addcarryx_u32(&x32, &x33, x31, x7, (x25 & UINT32_C(0x581a0db2)));
  fiat_np384_addcarryx_u32(&x34, &x35, x33, x9, (x25 & UINT32_C(0xf4372ddf)));
  fiat_np384_addcarryx_u32(&x36, &x37, x35, x11, (x25 & UINT32_C(0xc7634d81)));
  fiat_np384_addcarryx_u32(&x38, &x39, x37, x13, x25);
  fiat_np384_addcarryx_u32(&x40, &x41, x39, x15, x25);
  fiat_np384_addcarryx_u32(&x42, &x43, x41, x17, x25);
  fiat_np384_addcarryx_u32(&x44, &x45, x43, x19, x25);
  fiat_np384_addcarryx_u32(&x46, &x47, x45, x21, x25);
  fiat_np384_addcarryx_u32(&x48, &x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/*
 * The function fiat_np384_from_montgomery translates a field element out of the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_from_montgomery(fiat_np384_non_montgomery_domain_field_element out1, const fiat_np384_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  fiat_np384_uint1 x29;
  uint32_t x30;
  fiat_np384_uint1 x31;
  uint32_t x32;
  fiat_np384_uint1 x33;
  uint32_t x34;
  fiat_np384_uint1 x35;
  uint32_t x36;
  fiat_np384_uint1 x37;
  uint32_t x38;
  fiat_np384_uint1 x39;
  uint32_t x40;
  fiat_np384_uint1 x41;
  uint32_t x42;
  fiat_np384_uint1 x43;
  uint32_t x44;
  fiat_np384_uint1 x45;
  uint32_t x46;
  fiat_np384_uint1 x47;
  uint32_t x48;
  fiat_np384_uint1 x49;
  uint32_t x50;
  fiat_np384_uint1 x51;
  uint32_t x52;
  fiat_np384_uint1 x53;
  uint32_t x54;
  fiat_np384_uint1 x55;
  uint32_t x56;
  fiat_np384_uint1 x57;
  uint32_t x58;
  fiat_np384_uint1 x59;
  uint32_t x60;
  fiat_np384_uint1 x61;
  uint32_t x62;
  fiat_np384_uint1 x63;
  uint32_t x64;
  fiat_np384_uint1 x65;
  uint32_t x66;
  fiat_np384_uint1 x67;
  uint32_t x68;
  fiat_np384_uint1 x69;
  uint32_t x70;
  fiat_np384_uint1 x71;
  uint32_t x72;
  fiat_np384_uint1 x73;
  uint32_t x74;
  fiat_np384_uint1 x75;
  uint32_t x76;
  fiat_np384_uint1 x77;
  uint32_t x78;
  fiat_np384_uint1 x79;
  uint32_t x80;
  fiat_np384_uint1 x81;
  uint32_t x82;
  fiat_np384_uint1 x83;
  uint32_t x84;
  fiat_np384_uint1 x85;
  uint32_t x86;
  fiat_np384_uint1 x87;
  uint32_t x88;
  fiat_np384_uint1 x89;
  uint32_t x90;
  fiat_np384_uint1 x91;
  uint32_t x92;
  fiat_np384_uint1 x93;
  uint32_t x94;
  fiat_np384_uint1 x95;
  uint32_t x96;
  fiat_np384_uint1 x97;
  uint32_t x98;
  fiat_np384_uint1 x99;
  uint32_t x100;
  uint32_t x101;
  uint32_t x102;
  uint32_t x103;
  uint32_t x104;
  uint32_t x105;
  uint32_t x106;
  uint32_t x107;
  uint32_t x108;
  uint32_t x109;
  uint32_t x110;
  uint32_t x111;
  uint32_t x112;
  uint32_t x113;
  uint32_t x114;
  uint32_t x115;
  uint32_t x116;
  uint32_t x117;
  uint32_t x118;
  uint32_t x119;
  uint32_t x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  fiat_np384_uint1 x127;
  uint32_t x128;
  fiat_np384_uint1 x129;
  uint32_t x130;
  fiat_np384_uint1 x131;
  uint32_t x132;
  fiat_np384_uint1 x133;
  uint32_t x134;
  fiat_np384_uint1 x135;
  uint32_t x136;
  fiat_np384_uint1 x137;
  uint32_t x138;
  fiat_np384_uint1 x139;
  uint32_t x140;
  fiat_np384_uint1 x141;
  uint32_t x142;
  fiat_np384_uint1 x143;
  uint32_t x144;
  fiat_np384_uint1 x145;
  uint32_t x146;
  fiat_np384_uint1 x147;
  uint32_t x148;
  fiat_np384_uint1 x149;
  uint32_t x150;
  fiat_np384_uint1 x151;
  uint32_t x152;
  fiat_np384_uint1 x153;
  uint32_t x154;
  fiat_np384_uint1 x155;
  uint32_t x156;
  fiat_np384_uint1 x157;
  uint32_t x158;
  fiat_np384_uint1 x159;
  uint32_t x160;
  fiat_np384_uint1 x161;
  uint32_t x162;
  fiat_np384_uint1 x163;
  uint32_t x164;
  fiat_np384_uint1 x165;
  uint32_t x166;
  fiat_np384_uint1 x167;
  uint32_t x168;
  fiat_np384_uint1 x169;
  uint32_t x170;
  fiat_np384_uint1 x171;
  uint32_t x172;
  fiat_np384_uint1 x173;
  uint32_t x174;
  fiat_np384_uint1 x175;
  uint32_t x176;
  fiat_np384_uint1 x177;
  uint32_t x178;
  fiat_np384_uint1 x179;
  uint32_t x180;
  fiat_np384_uint1 x181;
  uint32_t x182;
  fiat_np384_uint1 x183;
  uint32_t x184;
  fiat_np384_uint1 x185;
  uint32_t x186;
  fiat_np384_uint1 x187;
  uint32_t x188;
  fiat_np384_uint1 x189;
  uint32_t x190;
  fiat_np384_uint1 x191;
  uint32_t x192;
  fiat_np384_uint1 x193;
  uint32_t x194;
  fiat_np384_uint1 x195;
  uint32_t x196;
  fiat_np384_uint1 x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  fiat_np384_uint1 x225;
  uint32_t x226;
  fiat_np384_uint1 x227;
  uint32_t x228;
  fiat_np384_uint1 x229;
  uint32_t x230;
  fiat_np384_uint1 x231;
  uint32_t x232;
  fiat_np384_uint1 x233;
  uint32_t x234;
  fiat_np384_uint1 x235;
  uint32_t x236;
  fiat_np384_uint1 x237;
  uint32_t x238;
  fiat_np384_uint1 x239;
  uint32_t x240;
  fiat_np384_uint1 x241;
  uint32_t x242;
  fiat_np384_uint1 x243;
  uint32_t x244;
  fiat_np384_uint1 x245;
  uint32_t x246;
  fiat_np384_uint1 x247;
  uint32_t x248;
  fiat_np384_uint1 x249;
  uint32_t x250;
  fiat_np384_uint1 x251;
  uint32_t x252;
  fiat_np384_uint1 x253;
  uint32_t x254;
  fiat_np384_uint1 x255;
  uint32_t x256;
  fiat_np384_uint1 x257;
  uint32_t x258;
  fiat_np384_uint1 x259;
  uint32_t x260;
  fiat_np384_uint1 x261;
  uint32_t x262;
  fiat_np384_uint1 x263;
  uint32_t x264;
  fiat_np384_uint1 x265;
  uint32_t x266;
  fiat_np384_uint1 x267;
  uint32_t x268;
  fiat_np384_uint1 x269;
  uint32_t x270;
  fiat_np384_uint1 x271;
  uint32_t x272;
  fiat_np384_uint1 x273;
  uint32_t x274;
  fiat_np384_uint1 x275;
  uint32_t x276;
  fiat_np384_uint1 x277;
  uint32_t x278;
  fiat_np384_uint1 x279;
  uint32_t x280;
  fiat_np384_uint1 x281;
  uint32_t x282;
  fiat_np384_uint1 x283;
  uint32_t x284;
  fiat_np384_uint1 x285;
  uint32_t x286;
  fiat_np384_uint1 x287;
  uint32_t x288;
  fiat_np384_uint1 x289;
  uint32_t x290;
  fiat_np384_uint1 x291;
  uint32_t x292;
  fiat_np384_uint1 x293;
  uint32_t x294;
  fiat_np384_uint1 x295;
  uint32_t x296;
  uint32_t x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  uint32_t x318;
  uint32_t x319;
  uint32_t x320;
  uint32_t x321;
  uint32_t x322;
  fiat_np384_uint1 x323;
  uint32_t x324;
  fiat_np384_uint1 x325;
  uint32_t x326;
  fiat_np384_uint1 x327;
  uint32_t x328;
  fiat_np384_uint1 x329;
  uint32_t x330;
  fiat_np384_uint1 x331;
  uint32_t x332;
  fiat_np384_uint1 x333;
  uint32_t x334;
  fiat_np384_uint1 x335;
  uint32_t x336;
  fiat_np384_uint1 x337;
  uint32_t x338;
  fiat_np384_uint1 x339;
  uint32_t x340;
  fiat_np384_uint1 x341;
  uint32_t x342;
  fiat_np384_uint1 x343;
  uint32_t x344;
  fiat_np384_uint1 x345;
  uint32_t x346;
  fiat_np384_uint1 x347;
  uint32_t x348;
  fiat_np384_uint1 x349;
  uint32_t x350;
  fiat_np384_uint1 x351;
  uint32_t x352;
  fiat_np384_uint1 x353;
  uint32_t x354;
  fiat_np384_uint1 x355;
  uint32_t x356;
  fiat_np384_uint1 x357;
  uint32_t x358;
  fiat_np384_uint1 x359;
  uint32_t x360;
  fiat_np384_uint1 x361;
  uint32_t x362;
  fiat_np384_uint1 x363;
  uint32_t x364;
  fiat_np384_uint1 x365;
  uint32_t x366;
  fiat_np384_uint1 x367;
  uint32_t x368;
  fiat_np384_uint1 x369;
  uint32_t x370;
  fiat_np384_uint1 x371;
  uint32_t x372;
  fiat_np384_uint1 x373;
  uint32_t x374;
  fiat_np384_uint1 x375;
  uint32_t x376;
  fiat_np384_uint1 x377;
  uint32_t x378;
  fiat_np384_uint1 x379;
  uint32_t x380;
  fiat_np384_uint1 x381;
  uint32_t x382;
  fiat_np384_uint1 x383;
  uint32_t x384;
  fiat_np384_uint1 x385;
  uint32_t x386;
  fiat_np384_uint1 x387;
  uint32_t x388;
  fiat_np384_uint1 x389;
  uint32_t x390;
  fiat_np384_uint1 x391;
  uint32_t x392;
  fiat_np384_uint1 x393;
  uint32_t x394;
  uint32_t x395;
  uint32_t x396;
  uint32_t x397;
  uint32_t x398;
  uint32_t x399;
  uint32_t x400;
  uint32_t x401;
  uint32_t x402;
  uint32_t x403;
  uint32_t x404;
  uint32_t x405;
  uint32_t x406;
  uint32_t x407;
  uint32_t x408;
  uint32_t x409;
  uint32_t x410;
  uint32_t x411;
  uint32_t x412;
  uint32_t x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  uint32_t x417;
  uint32_t x418;
  uint32_t x419;
  uint32_t x420;
  fiat_np384_uint1 x421;
  uint32_t x422;
  fiat_np384_uint1 x423;
  uint32_t x424;
  fiat_np384_uint1 x425;
  uint32_t x426;
  fiat_np384_uint1 x427;
  uint32_t x428;
  fiat_np384_uint1 x429;
  uint32_t x430;
  fiat_np384_uint1 x431;
  uint32_t x432;
  fiat_np384_uint1 x433;
  uint32_t x434;
  fiat_np384_uint1 x435;
  uint32_t x436;
  fiat_np384_uint1 x437;
  uint32_t x438;
  fiat_np384_uint1 x439;
  uint32_t x440;
  fiat_np384_uint1 x441;
  uint32_t x442;
  fiat_np384_uint1 x443;
  uint32_t x444;
  fiat_np384_uint1 x445;
  uint32_t x446;
  fiat_np384_uint1 x447;
  uint32_t x448;
  fiat_np384_uint1 x449;
  uint32_t x450;
  fiat_np384_uint1 x451;
  uint32_t x452;
  fiat_np384_uint1 x453;
  uint32_t x454;
  fiat_np384_uint1 x455;
  uint32_t x456;
  fiat_np384_uint1 x457;
  uint32_t x458;
  fiat_np384_uint1 x459;
  uint32_t x460;
  fiat_np384_uint1 x461;
  uint32_t x462;
  fiat_np384_uint1 x463;
  uint32_t x464;
  fiat_np384_uint1 x465;
  uint32_t x466;
  fiat_np384_uint1 x467;
  uint32_t x468;
  fiat_np384_uint1 x469;
  uint32_t x470;
  fiat_np384_uint1 x471;
  uint32_t x472;
  fiat_np384_uint1 x473;
  uint32_t x474;
  fiat_np384_uint1 x475;
  uint32_t x476;
  fiat_np384_uint1 x477;
  uint32_t x478;
  fiat_np384_uint1 x479;
  uint32_t x480;
  fiat_np384_uint1 x481;
  uint32_t x482;
  fiat_np384_uint1 x483;
  uint32_t x484;
  fiat_np384_uint1 x485;
  uint32_t x486;
  fiat_np384_uint1 x487;
  uint32_t x488;
  fiat_np384_uint1 x489;
  uint32_t x490;
  fiat_np384_uint1 x491;
  uint32_t x492;
  uint32_t x493;
  uint32_t x494;
  uint32_t x495;
  uint32_t x496;
  uint32_t x497;
  uint32_t x498;
  uint32_t x499;
  uint32_t x500;
  uint32_t x501;
  uint32_t x502;
  uint32_t x503;
  uint32_t x504;
  uint32_t x505;
  uint32_t x506;
  uint32_t x507;
  uint32_t x508;
  uint32_t x509;
  uint32_t x510;
  uint32_t x511;
  uint32_t x512;
  uint32_t x513;
  uint32_t x514;
  uint32_t x515;
  uint32_t x516;
  uint32_t x517;
  uint32_t x518;
  fiat_np384_uint1 x519;
  uint32_t x520;
  fiat_np384_uint1 x521;
  uint32_t x522;
  fiat_np384_uint1 x523;
  uint32_t x524;
  fiat_np384_uint1 x525;
  uint32_t x526;
  fiat_np384_uint1 x527;
  uint32_t x528;
  fiat_np384_uint1 x529;
  uint32_t x530;
  fiat_np384_uint1 x531;
  uint32_t x532;
  fiat_np384_uint1 x533;
  uint32_t x534;
  fiat_np384_uint1 x535;
  uint32_t x536;
  fiat_np384_uint1 x537;
  uint32_t x538;
  fiat_np384_uint1 x539;
  uint32_t x540;
  fiat_np384_uint1 x541;
  uint32_t x542;
  fiat_np384_uint1 x543;
  uint32_t x544;
  fiat_np384_uint1 x545;
  uint32_t x546;
  fiat_np384_uint1 x547;
  uint32_t x548;
  fiat_np384_uint1 x549;
  uint32_t x550;
  fiat_np384_uint1 x551;
  uint32_t x552;
  fiat_np384_uint1 x553;
  uint32_t x554;
  fiat_np384_uint1 x555;
  uint32_t x556;
  fiat_np384_uint1 x557;
  uint32_t x558;
  fiat_np384_uint1 x559;
  uint32_t x560;
  fiat_np384_uint1 x561;
  uint32_t x562;
  fiat_np384_uint1 x563;
  uint32_t x564;
  fiat_np384_uint1 x565;
  uint32_t x566;
  fiat_np384_uint1 x567;
  uint32_t x568;
  fiat_np384_uint1 x569;
  uint32_t x570;
  fiat_np384_uint1 x571;
  uint32_t x572;
  fiat_np384_uint1 x573;
  uint32_t x574;
  fiat_np384_uint1 x575;
  uint32_t x576;
  fiat_np384_uint1 x577;
  uint32_t x578;
  fiat_np384_uint1 x579;
  uint32_t x580;
  fiat_np384_uint1 x581;
  uint32_t x582;
  fiat_np384_uint1 x583;
  uint32_t x584;
  fiat_np384_uint1 x585;
  uint32_t x586;
  fiat_np384_uint1 x587;
  uint32_t x588;
  fiat_np384_uint1 x589;
  uint32_t x590;
  uint32_t x591;
  uint32_t x592;
  uint32_t x593;
  uint32_t x594;
  uint32_t x595;
  uint32_t x596;
  uint32_t x597;
  uint32_t x598;
  uint32_t x599;
  uint32_t x600;
  uint32_t x601;
  uint32_t x602;
  uint32_t x603;
  uint32_t x604;
  uint32_t x605;
  uint32_t x606;
  uint32_t x607;
  uint32_t x608;
  uint32_t x609;
  uint32_t x610;
  uint32_t x611;
  uint32_t x612;
  uint32_t x613;
  uint32_t x614;
  uint32_t x615;
  uint32_t x616;
  fiat_np384_uint1 x617;
  uint32_t x618;
  fiat_np384_uint1 x619;
  uint32_t x620;
  fiat_np384_uint1 x621;
  uint32_t x622;
  fiat_np384_uint1 x623;
  uint32_t x624;
  fiat_np384_uint1 x625;
  uint32_t x626;
  fiat_np384_uint1 x627;
  uint32_t x628;
  fiat_np384_uint1 x629;
  uint32_t x630;
  fiat_np384_uint1 x631;
  uint32_t x632;
  fiat_np384_uint1 x633;
  uint32_t x634;
  fiat_np384_uint1 x635;
  uint32_t x636;
  fiat_np384_uint1 x637;
  uint32_t x638;
  fiat_np384_uint1 x639;
  uint32_t x640;
  fiat_np384_uint1 x641;
  uint32_t x642;
  fiat_np384_uint1 x643;
  uint32_t x644;
  fiat_np384_uint1 x645;
  uint32_t x646;
  fiat_np384_uint1 x647;
  uint32_t x648;
  fiat_np384_uint1 x649;
  uint32_t x650;
  fiat_np384_uint1 x651;
  uint32_t x652;
  fiat_np384_uint1 x653;
  uint32_t x654;
  fiat_np384_uint1 x655;
  uint32_t x656;
  fiat_np384_uint1 x657;
  uint32_t x658;
  fiat_np384_uint1 x659;
  uint32_t x660;
  fiat_np384_uint1 x661;
  uint32_t x662;
  fiat_np384_uint1 x663;
  uint32_t x664;
  fiat_np384_uint1 x665;
  uint32_t x666;
  fiat_np384_uint1 x667;
  uint32_t x668;
  fiat_np384_uint1 x669;
  uint32_t x670;
  fiat_np384_uint1 x671;
  uint32_t x672;
  fiat_np384_uint1 x673;
  uint32_t x674;
  fiat_np384_uint1 x675;
  uint32_t x676;
  fiat_np384_uint1 x677;
  uint32_t x678;
  fiat_np384_uint1 x679;
  uint32_t x680;
  fiat_np384_uint1 x681;
  uint32_t x682;
  fiat_np384_uint1 x683;
  uint32_t x684;
  fiat_np384_uint1 x685;
  uint32_t x686;
  fiat_np384_uint1 x687;
  uint32_t x688;
  uint32_t x689;
  uint32_t x690;
  uint32_t x691;
  uint32_t x692;
  uint32_t x693;
  uint32_t x694;
  uint32_t x695;
  uint32_t x696;
  uint32_t x697;
  uint32_t x698;
  uint32_t x699;
  uint32_t x700;
  uint32_t x701;
  uint32_t x702;
  uint32_t x703;
  uint32_t x704;
  uint32_t x705;
  uint32_t x706;
  uint32_t x707;
  uint32_t x708;
  uint32_t x709;
  uint32_t x710;
  uint32_t x711;
  uint32_t x712;
  uint32_t x713;
  uint32_t x714;
  fiat_np384_uint1 x715;
  uint32_t x716;
  fiat_np384_uint1 x717;
  uint32_t x718;
  fiat_np384_uint1 x719;
  uint32_t x720;
  fiat_np384_uint1 x721;
  uint32_t x722;
  fiat_np384_uint1 x723;
  uint32_t x724;
  fiat_np384_uint1 x725;
  uint32_t x726;
  fiat_np384_uint1 x727;
  uint32_t x728;
  fiat_np384_uint1 x729;
  uint32_t x730;
  fiat_np384_uint1 x731;
  uint32_t x732;
  fiat_np384_uint1 x733;
  uint32_t x734;
  fiat_np384_uint1 x735;
  uint32_t x736;
  fiat_np384_uint1 x737;
  uint32_t x738;
  fiat_np384_uint1 x739;
  uint32_t x740;
  fiat_np384_uint1 x741;
  uint32_t x742;
  fiat_np384_uint1 x743;
  uint32_t x744;
  fiat_np384_uint1 x745;
  uint32_t x746;
  fiat_np384_uint1 x747;
  uint32_t x748;
  fiat_np384_uint1 x749;
  uint32_t x750;
  fiat_np384_uint1 x751;
  uint32_t x752;
  fiat_np384_uint1 x753;
  uint32_t x754;
  fiat_np384_uint1 x755;
  uint32_t x756;
  fiat_np384_uint1 x757;
  uint32_t x758;
  fiat_np384_uint1 x759;
  uint32_t x760;
  fiat_np384_uint1 x761;
  uint32_t x762;
  fiat_np384_uint1 x763;
  uint32_t x764;
  fiat_np384_uint1 x765;
  uint32_t x766;
  fiat_np384_uint1 x767;
  uint32_t x768;
  fiat_np384_uint1 x769;
  uint32_t x770;
  fiat_np384_uint1 x771;
  uint32_t x772;
  fiat_np384_uint1 x773;
  uint32_t x774;
  fiat_np384_uint1 x775;
  uint32_t x776;
  fiat_np384_uint1 x777;
  uint32_t x778;
  fiat_np384_uint1 x779;
  uint32_t x780;
  fiat_np384_uint1 x781;
  uint32_t x782;
  fiat_np384_uint1 x783;
  uint32_t x784;
  fiat_np384_uint1 x785;
  uint32_t x786;
  uint32_t x787;
  uint32_t x788;
  uint32_t x789;
  uint32_t x790;
  uint32_t x791;
  uint32_t x792;
  uint32_t x793;
  uint32_t x794;
  uint32_t x795;
  uint32_t x796;
  uint32_t x797;
  uint32_t x798;
  uint32_t x799;
  uint32_t x800;
  uint32_t x801;
  uint32_t x802;
  uint32_t x803;
  uint32_t x804;
  uint32_t x805;
  uint32_t x806;
  uint32_t x807;
  uint32_t x808;
  uint32_t x809;
  uint32_t x810;
  uint32_t x811;
  uint32_t x812;
  fiat_np384_uint1 x813;
  uint32_t x814;
  fiat_np384_uint1 x815;
  uint32_t x816;
  fiat_np384_uint1 x817;
  uint32_t x818;
  fiat_np384_uint1 x819;
  uint32_t x820;
  fiat_np384_uint1 x821;
  uint32_t x822;
  fiat_np384_uint1 x823;
  uint32_t x824;
  fiat_np384_uint1 x825;
  uint32_t x826;
  fiat_np384_uint1 x827;
  uint32_t x828;
  fiat_np384_uint1 x829;
  uint32_t x830;
  fiat_np384_uint1 x831;
  uint32_t x832;
  fiat_np384_uint1 x833;
  uint32_t x834;
  fiat_np384_uint1 x835;
  uint32_t x836;
  fiat_np384_uint1 x837;
  uint32_t x838;
  fiat_np384_uint1 x839;
  uint32_t x840;
  fiat_np384_uint1 x841;
  uint32_t x842;
  fiat_np384_uint1 x843;
  uint32_t x844;
  fiat_np384_uint1 x845;
  uint32_t x846;
  fiat_np384_uint1 x847;
  uint32_t x848;
  fiat_np384_uint1 x849;
  uint32_t x850;
  fiat_np384_uint1 x851;
  uint32_t x852;
  fiat_np384_uint1 x853;
  uint32_t x854;
  fiat_np384_uint1 x855;
  uint32_t x856;
  fiat_np384_uint1 x857;
  uint32_t x858;
  fiat_np384_uint1 x859;
  uint32_t x860;
  fiat_np384_uint1 x861;
  uint32_t x862;
  fiat_np384_uint1 x863;
  uint32_t x864;
  fiat_np384_uint1 x865;
  uint32_t x866;
  fiat_np384_uint1 x867;
  uint32_t x868;
  fiat_np384_uint1 x869;
  uint32_t x870;
  fiat_np384_uint1 x871;
  uint32_t x872;
  fiat_np384_uint1 x873;
  uint32_t x874;
  fiat_np384_uint1 x875;
  uint32_t x876;
  fiat_np384_uint1 x877;
  uint32_t x878;
  fiat_np384_uint1 x879;
  uint32_t x880;
  fiat_np384_uint1 x881;
  uint32_t x882;
  fiat_np384_uint1 x883;
  uint32_t x884;
  uint32_t x885;
  uint32_t x886;
  uint32_t x887;
  uint32_t x888;
  uint32_t x889;
  uint32_t x890;
  uint32_t x891;
  uint32_t x892;
  uint32_t x893;
  uint32_t x894;
  uint32_t x895;
  uint32_t x896;
  uint32_t x897;
  uint32_t x898;
  uint32_t x899;
  uint32_t x900;
  uint32_t x901;
  uint32_t x902;
  uint32_t x903;
  uint32_t x904;
  uint32_t x905;
  uint32_t x906;
  uint32_t x907;
  uint32_t x908;
  uint32_t x909;
  uint32_t x910;
  fiat_np384_uint1 x911;
  uint32_t x912;
  fiat_np384_uint1 x913;
  uint32_t x914;
  fiat_np384_uint1 x915;
  uint32_t x916;
  fiat_np384_uint1 x917;
  uint32_t x918;
  fiat_np384_uint1 x919;
  uint32_t x920;
  fiat_np384_uint1 x921;
  uint32_t x922;
  fiat_np384_uint1 x923;
  uint32_t x924;
  fiat_np384_uint1 x925;
  uint32_t x926;
  fiat_np384_uint1 x927;
  uint32_t x928;
  fiat_np384_uint1 x929;
  uint32_t x930;
  fiat_np384_uint1 x931;
  uint32_t x932;
  fiat_np384_uint1 x933;
  uint32_t x934;
  fiat_np384_uint1 x935;
  uint32_t x936;
  fiat_np384_uint1 x937;
  uint32_t x938;
  fiat_np384_uint1 x939;
  uint32_t x940;
  fiat_np384_uint1 x941;
  uint32_t x942;
  fiat_np384_uint1 x943;
  uint32_t x944;
  fiat_np384_uint1 x945;
  uint32_t x946;
  fiat_np384_uint1 x947;
  uint32_t x948;
  fiat_np384_uint1 x949;
  uint32_t x950;
  fiat_np384_uint1 x951;
  uint32_t x952;
  fiat_np384_uint1 x953;
  uint32_t x954;
  fiat_np384_uint1 x955;
  uint32_t x956;
  fiat_np384_uint1 x957;
  uint32_t x958;
  fiat_np384_uint1 x959;
  uint32_t x960;
  fiat_np384_uint1 x961;
  uint32_t x962;
  fiat_np384_uint1 x963;
  uint32_t x964;
  fiat_np384_uint1 x965;
  uint32_t x966;
  fiat_np384_uint1 x967;
  uint32_t x968;
  fiat_np384_uint1 x969;
  uint32_t x970;
  fiat_np384_uint1 x971;
  uint32_t x972;
  fiat_np384_uint1 x973;
  uint32_t x974;
  fiat_np384_uint1 x975;
  uint32_t x976;
  fiat_np384_uint1 x977;
  uint32_t x978;
  fiat_np384_uint1 x979;
  uint32_t x980;
  fiat_np384_uint1 x981;
  uint32_t x982;
  uint32_t x983;
  uint32_t x984;
  uint32_t x985;
  uint32_t x986;
  uint32_t x987;
  uint32_t x988;
  uint32_t x989;
  uint32_t x990;
  uint32_t x991;
  uint32_t x992;
  uint32_t x993;
  uint32_t x994;
  uint32_t x995;
  uint32_t x996;
  uint32_t x997;
  uint32_t x998;
  uint32_t x999;
  uint32_t x1000;
  uint32_t x1001;
  uint32_t x1002;
  uint32_t x1003;
  uint32_t x1004;
  uint32_t x1005;
  uint32_t x1006;
  uint32_t x1007;
  uint32_t x1008;
  fiat_np384_uint1 x1009;
  uint32_t x1010;
  fiat_np384_uint1 x1011;
  uint32_t x1012;
  fiat_np384_uint1 x1013;
  uint32_t x1014;
  fiat_np384_uint1 x1015;
  uint32_t x1016;
  fiat_np384_uint1 x1017;
  uint32_t x1018;
  fiat_np384_uint1 x1019;
  uint32_t x1020;
  fiat_np384_uint1 x1021;
  uint32_t x1022;
  fiat_np384_uint1 x1023;
  uint32_t x1024;
  fiat_np384_uint1 x1025;
  uint32_t x1026;
  fiat_np384_uint1 x1027;
  uint32_t x1028;
  fiat_np384_uint1 x1029;
  uint32_t x1030;
  fiat_np384_uint1 x1031;
  uint32_t x1032;
  fiat_np384_uint1 x1033;
  uint32_t x1034;
  fiat_np384_uint1 x1035;
  uint32_t x1036;
  fiat_np384_uint1 x1037;
  uint32_t x1038;
  fiat_np384_uint1 x1039;
  uint32_t x1040;
  fiat_np384_uint1 x1041;
  uint32_t x1042;
  fiat_np384_uint1 x1043;
  uint32_t x1044;
  fiat_np384_uint1 x1045;
  uint32_t x1046;
  fiat_np384_uint1 x1047;
  uint32_t x1048;
  fiat_np384_uint1 x1049;
  uint32_t x1050;
  fiat_np384_uint1 x1051;
  uint32_t x1052;
  fiat_np384_uint1 x1053;
  uint32_t x1054;
  fiat_np384_uint1 x1055;
  uint32_t x1056;
  fiat_np384_uint1 x1057;
  uint32_t x1058;
  fiat_np384_uint1 x1059;
  uint32_t x1060;
  fiat_np384_uint1 x1061;
  uint32_t x1062;
  fiat_np384_uint1 x1063;
  uint32_t x1064;
  fiat_np384_uint1 x1065;
  uint32_t x1066;
  fiat_np384_uint1 x1067;
  uint32_t x1068;
  fiat_np384_uint1 x1069;
  uint32_t x1070;
  fiat_np384_uint1 x1071;
  uint32_t x1072;
  fiat_np384_uint1 x1073;
  uint32_t x1074;
  fiat_np384_uint1 x1075;
  uint32_t x1076;
  fiat_np384_uint1 x1077;
  uint32_t x1078;
  fiat_np384_uint1 x1079;
  uint32_t x1080;
  uint32_t x1081;
  uint32_t x1082;
  uint32_t x1083;
  uint32_t x1084;
  uint32_t x1085;
  uint32_t x1086;
  uint32_t x1087;
  uint32_t x1088;
  uint32_t x1089;
  uint32_t x1090;
  uint32_t x1091;
  uint32_t x1092;
  uint32_t x1093;
  uint32_t x1094;
  uint32_t x1095;
  uint32_t x1096;
  uint32_t x1097;
  uint32_t x1098;
  uint32_t x1099;
  uint32_t x1100;
  uint32_t x1101;
  uint32_t x1102;
  uint32_t x1103;
  uint32_t x1104;
  uint32_t x1105;
  uint32_t x1106;
  fiat_np384_uint1 x1107;
  uint32_t x1108;
  fiat_np384_uint1 x1109;
  uint32_t x1110;
  fiat_np384_uint1 x1111;
  uint32_t x1112;
  fiat_np384_uint1 x1113;
  uint32_t x1114;
  fiat_np384_uint1 x1115;
  uint32_t x1116;
  fiat_np384_uint1 x1117;
  uint32_t x1118;
  fiat_np384_uint1 x1119;
  uint32_t x1120;
  fiat_np384_uint1 x1121;
  uint32_t x1122;
  fiat_np384_uint1 x1123;
  uint32_t x1124;
  fiat_np384_uint1 x1125;
  uint32_t x1126;
  fiat_np384_uint1 x1127;
  uint32_t x1128;
  fiat_np384_uint1 x1129;
  uint32_t x1130;
  fiat_np384_uint1 x1131;
  uint32_t x1132;
  fiat_np384_uint1 x1133;
  uint32_t x1134;
  fiat_np384_uint1 x1135;
  uint32_t x1136;
  fiat_np384_uint1 x1137;
  uint32_t x1138;
  fiat_np384_uint1 x1139;
  uint32_t x1140;
  fiat_np384_uint1 x1141;
  uint32_t x1142;
  fiat_np384_uint1 x1143;
  uint32_t x1144;
  fiat_np384_uint1 x1145;
  uint32_t x1146;
  fiat_np384_uint1 x1147;
  uint32_t x1148;
  fiat_np384_uint1 x1149;
  uint32_t x1150;
  fiat_np384_uint1 x1151;
  uint32_t x1152;
  fiat_np384_uint1 x1153;
  uint32_t x1154;
  fiat_np384_uint1 x1155;
  uint32_t x1156;
  fiat_np384_uint1 x1157;
  uint32_t x1158;
  fiat_np384_uint1 x1159;
  uint32_t x1160;
  fiat_np384_uint1 x1161;
  uint32_t x1162;
  fiat_np384_uint1 x1163;
  uint32_t x1164;
  fiat_np384_uint1 x1165;
  uint32_t x1166;
  fiat_np384_uint1 x1167;
  uint32_t x1168;
  fiat_np384_uint1 x1169;
  uint32_t x1170;
  fiat_np384_uint1 x1171;
  uint32_t x1172;
  fiat_np384_uint1 x1173;
  uint32_t x1174;
  fiat_np384_uint1 x1175;
  uint32_t x1176;
  fiat_np384_uint1 x1177;
  uint32_t x1178;
  fiat_np384_uint1 x1179;
  uint32_t x1180;
  uint32_t x1181;
  uint32_t x1182;
  uint32_t x1183;
  uint32_t x1184;
  uint32_t x1185;
  uint32_t x1186;
  uint32_t x1187;
  uint32_t x1188;
  uint32_t x1189;
  uint32_t x1190;
  uint32_t x1191;
  x1 = (arg1[0]);
  fiat_np384_mulx_u32(&x2, &x3, x1, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x4, &x5, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x6, &x7, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x8, &x9, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x10, &x11, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x12, &x13, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x14, &x15, x2, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x16, &x17, x2, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x18, &x19, x2, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x20, &x21, x2, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x22, &x23, x2, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x24, &x25, x2, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x26, &x27, x2, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x28, &x29, 0x0, x27, x24);
  fiat_np384_addcarryx_u32(&x30, &x31, x29, x25, x22);
  fiat_np384_addcarryx_u32(&x32, &x33, x31, x23, x20);
  fiat_np384_addcarryx_u32(&x34, &x35, x33, x21, x18);
  fiat_np384_addcarryx_u32(&x36, &x37, x35, x19, x16);
  fiat_np384_addcarryx_u32(&x38, &x39, x37, x17, x14);
  fiat_np384_addcarryx_u32(&x40, &x41, x39, x15, x12);
  fiat_np384_addcarryx_u32(&x42, &x43, x41, x13, x10);
  fiat_np384_addcarryx_u32(&x44, &x45, x43, x11, x8);
  fiat_np384_addcarryx_u32(&x46, &x47, x45, x9, x6);
  fiat_np384_addcarryx_u32(&x48, &x49, x47, x7, x4);
  fiat_np384_addcarryx_u32(&x50, &x51, 0x0, x1, x26);
  fiat_np384_addcarryx_u32(&x52, &x53, x51, 0x0, x28);
  fiat_np384_addcarryx_u32(&x54, &x55, x53, 0x0, x30);
  fiat_np384_addcarryx_u32(&x56, &x57, x55, 0x0, x32);
  fiat_np384_addcarryx_u32(&x58, &x59, x57, 0x0, x34);
  fiat_np384_addcarryx_u32(&x60, &x61, x59, 0x0, x36);
  fiat_np384_addcarryx_u32(&x62, &x63, x61, 0x0, x38);
  fiat_np384_addcarryx_u32(&x64, &x65, x63, 0x0, x40);
  fiat_np384_addcarryx_u32(&x66, &x67, x65, 0x0, x42);
  fiat_np384_addcarryx_u32(&x68, &x69, x67, 0x0, x44);
  fiat_np384_addcarryx_u32(&x70, &x71, x69, 0x0, x46);
  fiat_np384_addcarryx_u32(&x72, &x73, x71, 0x0, x48);
  fiat_np384_addcarryx_u32(&x74, &x75, x73, 0x0, (x49 + x5));
  fiat_np384_addcarryx_u32(&x76, &x77, 0x0, x52, (arg1[1]));
  fiat_np384_addcarryx_u32(&x78, &x79, x77, x54, 0x0);
  fiat_np384_addcarryx_u32(&x80, &x81, x79, x56, 0x0);
  fiat_np384_addcarryx_u32(&x82, &x83, x81, x58, 0x0);
  fiat_np384_addcarryx_u32(&x84, &x85, x83, x60, 0x0);
  fiat_np384_addcarryx_u32(&x86, &x87, x85, x62, 0x0);
  fiat_np384_addcarryx_u32(&x88, &x89, x87, x64, 0x0);
  fiat_np384_addcarryx_u32(&x90, &x91, x89, x66, 0x0);
  fiat_np384_addcarryx_u32(&x92, &x93, x91, x68, 0x0);
  fiat_np384_addcarryx_u32(&x94, &x95, x93, x70, 0x0);
  fiat_np384_addcarryx_u32(&x96, &x97, x95, x72, 0x0);
  fiat_np384_addcarryx_u32(&x98, &x99, x97, x74, 0x0);
  fiat_np384_mulx_u32(&x100, &x101, x76, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x102, &x103, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x104, &x105, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x106, &x107, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x108, &x109, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x110, &x111, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x112, &x113, x100, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x114, &x115, x100, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x116, &x117, x100, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x118, &x119, x100, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x120, &x121, x100, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x122, &x123, x100, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x124, &x125, x100, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x126, &x127, 0x0, x125, x122);
  fiat_np384_addcarryx_u32(&x128, &x129, x127, x123, x120);
  fiat_np384_addcarryx_u32(&x130, &x131, x129, x121, x118);
  fiat_np384_addcarryx_u32(&x132, &x133, x131, x119, x116);
  fiat_np384_addcarryx_u32(&x134, &x135, x133, x117, x114);
  fiat_np384_addcarryx_u32(&x136, &x137, x135, x115, x112);
  fiat_np384_addcarryx_u32(&x138, &x139, x137, x113, x110);
  fiat_np384_addcarryx_u32(&x140, &x141, x139, x111, x108);
  fiat_np384_addcarryx_u32(&x142, &x143, x141, x109, x106);
  fiat_np384_addcarryx_u32(&x144, &x145, x143, x107, x104);
  fiat_np384_addcarryx_u32(&x146, &x147, x145, x105, x102);
  fiat_np384_addcarryx_u32(&x148, &x149, 0x0, x76, x124);
  fiat_np384_addcarryx_u32(&x150, &x151, x149, x78, x126);
  fiat_np384_addcarryx_u32(&x152, &x153, x151, x80, x128);
  fiat_np384_addcarryx_u32(&x154, &x155, x153, x82, x130);
  fiat_np384_addcarryx_u32(&x156, &x157, x155, x84, x132);
  fiat_np384_addcarryx_u32(&x158, &x159, x157, x86, x134);
  fiat_np384_addcarryx_u32(&x160, &x161, x159, x88, x136);
  fiat_np384_addcarryx_u32(&x162, &x163, x161, x90, x138);
  fiat_np384_addcarryx_u32(&x164, &x165, x163, x92, x140);
  fiat_np384_addcarryx_u32(&x166, &x167, x165, x94, x142);
  fiat_np384_addcarryx_u32(&x168, &x169, x167, x96, x144);
  fiat_np384_addcarryx_u32(&x170, &x171, x169, x98, x146);
  fiat_np384_addcarryx_u32(&x172, &x173, x171, ((uint32_t)x99 + x75), (x147 + x103));
  fiat_np384_addcarryx_u32(&x174, &x175, 0x0, x150, (arg1[2]));
  fiat_np384_addcarryx_u32(&x176, &x177, x175, x152, 0x0);
  fiat_np384_addcarryx_u32(&x178, &x179, x177, x154, 0x0);
  fiat_np384_addcarryx_u32(&x180, &x181, x179, x156, 0x0);
  fiat_np384_addcarryx_u32(&x182, &x183, x181, x158, 0x0);
  fiat_np384_addcarryx_u32(&x184, &x185, x183, x160, 0x0);
  fiat_np384_addcarryx_u32(&x186, &x187, x185, x162, 0x0);
  fiat_np384_addcarryx_u32(&x188, &x189, x187, x164, 0x0);
  fiat_np384_addcarryx_u32(&x190, &x191, x189, x166, 0x0);
  fiat_np384_addcarryx_u32(&x192, &x193, x191, x168, 0x0);
  fiat_np384_addcarryx_u32(&x194, &x195, x193, x170, 0x0);
  fiat_np384_addcarryx_u32(&x196, &x197, x195, x172, 0x0);
  fiat_np384_mulx_u32(&x198, &x199, x174, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x200, &x201, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x202, &x203, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x204, &x205, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x206, &x207, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x208, &x209, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x210, &x211, x198, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x212, &x213, x198, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x214, &x215, x198, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x216, &x217, x198, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x218, &x219, x198, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x220, &x221, x198, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x222, &x223, x198, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x224, &x225, 0x0, x223, x220);
  fiat_np384_addcarryx_u32(&x226, &x227, x225, x221, x218);
  fiat_np384_addcarryx_u32(&x228, &x229, x227, x219, x216);
  fiat_np384_addcarryx_u32(&x230, &x231, x229, x217, x214);
  fiat_np384_addcarryx_u32(&x232, &x233, x231, x215, x212);
  fiat_np384_addcarryx_u32(&x234, &x235, x233, x213, x210);
  fiat_np384_addcarryx_u32(&x236, &x237, x235, x211, x208);
  fiat_np384_addcarryx_u32(&x238, &x239, x237, x209, x206);
  fiat_np384_addcarryx_u32(&x240, &x241, x239, x207, x204);
  fiat_np384_addcarryx_u32(&x242, &x243, x241, x205, x202);
  fiat_np384_addcarryx_u32(&x244, &x245, x243, x203, x200);
  fiat_np384_addcarryx_u32(&x246, &x247, 0x0, x174, x222);
  fiat_np384_addcarryx_u32(&x248, &x249, x247, x176, x224);
  fiat_np384_addcarryx_u32(&x250, &x251, x249, x178, x226);
  fiat_np384_addcarryx_u32(&x252, &x253, x251, x180, x228);
  fiat_np384_addcarryx_u32(&x254, &x255, x253, x182, x230);
  fiat_np384_addcarryx_u32(&x256, &x257, x255, x184, x232);
  fiat_np384_addcarryx_u32(&x258, &x259, x257, x186, x234);
  fiat_np384_addcarryx_u32(&x260, &x261, x259, x188, x236);
  fiat_np384_addcarryx_u32(&x262, &x263, x261, x190, x238);
  fiat_np384_addcarryx_u32(&x264, &x265, x263, x192, x240);
  fiat_np384_addcarryx_u32(&x266, &x267, x265, x194, x242);
  fiat_np384_addcarryx_u32(&x268, &x269, x267, x196, x244);
  fiat_np384_addcarryx_u32(&x270, &x271, x269, ((uint32_t)x197 + x173), (x245 + x201));
  fiat_np384_addcarryx_u32(&x272, &x273, 0x0, x248, (arg1[3]));
  fiat_np384_addcarryx_u32(&x274, &x275, x273, x250, 0x0);
  fiat_np384_addcarryx_u32(&x276, &x277, x275, x252, 0x0);
  fiat_np384_addcarryx_u32(&x278, &x279, x277, x254, 0x0);
  fiat_np384_addcarryx_u32(&x280, &x281, x279, x256, 0x0);
  fiat_np384_addcarryx_u32(&x282, &x283, x281, x258, 0x0);
  fiat_np384_addcarryx_u32(&x284, &x285, x283, x260, 0x0);
  fiat_np384_addcarryx_u32(&x286, &x287, x285, x262, 0x0);
  fiat_np384_addcarryx_u32(&x288, &x289, x287, x264, 0x0);
  fiat_np384_addcarryx_u32(&x290, &x291, x289, x266, 0x0);
  fiat_np384_addcarryx_u32(&x292, &x293, x291, x268, 0x0);
  fiat_np384_addcarryx_u32(&x294, &x295, x293, x270, 0x0);
  fiat_np384_mulx_u32(&x296, &x297, x272, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x298, &x299, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x300, &x301, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x302, &x303, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x304, &x305, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x306, &x307, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x308, &x309, x296, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x310, &x311, x296, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x312, &x313, x296, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x314, &x315, x296, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x316, &x317, x296, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x318, &x319, x296, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x320, &x321, x296, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x322, &x323, 0x0, x321, x318);
  fiat_np384_addcarryx_u32(&x324, &x325, x323, x319, x316);
  fiat_np384_addcarryx_u32(&x326, &x327, x325, x317, x314);
  fiat_np384_addcarryx_u32(&x328, &x329, x327, x315, x312);
  fiat_np384_addcarryx_u32(&x330, &x331, x329, x313, x310);
  fiat_np384_addcarryx_u32(&x332, &x333, x331, x311, x308);
  fiat_np384_addcarryx_u32(&x334, &x335, x333, x309, x306);
  fiat_np384_addcarryx_u32(&x336, &x337, x335, x307, x304);
  fiat_np384_addcarryx_u32(&x338, &x339, x337, x305, x302);
  fiat_np384_addcarryx_u32(&x340, &x341, x339, x303, x300);
  fiat_np384_addcarryx_u32(&x342, &x343, x341, x301, x298);
  fiat_np384_addcarryx_u32(&x344, &x345, 0x0, x272, x320);
  fiat_np384_addcarryx_u32(&x346, &x347, x345, x274, x322);
  fiat_np384_addcarryx_u32(&x348, &x349, x347, x276, x324);
  fiat_np384_addcarryx_u32(&x350, &x351, x349, x278, x326);
  fiat_np384_addcarryx_u32(&x352, &x353, x351, x280, x328);
  fiat_np384_addcarryx_u32(&x354, &x355, x353, x282, x330);
  fiat_np384_addcarryx_u32(&x356, &x357, x355, x284, x332);
  fiat_np384_addcarryx_u32(&x358, &x359, x357, x286, x334);
  fiat_np384_addcarryx_u32(&x360, &x361, x359, x288, x336);
  fiat_np384_addcarryx_u32(&x362, &x363, x361, x290, x338);
  fiat_np384_addcarryx_u32(&x364, &x365, x363, x292, x340);
  fiat_np384_addcarryx_u32(&x366, &x367, x365, x294, x342);
  fiat_np384_addcarryx_u32(&x368, &x369, x367, ((uint32_t)x295 + x271), (x343 + x299));
  fiat_np384_addcarryx_u32(&x370, &x371, 0x0, x346, (arg1[4]));
  fiat_np384_addcarryx_u32(&x372, &x373, x371, x348, 0x0);
  fiat_np384_addcarryx_u32(&x374, &x375, x373, x350, 0x0);
  fiat_np384_addcarryx_u32(&x376, &x377, x375, x352, 0x0);
  fiat_np384_addcarryx_u32(&x378, &x379, x377, x354, 0x0);
  fiat_np384_addcarryx_u32(&x380, &x381, x379, x356, 0x0);
  fiat_np384_addcarryx_u32(&x382, &x383, x381, x358, 0x0);
  fiat_np384_addcarryx_u32(&x384, &x385, x383, x360, 0x0);
  fiat_np384_addcarryx_u32(&x386, &x387, x385, x362, 0x0);
  fiat_np384_addcarryx_u32(&x388, &x389, x387, x364, 0x0);
  fiat_np384_addcarryx_u32(&x390, &x391, x389, x366, 0x0);
  fiat_np384_addcarryx_u32(&x392, &x393, x391, x368, 0x0);
  fiat_np384_mulx_u32(&x394, &x395, x370, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x396, &x397, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x398, &x399, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x400, &x401, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x402, &x403, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x404, &x405, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x406, &x407, x394, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x408, &x409, x394, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x410, &x411, x394, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x412, &x413, x394, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x414, &x415, x394, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x416, &x417, x394, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x418, &x419, x394, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x420, &x421, 0x0, x419, x416);
  fiat_np384_addcarryx_u32(&x422, &x423, x421, x417, x414);
  fiat_np384_addcarryx_u32(&x424, &x425, x423, x415, x412);
  fiat_np384_addcarryx_u32(&x426, &x427, x425, x413, x410);
  fiat_np384_addcarryx_u32(&x428, &x429, x427, x411, x408);
  fiat_np384_addcarryx_u32(&x430, &x431, x429, x409, x406);
  fiat_np384_addcarryx_u32(&x432, &x433, x431, x407, x404);
  fiat_np384_addcarryx_u32(&x434, &x435, x433, x405, x402);
  fiat_np384_addcarryx_u32(&x436, &x437, x435, x403, x400);
  fiat_np384_addcarryx_u32(&x438, &x439, x437, x401, x398);
  fiat_np384_addcarryx_u32(&x440, &x441, x439, x399, x396);
  fiat_np384_addcarryx_u32(&x442, &x443, 0x0, x370, x418);
  fiat_np384_addcarryx_u32(&x444, &x445, x443, x372, x420);
  fiat_np384_addcarryx_u32(&x446, &x447, x445, x374, x422);
  fiat_np384_addcarryx_u32(&x448, &x449, x447, x376, x424);
  fiat_np384_addcarryx_u32(&x450, &x451, x449, x378, x426);
  fiat_np384_addcarryx_u32(&x452, &x453, x451, x380, x428);
  fiat_np384_addcarryx_u32(&x454, &x455, x453, x382, x430);
  fiat_np384_addcarryx_u32(&x456, &x457, x455, x384, x432);
  fiat_np384_addcarryx_u32(&x458, &x459, x457, x386, x434);
  fiat_np384_addcarryx_u32(&x460, &x461, x459, x388, x436);
  fiat_np384_addcarryx_u32(&x462, &x463, x461, x390, x438);
  fiat_np384_addcarryx_u32(&x464, &x465, x463, x392, x440);
  fiat_np384_addcarryx_u32(&x466, &x467, x465, ((uint32_t)x393 + x369), (x441 + x397));
  fiat_np384_addcarryx_u32(&x468, &x469, 0x0, x444, (arg1[5]));
  fiat_np384_addcarryx_u32(&x470, &x471, x469, x446, 0x0);
  fiat_np384_addcarryx_u32(&x472, &x473, x471, x448, 0x0);
  fiat_np384_addcarryx_u32(&x474, &x475, x473, x450, 0x0);
  fiat_np384_addcarryx_u32(&x476, &x477, x475, x452, 0x0);
  fiat_np384_addcarryx_u32(&x478, &x479, x477, x454, 0x0);
  fiat_np384_addcarryx_u32(&x480, &x481, x479, x456, 0x0);
  fiat_np384_addcarryx_u32(&x482, &x483, x481, x458, 0x0);
  fiat_np384_addcarryx_u32(&x484, &x485, x483, x460, 0x0);
  fiat_np384_addcarryx_u32(&x486, &x487, x485, x462, 0x0);
  fiat_np384_addcarryx_u32(&x488, &x489, x487, x464, 0x0);
  fiat_np384_addcarryx_u32(&x490, &x491, x489, x466, 0x0);
  fiat_np384_mulx_u32(&x492, &x493, x468, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x494, &x495, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x496, &x497, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x498, &x499, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x500, &x501, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x502, &x503, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x504, &x505, x492, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x506, &x507, x492, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x508, &x509, x492, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x510, &x511, x492, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x512, &x513, x492, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x514, &x515, x492, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x516, &x517, x492, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x518, &x519, 0x0, x517, x514);
  fiat_np384_addcarryx_u32(&x520, &x521, x519, x515, x512);
  fiat_np384_addcarryx_u32(&x522, &x523, x521, x513, x510);
  fiat_np384_addcarryx_u32(&x524, &x525, x523, x511, x508);
  fiat_np384_addcarryx_u32(&x526, &x527, x525, x509, x506);
  fiat_np384_addcarryx_u32(&x528, &x529, x527, x507, x504);
  fiat_np384_addcarryx_u32(&x530, &x531, x529, x505, x502);
  fiat_np384_addcarryx_u32(&x532, &x533, x531, x503, x500);
  fiat_np384_addcarryx_u32(&x534, &x535, x533, x501, x498);
  fiat_np384_addcarryx_u32(&x536, &x537, x535, x499, x496);
  fiat_np384_addcarryx_u32(&x538, &x539, x537, x497, x494);
  fiat_np384_addcarryx_u32(&x540, &x541, 0x0, x468, x516);
  fiat_np384_addcarryx_u32(&x542, &x543, x541, x470, x518);
  fiat_np384_addcarryx_u32(&x544, &x545, x543, x472, x520);
  fiat_np384_addcarryx_u32(&x546, &x547, x545, x474, x522);
  fiat_np384_addcarryx_u32(&x548, &x549, x547, x476, x524);
  fiat_np384_addcarryx_u32(&x550, &x551, x549, x478, x526);
  fiat_np384_addcarryx_u32(&x552, &x553, x551, x480, x528);
  fiat_np384_addcarryx_u32(&x554, &x555, x553, x482, x530);
  fiat_np384_addcarryx_u32(&x556, &x557, x555, x484, x532);
  fiat_np384_addcarryx_u32(&x558, &x559, x557, x486, x534);
  fiat_np384_addcarryx_u32(&x560, &x561, x559, x488, x536);
  fiat_np384_addcarryx_u32(&x562, &x563, x561, x490, x538);
  fiat_np384_addcarryx_u32(&x564, &x565, x563, ((uint32_t)x491 + x467), (x539 + x495));
  fiat_np384_addcarryx_u32(&x566, &x567, 0x0, x542, (arg1[6]));
  fiat_np384_addcarryx_u32(&x568, &x569, x567, x544, 0x0);
  fiat_np384_addcarryx_u32(&x570, &x571, x569, x546, 0x0);
  fiat_np384_addcarryx_u32(&x572, &x573, x571, x548, 0x0);
  fiat_np384_addcarryx_u32(&x574, &x575, x573, x550, 0x0);
  fiat_np384_addcarryx_u32(&x576, &x577, x575, x552, 0x0);
  fiat_np384_addcarryx_u32(&x578, &x579, x577, x554, 0x0);
  fiat_np384_addcarryx_u32(&x580, &x581, x579, x556, 0x0);
  fiat_np384_addcarryx_u32(&x582, &x583, x581, x558, 0x0);
  fiat_np384_addcarryx_u32(&x584, &x585, x583, x560, 0x0);
  fiat_np384_addcarryx_u32(&x586, &x587, x585, x562, 0x0);
  fiat_np384_addcarryx_u32(&x588, &x589, x587, x564, 0x0);
  fiat_np384_mulx_u32(&x590, &x591, x566, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x592, &x593, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x594, &x595, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x596, &x597, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x598, &x599, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x600, &x601, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x602, &x603, x590, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x604, &x605, x590, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x606, &x607, x590, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x608, &x609, x590, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x610, &x611, x590, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x612, &x613, x590, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x614, &x615, x590, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x616, &x617, 0x0, x615, x612);
  fiat_np384_addcarryx_u32(&x618, &x619, x617, x613, x610);
  fiat_np384_addcarryx_u32(&x620, &x621, x619, x611, x608);
  fiat_np384_addcarryx_u32(&x622, &x623, x621, x609, x606);
  fiat_np384_addcarryx_u32(&x624, &x625, x623, x607, x604);
  fiat_np384_addcarryx_u32(&x626, &x627, x625, x605, x602);
  fiat_np384_addcarryx_u32(&x628, &x629, x627, x603, x600);
  fiat_np384_addcarryx_u32(&x630, &x631, x629, x601, x598);
  fiat_np384_addcarryx_u32(&x632, &x633, x631, x599, x596);
  fiat_np384_addcarryx_u32(&x634, &x635, x633, x597, x594);
  fiat_np384_addcarryx_u32(&x636, &x637, x635, x595, x592);
  fiat_np384_addcarryx_u32(&x638, &x639, 0x0, x566, x614);
  fiat_np384_addcarryx_u32(&x640, &x641, x639, x568, x616);
  fiat_np384_addcarryx_u32(&x642, &x643, x641, x570, x618);
  fiat_np384_addcarryx_u32(&x644, &x645, x643, x572, x620);
  fiat_np384_addcarryx_u32(&x646, &x647, x645, x574, x622);
  fiat_np384_addcarryx_u32(&x648, &x649, x647, x576, x624);
  fiat_np384_addcarryx_u32(&x650, &x651, x649, x578, x626);
  fiat_np384_addcarryx_u32(&x652, &x653, x651, x580, x628);
  fiat_np384_addcarryx_u32(&x654, &x655, x653, x582, x630);
  fiat_np384_addcarryx_u32(&x656, &x657, x655, x584, x632);
  fiat_np384_addcarryx_u32(&x658, &x659, x657, x586, x634);
  fiat_np384_addcarryx_u32(&x660, &x661, x659, x588, x636);
  fiat_np384_addcarryx_u32(&x662, &x663, x661, ((uint32_t)x589 + x565), (x637 + x593));
  fiat_np384_addcarryx_u32(&x664, &x665, 0x0, x640, (arg1[7]));
  fiat_np384_addcarryx_u32(&x666, &x667, x665, x642, 0x0);
  fiat_np384_addcarryx_u32(&x668, &x669, x667, x644, 0x0);
  fiat_np384_addcarryx_u32(&x670, &x671, x669, x646, 0x0);
  fiat_np384_addcarryx_u32(&x672, &x673, x671, x648, 0x0);
  fiat_np384_addcarryx_u32(&x674, &x675, x673, x650, 0x0);
  fiat_np384_addcarryx_u32(&x676, &x677, x675, x652, 0x0);
  fiat_np384_addcarryx_u32(&x678, &x679, x677, x654, 0x0);
  fiat_np384_addcarryx_u32(&x680, &x681, x679, x656, 0x0);
  fiat_np384_addcarryx_u32(&x682, &x683, x681, x658, 0x0);
  fiat_np384_addcarryx_u32(&x684, &x685, x683, x660, 0x0);
  fiat_np384_addcarryx_u32(&x686, &x687, x685, x662, 0x0);
  fiat_np384_mulx_u32(&x688, &x689, x664, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x690, &x691, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x692, &x693, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x694, &x695, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x696, &x697, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x698, &x699, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x700, &x701, x688, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x702, &x703, x688, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x704, &x705, x688, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x706, &x707, x688, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x708, &x709, x688, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x710, &x711, x688, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x712, &x713, x688, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x714, &x715, 0x0, x713, x710);
  fiat_np384_addcarryx_u32(&x716, &x717, x715, x711, x708);
  fiat_np384_addcarryx_u32(&x718, &x719, x717, x709, x706);
  fiat_np384_addcarryx_u32(&x720, &x721, x719, x707, x704);
  fiat_np384_addcarryx_u32(&x722, &x723, x721, x705, x702);
  fiat_np384_addcarryx_u32(&x724, &x725, x723, x703, x700);
  fiat_np384_addcarryx_u32(&x726, &x727, x725, x701, x698);
  fiat_np384_addcarryx_u32(&x728, &x729, x727, x699, x696);
  fiat_np384_addcarryx_u32(&x730, &x731, x729, x697, x694);
  fiat_np384_addcarryx_u32(&x732, &x733, x731, x695, x692);
  fiat_np384_addcarryx_u32(&x734, &x735, x733, x693, x690);
  fiat_np384_addcarryx_u32(&x736, &x737, 0x0, x664, x712);
  fiat_np384_addcarryx_u32(&x738, &x739, x737, x666, x714);
  fiat_np384_addcarryx_u32(&x740, &x741, x739, x668, x716);
  fiat_np384_addcarryx_u32(&x742, &x743, x741, x670, x718);
  fiat_np384_addcarryx_u32(&x744, &x745, x743, x672, x720);
  fiat_np384_addcarryx_u32(&x746, &x747, x745, x674, x722);
  fiat_np384_addcarryx_u32(&x748, &x749, x747, x676, x724);
  fiat_np384_addcarryx_u32(&x750, &x751, x749, x678, x726);
  fiat_np384_addcarryx_u32(&x752, &x753, x751, x680, x728);
  fiat_np384_addcarryx_u32(&x754, &x755, x753, x682, x730);
  fiat_np384_addcarryx_u32(&x756, &x757, x755, x684, x732);
  fiat_np384_addcarryx_u32(&x758, &x759, x757, x686, x734);
  fiat_np384_addcarryx_u32(&x760, &x761, x759, ((uint32_t)x687 + x663), (x735 + x691));
  fiat_np384_addcarryx_u32(&x762, &x763, 0x0, x738, (arg1[8]));
  fiat_np384_addcarryx_u32(&x764, &x765, x763, x740, 0x0);
  fiat_np384_addcarryx_u32(&x766, &x767, x765, x742, 0x0);
  fiat_np384_addcarryx_u32(&x768, &x769, x767, x744, 0x0);
  fiat_np384_addcarryx_u32(&x770, &x771, x769, x746, 0x0);
  fiat_np384_addcarryx_u32(&x772, &x773, x771, x748, 0x0);
  fiat_np384_addcarryx_u32(&x774, &x775, x773, x750, 0x0);
  fiat_np384_addcarryx_u32(&x776, &x777, x775, x752, 0x0);
  fiat_np384_addcarryx_u32(&x778, &x779, x777, x754, 0x0);
  fiat_np384_addcarryx_u32(&x780, &x781, x779, x756, 0x0);
  fiat_np384_addcarryx_u32(&x782, &x783, x781, x758, 0x0);
  fiat_np384_addcarryx_u32(&x784, &x785, x783, x760, 0x0);
  fiat_np384_mulx_u32(&x786, &x787, x762, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x788, &x789, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x790, &x791, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x792, &x793, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x794, &x795, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x796, &x797, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x798, &x799, x786, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x800, &x801, x786, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x802, &x803, x786, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x804, &x805, x786, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x806, &x807, x786, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x808, &x809, x786, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x810, &x811, x786, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x812, &x813, 0x0, x811, x808);
  fiat_np384_addcarryx_u32(&x814, &x815, x813, x809, x806);
  fiat_np384_addcarryx_u32(&x816, &x817, x815, x807, x804);
  fiat_np384_addcarryx_u32(&x818, &x819, x817, x805, x802);
  fiat_np384_addcarryx_u32(&x820, &x821, x819, x803, x800);
  fiat_np384_addcarryx_u32(&x822, &x823, x821, x801, x798);
  fiat_np384_addcarryx_u32(&x824, &x825, x823, x799, x796);
  fiat_np384_addcarryx_u32(&x826, &x827, x825, x797, x794);
  fiat_np384_addcarryx_u32(&x828, &x829, x827, x795, x792);
  fiat_np384_addcarryx_u32(&x830, &x831, x829, x793, x790);
  fiat_np384_addcarryx_u32(&x832, &x833, x831, x791, x788);
  fiat_np384_addcarryx_u32(&x834, &x835, 0x0, x762, x810);
  fiat_np384_addcarryx_u32(&x836, &x837, x835, x764, x812);
  fiat_np384_addcarryx_u32(&x838, &x839, x837, x766, x814);
  fiat_np384_addcarryx_u32(&x840, &x841, x839, x768, x816);
  fiat_np384_addcarryx_u32(&x842, &x843, x841, x770, x818);
  fiat_np384_addcarryx_u32(&x844, &x845, x843, x772, x820);
  fiat_np384_addcarryx_u32(&x846, &x847, x845, x774, x822);
  fiat_np384_addcarryx_u32(&x848, &x849, x847, x776, x824);
  fiat_np384_addcarryx_u32(&x850, &x851, x849, x778, x826);
  fiat_np384_addcarryx_u32(&x852, &x853, x851, x780, x828);
  fiat_np384_addcarryx_u32(&x854, &x855, x853, x782, x830);
  fiat_np384_addcarryx_u32(&x856, &x857, x855, x784, x832);
  fiat_np384_addcarryx_u32(&x858, &x859, x857, ((uint32_t)x785 + x761), (x833 + x789));
  fiat_np384_addcarryx_u32(&x860, &x861, 0x0, x836, (arg1[9]));
  fiat_np384_addcarryx_u32(&x862, &x863, x861, x838, 0x0);
  fiat_np384_addcarryx_u32(&x864, &x865, x863, x840, 0x0);
  fiat_np384_addcarryx_u32(&x866, &x867, x865, x842, 0x0);
  fiat_np384_addcarryx_u32(&x868, &x869, x867, x844, 0x0);
  fiat_np384_addcarryx_u32(&x870, &x871, x869, x846, 0x0);
  fiat_np384_addcarryx_u32(&x872, &x873, x871, x848, 0x0);
  fiat_np384_addcarryx_u32(&x874, &x875, x873, x850, 0x0);
  fiat_np384_addcarryx_u32(&x876, &x877, x875, x852, 0x0);
  fiat_np384_addcarryx_u32(&x878, &x879, x877, x854, 0x0);
  fiat_np384_addcarryx_u32(&x880, &x881, x879, x856, 0x0);
  fiat_np384_addcarryx_u32(&x882, &x883, x881, x858, 0x0);
  fiat_np384_mulx_u32(&x884, &x885, x860, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x886, &x887, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x888, &x889, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x890, &x891, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x892, &x893, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x894, &x895, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x896, &x897, x884, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x898, &x899, x884, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x900, &x901, x884, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x902, &x903, x884, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x904, &x905, x884, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x906, &x907, x884, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x908, &x909, x884, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x910, &x911, 0x0, x909, x906);
  fiat_np384_addcarryx_u32(&x912, &x913, x911, x907, x904);
  fiat_np384_addcarryx_u32(&x914, &x915, x913, x905, x902);
  fiat_np384_addcarryx_u32(&x916, &x917, x915, x903, x900);
  fiat_np384_addcarryx_u32(&x918, &x919, x917, x901, x898);
  fiat_np384_addcarryx_u32(&x920, &x921, x919, x899, x896);
  fiat_np384_addcarryx_u32(&x922, &x923, x921, x897, x894);
  fiat_np384_addcarryx_u32(&x924, &x925, x923, x895, x892);
  fiat_np384_addcarryx_u32(&x926, &x927, x925, x893, x890);
  fiat_np384_addcarryx_u32(&x928, &x929, x927, x891, x888);
  fiat_np384_addcarryx_u32(&x930, &x931, x929, x889, x886);
  fiat_np384_addcarryx_u32(&x932, &x933, 0x0, x860, x908);
  fiat_np384_addcarryx_u32(&x934, &x935, x933, x862, x910);
  fiat_np384_addcarryx_u32(&x936, &x937, x935, x864, x912);
  fiat_np384_addcarryx_u32(&x938, &x939, x937, x866, x914);
  fiat_np384_addcarryx_u32(&x940, &x941, x939, x868, x916);
  fiat_np384_addcarryx_u32(&x942, &x943, x941, x870, x918);
  fiat_np384_addcarryx_u32(&x944, &x945, x943, x872, x920);
  fiat_np384_addcarryx_u32(&x946, &x947, x945, x874, x922);
  fiat_np384_addcarryx_u32(&x948, &x949, x947, x876, x924);
  fiat_np384_addcarryx_u32(&x950, &x951, x949, x878, x926);
  fiat_np384_addcarryx_u32(&x952, &x953, x951, x880, x928);
  fiat_np384_addcarryx_u32(&x954, &x955, x953, x882, x930);
  fiat_np384_addcarryx_u32(&x956, &x957, x955, ((uint32_t)x883 + x859), (x931 + x887));
  fiat_np384_addcarryx_u32(&x958, &x959, 0x0, x934, (arg1[10]));
  fiat_np384_addcarryx_u32(&x960, &x961, x959, x936, 0x0);
  fiat_np384_addcarryx_u32(&x962, &x963, x961, x938, 0x0);
  fiat_np384_addcarryx_u32(&x964, &x965, x963, x940, 0x0);
  fiat_np384_addcarryx_u32(&x966, &x967, x965, x942, 0x0);
  fiat_np384_addcarryx_u32(&x968, &x969, x967, x944, 0x0);
  fiat_np384_addcarryx_u32(&x970, &x971, x969, x946, 0x0);
  fiat_np384_addcarryx_u32(&x972, &x973, x971, x948, 0x0);
  fiat_np384_addcarryx_u32(&x974, &x975, x973, x950, 0x0);
  fiat_np384_addcarryx_u32(&x976, &x977, x975, x952, 0x0);
  fiat_np384_addcarryx_u32(&x978, &x979, x977, x954, 0x0);
  fiat_np384_addcarryx_u32(&x980, &x981, x979, x956, 0x0);
  fiat_np384_mulx_u32(&x982, &x983, x958, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x984, &x985, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x986, &x987, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x988, &x989, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x990, &x991, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x992, &x993, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x994, &x995, x982, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x996, &x997, x982, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x998, &x999, x982, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1000, &x1001, x982, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1002, &x1003, x982, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1004, &x1005, x982, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1006, &x1007, x982, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1008, &x1009, 0x0, x1007, x1004);
  fiat_np384_addcarryx_u32(&x1010, &x1011, x1009, x1005, x1002);
  fiat_np384_addcarryx_u32(&x1012, &x1013, x1011, x1003, x1000);
  fiat_np384_addcarryx_u32(&x1014, &x1015, x1013, x1001, x998);
  fiat_np384_addcarryx_u32(&x1016, &x1017, x1015, x999, x996);
  fiat_np384_addcarryx_u32(&x1018, &x1019, x1017, x997, x994);
  fiat_np384_addcarryx_u32(&x1020, &x1021, x1019, x995, x992);
  fiat_np384_addcarryx_u32(&x1022, &x1023, x1021, x993, x990);
  fiat_np384_addcarryx_u32(&x1024, &x1025, x1023, x991, x988);
  fiat_np384_addcarryx_u32(&x1026, &x1027, x1025, x989, x986);
  fiat_np384_addcarryx_u32(&x1028, &x1029, x1027, x987, x984);
  fiat_np384_addcarryx_u32(&x1030, &x1031, 0x0, x958, x1006);
  fiat_np384_addcarryx_u32(&x1032, &x1033, x1031, x960, x1008);
  fiat_np384_addcarryx_u32(&x1034, &x1035, x1033, x962, x1010);
  fiat_np384_addcarryx_u32(&x1036, &x1037, x1035, x964, x1012);
  fiat_np384_addcarryx_u32(&x1038, &x1039, x1037, x966, x1014);
  fiat_np384_addcarryx_u32(&x1040, &x1041, x1039, x968, x1016);
  fiat_np384_addcarryx_u32(&x1042, &x1043, x1041, x970, x1018);
  fiat_np384_addcarryx_u32(&x1044, &x1045, x1043, x972, x1020);
  fiat_np384_addcarryx_u32(&x1046, &x1047, x1045, x974, x1022);
  fiat_np384_addcarryx_u32(&x1048, &x1049, x1047, x976, x1024);
  fiat_np384_addcarryx_u32(&x1050, &x1051, x1049, x978, x1026);
  fiat_np384_addcarryx_u32(&x1052, &x1053, x1051, x980, x1028);
  fiat_np384_addcarryx_u32(&x1054, &x1055, x1053, ((uint32_t)x981 + x957), (x1029 + x985));
  fiat_np384_addcarryx_u32(&x1056, &x1057, 0x0, x1032, (arg1[11]));
  fiat_np384_addcarryx_u32(&x1058, &x1059, x1057, x1034, 0x0);
  fiat_np384_addcarryx_u32(&x1060, &x1061, x1059, x1036, 0x0);
  fiat_np384_addcarryx_u32(&x1062, &x1063, x1061, x1038, 0x0);
  fiat_np384_addcarryx_u32(&x1064, &x1065, x1063, x1040, 0x0);
  fiat_np384_addcarryx_u32(&x1066, &x1067, x1065, x1042, 0x0);
  fiat_np384_addcarryx_u32(&x1068, &x1069, x1067, x1044, 0x0);
  fiat_np384_addcarryx_u32(&x1070, &x1071, x1069, x1046, 0x0);
  fiat_np384_addcarryx_u32(&x1072, &x1073, x1071, x1048, 0x0);
  fiat_np384_addcarryx_u32(&x1074, &x1075, x1073, x1050, 0x0);
  fiat_np384_addcarryx_u32(&x1076, &x1077, x1075, x1052, 0x0);
  fiat_np384_addcarryx_u32(&x1078, &x1079, x1077, x1054, 0x0);
  fiat_np384_mulx_u32(&x1080, &x1081, x1056, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1082, &x1083, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1084, &x1085, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1086, &x1087, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1088, &x1089, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1090, &x1091, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1092, &x1093, x1080, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1094, &x1095, x1080, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1096, &x1097, x1080, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1098, &x1099, x1080, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1100, &x1101, x1080, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1102, &x1103, x1080, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1104, &x1105, x1080, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1106, &x1107, 0x0, x1105, x1102);
  fiat_np384_addcarryx_u32(&x1108, &x1109, x1107, x1103, x1100);
  fiat_np384_addcarryx_u32(&x1110, &x1111, x1109, x1101, x1098);
  fiat_np384_addcarryx_u32(&x1112, &x1113, x1111, x1099, x1096);
  fiat_np384_addcarryx_u32(&x1114, &x1115, x1113, x1097, x1094);
  fiat_np384_addcarryx_u32(&x1116, &x1117, x1115, x1095, x1092);
  fiat_np384_addcarryx_u32(&x1118, &x1119, x1117, x1093, x1090);
  fiat_np384_addcarryx_u32(&x1120, &x1121, x1119, x1091, x1088);
  fiat_np384_addcarryx_u32(&x1122, &x1123, x1121, x1089, x1086);
  fiat_np384_addcarryx_u32(&x1124, &x1125, x1123, x1087, x1084);
  fiat_np384_addcarryx_u32(&x1126, &x1127, x1125, x1085, x1082);
  fiat_np384_addcarryx_u32(&x1128, &x1129, 0x0, x1056, x1104);
  fiat_np384_addcarryx_u32(&x1130, &x1131, x1129, x1058, x1106);
  fiat_np384_addcarryx_u32(&x1132, &x1133, x1131, x1060, x1108);
  fiat_np384_addcarryx_u32(&x1134, &x1135, x1133, x1062, x1110);
  fiat_np384_addcarryx_u32(&x1136, &x1137, x1135, x1064, x1112);
  fiat_np384_addcarryx_u32(&x1138, &x1139, x1137, x1066, x1114);
  fiat_np384_addcarryx_u32(&x1140, &x1141, x1139, x1068, x1116);
  fiat_np384_addcarryx_u32(&x1142, &x1143, x1141, x1070, x1118);
  fiat_np384_addcarryx_u32(&x1144, &x1145, x1143, x1072, x1120);
  fiat_np384_addcarryx_u32(&x1146, &x1147, x1145, x1074, x1122);
  fiat_np384_addcarryx_u32(&x1148, &x1149, x1147, x1076, x1124);
  fiat_np384_addcarryx_u32(&x1150, &x1151, x1149, x1078, x1126);
  fiat_np384_addcarryx_u32(&x1152, &x1153, x1151, ((uint32_t)x1079 + x1055), (x1127 + x1083));
  fiat_np384_subborrowx_u32(&x1154, &x1155, 0x0, x1130, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x1156, &x1157, x1155, x1132, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x1158, &x1159, x1157, x1134, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x1160, &x1161, x1159, x1136, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x1162, &x1163, x1161, x1138, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x1164, &x1165, x1163, x1140, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x1166, &x1167, x1165, x1142, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1168, &x1169, x1167, x1144, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1170, &x1171, x1169, x1146, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1172, &x1173, x1171, x1148, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1174, &x1175, x1173, x1150, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1176, &x1177, x1175, x1152, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1178, &x1179, x1177, x1153, 0x0);
  fiat_np384_cmovznz_u32(&x1180, x1179, x1154, x1130);
  fiat_np384_cmovznz_u32(&x1181, x1179, x1156, x1132);
  fiat_np384_cmovznz_u32(&x1182, x1179, x1158, x1134);
  fiat_np384_cmovznz_u32(&x1183, x1179, x1160, x1136);
  fiat_np384_cmovznz_u32(&x1184, x1179, x1162, x1138);
  fiat_np384_cmovznz_u32(&x1185, x1179, x1164, x1140);
  fiat_np384_cmovznz_u32(&x1186, x1179, x1166, x1142);
  fiat_np384_cmovznz_u32(&x1187, x1179, x1168, x1144);
  fiat_np384_cmovznz_u32(&x1188, x1179, x1170, x1146);
  fiat_np384_cmovznz_u32(&x1189, x1179, x1172, x1148);
  fiat_np384_cmovznz_u32(&x1190, x1179, x1174, x1150);
  fiat_np384_cmovznz_u32(&x1191, x1179, x1176, x1152);
  out1[0] = x1180;
  out1[1] = x1181;
  out1[2] = x1182;
  out1[3] = x1183;
  out1[4] = x1184;
  out1[5] = x1185;
  out1[6] = x1186;
  out1[7] = x1187;
  out1[8] = x1188;
  out1[9] = x1189;
  out1[10] = x1190;
  out1[11] = x1191;
}

/*
 * The function fiat_np384_to_montgomery translates a field element into the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_to_montgomery(fiat_np384_montgomery_domain_field_element out1, const fiat_np384_non_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  fiat_np384_uint1 x38;
  uint32_t x39;
  fiat_np384_uint1 x40;
  uint32_t x41;
  fiat_np384_uint1 x42;
  uint32_t x43;
  fiat_np384_uint1 x44;
  uint32_t x45;
  fiat_np384_uint1 x46;
  uint32_t x47;
  fiat_np384_uint1 x48;
  uint32_t x49;
  fiat_np384_uint1 x50;
  uint32_t x51;
  fiat_np384_uint1 x52;
  uint32_t x53;
  fiat_np384_uint1 x54;
  uint32_t x55;
  fiat_np384_uint1 x56;
  uint32_t x57;
  fiat_np384_uint1 x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  uint32_t x85;
  fiat_np384_uint1 x86;
  uint32_t x87;
  fiat_np384_uint1 x88;
  uint32_t x89;
  fiat_np384_uint1 x90;
  uint32_t x91;
  fiat_np384_uint1 x92;
  uint32_t x93;
  fiat_np384_uint1 x94;
  uint32_t x95;
  fiat_np384_uint1 x96;
  uint32_t x97;
  fiat_np384_uint1 x98;
  uint32_t x99;
  fiat_np384_uint1 x100;
  uint32_t x101;
  fiat_np384_uint1 x102;
  uint32_t x103;
  fiat_np384_uint1 x104;
  uint32_t x105;
  fiat_np384_uint1 x106;
  uint32_t x107;
  fiat_np384_uint1 x108;
  uint32_t x109;
  fiat_np384_uint1 x110;
  uint32_t x111;
  fiat_np384_uint1 x112;
  uint32_t x113;
  fiat_np384_uint1 x114;
  uint32_t x115;
  fiat_np384_uint1 x116;
  uint32_t x117;
  fiat_np384_uint1 x118;
  uint32_t x119;
  fiat_np384_uint1 x120;
  uint32_t x121;
  fiat_np384_uint1 x122;
  uint32_t x123;
  fiat_np384_uint1 x124;
  uint32_t x125;
  fiat_np384_uint1 x126;
  uint32_t x127;
  fiat_np384_uint1 x128;
  uint32_t x129;
  fiat_np384_uint1 x130;
  uint32_t x131;
  fiat_np384_uint1 x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  uint32_t x140;
  uint32_t x141;
  uint32_t x142;
  uint32_t x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  uint32_t x148;
  uint32_t x149;
  uint32_t x150;
  uint32_t x151;
  uint32_t x152;
  uint32_t x153;
  uint32_t x154;
  uint32_t x155;
  uint32_t x156;
  uint32_t x157;
  fiat_np384_uint1 x158;
  uint32_t x159;
  fiat_np384_uint1 x160;
  uint32_t x161;
  fiat_np384_uint1 x162;
  uint32_t x163;
  fiat_np384_uint1 x164;
  uint32_t x165;
  fiat_np384_uint1 x166;
  uint32_t x167;
  fiat_np384_uint1 x168;
  uint32_t x169;
  fiat_np384_uint1 x170;
  uint32_t x171;
  fiat_np384_uint1 x172;
  uint32_t x173;
  fiat_np384_uint1 x174;
  uint32_t x175;
  fiat_np384_uint1 x176;
  uint32_t x177;
  fiat_np384_uint1 x178;
  uint32_t x179;
  fiat_np384_uint1 x180;
  uint32_t x181;
  fiat_np384_uint1 x182;
  uint32_t x183;
  fiat_np384_uint1 x184;
  uint32_t x185;
  fiat_np384_uint1 x186;
  uint32_t x187;
  fiat_np384_uint1 x188;
  uint32_t x189;
  fiat_np384_uint1 x190;
  uint32_t x191;
  fiat_np384_uint1 x192;
  uint32_t x193;
  fiat_np384_uint1 x194;
  uint32_t x195;
  fiat_np384_uint1 x196;
  uint32_t x197;
  fiat_np384_uint1 x198;
  uint32_t x199;
  fiat_np384_uint1 x200;
  uint32_t x201;
  fiat_np384_uint1 x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  uint32_t x225;
  uint32_t x226;
  uint32_t x227;
  uint32_t x228;
  uint32_t x229;
  fiat_np384_uint1 x230;
  uint32_t x231;
  fiat_np384_uint1 x232;
  uint32_t x233;
  fiat_np384_uint1 x234;
  uint32_t x235;
  fiat_np384_uint1 x236;
  uint32_t x237;
  fiat_np384_uint1 x238;
  uint32_t x239;
  fiat_np384_uint1 x240;
  uint32_t x241;
  fiat_np384_uint1 x242;
  uint32_t x243;
  fiat_np384_uint1 x244;
  uint32_t x245;
  fiat_np384_uint1 x246;
  uint32_t x247;
  fiat_np384_uint1 x248;
  uint32_t x249;
  fiat_np384_uint1 x250;
  uint32_t x251;
  fiat_np384_uint1 x252;
  uint32_t x253;
  fiat_np384_uint1 x254;
  uint32_t x255;
  fiat_np384_uint1 x256;
  uint32_t x257;
  fiat_np384_uint1 x258;
  uint32_t x259;
  fiat_np384_uint1 x260;
  uint32_t x261;
  fiat_np384_uint1 x262;
  uint32_t x263;
  fiat_np384_uint1 x264;
  uint32_t x265;
  fiat_np384_uint1 x266;
  uint32_t x267;
  fiat_np384_uint1 x268;
  uint32_t x269;
  fiat_np384_uint1 x270;
  uint32_t x271;
  fiat_np384_uint1 x272;
  uint32_t x273;
  fiat_np384_uint1 x274;
  uint32_t x275;
  fiat_np384_uint1 x276;
  uint32_t x277;
  uint32_t x278;
  uint32_t x279;
  uint32_t x280;
  uint32_t x281;
  uint32_t x282;
  uint32_t x283;
  uint32_t x284;
  uint32_t x285;
  uint32_t x286;
  uint32_t x287;
  uint32_t x288;
  uint32_t x289;
  uint32_t x290;
  uint32_t x291;
  uint32_t x292;
  uint32_t x293;
  uint32_t x294;
  uint32_t x295;
  uint32_t x296;
  uint32_t x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  fiat_np384_uint1 x302;
  uint32_t x303;
  fiat_np384_uint1 x304;
  uint32_t x305;
  fiat_np384_uint1 x306;
  uint32_t x307;
  fiat_np384_uint1 x308;
  uint32_t x309;
  fiat_np384_uint1 x310;
  uint32_t x311;
  fiat_np384_uint1 x312;
  uint32_t x313;
  fiat_np384_uint1 x314;
  uint32_t x315;
  fiat_np384_uint1 x316;
  uint32_t x317;
  fiat_np384_uint1 x318;
  uint32_t x319;
  fiat_np384_uint1 x320;
  uint32_t x321;
  fiat_np384_uint1 x322;
  uint32_t x323;
  fiat_np384_uint1 x324;
  uint32_t x325;
  fiat_np384_uint1 x326;
  uint32_t x327;
  fiat_np384_uint1 x328;
  uint32_t x329;
  fiat_np384_uint1 x330;
  uint32_t x331;
  fiat_np384_uint1 x332;
  uint32_t x333;
  fiat_np384_uint1 x334;
  uint32_t x335;
  fiat_np384_uint1 x336;
  uint32_t x337;
  fiat_np384_uint1 x338;
  uint32_t x339;
  fiat_np384_uint1 x340;
  uint32_t x341;
  fiat_np384_uint1 x342;
  uint32_t x343;
  fiat_np384_uint1 x344;
  uint32_t x345;
  fiat_np384_uint1 x346;
  uint32_t x347;
  uint32_t x348;
  uint32_t x349;
  uint32_t x350;
  uint32_t x351;
  uint32_t x352;
  uint32_t x353;
  uint32_t x354;
  uint32_t x355;
  uint32_t x356;
  uint32_t x357;
  uint32_t x358;
  uint32_t x359;
  uint32_t x360;
  uint32_t x361;
  uint32_t x362;
  uint32_t x363;
  uint32_t x364;
  uint32_t x365;
  uint32_t x366;
  uint32_t x367;
  uint32_t x368;
  uint32_t x369;
  uint32_t x370;
  uint32_t x371;
  uint32_t x372;
  uint32_t x373;
  fiat_np384_uint1 x374;
  uint32_t x375;
  fiat_np384_uint1 x376;
  uint32_t x377;
  fiat_np384_uint1 x378;
  uint32_t x379;
  fiat_np384_uint1 x380;
  uint32_t x381;
  fiat_np384_uint1 x382;
  uint32_t x383;
  fiat_np384_uint1 x384;
  uint32_t x385;
  fiat_np384_uint1 x386;
  uint32_t x387;
  fiat_np384_uint1 x388;
  uint32_t x389;
  fiat_np384_uint1 x390;
  uint32_t x391;
  fiat_np384_uint1 x392;
  uint32_t x393;
  fiat_np384_uint1 x394;
  uint32_t x395;
  fiat_np384_uint1 x396;
  uint32_t x397;
  fiat_np384_uint1 x398;
  uint32_t x399;
  fiat_np384_uint1 x400;
  uint32_t x401;
  fiat_np384_uint1 x402;
  uint32_t x403;
  fiat_np384_uint1 x404;
  uint32_t x405;
  fiat_np384_uint1 x406;
  uint32_t x407;
  fiat_np384_uint1 x408;
  uint32_t x409;
  fiat_np384_uint1 x410;
  uint32_t x411;
  fiat_np384_uint1 x412;
  uint32_t x413;
  fiat_np384_uint1 x414;
  uint32_t x415;
  fiat_np384_uint1 x416;
  uint32_t x417;
  fiat_np384_uint1 x418;
  uint32_t x419;
  fiat_np384_uint1 x420;
  uint32_t x421;
  uint32_t x422;
  uint32_t x423;
  uint32_t x424;
  uint32_t x425;
  uint32_t x426;
  uint32_t x427;
  uint32_t x428;
  uint32_t x429;
  uint32_t x430;
  uint32_t x431;
  uint32_t x432;
  uint32_t x433;
  uint32_t x434;
  uint32_t x435;
  uint32_t x436;
  uint32_t x437;
  uint32_t x438;
  uint32_t x439;
  uint32_t x440;
  uint32_t x441;
  uint32_t x442;
  uint32_t x443;
  uint32_t x444;
  uint32_t x445;
  fiat_np384_uint1 x446;
  uint32_t x447;
  fiat_np384_uint1 x448;
  uint32_t x449;
  fiat_np384_uint1 x450;
  uint32_t x451;
  fiat_np384_uint1 x452;
  uint32_t x453;
  fiat_np384_uint1 x454;
  uint32_t x455;
  fiat_np384_uint1 x456;
  uint32_t x457;
  fiat_np384_uint1 x458;
  uint32_t x459;
  fiat_np384_uint1 x460;
  uint32_t x461;
  fiat_np384_uint1 x462;
  uint32_t x463;
  fiat_np384_uint1 x464;
  uint32_t x465;
  fiat_np384_uint1 x466;
  uint32_t x467;
  fiat_np384_uint1 x468;
  uint32_t x469;
  fiat_np384_uint1 x470;
  uint32_t x471;
  fiat_np384_uint1 x472;
  uint32_t x473;
  fiat_np384_uint1 x474;
  uint32_t x475;
  fiat_np384_uint1 x476;
  uint32_t x477;
  fiat_np384_uint1 x478;
  uint32_t x479;
  fiat_np384_uint1 x480;
  uint32_t x481;
  fiat_np384_uint1 x482;
  uint32_t x483;
  fiat_np384_uint1 x484;
  uint32_t x485;
  fiat_np384_uint1 x486;
  uint32_t x487;
  fiat_np384_uint1 x488;
  uint32_t x489;
  fiat_np384_uint1 x490;
  uint32_t x491;
  uint32_t x492;
  uint32_t x493;
  uint32_t x494;
  uint32_t x495;
  uint32_t x496;
  uint32_t x497;
  uint32_t x498;
  uint32_t x499;
  uint32_t x500;
  uint32_t x501;
  uint32_t x502;
  uint32_t x503;
  uint32_t x504;
  uint32_t x505;
  uint32_t x506;
  uint32_t x507;
  uint32_t x508;
  uint32_t x509;
  uint32_t x510;
  uint32_t x511;
  uint32_t x512;
  uint32_t x513;
  uint32_t x514;
  uint32_t x515;
  uint32_t x516;
  uint32_t x517;
  fiat_np384_uint1 x518;
  uint32_t x519;
  fiat_np384_uint1 x520;
  uint32_t x521;
  fiat_np384_uint1 x522;
  uint32_t x523;
  fiat_np384_uint1 x524;
  uint32_t x525;
  fiat_np384_uint1 x526;
  uint32_t x527;
  fiat_np384_uint1 x528;
  uint32_t x529;
  fiat_np384_uint1 x530;
  uint32_t x531;
  fiat_np384_uint1 x532;
  uint32_t x533;
  fiat_np384_uint1 x534;
  uint32_t x535;
  fiat_np384_uint1 x536;
  uint32_t x537;
  fiat_np384_uint1 x538;
  uint32_t x539;
  fiat_np384_uint1 x540;
  uint32_t x541;
  fiat_np384_uint1 x542;
  uint32_t x543;
  fiat_np384_uint1 x544;
  uint32_t x545;
  fiat_np384_uint1 x546;
  uint32_t x547;
  fiat_np384_uint1 x548;
  uint32_t x549;
  fiat_np384_uint1 x550;
  uint32_t x551;
  fiat_np384_uint1 x552;
  uint32_t x553;
  fiat_np384_uint1 x554;
  uint32_t x555;
  fiat_np384_uint1 x556;
  uint32_t x557;
  fiat_np384_uint1 x558;
  uint32_t x559;
  fiat_np384_uint1 x560;
  uint32_t x561;
  fiat_np384_uint1 x562;
  uint32_t x563;
  fiat_np384_uint1 x564;
  uint32_t x565;
  uint32_t x566;
  uint32_t x567;
  uint32_t x568;
  uint32_t x569;
  uint32_t x570;
  uint32_t x571;
  uint32_t x572;
  uint32_t x573;
  uint32_t x574;
  uint32_t x575;
  uint32_t x576;
  uint32_t x577;
  uint32_t x578;
  uint32_t x579;
  uint32_t x580;
  uint32_t x581;
  uint32_t x582;
  uint32_t x583;
  uint32_t x584;
  uint32_t x585;
  uint32_t x586;
  uint32_t x587;
  uint32_t x588;
  uint32_t x589;
  fiat_np384_uint1 x590;
  uint32_t x591;
  fiat_np384_uint1 x592;
  uint32_t x593;
  fiat_np384_uint1 x594;
  uint32_t x595;
  fiat_np384_uint1 x596;
  uint32_t x597;
  fiat_np384_uint1 x598;
  uint32_t x599;
  fiat_np384_uint1 x600;
  uint32_t x601;
  fiat_np384_uint1 x602;
  uint32_t x603;
  fiat_np384_uint1 x604;
  uint32_t x605;
  fiat_np384_uint1 x606;
  uint32_t x607;
  fiat_np384_uint1 x608;
  uint32_t x609;
  fiat_np384_uint1 x610;
  uint32_t x611;
  fiat_np384_uint1 x612;
  uint32_t x613;
  fiat_np384_uint1 x614;
  uint32_t x615;
  fiat_np384_uint1 x616;
  uint32_t x617;
  fiat_np384_uint1 x618;
  uint32_t x619;
  fiat_np384_uint1 x620;
  uint32_t x621;
  fiat_np384_uint1 x622;
  uint32_t x623;
  fiat_np384_uint1 x624;
  uint32_t x625;
  fiat_np384_uint1 x626;
  uint32_t x627;
  fiat_np384_uint1 x628;
  uint32_t x629;
  fiat_np384_uint1 x630;
  uint32_t x631;
  fiat_np384_uint1 x632;
  uint32_t x633;
  fiat_np384_uint1 x634;
  uint32_t x635;
  uint32_t x636;
  uint32_t x637;
  uint32_t x638;
  uint32_t x639;
  uint32_t x640;
  uint32_t x641;
  uint32_t x642;
  uint32_t x643;
  uint32_t x644;
  uint32_t x645;
  uint32_t x646;
  uint32_t x647;
  uint32_t x648;
  uint32_t x649;
  uint32_t x650;
  uint32_t x651;
  uint32_t x652;
  uint32_t x653;
  uint32_t x654;
  uint32_t x655;
  uint32_t x656;
  uint32_t x657;
  uint32_t x658;
  uint32_t x659;
  uint32_t x660;
  uint32_t x661;
  fiat_np384_uint1 x662;
  uint32_t x663;
  fiat_np384_uint1 x664;
  uint32_t x665;
  fiat_np384_uint1 x666;
  uint32_t x667;
  fiat_np384_uint1 x668;
  uint32_t x669;
  fiat_np384_uint1 x670;
  uint32_t x671;
  fiat_np384_uint1 x672;
  uint32_t x673;
  fiat_np384_uint1 x674;
  uint32_t x675;
  fiat_np384_uint1 x676;
  uint32_t x677;
  fiat_np384_uint1 x678;
  uint32_t x679;
  fiat_np384_uint1 x680;
  uint32_t x681;
  fiat_np384_uint1 x682;
  uint32_t x683;
  fiat_np384_uint1 x684;
  uint32_t x685;
  fiat_np384_uint1 x686;
  uint32_t x687;
  fiat_np384_uint1 x688;
  uint32_t x689;
  fiat_np384_uint1 x690;
  uint32_t x691;
  fiat_np384_uint1 x692;
  uint32_t x693;
  fiat_np384_uint1 x694;
  uint32_t x695;
  fiat_np384_uint1 x696;
  uint32_t x697;
  fiat_np384_uint1 x698;
  uint32_t x699;
  fiat_np384_uint1 x700;
  uint32_t x701;
  fiat_np384_uint1 x702;
  uint32_t x703;
  fiat_np384_uint1 x704;
  uint32_t x705;
  fiat_np384_uint1 x706;
  uint32_t x707;
  fiat_np384_uint1 x708;
  uint32_t x709;
  uint32_t x710;
  uint32_t x711;
  uint32_t x712;
  uint32_t x713;
  uint32_t x714;
  uint32_t x715;
  uint32_t x716;
  uint32_t x717;
  uint32_t x718;
  uint32_t x719;
  uint32_t x720;
  uint32_t x721;
  uint32_t x722;
  uint32_t x723;
  uint32_t x724;
  uint32_t x725;
  uint32_t x726;
  uint32_t x727;
  uint32_t x728;
  uint32_t x729;
  uint32_t x730;
  uint32_t x731;
  uint32_t x732;
  uint32_t x733;
  fiat_np384_uint1 x734;
  uint32_t x735;
  fiat_np384_uint1 x736;
  uint32_t x737;
  fiat_np384_uint1 x738;
  uint32_t x739;
  fiat_np384_uint1 x740;
  uint32_t x741;
  fiat_np384_uint1 x742;
  uint32_t x743;
  fiat_np384_uint1 x744;
  uint32_t x745;
  fiat_np384_uint1 x746;
  uint32_t x747;
  fiat_np384_uint1 x748;
  uint32_t x749;
  fiat_np384_uint1 x750;
  uint32_t x751;
  fiat_np384_uint1 x752;
  uint32_t x753;
  fiat_np384_uint1 x754;
  uint32_t x755;
  fiat_np384_uint1 x756;
  uint32_t x757;
  fiat_np384_uint1 x758;
  uint32_t x759;
  fiat_np384_uint1 x760;
  uint32_t x761;
  fiat_np384_uint1 x762;
  uint32_t x763;
  fiat_np384_uint1 x764;
  uint32_t x765;
  fiat_np384_uint1 x766;
  uint32_t x767;
  fiat_np384_uint1 x768;
  uint32_t x769;
  fiat_np384_uint1 x770;
  uint32_t x771;
  fiat_np384_uint1 x772;
  uint32_t x773;
  fiat_np384_uint1 x774;
  uint32_t x775;
  fiat_np384_uint1 x776;
  uint32_t x777;
  fiat_np384_uint1 x778;
  uint32_t x779;
  uint32_t x780;
  uint32_t x781;
  uint32_t x782;
  uint32_t x783;
  uint32_t x784;
  uint32_t x785;
  uint32_t x786;
  uint32_t x787;
  uint32_t x788;
  uint32_t x789;
  uint32_t x790;
  uint32_t x791;
  uint32_t x792;
  uint32_t x793;
  uint32_t x794;
  uint32_t x795;
  uint32_t x796;
  uint32_t x797;
  uint32_t x798;
  uint32_t x799;
  uint32_t x800;
  uint32_t x801;
  uint32_t x802;
  uint32_t x803;
  uint32_t x804;
  uint32_t x805;
  fiat_np384_uint1 x806;
  uint32_t x807;
  fiat_np384_uint1 x808;
  uint32_t x809;
  fiat_np384_uint1 x810;
  uint32_t x811;
  fiat_np384_uint1 x812;
  uint32_t x813;
  fiat_np384_uint1 x814;
  uint32_t x815;
  fiat_np384_uint1 x816;
  uint32_t x817;
  fiat_np384_uint1 x818;
  uint32_t x819;
  fiat_np384_uint1 x820;
  uint32_t x821;
  fiat_np384_uint1 x822;
  uint32_t x823;
  fiat_np384_uint1 x824;
  uint32_t x825;
  fiat_np384_uint1 x826;
  uint32_t x827;
  fiat_np384_uint1 x828;
  uint32_t x829;
  fiat_np384_uint1 x830;
  uint32_t x831;
  fiat_np384_uint1 x832;
  uint32_t x833;
  fiat_np384_uint1 x834;
  uint32_t x835;
  fiat_np384_uint1 x836;
  uint32_t x837;
  fiat_np384_uint1 x838;
  uint32_t x839;
  fiat_np384_uint1 x840;
  uint32_t x841;
  fiat_np384_uint1 x842;
  uint32_t x843;
  fiat_np384_uint1 x844;
  uint32_t x845;
  fiat_np384_uint1 x846;
  uint32_t x847;
  fiat_np384_uint1 x848;
  uint32_t x849;
  fiat_np384_uint1 x850;
  uint32_t x851;
  fiat_np384_uint1 x852;
  uint32_t x853;
  uint32_t x854;
  uint32_t x855;
  uint32_t x856;
  uint32_t x857;
  uint32_t x858;
  uint32_t x859;
  uint32_t x860;
  uint32_t x861;
  uint32_t x862;
  uint32_t x863;
  uint32_t x864;
  uint32_t x865;
  uint32_t x866;
  uint32_t x867;
  uint32_t x868;
  uint32_t x869;
  uint32_t x870;
  uint32_t x871;
  uint32_t x872;
  uint32_t x873;
  uint32_t x874;
  uint32_t x875;
  uint32_t x876;
  uint32_t x877;
  fiat_np384_uint1 x878;
  uint32_t x879;
  fiat_np384_uint1 x880;
  uint32_t x881;
  fiat_np384_uint1 x882;
  uint32_t x883;
  fiat_np384_uint1 x884;
  uint32_t x885;
  fiat_np384_uint1 x886;
  uint32_t x887;
  fiat_np384_uint1 x888;
  uint32_t x889;
  fiat_np384_uint1 x890;
  uint32_t x891;
  fiat_np384_uint1 x892;
  uint32_t x893;
  fiat_np384_uint1 x894;
  uint32_t x895;
  fiat_np384_uint1 x896;
  uint32_t x897;
  fiat_np384_uint1 x898;
  uint32_t x899;
  fiat_np384_uint1 x900;
  uint32_t x901;
  fiat_np384_uint1 x902;
  uint32_t x903;
  fiat_np384_uint1 x904;
  uint32_t x905;
  fiat_np384_uint1 x906;
  uint32_t x907;
  fiat_np384_uint1 x908;
  uint32_t x909;
  fiat_np384_uint1 x910;
  uint32_t x911;
  fiat_np384_uint1 x912;
  uint32_t x913;
  fiat_np384_uint1 x914;
  uint32_t x915;
  fiat_np384_uint1 x916;
  uint32_t x917;
  fiat_np384_uint1 x918;
  uint32_t x919;
  fiat_np384_uint1 x920;
  uint32_t x921;
  fiat_np384_uint1 x922;
  uint32_t x923;
  uint32_t x924;
  uint32_t x925;
  uint32_t x926;
  uint32_t x927;
  uint32_t x928;
  uint32_t x929;
  uint32_t x930;
  uint32_t x931;
  uint32_t x932;
  uint32_t x933;
  uint32_t x934;
  uint32_t x935;
  uint32_t x936;
  uint32_t x937;
  uint32_t x938;
  uint32_t x939;
  uint32_t x940;
  uint32_t x941;
  uint32_t x942;
  uint32_t x943;
  uint32_t x944;
  uint32_t x945;
  uint32_t x946;
  uint32_t x947;
  uint32_t x948;
  uint32_t x949;
  fiat_np384_uint1 x950;
  uint32_t x951;
  fiat_np384_uint1 x952;
  uint32_t x953;
  fiat_np384_uint1 x954;
  uint32_t x955;
  fiat_np384_uint1 x956;
  uint32_t x957;
  fiat_np384_uint1 x958;
  uint32_t x959;
  fiat_np384_uint1 x960;
  uint32_t x961;
  fiat_np384_uint1 x962;
  uint32_t x963;
  fiat_np384_uint1 x964;
  uint32_t x965;
  fiat_np384_uint1 x966;
  uint32_t x967;
  fiat_np384_uint1 x968;
  uint32_t x969;
  fiat_np384_uint1 x970;
  uint32_t x971;
  fiat_np384_uint1 x972;
  uint32_t x973;
  fiat_np384_uint1 x974;
  uint32_t x975;
  fiat_np384_uint1 x976;
  uint32_t x977;
  fiat_np384_uint1 x978;
  uint32_t x979;
  fiat_np384_uint1 x980;
  uint32_t x981;
  fiat_np384_uint1 x982;
  uint32_t x983;
  fiat_np384_uint1 x984;
  uint32_t x985;
  fiat_np384_uint1 x986;
  uint32_t x987;
  fiat_np384_uint1 x988;
  uint32_t x989;
  fiat_np384_uint1 x990;
  uint32_t x991;
  fiat_np384_uint1 x992;
  uint32_t x993;
  fiat_np384_uint1 x994;
  uint32_t x995;
  fiat_np384_uint1 x996;
  uint32_t x997;
  uint32_t x998;
  uint32_t x999;
  uint32_t x1000;
  uint32_t x1001;
  uint32_t x1002;
  uint32_t x1003;
  uint32_t x1004;
  uint32_t x1005;
  uint32_t x1006;
  uint32_t x1007;
  uint32_t x1008;
  uint32_t x1009;
  uint32_t x1010;
  uint32_t x1011;
  uint32_t x1012;
  uint32_t x1013;
  uint32_t x1014;
  uint32_t x1015;
  uint32_t x1016;
  uint32_t x1017;
  uint32_t x1018;
  uint32_t x1019;
  uint32_t x1020;
  uint32_t x1021;
  fiat_np384_uint1 x1022;
  uint32_t x1023;
  fiat_np384_uint1 x1024;
  uint32_t x1025;
  fiat_np384_uint1 x1026;
  uint32_t x1027;
  fiat_np384_uint1 x1028;
  uint32_t x1029;
  fiat_np384_uint1 x1030;
  uint32_t x1031;
  fiat_np384_uint1 x1032;
  uint32_t x1033;
  fiat_np384_uint1 x1034;
  uint32_t x1035;
  fiat_np384_uint1 x1036;
  uint32_t x1037;
  fiat_np384_uint1 x1038;
  uint32_t x1039;
  fiat_np384_uint1 x1040;
  uint32_t x1041;
  fiat_np384_uint1 x1042;
  uint32_t x1043;
  fiat_np384_uint1 x1044;
  uint32_t x1045;
  fiat_np384_uint1 x1046;
  uint32_t x1047;
  fiat_np384_uint1 x1048;
  uint32_t x1049;
  fiat_np384_uint1 x1050;
  uint32_t x1051;
  fiat_np384_uint1 x1052;
  uint32_t x1053;
  fiat_np384_uint1 x1054;
  uint32_t x1055;
  fiat_np384_uint1 x1056;
  uint32_t x1057;
  fiat_np384_uint1 x1058;
  uint32_t x1059;
  fiat_np384_uint1 x1060;
  uint32_t x1061;
  fiat_np384_uint1 x1062;
  uint32_t x1063;
  fiat_np384_uint1 x1064;
  uint32_t x1065;
  fiat_np384_uint1 x1066;
  uint32_t x1067;
  uint32_t x1068;
  uint32_t x1069;
  uint32_t x1070;
  uint32_t x1071;
  uint32_t x1072;
  uint32_t x1073;
  uint32_t x1074;
  uint32_t x1075;
  uint32_t x1076;
  uint32_t x1077;
  uint32_t x1078;
  uint32_t x1079;
  uint32_t x1080;
  uint32_t x1081;
  uint32_t x1082;
  uint32_t x1083;
  uint32_t x1084;
  uint32_t x1085;
  uint32_t x1086;
  uint32_t x1087;
  uint32_t x1088;
  uint32_t x1089;
  uint32_t x1090;
  uint32_t x1091;
  uint32_t x1092;
  uint32_t x1093;
  fiat_np384_uint1 x1094;
  uint32_t x1095;
  fiat_np384_uint1 x1096;
  uint32_t x1097;
  fiat_np384_uint1 x1098;
  uint32_t x1099;
  fiat_np384_uint1 x1100;
  uint32_t x1101;
  fiat_np384_uint1 x1102;
  uint32_t x1103;
  fiat_np384_uint1 x1104;
  uint32_t x1105;
  fiat_np384_uint1 x1106;
  uint32_t x1107;
  fiat_np384_uint1 x1108;
  uint32_t x1109;
  fiat_np384_uint1 x1110;
  uint32_t x1111;
  fiat_np384_uint1 x1112;
  uint32_t x1113;
  fiat_np384_uint1 x1114;
  uint32_t x1115;
  fiat_np384_uint1 x1116;
  uint32_t x1117;
  fiat_np384_uint1 x1118;
  uint32_t x1119;
  fiat_np384_uint1 x1120;
  uint32_t x1121;
  fiat_np384_uint1 x1122;
  uint32_t x1123;
  fiat_np384_uint1 x1124;
  uint32_t x1125;
  fiat_np384_uint1 x1126;
  uint32_t x1127;
  fiat_np384_uint1 x1128;
  uint32_t x1129;
  fiat_np384_uint1 x1130;
  uint32_t x1131;
  fiat_np384_uint1 x1132;
  uint32_t x1133;
  fiat_np384_uint1 x1134;
  uint32_t x1135;
  fiat_np384_uint1 x1136;
  uint32_t x1137;
  fiat_np384_uint1 x1138;
  uint32_t x1139;
  fiat_np384_uint1 x1140;
  uint32_t x1141;
  uint32_t x1142;
  uint32_t x1143;
  uint32_t x1144;
  uint32_t x1145;
  uint32_t x1146;
  uint32_t x1147;
  uint32_t x1148;
  uint32_t x1149;
  uint32_t x1150;
  uint32_t x1151;
  uint32_t x1152;
  uint32_t x1153;
  uint32_t x1154;
  uint32_t x1155;
  uint32_t x1156;
  uint32_t x1157;
  uint32_t x1158;
  uint32_t x1159;
  uint32_t x1160;
  uint32_t x1161;
  uint32_t x1162;
  uint32_t x1163;
  uint32_t x1164;
  uint32_t x1165;
  fiat_np384_uint1 x1166;
  uint32_t x1167;
  fiat_np384_uint1 x1168;
  uint32_t x1169;
  fiat_np384_uint1 x1170;
  uint32_t x1171;
  fiat_np384_uint1 x1172;
  uint32_t x1173;
  fiat_np384_uint1 x1174;
  uint32_t x1175;
  fiat_np384_uint1 x1176;
  uint32_t x1177;
  fiat_np384_uint1 x1178;
  uint32_t x1179;
  fiat_np384_uint1 x1180;
  uint32_t x1181;
  fiat_np384_uint1 x1182;
  uint32_t x1183;
  fiat_np384_uint1 x1184;
  uint32_t x1185;
  fiat_np384_uint1 x1186;
  uint32_t x1187;
  fiat_np384_uint1 x1188;
  uint32_t x1189;
  fiat_np384_uint1 x1190;
  uint32_t x1191;
  fiat_np384_uint1 x1192;
  uint32_t x1193;
  fiat_np384_uint1 x1194;
  uint32_t x1195;
  fiat_np384_uint1 x1196;
  uint32_t x1197;
  fiat_np384_uint1 x1198;
  uint32_t x1199;
  fiat_np384_uint1 x1200;
  uint32_t x1201;
  fiat_np384_uint1 x1202;
  uint32_t x1203;
  fiat_np384_uint1 x1204;
  uint32_t x1205;
  fiat_np384_uint1 x1206;
  uint32_t x1207;
  fiat_np384_uint1 x1208;
  uint32_t x1209;
  fiat_np384_uint1 x1210;
  uint32_t x1211;
  uint32_t x1212;
  uint32_t x1213;
  uint32_t x1214;
  uint32_t x1215;
  uint32_t x1216;
  uint32_t x1217;
  uint32_t x1218;
  uint32_t x1219;
  uint32_t x1220;
  uint32_t x1221;
  uint32_t x1222;
  uint32_t x1223;
  uint32_t x1224;
  uint32_t x1225;
  uint32_t x1226;
  uint32_t x1227;
  uint32_t x1228;
  uint32_t x1229;
  uint32_t x1230;
  uint32_t x1231;
  uint32_t x1232;
  uint32_t x1233;
  uint32_t x1234;
  uint32_t x1235;
  uint32_t x1236;
  uint32_t x1237;
  fiat_np384_uint1 x1238;
  uint32_t x1239;
  fiat_np384_uint1 x1240;
  uint32_t x1241;
  fiat_np384_uint1 x1242;
  uint32_t x1243;
  fiat_np384_uint1 x1244;
  uint32_t x1245;
  fiat_np384_uint1 x1246;
  uint32_t x1247;
  fiat_np384_uint1 x1248;
  uint32_t x1249;
  fiat_np384_uint1 x1250;
  uint32_t x1251;
  fiat_np384_uint1 x1252;
  uint32_t x1253;
  fiat_np384_uint1 x1254;
  uint32_t x1255;
  fiat_np384_uint1 x1256;
  uint32_t x1257;
  fiat_np384_uint1 x1258;
  uint32_t x1259;
  fiat_np384_uint1 x1260;
  uint32_t x1261;
  fiat_np384_uint1 x1262;
  uint32_t x1263;
  fiat_np384_uint1 x1264;
  uint32_t x1265;
  fiat_np384_uint1 x1266;
  uint32_t x1267;
  fiat_np384_uint1 x1268;
  uint32_t x1269;
  fiat_np384_uint1 x1270;
  uint32_t x1271;
  fiat_np384_uint1 x1272;
  uint32_t x1273;
  fiat_np384_uint1 x1274;
  uint32_t x1275;
  fiat_np384_uint1 x1276;
  uint32_t x1277;
  fiat_np384_uint1 x1278;
  uint32_t x1279;
  fiat_np384_uint1 x1280;
  uint32_t x1281;
  fiat_np384_uint1 x1282;
  uint32_t x1283;
  fiat_np384_uint1 x1284;
  uint32_t x1285;
  uint32_t x1286;
  uint32_t x1287;
  uint32_t x1288;
  uint32_t x1289;
  uint32_t x1290;
  uint32_t x1291;
  uint32_t x1292;
  uint32_t x1293;
  uint32_t x1294;
  uint32_t x1295;
  uint32_t x1296;
  uint32_t x1297;
  uint32_t x1298;
  uint32_t x1299;
  uint32_t x1300;
  uint32_t x1301;
  uint32_t x1302;
  uint32_t x1303;
  uint32_t x1304;
  uint32_t x1305;
  uint32_t x1306;
  uint32_t x1307;
  uint32_t x1308;
  uint32_t x1309;
  fiat_np384_uint1 x1310;
  uint32_t x1311;
  fiat_np384_uint1 x1312;
  uint32_t x1313;
  fiat_np384_uint1 x1314;
  uint32_t x1315;
  fiat_np384_uint1 x1316;
  uint32_t x1317;
  fiat_np384_uint1 x1318;
  uint32_t x1319;
  fiat_np384_uint1 x1320;
  uint32_t x1321;
  fiat_np384_uint1 x1322;
  uint32_t x1323;
  fiat_np384_uint1 x1324;
  uint32_t x1325;
  fiat_np384_uint1 x1326;
  uint32_t x1327;
  fiat_np384_uint1 x1328;
  uint32_t x1329;
  fiat_np384_uint1 x1330;
  uint32_t x1331;
  fiat_np384_uint1 x1332;
  uint32_t x1333;
  fiat_np384_uint1 x1334;
  uint32_t x1335;
  fiat_np384_uint1 x1336;
  uint32_t x1337;
  fiat_np384_uint1 x1338;
  uint32_t x1339;
  fiat_np384_uint1 x1340;
  uint32_t x1341;
  fiat_np384_uint1 x1342;
  uint32_t x1343;
  fiat_np384_uint1 x1344;
  uint32_t x1345;
  fiat_np384_uint1 x1346;
  uint32_t x1347;
  fiat_np384_uint1 x1348;
  uint32_t x1349;
  fiat_np384_uint1 x1350;
  uint32_t x1351;
  fiat_np384_uint1 x1352;
  uint32_t x1353;
  fiat_np384_uint1 x1354;
  uint32_t x1355;
  uint32_t x1356;
  uint32_t x1357;
  uint32_t x1358;
  uint32_t x1359;
  uint32_t x1360;
  uint32_t x1361;
  uint32_t x1362;
  uint32_t x1363;
  uint32_t x1364;
  uint32_t x1365;
  uint32_t x1366;
  uint32_t x1367;
  uint32_t x1368;
  uint32_t x1369;
  uint32_t x1370;
  uint32_t x1371;
  uint32_t x1372;
  uint32_t x1373;
  uint32_t x1374;
  uint32_t x1375;
  uint32_t x1376;
  uint32_t x1377;
  uint32_t x1378;
  uint32_t x1379;
  uint32_t x1380;
  uint32_t x1381;
  fiat_np384_uint1 x1382;
  uint32_t x1383;
  fiat_np384_uint1 x1384;
  uint32_t x1385;
  fiat_np384_uint1 x1386;
  uint32_t x1387;
  fiat_np384_uint1 x1388;
  uint32_t x1389;
  fiat_np384_uint1 x1390;
  uint32_t x1391;
  fiat_np384_uint1 x1392;
  uint32_t x1393;
  fiat_np384_uint1 x1394;
  uint32_t x1395;
  fiat_np384_uint1 x1396;
  uint32_t x1397;
  fiat_np384_uint1 x1398;
  uint32_t x1399;
  fiat_np384_uint1 x1400;
  uint32_t x1401;
  fiat_np384_uint1 x1402;
  uint32_t x1403;
  fiat_np384_uint1 x1404;
  uint32_t x1405;
  fiat_np384_uint1 x1406;
  uint32_t x1407;
  fiat_np384_uint1 x1408;
  uint32_t x1409;
  fiat_np384_uint1 x1410;
  uint32_t x1411;
  fiat_np384_uint1 x1412;
  uint32_t x1413;
  fiat_np384_uint1 x1414;
  uint32_t x1415;
  fiat_np384_uint1 x1416;
  uint32_t x1417;
  fiat_np384_uint1 x1418;
  uint32_t x1419;
  fiat_np384_uint1 x1420;
  uint32_t x1421;
  fiat_np384_uint1 x1422;
  uint32_t x1423;
  fiat_np384_uint1 x1424;
  uint32_t x1425;
  fiat_np384_uint1 x1426;
  uint32_t x1427;
  fiat_np384_uint1 x1428;
  uint32_t x1429;
  uint32_t x1430;
  uint32_t x1431;
  uint32_t x1432;
  uint32_t x1433;
  uint32_t x1434;
  uint32_t x1435;
  uint32_t x1436;
  uint32_t x1437;
  uint32_t x1438;
  uint32_t x1439;
  uint32_t x1440;
  uint32_t x1441;
  uint32_t x1442;
  uint32_t x1443;
  uint32_t x1444;
  uint32_t x1445;
  uint32_t x1446;
  uint32_t x1447;
  uint32_t x1448;
  uint32_t x1449;
  uint32_t x1450;
  uint32_t x1451;
  uint32_t x1452;
  uint32_t x1453;
  fiat_np384_uint1 x1454;
  uint32_t x1455;
  fiat_np384_uint1 x1456;
  uint32_t x1457;
  fiat_np384_uint1 x1458;
  uint32_t x1459;
  fiat_np384_uint1 x1460;
  uint32_t x1461;
  fiat_np384_uint1 x1462;
  uint32_t x1463;
  fiat_np384_uint1 x1464;
  uint32_t x1465;
  fiat_np384_uint1 x1466;
  uint32_t x1467;
  fiat_np384_uint1 x1468;
  uint32_t x1469;
  fiat_np384_uint1 x1470;
  uint32_t x1471;
  fiat_np384_uint1 x1472;
  uint32_t x1473;
  fiat_np384_uint1 x1474;
  uint32_t x1475;
  fiat_np384_uint1 x1476;
  uint32_t x1477;
  fiat_np384_uint1 x1478;
  uint32_t x1479;
  fiat_np384_uint1 x1480;
  uint32_t x1481;
  fiat_np384_uint1 x1482;
  uint32_t x1483;
  fiat_np384_uint1 x1484;
  uint32_t x1485;
  fiat_np384_uint1 x1486;
  uint32_t x1487;
  fiat_np384_uint1 x1488;
  uint32_t x1489;
  fiat_np384_uint1 x1490;
  uint32_t x1491;
  fiat_np384_uint1 x1492;
  uint32_t x1493;
  fiat_np384_uint1 x1494;
  uint32_t x1495;
  fiat_np384_uint1 x1496;
  uint32_t x1497;
  fiat_np384_uint1 x1498;
  uint32_t x1499;
  uint32_t x1500;
  uint32_t x1501;
  uint32_t x1502;
  uint32_t x1503;
  uint32_t x1504;
  uint32_t x1505;
  uint32_t x1506;
  uint32_t x1507;
  uint32_t x1508;
  uint32_t x1509;
  uint32_t x1510;
  uint32_t x1511;
  uint32_t x1512;
  uint32_t x1513;
  uint32_t x1514;
  uint32_t x1515;
  uint32_t x1516;
  uint32_t x1517;
  uint32_t x1518;
  uint32_t x1519;
  uint32_t x1520;
  uint32_t x1521;
  uint32_t x1522;
  uint32_t x1523;
  uint32_t x1524;
  uint32_t x1525;
  fiat_np384_uint1 x1526;
  uint32_t x1527;
  fiat_np384_uint1 x1528;
  uint32_t x1529;
  fiat_np384_uint1 x1530;
  uint32_t x1531;
  fiat_np384_uint1 x1532;
  uint32_t x1533;
  fiat_np384_uint1 x1534;
  uint32_t x1535;
  fiat_np384_uint1 x1536;
  uint32_t x1537;
  fiat_np384_uint1 x1538;
  uint32_t x1539;
  fiat_np384_uint1 x1540;
  uint32_t x1541;
  fiat_np384_uint1 x1542;
  uint32_t x1543;
  fiat_np384_uint1 x1544;
  uint32_t x1545;
  fiat_np384_uint1 x1546;
  uint32_t x1547;
  fiat_np384_uint1 x1548;
  uint32_t x1549;
  fiat_np384_uint1 x1550;
  uint32_t x1551;
  fiat_np384_uint1 x1552;
  uint32_t x1553;
  fiat_np384_uint1 x1554;
  uint32_t x1555;
  fiat_np384_uint1 x1556;
  uint32_t x1557;
  fiat_np384_uint1 x1558;
  uint32_t x1559;
  fiat_np384_uint1 x1560;
  uint32_t x1561;
  fiat_np384_uint1 x1562;
  uint32_t x1563;
  fiat_np384_uint1 x1564;
  uint32_t x1565;
  fiat_np384_uint1 x1566;
  uint32_t x1567;
  fiat_np384_uint1 x1568;
  uint32_t x1569;
  fiat_np384_uint1 x1570;
  uint32_t x1571;
  fiat_np384_uint1 x1572;
  uint32_t x1573;
  uint32_t x1574;
  uint32_t x1575;
  uint32_t x1576;
  uint32_t x1577;
  uint32_t x1578;
  uint32_t x1579;
  uint32_t x1580;
  uint32_t x1581;
  uint32_t x1582;
  uint32_t x1583;
  uint32_t x1584;
  uint32_t x1585;
  uint32_t x1586;
  uint32_t x1587;
  uint32_t x1588;
  uint32_t x1589;
  uint32_t x1590;
  uint32_t x1591;
  uint32_t x1592;
  uint32_t x1593;
  uint32_t x1594;
  uint32_t x1595;
  uint32_t x1596;
  uint32_t x1597;
  fiat_np384_uint1 x1598;
  uint32_t x1599;
  fiat_np384_uint1 x1600;
  uint32_t x1601;
  fiat_np384_uint1 x1602;
  uint32_t x1603;
  fiat_np384_uint1 x1604;
  uint32_t x1605;
  fiat_np384_uint1 x1606;
  uint32_t x1607;
  fiat_np384_uint1 x1608;
  uint32_t x1609;
  fiat_np384_uint1 x1610;
  uint32_t x1611;
  fiat_np384_uint1 x1612;
  uint32_t x1613;
  fiat_np384_uint1 x1614;
  uint32_t x1615;
  fiat_np384_uint1 x1616;
  uint32_t x1617;
  fiat_np384_uint1 x1618;
  uint32_t x1619;
  fiat_np384_uint1 x1620;
  uint32_t x1621;
  fiat_np384_uint1 x1622;
  uint32_t x1623;
  fiat_np384_uint1 x1624;
  uint32_t x1625;
  fiat_np384_uint1 x1626;
  uint32_t x1627;
  fiat_np384_uint1 x1628;
  uint32_t x1629;
  fiat_np384_uint1 x1630;
  uint32_t x1631;
  fiat_np384_uint1 x1632;
  uint32_t x1633;
  fiat_np384_uint1 x1634;
  uint32_t x1635;
  fiat_np384_uint1 x1636;
  uint32_t x1637;
  fiat_np384_uint1 x1638;
  uint32_t x1639;
  fiat_np384_uint1 x1640;
  uint32_t x1641;
  fiat_np384_uint1 x1642;
  uint32_t x1643;
  uint32_t x1644;
  uint32_t x1645;
  uint32_t x1646;
  uint32_t x1647;
  uint32_t x1648;
  uint32_t x1649;
  uint32_t x1650;
  uint32_t x1651;
  uint32_t x1652;
  uint32_t x1653;
  uint32_t x1654;
  uint32_t x1655;
  uint32_t x1656;
  uint32_t x1657;
  uint32_t x1658;
  uint32_t x1659;
  uint32_t x1660;
  uint32_t x1661;
  uint32_t x1662;
  uint32_t x1663;
  uint32_t x1664;
  uint32_t x1665;
  uint32_t x1666;
  uint32_t x1667;
  uint32_t x1668;
  uint32_t x1669;
  fiat_np384_uint1 x1670;
  uint32_t x1671;
  fiat_np384_uint1 x1672;
  uint32_t x1673;
  fiat_np384_uint1 x1674;
  uint32_t x1675;
  fiat_np384_uint1 x1676;
  uint32_t x1677;
  fiat_np384_uint1 x1678;
  uint32_t x1679;
  fiat_np384_uint1 x1680;
  uint32_t x1681;
  fiat_np384_uint1 x1682;
  uint32_t x1683;
  fiat_np384_uint1 x1684;
  uint32_t x1685;
  fiat_np384_uint1 x1686;
  uint32_t x1687;
  fiat_np384_uint1 x1688;
  uint32_t x1689;
  fiat_np384_uint1 x1690;
  uint32_t x1691;
  fiat_np384_uint1 x1692;
  uint32_t x1693;
  fiat_np384_uint1 x1694;
  uint32_t x1695;
  fiat_np384_uint1 x1696;
  uint32_t x1697;
  fiat_np384_uint1 x1698;
  uint32_t x1699;
  fiat_np384_uint1 x1700;
  uint32_t x1701;
  fiat_np384_uint1 x1702;
  uint32_t x1703;
  fiat_np384_uint1 x1704;
  uint32_t x1705;
  fiat_np384_uint1 x1706;
  uint32_t x1707;
  fiat_np384_uint1 x1708;
  uint32_t x1709;
  fiat_np384_uint1 x1710;
  uint32_t x1711;
  fiat_np384_uint1 x1712;
  uint32_t x1713;
  fiat_np384_uint1 x1714;
  uint32_t x1715;
  fiat_np384_uint1 x1716;
  uint32_t x1717;
  fiat_np384_uint1 x1718;
  uint32_t x1719;
  fiat_np384_uint1 x1720;
  uint32_t x1721;
  fiat_np384_uint1 x1722;
  uint32_t x1723;
  fiat_np384_uint1 x1724;
  uint32_t x1725;
  fiat_np384_uint1 x1726;
  uint32_t x1727;
  fiat_np384_uint1 x1728;
  uint32_t x1729;
  fiat_np384_uint1 x1730;
  uint32_t x1731;
  fiat_np384_uint1 x1732;
  uint32_t x1733;
  fiat_np384_uint1 x1734;
  uint32_t x1735;
  fiat_np384_uint1 x1736;
  uint32_t x1737;
  fiat_np384_uint1 x1738;
  uint32_t x1739;
  fiat_np384_uint1 x1740;
  uint32_t x1741;
  fiat_np384_uint1 x1742;
  uint32_t x1743;
  uint32_t x1744;
  uint32_t x1745;
  uint32_t x1746;
  uint32_t x1747;
  uint32_t x1748;
  uint32_t x1749;
  uint32_t x1750;
  uint32_t x1751;
  uint32_t x1752;
  uint32_t x1753;
  uint32_t x1754;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[7]);
  x8 = (arg1[8]);
  x9 = (arg1[9]);
  x10 = (arg1[10]);
  x11 = (arg1[11]);
  x12 = (arg1[0]);
  fiat_np384_mulx_u32(&x13, &x14, x12, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x15, &x16, x12, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x17, &x18, x12, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x19, &x20, x12, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x21, &x22, x12, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x23, &x24, x12, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x25, &x26, x12, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x27, &x28, x12, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x29, &x30, x12, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x31, &x32, x12, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x33, &x34, x12, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x35, &x36, x12, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  fiat_np384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  fiat_np384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  fiat_np384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  fiat_np384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  fiat_np384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  fiat_np384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  fiat_np384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  fiat_np384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  fiat_np384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  fiat_np384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  fiat_np384_mulx_u32(&x59, &x60, x35, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x61, &x62, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x63, &x64, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x65, &x66, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x67, &x68, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x69, &x70, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x71, &x72, x59, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x73, &x74, x59, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x75, &x76, x59, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x77, &x78, x59, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x79, &x80, x59, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x81, &x82, x59, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x83, &x84, x59, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x85, &x86, 0x0, x84, x81);
  fiat_np384_addcarryx_u32(&x87, &x88, x86, x82, x79);
  fiat_np384_addcarryx_u32(&x89, &x90, x88, x80, x77);
  fiat_np384_addcarryx_u32(&x91, &x92, x90, x78, x75);
  fiat_np384_addcarryx_u32(&x93, &x94, x92, x76, x73);
  fiat_np384_addcarryx_u32(&x95, &x96, x94, x74, x71);
  fiat_np384_addcarryx_u32(&x97, &x98, x96, x72, x69);
  fiat_np384_addcarryx_u32(&x99, &x100, x98, x70, x67);
  fiat_np384_addcarryx_u32(&x101, &x102, x100, x68, x65);
  fiat_np384_addcarryx_u32(&x103, &x104, x102, x66, x63);
  fiat_np384_addcarryx_u32(&x105, &x106, x104, x64, x61);
  fiat_np384_addcarryx_u32(&x107, &x108, 0x0, x35, x83);
  fiat_np384_addcarryx_u32(&x109, &x110, x108, x37, x85);
  fiat_np384_addcarryx_u32(&x111, &x112, x110, x39, x87);
  fiat_np384_addcarryx_u32(&x113, &x114, x112, x41, x89);
  fiat_np384_addcarryx_u32(&x115, &x116, x114, x43, x91);
  fiat_np384_addcarryx_u32(&x117, &x118, x116, x45, x93);
  fiat_np384_addcarryx_u32(&x119, &x120, x118, x47, x95);
  fiat_np384_addcarryx_u32(&x121, &x122, x120, x49, x97);
  fiat_np384_addcarryx_u32(&x123, &x124, x122, x51, x99);
  fiat_np384_addcarryx_u32(&x125, &x126, x124, x53, x101);
  fiat_np384_addcarryx_u32(&x127, &x128, x126, x55, x103);
  fiat_np384_addcarryx_u32(&x129, &x130, x128, x57, x105);
  fiat_np384_addcarryx_u32(&x131, &x132, x130, (x58 + x14), (x106 + x62));
  fiat_np384_mulx_u32(&x133, &x134, x1, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x135, &x136, x1, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x137, &x138, x1, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x139, &x140, x1, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x141, &x142, x1, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x143, &x144, x1, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x145, &x146, x1, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x147, &x148, x1, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x149, &x150, x1, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x151, &x152, x1, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x153, &x154, x1, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x155, &x156, x1, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x157, &x158, 0x0, x156, x153);
  fiat_np384_addcarryx_u32(&x159, &x160, x158, x154, x151);
  fiat_np384_addcarryx_u32(&x161, &x162, x160, x152, x149);
  fiat_np384_addcarryx_u32(&x163, &x164, x162, x150, x147);
  fiat_np384_addcarryx_u32(&x165, &x166, x164, x148, x145);
  fiat_np384_addcarryx_u32(&x167, &x168, x166, x146, x143);
  fiat_np384_addcarryx_u32(&x169, &x170, x168, x144, x141);
  fiat_np384_addcarryx_u32(&x171, &x172, x170, x142, x139);
  fiat_np384_addcarryx_u32(&x173, &x174, x172, x140, x137);
  fiat_np384_addcarryx_u32(&x175, &x176, x174, x138, x135);
  fiat_np384_addcarryx_u32(&x177, &x178, x176, x136, x133);
  fiat_np384_addcarryx_u32(&x179, &x180, 0x0, x109, x155);
  fiat_np384_addcarryx_u32(&x181, &x182, x180, x111, x157);
  fiat_np384_addcarryx_u32(&x183, &x184, x182, x113, x159);
  fiat_np384_addcarryx_u32(&x185, &x186, x184, x115, x161);
  fiat_np384_addcarryx_u32(&x187, &x188, x186, x117, x163);
  fiat_np384_addcarryx_u32(&x189, &x190, x188, x119, x165);
  fiat_np384_addcarryx_u32(&x191, &x192, x190, x121, x167);
  fiat_np384_addcarryx_u32(&x193, &x194, x192, x123, x169);
  fiat_np384_addcarryx_u32(&x195, &x196, x194, x125, x171);
  fiat_np384_addcarryx_u32(&x197, &x198, x196, x127, x173);
  fiat_np384_addcarryx_u32(&x199, &x200, x198, x129, x175);
  fiat_np384_addcarryx_u32(&x201, &x202, x200, x131, x177);
  fiat_np384_mulx_u32(&x203, &x204, x179, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x205, &x206, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x207, &x208, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x209, &x210, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x211, &x212, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x213, &x214, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x215, &x216, x203, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x217, &x218, x203, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x219, &x220, x203, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x221, &x222, x203, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x223, &x224, x203, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x225, &x226, x203, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x227, &x228, x203, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x229, &x230, 0x0, x228, x225);
  fiat_np384_addcarryx_u32(&x231, &x232, x230, x226, x223);
  fiat_np384_addcarryx_u32(&x233, &x234, x232, x224, x221);
  fiat_np384_addcarryx_u32(&x235, &x236, x234, x222, x219);
  fiat_np384_addcarryx_u32(&x237, &x238, x236, x220, x217);
  fiat_np384_addcarryx_u32(&x239, &x240, x238, x218, x215);
  fiat_np384_addcarryx_u32(&x241, &x242, x240, x216, x213);
  fiat_np384_addcarryx_u32(&x243, &x244, x242, x214, x211);
  fiat_np384_addcarryx_u32(&x245, &x246, x244, x212, x209);
  fiat_np384_addcarryx_u32(&x247, &x248, x246, x210, x207);
  fiat_np384_addcarryx_u32(&x249, &x250, x248, x208, x205);
  fiat_np384_addcarryx_u32(&x251, &x252, 0x0, x179, x227);
  fiat_np384_addcarryx_u32(&x253, &x254, x252, x181, x229);
  fiat_np384_addcarryx_u32(&x255, &x256, x254, x183, x231);
  fiat_np384_addcarryx_u32(&x257, &x258, x256, x185, x233);
  fiat_np384_addcarryx_u32(&x259, &x260, x258, x187, x235);
  fiat_np384_addcarryx_u32(&x261, &x262, x260, x189, x237);
  fiat_np384_addcarryx_u32(&x263, &x264, x262, x191, x239);
  fiat_np384_addcarryx_u32(&x265, &x266, x264, x193, x241);
  fiat_np384_addcarryx_u32(&x267, &x268, x266, x195, x243);
  fiat_np384_addcarryx_u32(&x269, &x270, x268, x197, x245);
  fiat_np384_addcarryx_u32(&x271, &x272, x270, x199, x247);
  fiat_np384_addcarryx_u32(&x273, &x274, x272, x201, x249);
  fiat_np384_addcarryx_u32(&x275, &x276, x274, (((uint32_t)x202 + x132) + (x178 + x134)), (x250 + x206));
  fiat_np384_mulx_u32(&x277, &x278, x2, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x279, &x280, x2, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x281, &x282, x2, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x283, &x284, x2, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x285, &x286, x2, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x287, &x288, x2, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x289, &x290, x2, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x291, &x292, x2, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x293, &x294, x2, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x295, &x296, x2, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x297, &x298, x2, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x299, &x300, x2, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x301, &x302, 0x0, x300, x297);
  fiat_np384_addcarryx_u32(&x303, &x304, x302, x298, x295);
  fiat_np384_addcarryx_u32(&x305, &x306, x304, x296, x293);
  fiat_np384_addcarryx_u32(&x307, &x308, x306, x294, x291);
  fiat_np384_addcarryx_u32(&x309, &x310, x308, x292, x289);
  fiat_np384_addcarryx_u32(&x311, &x312, x310, x290, x287);
  fiat_np384_addcarryx_u32(&x313, &x314, x312, x288, x285);
  fiat_np384_addcarryx_u32(&x315, &x316, x314, x286, x283);
  fiat_np384_addcarryx_u32(&x317, &x318, x316, x284, x281);
  fiat_np384_addcarryx_u32(&x319, &x320, x318, x282, x279);
  fiat_np384_addcarryx_u32(&x321, &x322, x320, x280, x277);
  fiat_np384_addcarryx_u32(&x323, &x324, 0x0, x253, x299);
  fiat_np384_addcarryx_u32(&x325, &x326, x324, x255, x301);
  fiat_np384_addcarryx_u32(&x327, &x328, x326, x257, x303);
  fiat_np384_addcarryx_u32(&x329, &x330, x328, x259, x305);
  fiat_np384_addcarryx_u32(&x331, &x332, x330, x261, x307);
  fiat_np384_addcarryx_u32(&x333, &x334, x332, x263, x309);
  fiat_np384_addcarryx_u32(&x335, &x336, x334, x265, x311);
  fiat_np384_addcarryx_u32(&x337, &x338, x336, x267, x313);
  fiat_np384_addcarryx_u32(&x339, &x340, x338, x269, x315);
  fiat_np384_addcarryx_u32(&x341, &x342, x340, x271, x317);
  fiat_np384_addcarryx_u32(&x343, &x344, x342, x273, x319);
  fiat_np384_addcarryx_u32(&x345, &x346, x344, x275, x321);
  fiat_np384_mulx_u32(&x347, &x348, x323, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x349, &x350, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x351, &x352, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x353, &x354, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x355, &x356, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x357, &x358, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x359, &x360, x347, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x361, &x362, x347, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x363, &x364, x347, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x365, &x366, x347, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x367, &x368, x347, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x369, &x370, x347, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x371, &x372, x347, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x373, &x374, 0x0, x372, x369);
  fiat_np384_addcarryx_u32(&x375, &x376, x374, x370, x367);
  fiat_np384_addcarryx_u32(&x377, &x378, x376, x368, x365);
  fiat_np384_addcarryx_u32(&x379, &x380, x378, x366, x363);
  fiat_np384_addcarryx_u32(&x381, &x382, x380, x364, x361);
  fiat_np384_addcarryx_u32(&x383, &x384, x382, x362, x359);
  fiat_np384_addcarryx_u32(&x385, &x386, x384, x360, x357);
  fiat_np384_addcarryx_u32(&x387, &x388, x386, x358, x355);
  fiat_np384_addcarryx_u32(&x389, &x390, x388, x356, x353);
  fiat_np384_addcarryx_u32(&x391, &x392, x390, x354, x351);
  fiat_np384_addcarryx_u32(&x393, &x394, x392, x352, x349);
  fiat_np384_addcarryx_u32(&x395, &x396, 0x0, x323, x371);
  fiat_np384_addcarryx_u32(&x397, &x398, x396, x325, x373);
  fiat_np384_addcarryx_u32(&x399, &x400, x398, x327, x375);
  fiat_np384_addcarryx_u32(&x401, &x402, x400, x329, x377);
  fiat_np384_addcarryx_u32(&x403, &x404, x402, x331, x379);
  fiat_np384_addcarryx_u32(&x405, &x406, x404, x333, x381);
  fiat_np384_addcarryx_u32(&x407, &x408, x406, x335, x383);
  fiat_np384_addcarryx_u32(&x409, &x410, x408, x337, x385);
  fiat_np384_addcarryx_u32(&x411, &x412, x410, x339, x387);
  fiat_np384_addcarryx_u32(&x413, &x414, x412, x341, x389);
  fiat_np384_addcarryx_u32(&x415, &x416, x414, x343, x391);
  fiat_np384_addcarryx_u32(&x417, &x418, x416, x345, x393);
  fiat_np384_addcarryx_u32(&x419, &x420, x418, (((uint32_t)x346 + x276) + (x322 + x278)), (x394 + x350));
  fiat_np384_mulx_u32(&x421, &x422, x3, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x423, &x424, x3, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x425, &x426, x3, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x427, &x428, x3, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x429, &x430, x3, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x431, &x432, x3, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x433, &x434, x3, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x435, &x436, x3, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x437, &x438, x3, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x439, &x440, x3, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x441, &x442, x3, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x443, &x444, x3, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x445, &x446, 0x0, x444, x441);
  fiat_np384_addcarryx_u32(&x447, &x448, x446, x442, x439);
  fiat_np384_addcarryx_u32(&x449, &x450, x448, x440, x437);
  fiat_np384_addcarryx_u32(&x451, &x452, x450, x438, x435);
  fiat_np384_addcarryx_u32(&x453, &x454, x452, x436, x433);
  fiat_np384_addcarryx_u32(&x455, &x456, x454, x434, x431);
  fiat_np384_addcarryx_u32(&x457, &x458, x456, x432, x429);
  fiat_np384_addcarryx_u32(&x459, &x460, x458, x430, x427);
  fiat_np384_addcarryx_u32(&x461, &x462, x460, x428, x425);
  fiat_np384_addcarryx_u32(&x463, &x464, x462, x426, x423);
  fiat_np384_addcarryx_u32(&x465, &x466, x464, x424, x421);
  fiat_np384_addcarryx_u32(&x467, &x468, 0x0, x397, x443);
  fiat_np384_addcarryx_u32(&x469, &x470, x468, x399, x445);
  fiat_np384_addcarryx_u32(&x471, &x472, x470, x401, x447);
  fiat_np384_addcarryx_u32(&x473, &x474, x472, x403, x449);
  fiat_np384_addcarryx_u32(&x475, &x476, x474, x405, x451);
  fiat_np384_addcarryx_u32(&x477, &x478, x476, x407, x453);
  fiat_np384_addcarryx_u32(&x479, &x480, x478, x409, x455);
  fiat_np384_addcarryx_u32(&x481, &x482, x480, x411, x457);
  fiat_np384_addcarryx_u32(&x483, &x484, x482, x413, x459);
  fiat_np384_addcarryx_u32(&x485, &x486, x484, x415, x461);
  fiat_np384_addcarryx_u32(&x487, &x488, x486, x417, x463);
  fiat_np384_addcarryx_u32(&x489, &x490, x488, x419, x465);
  fiat_np384_mulx_u32(&x491, &x492, x467, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x493, &x494, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x495, &x496, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x497, &x498, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x499, &x500, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x501, &x502, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x503, &x504, x491, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x505, &x506, x491, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x507, &x508, x491, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x509, &x510, x491, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x511, &x512, x491, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x513, &x514, x491, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x515, &x516, x491, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x517, &x518, 0x0, x516, x513);
  fiat_np384_addcarryx_u32(&x519, &x520, x518, x514, x511);
  fiat_np384_addcarryx_u32(&x521, &x522, x520, x512, x509);
  fiat_np384_addcarryx_u32(&x523, &x524, x522, x510, x507);
  fiat_np384_addcarryx_u32(&x525, &x526, x524, x508, x505);
  fiat_np384_addcarryx_u32(&x527, &x528, x526, x506, x503);
  fiat_np384_addcarryx_u32(&x529, &x530, x528, x504, x501);
  fiat_np384_addcarryx_u32(&x531, &x532, x530, x502, x499);
  fiat_np384_addcarryx_u32(&x533, &x534, x532, x500, x497);
  fiat_np384_addcarryx_u32(&x535, &x536, x534, x498, x495);
  fiat_np384_addcarryx_u32(&x537, &x538, x536, x496, x493);
  fiat_np384_addcarryx_u32(&x539, &x540, 0x0, x467, x515);
  fiat_np384_addcarryx_u32(&x541, &x542, x540, x469, x517);
  fiat_np384_addcarryx_u32(&x543, &x544, x542, x471, x519);
  fiat_np384_addcarryx_u32(&x545, &x546, x544, x473, x521);
  fiat_np384_addcarryx_u32(&x547, &x548, x546, x475, x523);
  fiat_np384_addcarryx_u32(&x549, &x550, x548, x477, x525);
  fiat_np384_addcarryx_u32(&x551, &x552, x550, x479, x527);
  fiat_np384_addcarryx_u32(&x553, &x554, x552, x481, x529);
  fiat_np384_addcarryx_u32(&x555, &x556, x554, x483, x531);
  fiat_np384_addcarryx_u32(&x557, &x558, x556, x485, x533);
  fiat_np384_addcarryx_u32(&x559, &x560, x558, x487, x535);
  fiat_np384_addcarryx_u32(&x561, &x562, x560, x489, x537);
  fiat_np384_addcarryx_u32(&x563, &x564, x562, (((uint32_t)x490 + x420) + (x466 + x422)), (x538 + x494));
  fiat_np384_mulx_u32(&x565, &x566, x4, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x567, &x568, x4, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x569, &x570, x4, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x571, &x572, x4, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x573, &x574, x4, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x575, &x576, x4, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x577, &x578, x4, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x579, &x580, x4, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x581, &x582, x4, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x583, &x584, x4, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x585, &x586, x4, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x587, &x588, x4, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x589, &x590, 0x0, x588, x585);
  fiat_np384_addcarryx_u32(&x591, &x592, x590, x586, x583);
  fiat_np384_addcarryx_u32(&x593, &x594, x592, x584, x581);
  fiat_np384_addcarryx_u32(&x595, &x596, x594, x582, x579);
  fiat_np384_addcarryx_u32(&x597, &x598, x596, x580, x577);
  fiat_np384_addcarryx_u32(&x599, &x600, x598, x578, x575);
  fiat_np384_addcarryx_u32(&x601, &x602, x600, x576, x573);
  fiat_np384_addcarryx_u32(&x603, &x604, x602, x574, x571);
  fiat_np384_addcarryx_u32(&x605, &x606, x604, x572, x569);
  fiat_np384_addcarryx_u32(&x607, &x608, x606, x570, x567);
  fiat_np384_addcarryx_u32(&x609, &x610, x608, x568, x565);
  fiat_np384_addcarryx_u32(&x611, &x612, 0x0, x541, x587);
  fiat_np384_addcarryx_u32(&x613, &x614, x612, x543, x589);
  fiat_np384_addcarryx_u32(&x615, &x616, x614, x545, x591);
  fiat_np384_addcarryx_u32(&x617, &x618, x616, x547, x593);
  fiat_np384_addcarryx_u32(&x619, &x620, x618, x549, x595);
  fiat_np384_addcarryx_u32(&x621, &x622, x620, x551, x597);
  fiat_np384_addcarryx_u32(&x623, &x624, x622, x553, x599);
  fiat_np384_addcarryx_u32(&x625, &x626, x624, x555, x601);
  fiat_np384_addcarryx_u32(&x627, &x628, x626, x557, x603);
  fiat_np384_addcarryx_u32(&x629, &x630, x628, x559, x605);
  fiat_np384_addcarryx_u32(&x631, &x632, x630, x561, x607);
  fiat_np384_addcarryx_u32(&x633, &x634, x632, x563, x609);
  fiat_np384_mulx_u32(&x635, &x636, x611, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x637, &x638, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x639, &x640, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x641, &x642, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x643, &x644, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x645, &x646, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x647, &x648, x635, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x649, &x650, x635, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x651, &x652, x635, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x653, &x654, x635, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x655, &x656, x635, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x657, &x658, x635, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x659, &x660, x635, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x661, &x662, 0x0, x660, x657);
  fiat_np384_addcarryx_u32(&x663, &x664, x662, x658, x655);
  fiat_np384_addcarryx_u32(&x665, &x666, x664, x656, x653);
  fiat_np384_addcarryx_u32(&x667, &x668, x666, x654, x651);
  fiat_np384_addcarryx_u32(&x669, &x670, x668, x652, x649);
  fiat_np384_addcarryx_u32(&x671, &x672, x670, x650, x647);
  fiat_np384_addcarryx_u32(&x673, &x674, x672, x648, x645);
  fiat_np384_addcarryx_u32(&x675, &x676, x674, x646, x643);
  fiat_np384_addcarryx_u32(&x677, &x678, x676, x644, x641);
  fiat_np384_addcarryx_u32(&x679, &x680, x678, x642, x639);
  fiat_np384_addcarryx_u32(&x681, &x682, x680, x640, x637);
  fiat_np384_addcarryx_u32(&x683, &x684, 0x0, x611, x659);
  fiat_np384_addcarryx_u32(&x685, &x686, x684, x613, x661);
  fiat_np384_addcarryx_u32(&x687, &x688, x686, x615, x663);
  fiat_np384_addcarryx_u32(&x689, &x690, x688, x617, x665);
  fiat_np384_addcarryx_u32(&x691, &x692, x690, x619, x667);
  fiat_np384_addcarryx_u32(&x693, &x694, x692, x621, x669);
  fiat_np384_addcarryx_u32(&x695, &x696, x694, x623, x671);
  fiat_np384_addcarryx_u32(&x697, &x698, x696, x625, x673);
  fiat_np384_addcarryx_u32(&x699, &x700, x698, x627, x675);
  fiat_np384_addcarryx_u32(&x701, &x702, x700, x629, x677);
  fiat_np384_addcarryx_u32(&x703, &x704, x702, x631, x679);
  fiat_np384_addcarryx_u32(&x705, &x706, x704, x633, x681);
  fiat_np384_addcarryx_u32(&x707, &x708, x706, (((uint32_t)x634 + x564) + (x610 + x566)), (x682 + x638));
  fiat_np384_mulx_u32(&x709, &x710, x5, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x711, &x712, x5, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x713, &x714, x5, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x715, &x716, x5, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x717, &x718, x5, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x719, &x720, x5, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x721, &x722, x5, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x723, &x724, x5, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x725, &x726, x5, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x727, &x728, x5, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x729, &x730, x5, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x731, &x732, x5, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x733, &x734, 0x0, x732, x729);
  fiat_np384_addcarryx_u32(&x735, &x736, x734, x730, x727);
  fiat_np384_addcarryx_u32(&x737, &x738, x736, x728, x725);
  fiat_np384_addcarryx_u32(&x739, &x740, x738, x726, x723);
  fiat_np384_addcarryx_u32(&x741, &x742, x740, x724, x721);
  fiat_np384_addcarryx_u32(&x743, &x744, x742, x722, x719);
  fiat_np384_addcarryx_u32(&x745, &x746, x744, x720, x717);
  fiat_np384_addcarryx_u32(&x747, &x748, x746, x718, x715);
  fiat_np384_addcarryx_u32(&x749, &x750, x748, x716, x713);
  fiat_np384_addcarryx_u32(&x751, &x752, x750, x714, x711);
  fiat_np384_addcarryx_u32(&x753, &x754, x752, x712, x709);
  fiat_np384_addcarryx_u32(&x755, &x756, 0x0, x685, x731);
  fiat_np384_addcarryx_u32(&x757, &x758, x756, x687, x733);
  fiat_np384_addcarryx_u32(&x759, &x760, x758, x689, x735);
  fiat_np384_addcarryx_u32(&x761, &x762, x760, x691, x737);
  fiat_np384_addcarryx_u32(&x763, &x764, x762, x693, x739);
  fiat_np384_addcarryx_u32(&x765, &x766, x764, x695, x741);
  fiat_np384_addcarryx_u32(&x767, &x768, x766, x697, x743);
  fiat_np384_addcarryx_u32(&x769, &x770, x768, x699, x745);
  fiat_np384_addcarryx_u32(&x771, &x772, x770, x701, x747);
  fiat_np384_addcarryx_u32(&x773, &x774, x772, x703, x749);
  fiat_np384_addcarryx_u32(&x775, &x776, x774, x705, x751);
  fiat_np384_addcarryx_u32(&x777, &x778, x776, x707, x753);
  fiat_np384_mulx_u32(&x779, &x780, x755, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x781, &x782, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x783, &x784, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x785, &x786, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x787, &x788, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x789, &x790, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x791, &x792, x779, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x793, &x794, x779, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x795, &x796, x779, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x797, &x798, x779, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x799, &x800, x779, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x801, &x802, x779, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x803, &x804, x779, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x805, &x806, 0x0, x804, x801);
  fiat_np384_addcarryx_u32(&x807, &x808, x806, x802, x799);
  fiat_np384_addcarryx_u32(&x809, &x810, x808, x800, x797);
  fiat_np384_addcarryx_u32(&x811, &x812, x810, x798, x795);
  fiat_np384_addcarryx_u32(&x813, &x814, x812, x796, x793);
  fiat_np384_addcarryx_u32(&x815, &x816, x814, x794, x791);
  fiat_np384_addcarryx_u32(&x817, &x818, x816, x792, x789);
  fiat_np384_addcarryx_u32(&x819, &x820, x818, x790, x787);
  fiat_np384_addcarryx_u32(&x821, &x822, x820, x788, x785);
  fiat_np384_addcarryx_u32(&x823, &x824, x822, x786, x783);
  fiat_np384_addcarryx_u32(&x825, &x826, x824, x784, x781);
  fiat_np384_addcarryx_u32(&x827, &x828, 0x0, x755, x803);
  fiat_np384_addcarryx_u32(&x829, &x830, x828, x757, x805);
  fiat_np384_addcarryx_u32(&x831, &x832, x830, x759, x807);
  fiat_np384_addcarryx_u32(&x833, &x834, x832, x761, x809);
  fiat_np384_addcarryx_u32(&x835, &x836, x834, x763, x811);
  fiat_np384_addcarryx_u32(&x837, &x838, x836, x765, x813);
  fiat_np384_addcarryx_u32(&x839, &x840, x838, x767, x815);
  fiat_np384_addcarryx_u32(&x841, &x842, x840, x769, x817);
  fiat_np384_addcarryx_u32(&x843, &x844, x842, x771, x819);
  fiat_np384_addcarryx_u32(&x845, &x846, x844, x773, x821);
  fiat_np384_addcarryx_u32(&x847, &x848, x846, x775, x823);
  fiat_np384_addcarryx_u32(&x849, &x850, x848, x777, x825);
  fiat_np384_addcarryx_u32(&x851, &x852, x850, (((uint32_t)x778 + x708) + (x754 + x710)), (x826 + x782));
  fiat_np384_mulx_u32(&x853, &x854, x6, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x855, &x856, x6, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x857, &x858, x6, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x859, &x860, x6, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x861, &x862, x6, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x863, &x864, x6, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x865, &x866, x6, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x867, &x868, x6, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x869, &x870, x6, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x871, &x872, x6, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x873, &x874, x6, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x875, &x876, x6, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x877, &x878, 0x0, x876, x873);
  fiat_np384_addcarryx_u32(&x879, &x880, x878, x874, x871);
  fiat_np384_addcarryx_u32(&x881, &x882, x880, x872, x869);
  fiat_np384_addcarryx_u32(&x883, &x884, x882, x870, x867);
  fiat_np384_addcarryx_u32(&x885, &x886, x884, x868, x865);
  fiat_np384_addcarryx_u32(&x887, &x888, x886, x866, x863);
  fiat_np384_addcarryx_u32(&x889, &x890, x888, x864, x861);
  fiat_np384_addcarryx_u32(&x891, &x892, x890, x862, x859);
  fiat_np384_addcarryx_u32(&x893, &x894, x892, x860, x857);
  fiat_np384_addcarryx_u32(&x895, &x896, x894, x858, x855);
  fiat_np384_addcarryx_u32(&x897, &x898, x896, x856, x853);
  fiat_np384_addcarryx_u32(&x899, &x900, 0x0, x829, x875);
  fiat_np384_addcarryx_u32(&x901, &x902, x900, x831, x877);
  fiat_np384_addcarryx_u32(&x903, &x904, x902, x833, x879);
  fiat_np384_addcarryx_u32(&x905, &x906, x904, x835, x881);
  fiat_np384_addcarryx_u32(&x907, &x908, x906, x837, x883);
  fiat_np384_addcarryx_u32(&x909, &x910, x908, x839, x885);
  fiat_np384_addcarryx_u32(&x911, &x912, x910, x841, x887);
  fiat_np384_addcarryx_u32(&x913, &x914, x912, x843, x889);
  fiat_np384_addcarryx_u32(&x915, &x916, x914, x845, x891);
  fiat_np384_addcarryx_u32(&x917, &x918, x916, x847, x893);
  fiat_np384_addcarryx_u32(&x919, &x920, x918, x849, x895);
  fiat_np384_addcarryx_u32(&x921, &x922, x920, x851, x897);
  fiat_np384_mulx_u32(&x923, &x924, x899, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x925, &x926, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x927, &x928, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x929, &x930, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x931, &x932, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x933, &x934, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x935, &x936, x923, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x937, &x938, x923, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x939, &x940, x923, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x941, &x942, x923, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x943, &x944, x923, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x945, &x946, x923, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x947, &x948, x923, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x949, &x950, 0x0, x948, x945);
  fiat_np384_addcarryx_u32(&x951, &x952, x950, x946, x943);
  fiat_np384_addcarryx_u32(&x953, &x954, x952, x944, x941);
  fiat_np384_addcarryx_u32(&x955, &x956, x954, x942, x939);
  fiat_np384_addcarryx_u32(&x957, &x958, x956, x940, x937);
  fiat_np384_addcarryx_u32(&x959, &x960, x958, x938, x935);
  fiat_np384_addcarryx_u32(&x961, &x962, x960, x936, x933);
  fiat_np384_addcarryx_u32(&x963, &x964, x962, x934, x931);
  fiat_np384_addcarryx_u32(&x965, &x966, x964, x932, x929);
  fiat_np384_addcarryx_u32(&x967, &x968, x966, x930, x927);
  fiat_np384_addcarryx_u32(&x969, &x970, x968, x928, x925);
  fiat_np384_addcarryx_u32(&x971, &x972, 0x0, x899, x947);
  fiat_np384_addcarryx_u32(&x973, &x974, x972, x901, x949);
  fiat_np384_addcarryx_u32(&x975, &x976, x974, x903, x951);
  fiat_np384_addcarryx_u32(&x977, &x978, x976, x905, x953);
  fiat_np384_addcarryx_u32(&x979, &x980, x978, x907, x955);
  fiat_np384_addcarryx_u32(&x981, &x982, x980, x909, x957);
  fiat_np384_addcarryx_u32(&x983, &x984, x982, x911, x959);
  fiat_np384_addcarryx_u32(&x985, &x986, x984, x913, x961);
  fiat_np384_addcarryx_u32(&x987, &x988, x986, x915, x963);
  fiat_np384_addcarryx_u32(&x989, &x990, x988, x917, x965);
  fiat_np384_addcarryx_u32(&x991, &x992, x990, x919, x967);
  fiat_np384_addcarryx_u32(&x993, &x994, x992, x921, x969);
  fiat_np384_addcarryx_u32(&x995, &x996, x994, (((uint32_t)x922 + x852) + (x898 + x854)), (x970 + x926));
  fiat_np384_mulx_u32(&x997, &x998, x7, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x999, &x1000, x7, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x1001, &x1002, x7, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x1003, &x1004, x7, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x1005, &x1006, x7, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x1007, &x1008, x7, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x1009, &x1010, x7, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x1011, &x1012, x7, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x1013, &x1014, x7, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x1015, &x1016, x7, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x1017, &x1018, x7, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x1019, &x1020, x7, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x1021, &x1022, 0x0, x1020, x1017);
  fiat_np384_addcarryx_u32(&x1023, &x1024, x1022, x1018, x1015);
  fiat_np384_addcarryx_u32(&x1025, &x1026, x1024, x1016, x1013);
  fiat_np384_addcarryx_u32(&x1027, &x1028, x1026, x1014, x1011);
  fiat_np384_addcarryx_u32(&x1029, &x1030, x1028, x1012, x1009);
  fiat_np384_addcarryx_u32(&x1031, &x1032, x1030, x1010, x1007);
  fiat_np384_addcarryx_u32(&x1033, &x1034, x1032, x1008, x1005);
  fiat_np384_addcarryx_u32(&x1035, &x1036, x1034, x1006, x1003);
  fiat_np384_addcarryx_u32(&x1037, &x1038, x1036, x1004, x1001);
  fiat_np384_addcarryx_u32(&x1039, &x1040, x1038, x1002, x999);
  fiat_np384_addcarryx_u32(&x1041, &x1042, x1040, x1000, x997);
  fiat_np384_addcarryx_u32(&x1043, &x1044, 0x0, x973, x1019);
  fiat_np384_addcarryx_u32(&x1045, &x1046, x1044, x975, x1021);
  fiat_np384_addcarryx_u32(&x1047, &x1048, x1046, x977, x1023);
  fiat_np384_addcarryx_u32(&x1049, &x1050, x1048, x979, x1025);
  fiat_np384_addcarryx_u32(&x1051, &x1052, x1050, x981, x1027);
  fiat_np384_addcarryx_u32(&x1053, &x1054, x1052, x983, x1029);
  fiat_np384_addcarryx_u32(&x1055, &x1056, x1054, x985, x1031);
  fiat_np384_addcarryx_u32(&x1057, &x1058, x1056, x987, x1033);
  fiat_np384_addcarryx_u32(&x1059, &x1060, x1058, x989, x1035);
  fiat_np384_addcarryx_u32(&x1061, &x1062, x1060, x991, x1037);
  fiat_np384_addcarryx_u32(&x1063, &x1064, x1062, x993, x1039);
  fiat_np384_addcarryx_u32(&x1065, &x1066, x1064, x995, x1041);
  fiat_np384_mulx_u32(&x1067, &x1068, x1043, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1069, &x1070, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1071, &x1072, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1073, &x1074, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1075, &x1076, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1077, &x1078, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1079, &x1080, x1067, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1081, &x1082, x1067, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1083, &x1084, x1067, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1085, &x1086, x1067, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1087, &x1088, x1067, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1089, &x1090, x1067, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1091, &x1092, x1067, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1093, &x1094, 0x0, x1092, x1089);
  fiat_np384_addcarryx_u32(&x1095, &x1096, x1094, x1090, x1087);
  fiat_np384_addcarryx_u32(&x1097, &x1098, x1096, x1088, x1085);
  fiat_np384_addcarryx_u32(&x1099, &x1100, x1098, x1086, x1083);
  fiat_np384_addcarryx_u32(&x1101, &x1102, x1100, x1084, x1081);
  fiat_np384_addcarryx_u32(&x1103, &x1104, x1102, x1082, x1079);
  fiat_np384_addcarryx_u32(&x1105, &x1106, x1104, x1080, x1077);
  fiat_np384_addcarryx_u32(&x1107, &x1108, x1106, x1078, x1075);
  fiat_np384_addcarryx_u32(&x1109, &x1110, x1108, x1076, x1073);
  fiat_np384_addcarryx_u32(&x1111, &x1112, x1110, x1074, x1071);
  fiat_np384_addcarryx_u32(&x1113, &x1114, x1112, x1072, x1069);
  fiat_np384_addcarryx_u32(&x1115, &x1116, 0x0, x1043, x1091);
  fiat_np384_addcarryx_u32(&x1117, &x1118, x1116, x1045, x1093);
  fiat_np384_addcarryx_u32(&x1119, &x1120, x1118, x1047, x1095);
  fiat_np384_addcarryx_u32(&x1121, &x1122, x1120, x1049, x1097);
  fiat_np384_addcarryx_u32(&x1123, &x1124, x1122, x1051, x1099);
  fiat_np384_addcarryx_u32(&x1125, &x1126, x1124, x1053, x1101);
  fiat_np384_addcarryx_u32(&x1127, &x1128, x1126, x1055, x1103);
  fiat_np384_addcarryx_u32(&x1129, &x1130, x1128, x1057, x1105);
  fiat_np384_addcarryx_u32(&x1131, &x1132, x1130, x1059, x1107);
  fiat_np384_addcarryx_u32(&x1133, &x1134, x1132, x1061, x1109);
  fiat_np384_addcarryx_u32(&x1135, &x1136, x1134, x1063, x1111);
  fiat_np384_addcarryx_u32(&x1137, &x1138, x1136, x1065, x1113);
  fiat_np384_addcarryx_u32(&x1139, &x1140, x1138, (((uint32_t)x1066 + x996) + (x1042 + x998)), (x1114 + x1070));
  fiat_np384_mulx_u32(&x1141, &x1142, x8, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x1143, &x1144, x8, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x1145, &x1146, x8, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x1147, &x1148, x8, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x1149, &x1150, x8, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x1151, &x1152, x8, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x1153, &x1154, x8, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x1155, &x1156, x8, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x1157, &x1158, x8, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x1159, &x1160, x8, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x1161, &x1162, x8, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x1163, &x1164, x8, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x1165, &x1166, 0x0, x1164, x1161);
  fiat_np384_addcarryx_u32(&x1167, &x1168, x1166, x1162, x1159);
  fiat_np384_addcarryx_u32(&x1169, &x1170, x1168, x1160, x1157);
  fiat_np384_addcarryx_u32(&x1171, &x1172, x1170, x1158, x1155);
  fiat_np384_addcarryx_u32(&x1173, &x1174, x1172, x1156, x1153);
  fiat_np384_addcarryx_u32(&x1175, &x1176, x1174, x1154, x1151);
  fiat_np384_addcarryx_u32(&x1177, &x1178, x1176, x1152, x1149);
  fiat_np384_addcarryx_u32(&x1179, &x1180, x1178, x1150, x1147);
  fiat_np384_addcarryx_u32(&x1181, &x1182, x1180, x1148, x1145);
  fiat_np384_addcarryx_u32(&x1183, &x1184, x1182, x1146, x1143);
  fiat_np384_addcarryx_u32(&x1185, &x1186, x1184, x1144, x1141);
  fiat_np384_addcarryx_u32(&x1187, &x1188, 0x0, x1117, x1163);
  fiat_np384_addcarryx_u32(&x1189, &x1190, x1188, x1119, x1165);
  fiat_np384_addcarryx_u32(&x1191, &x1192, x1190, x1121, x1167);
  fiat_np384_addcarryx_u32(&x1193, &x1194, x1192, x1123, x1169);
  fiat_np384_addcarryx_u32(&x1195, &x1196, x1194, x1125, x1171);
  fiat_np384_addcarryx_u32(&x1197, &x1198, x1196, x1127, x1173);
  fiat_np384_addcarryx_u32(&x1199, &x1200, x1198, x1129, x1175);
  fiat_np384_addcarryx_u32(&x1201, &x1202, x1200, x1131, x1177);
  fiat_np384_addcarryx_u32(&x1203, &x1204, x1202, x1133, x1179);
  fiat_np384_addcarryx_u32(&x1205, &x1206, x1204, x1135, x1181);
  fiat_np384_addcarryx_u32(&x1207, &x1208, x1206, x1137, x1183);
  fiat_np384_addcarryx_u32(&x1209, &x1210, x1208, x1139, x1185);
  fiat_np384_mulx_u32(&x1211, &x1212, x1187, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1213, &x1214, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1215, &x1216, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1217, &x1218, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1219, &x1220, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1221, &x1222, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1223, &x1224, x1211, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1225, &x1226, x1211, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1227, &x1228, x1211, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1229, &x1230, x1211, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1231, &x1232, x1211, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1233, &x1234, x1211, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1235, &x1236, x1211, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1237, &x1238, 0x0, x1236, x1233);
  fiat_np384_addcarryx_u32(&x1239, &x1240, x1238, x1234, x1231);
  fiat_np384_addcarryx_u32(&x1241, &x1242, x1240, x1232, x1229);
  fiat_np384_addcarryx_u32(&x1243, &x1244, x1242, x1230, x1227);
  fiat_np384_addcarryx_u32(&x1245, &x1246, x1244, x1228, x1225);
  fiat_np384_addcarryx_u32(&x1247, &x1248, x1246, x1226, x1223);
  fiat_np384_addcarryx_u32(&x1249, &x1250, x1248, x1224, x1221);
  fiat_np384_addcarryx_u32(&x1251, &x1252, x1250, x1222, x1219);
  fiat_np384_addcarryx_u32(&x1253, &x1254, x1252, x1220, x1217);
  fiat_np384_addcarryx_u32(&x1255, &x1256, x1254, x1218, x1215);
  fiat_np384_addcarryx_u32(&x1257, &x1258, x1256, x1216, x1213);
  fiat_np384_addcarryx_u32(&x1259, &x1260, 0x0, x1187, x1235);
  fiat_np384_addcarryx_u32(&x1261, &x1262, x1260, x1189, x1237);
  fiat_np384_addcarryx_u32(&x1263, &x1264, x1262, x1191, x1239);
  fiat_np384_addcarryx_u32(&x1265, &x1266, x1264, x1193, x1241);
  fiat_np384_addcarryx_u32(&x1267, &x1268, x1266, x1195, x1243);
  fiat_np384_addcarryx_u32(&x1269, &x1270, x1268, x1197, x1245);
  fiat_np384_addcarryx_u32(&x1271, &x1272, x1270, x1199, x1247);
  fiat_np384_addcarryx_u32(&x1273, &x1274, x1272, x1201, x1249);
  fiat_np384_addcarryx_u32(&x1275, &x1276, x1274, x1203, x1251);
  fiat_np384_addcarryx_u32(&x1277, &x1278, x1276, x1205, x1253);
  fiat_np384_addcarryx_u32(&x1279, &x1280, x1278, x1207, x1255);
  fiat_np384_addcarryx_u32(&x1281, &x1282, x1280, x1209, x1257);
  fiat_np384_addcarryx_u32(&x1283, &x1284, x1282, (((uint32_t)x1210 + x1140) + (x1186 + x1142)), (x1258 + x1214));
  fiat_np384_mulx_u32(&x1285, &x1286, x9, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x1287, &x1288, x9, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x1289, &x1290, x9, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x1291, &x1292, x9, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x1293, &x1294, x9, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x1295, &x1296, x9, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x1297, &x1298, x9, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x1299, &x1300, x9, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x1301, &x1302, x9, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x1303, &x1304, x9, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x1305, &x1306, x9, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x1307, &x1308, x9, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x1309, &x1310, 0x0, x1308, x1305);
  fiat_np384_addcarryx_u32(&x1311, &x1312, x1310, x1306, x1303);
  fiat_np384_addcarryx_u32(&x1313, &x1314, x1312, x1304, x1301);
  fiat_np384_addcarryx_u32(&x1315, &x1316, x1314, x1302, x1299);
  fiat_np384_addcarryx_u32(&x1317, &x1318, x1316, x1300, x1297);
  fiat_np384_addcarryx_u32(&x1319, &x1320, x1318, x1298, x1295);
  fiat_np384_addcarryx_u32(&x1321, &x1322, x1320, x1296, x1293);
  fiat_np384_addcarryx_u32(&x1323, &x1324, x1322, x1294, x1291);
  fiat_np384_addcarryx_u32(&x1325, &x1326, x1324, x1292, x1289);
  fiat_np384_addcarryx_u32(&x1327, &x1328, x1326, x1290, x1287);
  fiat_np384_addcarryx_u32(&x1329, &x1330, x1328, x1288, x1285);
  fiat_np384_addcarryx_u32(&x1331, &x1332, 0x0, x1261, x1307);
  fiat_np384_addcarryx_u32(&x1333, &x1334, x1332, x1263, x1309);
  fiat_np384_addcarryx_u32(&x1335, &x1336, x1334, x1265, x1311);
  fiat_np384_addcarryx_u32(&x1337, &x1338, x1336, x1267, x1313);
  fiat_np384_addcarryx_u32(&x1339, &x1340, x1338, x1269, x1315);
  fiat_np384_addcarryx_u32(&x1341, &x1342, x1340, x1271, x1317);
  fiat_np384_addcarryx_u32(&x1343, &x1344, x1342, x1273, x1319);
  fiat_np384_addcarryx_u32(&x1345, &x1346, x1344, x1275, x1321);
  fiat_np384_addcarryx_u32(&x1347, &x1348, x1346, x1277, x1323);
  fiat_np384_addcarryx_u32(&x1349, &x1350, x1348, x1279, x1325);
  fiat_np384_addcarryx_u32(&x1351, &x1352, x1350, x1281, x1327);
  fiat_np384_addcarryx_u32(&x1353, &x1354, x1352, x1283, x1329);
  fiat_np384_mulx_u32(&x1355, &x1356, x1331, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1357, &x1358, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1359, &x1360, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1361, &x1362, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1363, &x1364, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1365, &x1366, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1367, &x1368, x1355, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1369, &x1370, x1355, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1371, &x1372, x1355, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1373, &x1374, x1355, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1375, &x1376, x1355, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1377, &x1378, x1355, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1379, &x1380, x1355, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1381, &x1382, 0x0, x1380, x1377);
  fiat_np384_addcarryx_u32(&x1383, &x1384, x1382, x1378, x1375);
  fiat_np384_addcarryx_u32(&x1385, &x1386, x1384, x1376, x1373);
  fiat_np384_addcarryx_u32(&x1387, &x1388, x1386, x1374, x1371);
  fiat_np384_addcarryx_u32(&x1389, &x1390, x1388, x1372, x1369);
  fiat_np384_addcarryx_u32(&x1391, &x1392, x1390, x1370, x1367);
  fiat_np384_addcarryx_u32(&x1393, &x1394, x1392, x1368, x1365);
  fiat_np384_addcarryx_u32(&x1395, &x1396, x1394, x1366, x1363);
  fiat_np384_addcarryx_u32(&x1397, &x1398, x1396, x1364, x1361);
  fiat_np384_addcarryx_u32(&x1399, &x1400, x1398, x1362, x1359);
  fiat_np384_addcarryx_u32(&x1401, &x1402, x1400, x1360, x1357);
  fiat_np384_addcarryx_u32(&x1403, &x1404, 0x0, x1331, x1379);
  fiat_np384_addcarryx_u32(&x1405, &x1406, x1404, x1333, x1381);
  fiat_np384_addcarryx_u32(&x1407, &x1408, x1406, x1335, x1383);
  fiat_np384_addcarryx_u32(&x1409, &x1410, x1408, x1337, x1385);
  fiat_np384_addcarryx_u32(&x1411, &x1412, x1410, x1339, x1387);
  fiat_np384_addcarryx_u32(&x1413, &x1414, x1412, x1341, x1389);
  fiat_np384_addcarryx_u32(&x1415, &x1416, x1414, x1343, x1391);
  fiat_np384_addcarryx_u32(&x1417, &x1418, x1416, x1345, x1393);
  fiat_np384_addcarryx_u32(&x1419, &x1420, x1418, x1347, x1395);
  fiat_np384_addcarryx_u32(&x1421, &x1422, x1420, x1349, x1397);
  fiat_np384_addcarryx_u32(&x1423, &x1424, x1422, x1351, x1399);
  fiat_np384_addcarryx_u32(&x1425, &x1426, x1424, x1353, x1401);
  fiat_np384_addcarryx_u32(&x1427, &x1428, x1426, (((uint32_t)x1354 + x1284) + (x1330 + x1286)), (x1402 + x1358));
  fiat_np384_mulx_u32(&x1429, &x1430, x10, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x1431, &x1432, x10, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x1433, &x1434, x10, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x1435, &x1436, x10, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x1437, &x1438, x10, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x1439, &x1440, x10, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x1441, &x1442, x10, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x1443, &x1444, x10, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x1445, &x1446, x10, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x1447, &x1448, x10, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x1449, &x1450, x10, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x1451, &x1452, x10, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x1453, &x1454, 0x0, x1452, x1449);
  fiat_np384_addcarryx_u32(&x1455, &x1456, x1454, x1450, x1447);
  fiat_np384_addcarryx_u32(&x1457, &x1458, x1456, x1448, x1445);
  fiat_np384_addcarryx_u32(&x1459, &x1460, x1458, x1446, x1443);
  fiat_np384_addcarryx_u32(&x1461, &x1462, x1460, x1444, x1441);
  fiat_np384_addcarryx_u32(&x1463, &x1464, x1462, x1442, x1439);
  fiat_np384_addcarryx_u32(&x1465, &x1466, x1464, x1440, x1437);
  fiat_np384_addcarryx_u32(&x1467, &x1468, x1466, x1438, x1435);
  fiat_np384_addcarryx_u32(&x1469, &x1470, x1468, x1436, x1433);
  fiat_np384_addcarryx_u32(&x1471, &x1472, x1470, x1434, x1431);
  fiat_np384_addcarryx_u32(&x1473, &x1474, x1472, x1432, x1429);
  fiat_np384_addcarryx_u32(&x1475, &x1476, 0x0, x1405, x1451);
  fiat_np384_addcarryx_u32(&x1477, &x1478, x1476, x1407, x1453);
  fiat_np384_addcarryx_u32(&x1479, &x1480, x1478, x1409, x1455);
  fiat_np384_addcarryx_u32(&x1481, &x1482, x1480, x1411, x1457);
  fiat_np384_addcarryx_u32(&x1483, &x1484, x1482, x1413, x1459);
  fiat_np384_addcarryx_u32(&x1485, &x1486, x1484, x1415, x1461);
  fiat_np384_addcarryx_u32(&x1487, &x1488, x1486, x1417, x1463);
  fiat_np384_addcarryx_u32(&x1489, &x1490, x1488, x1419, x1465);
  fiat_np384_addcarryx_u32(&x1491, &x1492, x1490, x1421, x1467);
  fiat_np384_addcarryx_u32(&x1493, &x1494, x1492, x1423, x1469);
  fiat_np384_addcarryx_u32(&x1495, &x1496, x1494, x1425, x1471);
  fiat_np384_addcarryx_u32(&x1497, &x1498, x1496, x1427, x1473);
  fiat_np384_mulx_u32(&x1499, &x1500, x1475, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1501, &x1502, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1503, &x1504, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1505, &x1506, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1507, &x1508, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1509, &x1510, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1511, &x1512, x1499, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1513, &x1514, x1499, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1515, &x1516, x1499, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1517, &x1518, x1499, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1519, &x1520, x1499, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1521, &x1522, x1499, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1523, &x1524, x1499, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1525, &x1526, 0x0, x1524, x1521);
  fiat_np384_addcarryx_u32(&x1527, &x1528, x1526, x1522, x1519);
  fiat_np384_addcarryx_u32(&x1529, &x1530, x1528, x1520, x1517);
  fiat_np384_addcarryx_u32(&x1531, &x1532, x1530, x1518, x1515);
  fiat_np384_addcarryx_u32(&x1533, &x1534, x1532, x1516, x1513);
  fiat_np384_addcarryx_u32(&x1535, &x1536, x1534, x1514, x1511);
  fiat_np384_addcarryx_u32(&x1537, &x1538, x1536, x1512, x1509);
  fiat_np384_addcarryx_u32(&x1539, &x1540, x1538, x1510, x1507);
  fiat_np384_addcarryx_u32(&x1541, &x1542, x1540, x1508, x1505);
  fiat_np384_addcarryx_u32(&x1543, &x1544, x1542, x1506, x1503);
  fiat_np384_addcarryx_u32(&x1545, &x1546, x1544, x1504, x1501);
  fiat_np384_addcarryx_u32(&x1547, &x1548, 0x0, x1475, x1523);
  fiat_np384_addcarryx_u32(&x1549, &x1550, x1548, x1477, x1525);
  fiat_np384_addcarryx_u32(&x1551, &x1552, x1550, x1479, x1527);
  fiat_np384_addcarryx_u32(&x1553, &x1554, x1552, x1481, x1529);
  fiat_np384_addcarryx_u32(&x1555, &x1556, x1554, x1483, x1531);
  fiat_np384_addcarryx_u32(&x1557, &x1558, x1556, x1485, x1533);
  fiat_np384_addcarryx_u32(&x1559, &x1560, x1558, x1487, x1535);
  fiat_np384_addcarryx_u32(&x1561, &x1562, x1560, x1489, x1537);
  fiat_np384_addcarryx_u32(&x1563, &x1564, x1562, x1491, x1539);
  fiat_np384_addcarryx_u32(&x1565, &x1566, x1564, x1493, x1541);
  fiat_np384_addcarryx_u32(&x1567, &x1568, x1566, x1495, x1543);
  fiat_np384_addcarryx_u32(&x1569, &x1570, x1568, x1497, x1545);
  fiat_np384_addcarryx_u32(&x1571, &x1572, x1570, (((uint32_t)x1498 + x1428) + (x1474 + x1430)), (x1546 + x1502));
  fiat_np384_mulx_u32(&x1573, &x1574, x11, UINT32_C(0xc84ee01));
  fiat_np384_mulx_u32(&x1575, &x1576, x11, UINT32_C(0x2b39bf21));
  fiat_np384_mulx_u32(&x1577, &x1578, x11, UINT32_C(0x3fb05b7a));
  fiat_np384_mulx_u32(&x1579, &x1580, x11, UINT32_C(0x28266895));
  fiat_np384_mulx_u32(&x1581, &x1582, x11, UINT32_C(0xd40d4917));
  fiat_np384_mulx_u32(&x1583, &x1584, x11, UINT32_C(0x4aab1cc5));
  fiat_np384_mulx_u32(&x1585, &x1586, x11, UINT32_C(0xbc3e483a));
  fiat_np384_mulx_u32(&x1587, &x1588, x11, UINT32_C(0xfcb82947));
  fiat_np384_mulx_u32(&x1589, &x1590, x11, UINT32_C(0xff3d81e5));
  fiat_np384_mulx_u32(&x1591, &x1592, x11, UINT32_C(0xdf1aa419));
  fiat_np384_mulx_u32(&x1593, &x1594, x11, UINT32_C(0x2d319b24));
  fiat_np384_mulx_u32(&x1595, &x1596, x11, UINT32_C(0x19b409a9));
  fiat_np384_addcarryx_u32(&x1597, &x1598, 0x0, x1596, x1593);
  fiat_np384_addcarryx_u32(&x1599, &x1600, x1598, x1594, x1591);
  fiat_np384_addcarryx_u32(&x1601, &x1602, x1600, x1592, x1589);
  fiat_np384_addcarryx_u32(&x1603, &x1604, x1602, x1590, x1587);
  fiat_np384_addcarryx_u32(&x1605, &x1606, x1604, x1588, x1585);
  fiat_np384_addcarryx_u32(&x1607, &x1608, x1606, x1586, x1583);
  fiat_np384_addcarryx_u32(&x1609, &x1610, x1608, x1584, x1581);
  fiat_np384_addcarryx_u32(&x1611, &x1612, x1610, x1582, x1579);
  fiat_np384_addcarryx_u32(&x1613, &x1614, x1612, x1580, x1577);
  fiat_np384_addcarryx_u32(&x1615, &x1616, x1614, x1578, x1575);
  fiat_np384_addcarryx_u32(&x1617, &x1618, x1616, x1576, x1573);
  fiat_np384_addcarryx_u32(&x1619, &x1620, 0x0, x1549, x1595);
  fiat_np384_addcarryx_u32(&x1621, &x1622, x1620, x1551, x1597);
  fiat_np384_addcarryx_u32(&x1623, &x1624, x1622, x1553, x1599);
  fiat_np384_addcarryx_u32(&x1625, &x1626, x1624, x1555, x1601);
  fiat_np384_addcarryx_u32(&x1627, &x1628, x1626, x1557, x1603);
  fiat_np384_addcarryx_u32(&x1629, &x1630, x1628, x1559, x1605);
  fiat_np384_addcarryx_u32(&x1631, &x1632, x1630, x1561, x1607);
  fiat_np384_addcarryx_u32(&x1633, &x1634, x1632, x1563, x1609);
  fiat_np384_addcarryx_u32(&x1635, &x1636, x1634, x1565, x1611);
  fiat_np384_addcarryx_u32(&x1637, &x1638, x1636, x1567, x1613);
  fiat_np384_addcarryx_u32(&x1639, &x1640, x1638, x1569, x1615);
  fiat_np384_addcarryx_u32(&x1641, &x1642, x1640, x1571, x1617);
  fiat_np384_mulx_u32(&x1643, &x1644, x1619, UINT32_C(0xe88fdc45));
  fiat_np384_mulx_u32(&x1645, &x1646, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1647, &x1648, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1649, &x1650, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1651, &x1652, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1653, &x1654, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1655, &x1656, x1643, UINT32_C(0xffffffff));
  fiat_np384_mulx_u32(&x1657, &x1658, x1643, UINT32_C(0xc7634d81));
  fiat_np384_mulx_u32(&x1659, &x1660, x1643, UINT32_C(0xf4372ddf));
  fiat_np384_mulx_u32(&x1661, &x1662, x1643, UINT32_C(0x581a0db2));
  fiat_np384_mulx_u32(&x1663, &x1664, x1643, UINT32_C(0x48b0a77a));
  fiat_np384_mulx_u32(&x1665, &x1666, x1643, UINT32_C(0xecec196a));
  fiat_np384_mulx_u32(&x1667, &x1668, x1643, UINT32_C(0xccc52973));
  fiat_np384_addcarryx_u32(&x1669, &x1670, 0x0, x1668, x1665);
  fiat_np384_addcarryx_u32(&x1671, &x1672, x1670, x1666, x1663);
  fiat_np384_addcarryx_u32(&x1673, &x1674, x1672, x1664, x1661);
  fiat_np384_addcarryx_u32(&x1675, &x1676, x1674, x1662, x1659);
  fiat_np384_addcarryx_u32(&x1677, &x1678, x1676, x1660, x1657);
  fiat_np384_addcarryx_u32(&x1679, &x1680, x1678, x1658, x1655);
  fiat_np384_addcarryx_u32(&x1681, &x1682, x1680, x1656, x1653);
  fiat_np384_addcarryx_u32(&x1683, &x1684, x1682, x1654, x1651);
  fiat_np384_addcarryx_u32(&x1685, &x1686, x1684, x1652, x1649);
  fiat_np384_addcarryx_u32(&x1687, &x1688, x1686, x1650, x1647);
  fiat_np384_addcarryx_u32(&x1689, &x1690, x1688, x1648, x1645);
  fiat_np384_addcarryx_u32(&x1691, &x1692, 0x0, x1619, x1667);
  fiat_np384_addcarryx_u32(&x1693, &x1694, x1692, x1621, x1669);
  fiat_np384_addcarryx_u32(&x1695, &x1696, x1694, x1623, x1671);
  fiat_np384_addcarryx_u32(&x1697, &x1698, x1696, x1625, x1673);
  fiat_np384_addcarryx_u32(&x1699, &x1700, x1698, x1627, x1675);
  fiat_np384_addcarryx_u32(&x1701, &x1702, x1700, x1629, x1677);
  fiat_np384_addcarryx_u32(&x1703, &x1704, x1702, x1631, x1679);
  fiat_np384_addcarryx_u32(&x1705, &x1706, x1704, x1633, x1681);
  fiat_np384_addcarryx_u32(&x1707, &x1708, x1706, x1635, x1683);
  fiat_np384_addcarryx_u32(&x1709, &x1710, x1708, x1637, x1685);
  fiat_np384_addcarryx_u32(&x1711, &x1712, x1710, x1639, x1687);
  fiat_np384_addcarryx_u32(&x1713, &x1714, x1712, x1641, x1689);
  fiat_np384_addcarryx_u32(&x1715, &x1716, x1714, (((uint32_t)x1642 + x1572) + (x1618 + x1574)), (x1690 + x1646));
  fiat_np384_subborrowx_u32(&x1717, &x1718, 0x0, x1693, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x1719, &x1720, x1718, x1695, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x1721, &x1722, x1720, x1697, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x1723, &x1724, x1722, x1699, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x1725, &x1726, x1724, x1701, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x1727, &x1728, x1726, x1703, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x1729, &x1730, x1728, x1705, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1731, &x1732, x1730, x1707, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1733, &x1734, x1732, x1709, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1735, &x1736, x1734, x1711, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1737, &x1738, x1736, x1713, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1739, &x1740, x1738, x1715, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x1741, &x1742, x1740, x1716, 0x0);
  fiat_np384_cmovznz_u32(&x1743, x1742, x1717, x1693);
  fiat_np384_cmovznz_u32(&x1744, x1742, x1719, x1695);
  fiat_np384_cmovznz_u32(&x1745, x1742, x1721, x1697);
  fiat_np384_cmovznz_u32(&x1746, x1742, x1723, x1699);
  fiat_np384_cmovznz_u32(&x1747, x1742, x1725, x1701);
  fiat_np384_cmovznz_u32(&x1748, x1742, x1727, x1703);
  fiat_np384_cmovznz_u32(&x1749, x1742, x1729, x1705);
  fiat_np384_cmovznz_u32(&x1750, x1742, x1731, x1707);
  fiat_np384_cmovznz_u32(&x1751, x1742, x1733, x1709);
  fiat_np384_cmovznz_u32(&x1752, x1742, x1735, x1711);
  fiat_np384_cmovznz_u32(&x1753, x1742, x1737, x1713);
  fiat_np384_cmovznz_u32(&x1754, x1742, x1739, x1715);
  out1[0] = x1743;
  out1[1] = x1744;
  out1[2] = x1745;
  out1[3] = x1746;
  out1[4] = x1747;
  out1[5] = x1748;
  out1[6] = x1749;
  out1[7] = x1750;
  out1[8] = x1751;
  out1[9] = x1752;
  out1[10] = x1753;
  out1[11] = x1754;
}

/*
 * The function fiat_np384_set_one returns the field element one in the Montgomery domain.
 *
 * Postconditions:
 *   eval (from_montgomery out1) mod m = 1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_np384_set_one(fiat_np384_montgomery_domain_field_element out1) {
  out1[0] = UINT32_C(0x333ad68d);
  out1[1] = UINT32_C(0x1313e695);
  out1[2] = UINT32_C(0xb74f5885);
  out1[3] = UINT32_C(0xa7e5f24d);
  out1[4] = UINT32_C(0xbc8d220);
  out1[5] = UINT32_C(0x389cb27e);
  out1[6] = 0x0;
  out1[7] = 0x0;
  out1[8] = 0x0;
  out1[9] = 0x0;
  out1[10] = 0x0;
  out1[11] = 0x0;
}

/*
 * The function fiat_np384_msat returns the saturated representation of the prime modulus.
 *
 * Postconditions:
 *   twos_complement_eval out1 = m
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np384_msat(uint32_t out1[13]) {
  out1[0] = UINT32_C(0xccc52973);
  out1[1] = UINT32_C(0xecec196a);
  out1[2] = UINT32_C(0x48b0a77a);
  out1[3] = UINT32_C(0x581a0db2);
  out1[4] = UINT32_C(0xf4372ddf);
  out1[5] = UINT32_C(0xc7634d81);
  out1[6] = UINT32_C(0xffffffff);
  out1[7] = UINT32_C(0xffffffff);
  out1[8] = UINT32_C(0xffffffff);
  out1[9] = UINT32_C(0xffffffff);
  out1[10] = UINT32_C(0xffffffff);
  out1[11] = UINT32_C(0xffffffff);
  out1[12] = 0x0;
}

/*
 * The function fiat_np384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
 *
 * Postconditions:
 *   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np384_divstep_precomp(uint32_t out1[12]) {
  out1[0] = UINT32_C(0xe6045b6a);
  out1[1] = UINT32_C(0x49589ae0);
  out1[2] = UINT32_C(0x870040ed);
  out1[3] = UINT32_C(0x3c9a5352);
  out1[4] = UINT32_C(0x977dc242);
  out1[5] = UINT32_C(0xdacb097e);
  out1[6] = UINT32_C(0xd1ecbe36);
  out1[7] = UINT32_C(0xb5ab30a6);
  out1[8] = UINT32_C(0x1f959973);
  out1[9] = UINT32_C(0x97d7a108);
  out1[10] = UINT32_C(0xd27192bc);
  out1[11] = UINT32_C(0x2ba012f8);
}

/*
 * The function fiat_np384_divstep computes a divstep.
 *
 * Preconditions:
 *   0 ≤ eval arg4 < m
 *   0 ≤ eval arg5 < m
 * Postconditions:
 *   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
 *   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
 *   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
 *   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
 *   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out2 < m
 *   0 ≤ eval out3 < m
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np384_divstep(uint32_t* out1, uint32_t out2[13], uint32_t out3[13], uint32_t out4[12], uint32_t out5[12], uint32_t arg1, const uint32_t arg2[13], const uint32_t arg3[13], const uint32_t arg4[12], const uint32_t arg5[12]) {
  uint32_t x1;
  fiat_np384_uint1 x2;
  fiat_np384_uint1 x3;
  uint32_t x4;
  fiat_np384_uint1 x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  fiat_np384_uint1 x21;
  uint32_t x22;
  fiat_np384_uint1 x23;
  uint32_t x24;
  fiat_np384_uint1 x25;
  uint32_t x26;
  fiat_np384_uint1 x27;
  uint32_t x28;
  fiat_np384_uint1 x29;
  uint32_t x30;
  fiat_np384_uint1 x31;
  uint32_t x32;
  fiat_np384_uint1 x33;
  uint32_t x34;
  fiat_np384_uint1 x35;
  uint32_t x36;
  fiat_np384_uint1 x37;
  uint32_t x38;
  fiat_np384_uint1 x39;
  uint32_t x40;
  fiat_np384_uint1 x41;
  uint32_t x42;
  fiat_np384_uint1 x43;
  uint32_t x44;
  fiat_np384_uint1 x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  fiat_np384_uint1 x72;
  uint32_t x73;
  fiat_np384_uint1 x74;
  uint32_t x75;
  fiat_np384_uint1 x76;
  uint32_t x77;
  fiat_np384_uint1 x78;
  uint32_t x79;
  fiat_np384_uint1 x80;
  uint32_t x81;
  fiat_np384_uint1 x82;
  uint32_t x83;
  fiat_np384_uint1 x84;
  uint32_t x85;
  fiat_np384_uint1 x86;
  uint32_t x87;
  fiat_np384_uint1 x88;
  uint32_t x89;
  fiat_np384_uint1 x90;
  uint32_t x91;
  fiat_np384_uint1 x92;
  uint32_t x93;
  fiat_np384_uint1 x94;
  uint32_t x95;
  fiat_np384_uint1 x96;
  uint32_t x97;
  fiat_np384_uint1 x98;
  uint32_t x99;
  fiat_np384_uint1 x100;
  uint32_t x101;
  fiat_np384_uint1 x102;
  uint32_t x103;
  fiat_np384_uint1 x104;
  uint32_t x105;
  fiat_np384_uint1 x106;
  uint32_t x107;
  fiat_np384_uint1 x108;
  uint32_t x109;
  fiat_np384_uint1 x110;
  uint32_t x111;
  fiat_np384_uint1 x112;
  uint32_t x113;
  fiat_np384_uint1 x114;
  uint32_t x115;
  fiat_np384_uint1 x116;
  uint32_t x117;
  fiat_np384_uint1 x118;
  uint32_t x119;
  fiat_np384_uint1 x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  fiat_np384_uint1 x134;
  uint32_t x135;
  fiat_np384_uint1 x136;
  uint32_t x137;
  fiat_np384_uint1 x138;
  uint32_t x139;
  fiat_np384_uint1 x140;
  uint32_t x141;
  fiat_np384_uint1 x142;
  uint32_t x143;
  fiat_np384_uint1 x144;
  uint32_t x145;
  fiat_np384_uint1 x146;
  uint32_t x147;
  fiat_np384_uint1 x148;
  uint32_t x149;
  fiat_np384_uint1 x150;
  uint32_t x151;
  fiat_np384_uint1 x152;
  uint32_t x153;
  fiat_np384_uint1 x154;
  uint32_t x155;
  fiat_np384_uint1 x156;
  uint32_t x157;
  uint32_t x158;
  fiat_np384_uint1 x159;
  uint32_t x160;
  fiat_np384_uint1 x161;
  uint32_t x162;
  fiat_np384_uint1 x163;
  uint32_t x164;
  fiat_np384_uint1 x165;
  uint32_t x166;
  fiat_np384_uint1 x167;
  uint32_t x168;
  fiat_np384_uint1 x169;
  uint32_t x170;
  fiat_np384_uint1 x171;
  uint32_t x172;
  fiat_np384_uint1 x173;
  uint32_t x174;
  fiat_np384_uint1 x175;
  uint32_t x176;
  fiat_np384_uint1 x177;
  uint32_t x178;
  fiat_np384_uint1 x179;
  uint32_t x180;
  fiat_np384_uint1 x181;
  uint32_t x182;
  uint32_t x183;
  uint32_t x184;
  uint32_t x185;
  uint32_t x186;
  uint32_t x187;
  uint32_t x188;
  uint32_t x189;
  uint32_t x190;
  uint32_t x191;
  uint32_t x192;
  uint32_t x193;
  fiat_np384_uint1 x194;
  uint32_t x195;
  uint32_t x196;
  uint32_t x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  fiat_np384_uint1 x209;
  uint32_t x210;
  fiat_np384_uint1 x211;
  uint32_t x212;
  fiat_np384_uint1 x213;
  uint32_t x214;
  fiat_np384_uint1 x215;
  uint32_t x216;
  fiat_np384_uint1 x217;
  uint32_t x218;
  fiat_np384_uint1 x219;
  uint32_t x220;
  fiat_np384_uint1 x221;
  uint32_t x222;
  fiat_np384_uint1 x223;
  uint32_t x224;
  fiat_np384_uint1 x225;
  uint32_t x226;
  fiat_np384_uint1 x227;
  uint32_t x228;
  fiat_np384_uint1 x229;
  uint32_t x230;
  fiat_np384_uint1 x231;
  uint32_t x232;
  fiat_np384_uint1 x233;
  uint32_t x234;
  uint32_t x235;
  uint32_t x236;
  uint32_t x237;
  uint32_t x238;
  uint32_t x239;
  uint32_t x240;
  uint32_t x241;
  uint32_t x242;
  uint32_t x243;
  uint32_t x244;
  uint32_t x245;
  uint32_t x246;
  fiat_np384_uint1 x247;
  uint32_t x248;
  fiat_np384_uint1 x249;
  uint32_t x250;
  fiat_np384_uint1 x251;
  uint32_t x252;
  fiat_np384_uint1 x253;
  uint32_t x254;
  fiat_np384_uint1 x255;
  uint32_t x256;
  fiat_np384_uint1 x257;
  uint32_t x258;
  fiat_np384_uint1 x259;
  uint32_t x260;
  fiat_np384_uint1 x261;
  uint32_t x262;
  fiat_np384_uint1 x263;
  uint32_t x264;
  fiat_np384_uint1 x265;
  uint32_t x266;
  fiat_np384_uint1 x267;
  uint32_t x268;
  fiat_np384_uint1 x269;
  uint32_t x270;
  fiat_np384_uint1 x271;
  uint32_t x272;
  fiat_np384_uint1 x273;
  uint32_t x274;
  fiat_np384_uint1 x275;
  uint32_t x276;
  fiat_np384_uint1 x277;
  uint32_t x278;
  fiat_np384_uint1 x279;
  uint32_t x280;
  fiat_np384_uint1 x281;
  uint32_t x282;
  fiat_np384_uint1 x283;
  uint32_t x284;
  fiat_np384_uint1 x285;
  uint32_t x286;
  fiat_np384_uint1 x287;
  uint32_t x288;
  fiat_np384_uint1 x289;
  uint32_t x290;
  fiat_np384_uint1 x291;
  uint32_t x292;
  fiat_np384_uint1 x293;
  uint32_t x294;
  fiat_np384_uint1 x295;
  uint32_t x296;
  fiat_np384_uint1 x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  uint32_t x318;
  uint32_t x319;
  uint32_t x320;
  uint32_t x321;
  uint32_t x322;
  uint32_t x323;
  uint32_t x324;
  uint32_t x325;
  uint32_t x326;
  uint32_t x327;
  uint32_t x328;
  uint32_t x329;
  uint32_t x330;
  uint32_t x331;
  uint32_t x332;
  uint32_t x333;
  uint32_t x334;
  fiat_np384_addcarryx_u32(&x1, &x2, 0x0, (~arg1), 0x1);
  x3 = (fiat_np384_uint1)((fiat_np384_uint1)(x1 >> 31) & (fiat_np384_uint1)((arg3[0]) & 0x1));
  fiat_np384_addcarryx_u32(&x4, &x5, 0x0, (~arg1), 0x1);
  fiat_np384_cmovznz_u32(&x6, x3, arg1, x4);
  fiat_np384_cmovznz_u32(&x7, x3, (arg2[0]), (arg3[0]));
  fiat_np384_cmovznz_u32(&x8, x3, (arg2[1]), (arg3[1]));
  fiat_np384_cmovznz_u32(&x9, x3, (arg2[2]), (arg3[2]));
  fiat_np384_cmovznz_u32(&x10, x3, (arg2[3]), (arg3[3]));
  fiat_np384_cmovznz_u32(&x11, x3, (arg2[4]), (arg3[4]));
  fiat_np384_cmovznz_u32(&x12, x3, (arg2[5]), (arg3[5]));
  fiat_np384_cmovznz_u32(&x13, x3, (arg2[6]), (arg3[6]));
  fiat_np384_cmovznz_u32(&x14, x3, (arg2[7]), (arg3[7]));
  fiat_np384_cmovznz_u32(&x15, x3, (arg2[8]), (arg3[8]));
  fiat_np384_cmovznz_u32(&x16, x3, (arg2[9]), (arg3[9]));
  fiat_np384_cmovznz_u32(&x17, x3, (arg2[10]), (arg3[10]));
  fiat_np384_cmovznz_u32(&x18, x3, (arg2[11]), (arg3[11]));
  fiat_np384_cmovznz_u32(&x19, x3, (arg2[12]), (arg3[12]));
  fiat_np384_addcarryx_u32(&x20, &x21, 0x0, 0x1, (~(arg2[0])));
  fiat_np384_addcarryx_u32(&x22, &x23, x21, 0x0, (~(arg2[1])));
  fiat_np384_addcarryx_u32(&x24, &x25, x23, 0x0, (~(arg2[2])));
  fiat_np384_addcarryx_u32(&x26, &x27, x25, 0x0, (~(arg2[3])));
  fiat_np384_addcarryx_u32(&x28, &x29, x27, 0x0, (~(arg2[4])));
  fiat_np384_addcarryx_u32(&x30, &x31, x29, 0x0, (~(arg2[5])));
  fiat_np384_addcarryx_u32(&x32, &x33, x31, 0x0, (~(arg2[6])));
  fiat_np384_addcarryx_u32(&x34, &x35, x33, 0x0, (~(arg2[7])));
  fiat_np384_addcarryx_u32(&x36, &x37, x35, 0x0, (~(arg2[8])));
  fiat_np384_addcarryx_u32(&x38, &x39, x37, 0x0, (~(arg2[9])));
  fiat_np384_addcarryx_u32(&x40, &x41, x39, 0x0, (~(arg2[10])));
  fiat_np384_addcarryx_u32(&x42, &x43, x41, 0x0, (~(arg2[11])));
  fiat_np384_addcarryx_u32(&x44, &x45, x43, 0x0, (~(arg2[12])));
  fiat_np384_cmovznz_u32(&x46, x3, (arg3[0]), x20);
  fiat_np384_cmovznz_u32(&x47, x3, (arg3[1]), x22);
  fiat_np384_cmovznz_u32(&x48, x3, (arg3[2]), x24);
  fiat_np384_cmovznz_u32(&x49, x3, (arg3[3]), x26);
  fiat_np384_cmovznz_u32(&x50, x3, (arg3[4]), x28);
  fiat_np384_cmovznz_u32(&x51, x3, (arg3[5]), x30);
  fiat_np384_cmovznz_u32(&x52, x3, (arg3[6]), x32);
  fiat_np384_cmovznz_u32(&x53, x3, (arg3[7]), x34);
  fiat_np384_cmovznz_u32(&x54, x3, (arg3[8]), x36);
  fiat_np384_cmovznz_u32(&x55, x3, (arg3[9]), x38);
  fiat_np384_cmovznz_u32(&x56, x3, (arg3[10]), x40);
  fiat_np384_cmovznz_u32(&x57, x3, (arg3[11]), x42);
  fiat_np384_cmovznz_u32(&x58, x3, (arg3[12]), x44);
  fiat_np384_cmovznz_u32(&x59, x3, (arg4[0]), (arg5[0]));
  fiat_np384_cmovznz_u32(&x60, x3, (arg4[1]), (arg5[1]));
  fiat_np384_cmovznz_u32(&x61, x3, (arg4[2]), (arg5[2]));
  fiat_np384_cmovznz_u32(&x62, x3, (arg4[3]), (arg5[3]));
  fiat_np384_cmovznz_u32(&x63, x3, (arg4[4]), (arg5[4]));
  fiat_np384_cmovznz_u32(&x64, x3, (arg4[5]), (arg5[5]));
  fiat_np384_cmovznz_u32(&x65, x3, (arg4[6]), (arg5[6]));
  fiat_np384_cmovznz_u32(&x66, x3, (arg4[7]), (arg5[7]));
  fiat_np384_cmovznz_u32(&x67, x3, (arg4[8]), (arg5[8]));
  fiat_np384_cmovznz_u32(&x68, x3, (arg4[9]), (arg5[9]));
  fiat_np384_cmovznz_u32(&x69, x3, (arg4[10]), (arg5[10]));
  fiat_np384_cmovznz_u32(&x70, x3, (arg4[11]), (arg5[11]));
  fiat_np384_addcarryx_u32(&x71, &x72, 0x0, x59, x59);
  fiat_np384_addcarryx_u32(&x73, &x74, x72, x60, x60);
  fiat_np384_addcarryx_u32(&x75, &x76, x74, x61, x61);
  fiat_np384_addcarryx_u32(&x77, &x78, x76, x62, x62);
  fiat_np384_addcarryx_u32(&x79, &x80, x78, x63, x63);
  fiat_np384_addcarryx_u32(&x81, &x82, x80, x64, x64);
  fiat_np384_addcarryx_u32(&x83, &x84, x82, x65, x65);
  fiat_np384_addcarryx_u32(&x85, &x86, x84, x66, x66);
  fiat_np384_addcarryx_u32(&x87, &x88, x86, x67, x67);
  fiat_np384_addcarryx_u32(&x89, &x90, x88, x68, x68);
  fiat_np384_addcarryx_u32(&x91, &x92, x90, x69, x69);
  fiat_np384_addcarryx_u32(&x93, &x94, x92, x70, x70);
  fiat_np384_subborrowx_u32(&x95, &x96, 0x0, x71, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x97, &x98, x96, x73, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x99, &x100, x98, x75, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x101, &x102, x100, x77, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x103, &x104, x102, x79, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x105, &x106, x104, x81, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x107, &x108, x106, x83, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x109, &x110, x108, x85, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x111, &x112, x110, x87, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x113, &x114, x112, x89, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x115, &x116, x114, x91, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x117, &x118, x116, x93, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x119, &x120, x118, x94, 0x0);
  x121 = (arg4[11]);
  x122 = (arg4[10]);
  x123 = (arg4[9]);
  x124 = (arg4[8]);
  x125 = (arg4[7]);
  x126 = (arg4[6]);
  x127 = (arg4[5]);
  x128 = (arg4[4]);
  x129 = (arg4[3]);
  x130 = (arg4[2]);
  x131 = (arg4[1]);
  x132 = (arg4[0]);
  fiat_np384_subborrowx_u32(&x133, &x134, 0x0, 0x0, x132);
  fiat_np384_subborrowx_u32(&x135, &x136, x134, 0x0, x131);
  fiat_np384_subborrowx_u32(&x137, &x138, x136, 0x0, x130);
  fiat_np384_subborrowx_u32(&x139, &x140, x138, 0x0, x129);
  fiat_np384_subborrowx_u32(&x141, &x142, x140, 0x0, x128);
  fiat_np384_subborrowx_u32(&x143, &x144, x142, 0x0, x127);
  fiat_np384_subborrowx_u32(&x145, &x146, x144, 0x0, x126);
  fiat_np384_subborrowx_u32(&x147, &x148, x146, 0x0, x125);
  fiat_np384_subborrowx_u32(&x149, &x150, x148, 0x0, x124);
  fiat_np384_subborrowx_u32(&x151, &x152, x150, 0x0, x123);
  fiat_np384_subborrowx_u32(&x153, &x154, x152, 0x0, x122);
  fiat_np384_subborrowx_u32(&x155, &x156, x154, 0x0, x121);
  fiat_np384_cmovznz_u32(&x157, x156, 0x0, UINT32_C(0xffffffff));
  fiat_np384_addcarryx_u32(&x158, &x159, 0x0, x133, (x157 & UINT32_C(0xccc52973)));
  fiat_np384_addcarryx_u32(&x160, &x161, x159, x135, (x157 & UINT32_C(0xecec196a)));
  fiat_np384_addcarryx_u32(&x162, &x163, x161, x137, (x157 & UINT32_C(0x48b0a77a)));
  fiat_np384_addcarryx_u32(&x164, &x165, x163, x139, (x157 & UINT32_C(0x581a0db2)));
  fiat_np384_addcarryx_u32(&x166, &x167, x165, x141, (x157 & UINT32_C(0xf4372ddf)));
  fiat_np384_addcarryx_u32(&x168, &x169, x167, x143, (x157 & UINT32_C(0xc7634d81)));
  fiat_np384_addcarryx_u32(&x170, &x171, x169, x145, x157);
  fiat_np384_addcarryx_u32(&x172, &x173, x171, x147, x157);
  fiat_np384_addcarryx_u32(&x174, &x175, x173, x149, x157);
  fiat_np384_addcarryx_u32(&x176, &x177, x175, x151, x157);
  fiat_np384_addcarryx_u32(&x178, &x179, x177, x153, x157);
  fiat_np384_addcarryx_u32(&x180, &x181, x179, x155, x157);
  fiat_np384_cmovznz_u32(&x182, x3, (arg5[0]), x158);
  fiat_np384_cmovznz_u32(&x183, x3, (arg5[1]), x160);
  fiat_np384_cmovznz_u32(&x184, x3, (arg5[2]), x162);
  fiat_np384_cmovznz_u32(&x185, x3, (arg5[3]), x164);
  fiat_np384_cmovznz_u32(&x186, x3, (arg5[4]), x166);
  fiat_np384_cmovznz_u32(&x187, x3, (arg5[5]), x168);
  fiat_np384_cmovznz_u32(&x188, x3, (arg5[6]), x170);
  fiat_np384_cmovznz_u32(&x189, x3, (arg5[7]), x172);
  fiat_np384_cmovznz_u32(&x190, x3, (arg5[8]), x174);
  fiat_np384_cmovznz_u32(&x191, x3, (arg5[9]), x176);
  fiat_np384_cmovznz_u32(&x192, x3, (arg5[10]), x178);
  fiat_np384_cmovznz_u32(&x193, x3, (arg5[11]), x180);
  x194 = (fiat_np384_uint1)(x46 & 0x1);
  fiat_np384_cmovznz_u32(&x195, x194, 0x0, x7);
  fiat_np384_cmovznz_u32(&x196, x194, 0x0, x8);
  fiat_np384_cmovznz_u32(&x197, x194, 0x0, x9);
  fiat_np384_cmovznz_u32(&x198, x194, 0x0, x10);
  fiat_np384_cmovznz_u32(&x199, x194, 0x0, x11);
  fiat_np384_cmovznz_u32(&x200, x194, 0x0, x12);
  fiat_np384_cmovznz_u32(&x201, x194, 0x0, x13);
  fiat_np384_cmovznz_u32(&x202, x194, 0x0, x14);
  fiat_np384_cmovznz_u32(&x203, x194, 0x0, x15);
  fiat_np384_cmovznz_u32(&x204, x194, 0x0, x16);
  fiat_np384_cmovznz_u32(&x205, x194, 0x0, x17);
  fiat_np384_cmovznz_u32(&x206, x194, 0x0, x18);
  fiat_np384_cmovznz_u32(&x207, x194, 0x0, x19);
  fiat_np384_addcarryx_u32(&x208, &x209, 0x0, x46, x195);
  fiat_np384_addcarryx_u32(&x210, &x211, x209, x47, x196);
  fiat_np384_addcarryx_u32(&x212, &x213, x211, x48, x197);
  fiat_np384_addcarryx_u32(&x214, &x215, x213, x49, x198);
  fiat_np384_addcarryx_u32(&x216, &x217, x215, x50, x199);
  fiat_np384_addcarryx_u32(&x218, &x219, x217, x51, x200);
  fiat_np384_addcarryx_u32(&x220, &x221, x219, x52, x201);
  fiat_np384_addcarryx_u32(&x222, &x223, x221, x53, x202);
  fiat_np384_addcarryx_u32(&x224, &x225, x223, x54, x203);
  fiat_np384_addcarryx_u32(&x226, &x227, x225, x55, x204);
  fiat_np384_addcarryx_u32(&x228, &x229, x227, x56, x205);
  fiat_np384_addcarryx_u32(&x230, &x231, x229, x57, x206);
  fiat_np384_addcarryx_u32(&x232, &x233, x231, x58, x207);
  fiat_np384_cmovznz_u32(&x234, x194, 0x0, x59);
  fiat_np384_cmovznz_u32(&x235, x194, 0x0, x60);
  fiat_np384_cmovznz_u32(&x236, x194, 0x0, x61);
  fiat_np384_cmovznz_u32(&x237, x194, 0x0, x62);
  fiat_np384_cmovznz_u32(&x238, x194, 0x0, x63);
  fiat_np384_cmovznz_u32(&x239, x194, 0x0, x64);
  fiat_np384_cmovznz_u32(&x240, x194, 0x0, x65);
  fiat_np384_cmovznz_u32(&x241, x194, 0x0, x66);
  fiat_np384_cmovznz_u32(&x242, x194, 0x0, x67);
  fiat_np384_cmovznz_u32(&x243, x194, 0x0, x68);
  fiat_np384_cmovznz_u32(&x244, x194, 0x0, x69);
  fiat_np384_cmovznz_u32(&x245, x194, 0x0, x70);
  fiat_np384_addcarryx_u32(&x246, &x247, 0x0, x182, x234);
  fiat_np384_addcarryx_u32(&x248, &x249, x247, x183, x235);
  fiat_np384_addcarryx_u32(&x250, &x251, x249, x184, x236);
  fiat_np384_addcarryx_u32(&x252, &x253, x251, x185, x237);
  fiat_np384_addcarryx_u32(&x254, &x255, x253, x186, x238);
  fiat_np384_addcarryx_u32(&x256, &x257, x255, x187, x239);
  fiat_np384_addcarryx_u32(&x258, &x259, x257, x188, x240);
  fiat_np384_addcarryx_u32(&x260, &x261, x259, x189, x241);
  fiat_np384_addcarryx_u32(&x262, &x263, x261, x190, x242);
  fiat_np384_addcarryx_u32(&x264, &x265, x263, x191, x243);
  fiat_np384_addcarryx_u32(&x266, &x267, x265, x192, x244);
  fiat_np384_addcarryx_u32(&x268, &x269, x267, x193, x245);
  fiat_np384_subborrowx_u32(&x270, &x271, 0x0, x246, UINT32_C(0xccc52973));
  fiat_np384_subborrowx_u32(&x272, &x273, x271, x248, UINT32_C(0xecec196a));
  fiat_np384_subborrowx_u32(&x274, &x275, x273, x250, UINT32_C(0x48b0a77a));
  fiat_np384_subborrowx_u32(&x276, &x277, x275, x252, UINT32_C(0x581a0db2));
  fiat_np384_subborrowx_u32(&x278, &x279, x277, x254, UINT32_C(0xf4372ddf));
  fiat_np384_subborrowx_u32(&x280, &x281, x279, x256, UINT32_C(0xc7634d81));
  fiat_np384_subborrowx_u32(&x282, &x283, x281, x258, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x284, &x285, x283, x260, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x286, &x287, x285, x262, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x288, &x289, x287, x264, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x290, &x291, x289, x266, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x292, &x293, x291, x268, UINT32_C(0xffffffff));
  fiat_np384_subborrowx_u32(&x294, &x295, x293, x269, 0x0);
  fiat_np384_addcarryx_u32(&x296, &x297, 0x0, x6, 0x1);
  x298 = ((x208 >> 1) | ((x210 << 31) & UINT32_C(0xffffffff)));
  x299 = ((x210 >> 1) | ((x212 << 31) & UINT32_C(0xffffffff)));
  x300 = ((x212 >> 1) | ((x214 << 31) & UINT32_C(0xffffffff)));
  x301 = ((x214 >> 1) | ((x216 << 31) & UINT32_C(0xffffffff)));
  x302 = ((x216 >> 1) | ((x218 << 31) & UINT32_C(0xffffffff)));
  x303 = ((x218 >> 1) | ((x220 << 31) & UINT32_C(0xffffffff)));
  x304 = ((x220 >> 1) | ((x222 << 31) & UINT32_C(0xffffffff)));
  x305 = ((x222 >> 1) | ((x224 << 31) & UINT32_C(0xffffffff)));
  x306 = ((x224 >> 1) | ((x226 << 31) & UINT32_C(0xffffffff)));
  x307 = ((x226 >> 1) | ((x228 << 31) & UINT32_C(0xffffffff)));
  x308 = ((x228 >> 1) | ((x230 << 31) & UINT32_C(0xffffffff)));
  x309 = ((x230 >> 1) | ((x232 << 31) & UINT32_C(0xffffffff)));
  x310 = ((x232 & UINT32_C(0x80000000)) | (x232 >> 1));
  fiat_np384_cmovznz_u32(&x311, x120, x95, x71);
  fiat_np384_cmovznz_u32(&x312, x120, x97, x73);
  fiat_np384_cmovznz_u32(&x313, x120, x99, x75);
  fiat_np384_cmovznz_u32(&x314, x120, x101, x77);
  fiat_np384_cmovznz_u32(&x315, x120, x103, x79);
  fiat_np384_cmovznz_u32(&x316, x120, x105, x81);
  fiat_np384_cmovznz_u32(&x317, x120, x107, x83);
  fiat_np384_cmovznz_u32(&x318, x120, x109, x85);
  fiat_np384_cmovznz_u32(&x319, x120, x111, x87);
  fiat_np384_cmovznz_u32(&x320, x120, x113, x89);
  fiat_np384_cmovznz_u32(&x321, x120, x115, x91);
  fiat_np384_cmovznz_u32(&x322, x120, x117, x93);
  fiat_np384_cmovznz_u32(&x323, x295, x270, x246);
  fiat_np384_cmovznz_u32(&x324, x295, x272, x248);
  fiat_np384_cmovznz_u32(&x325, x295, x274, x250);
  fiat_np384_cmovznz_u32(&x326, x295, x276, x252);
  fiat_np384_cmovznz_u32(&x327, x295, x278, x254);
  fiat_np384_cmovznz_u32(&x328, x295, x280, x256);
  fiat_np384_cmovznz_u32(&x329, x295, x282, x258);
  fiat_np384_cmovznz_u32(&x330, x295, x284, x260);
  fiat_np384_cmovznz_u32(&x331, x295, x286, x262);
  fiat_np384_cmovznz_u32(&x332, x295, x288, x264);
  fiat_np384_cmovznz_u32(&x333, x295, x290, x266);
  fiat_np384_cmovznz_u32(&x334, x295, x292, x268);
  *out1 = x296;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out2[9] = x16;
  out2[10] = x17;
  out2[11] = x18;
  out2[12] = x19;
  out3[0] = x298;
  out3[1] = x299;
  out3[2] = x300;
  out3[3] = x301;
  out3[4] = x302;
  out3[5] = x303;
  out3[6] = x304;
  out3[7] = x305;
  out3[8] = x306;
  out3[9] = x307;
  out3[10] = x308;
  out3[11] = x309;
  out3[12] = x310;
  out4[0] = x311;
  out4[1] = x312;
  out4[2] = x313;
  out4[3] = x314;
  out4[4] = x315;
  out4[5] = x316;
  out4[6] = x317;
  out4[7] = x318;
  out4[8] = x319;
  out4[9] = x320;
  out4[10] = x321;
  out4[11] = x322;
  out5[0] = x323;
  out5[1] = x324;
  out5[2] = x325;
  out5[3] = x326;
  out5[4] = x327;
  out5[5] = x328;
  out5[6] = x329;
  out5[7] = x330;
  out5[8] = x331;
  out5[9] = x332;
  out5[10] = x333;
  out5[11] = x334;
}

/*
 * The function fiat_np384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_np384_to_bytes(uint8_t out1[48], const uint32_t arg1[12]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint8_t x13;
  uint32_t x14;
  uint8_t x15;
  uint32_t x16;
  uint8_t x17;
  uint8_t x18;
  uint8_t x19;
  uint32_t x20;
  uint8_t x21;
  uint32_t x22;
  uint8_t x23;
  uint8_t x24;
  uint8_t x25;
  uint32_t x26;
  uint8_t x27;
  uint32_t x28;
  uint8_t x29;
  uint8_t x30;
  uint8_t x31;
  uint32_t x32;
  uint8_t x33;
  uint32_t x34;
  uint8_t x35;
  uint8_t x36;
  uint8_t x37;
  uint32_t x38;
  uint8_t x39;
  uint32_t x40;
  uint8_t x41;
  uint8_t x42;
  uint8_t x43;
  uint32_t x44;
  uint8_t x45;
  uint32_t x46;
  uint8_t x47;
  uint8_t x48;
  uint8_t x49;
  uint32_t x50;
  uint8_t x51;
  uint32_t x52;
  uint8_t x53;
  uint8_t x54;
  uint8_t x55;
  uint32_t x56;
  uint8_t x57;
  uint32_t x58;
  uint8_t x59;
  uint8_t x60;
  uint8_t x61;
  uint32_t x62;
  uint8_t x63;
  uint32_t x64;
  uint8_t x65;
  uint8_t x66;
  uint8_t x67;
  uint32_t x68;
  uint8_t x69;
  uint32_t x70;
  uint8_t x71;
  uint8_t x72;
  uint8_t x73;
  uint32_t x74;
  uint8_t x75;
  uint32_t x76;
  uint8_t x77;
  uint8_t x78;
  uint8_t x79;
  uint32_t x80;
  uint8_t x81;
  uint32_t x82;
  uint8_t x83;
  uint8_t x84;
  x1 = (arg1[11]);
  x2 = (arg1[10]);
  x3 = (arg1[9]);
  x4 = (arg1[8]);
  x5 = (arg1[7]);
  x6 = (arg1[6]);
  x7 = (arg1[5]);
  x8 = (arg1[4]);
  x9 = (arg1[3]);
  x10 = (arg1[2]);
  x11 = (arg1[1]);
  x12 = (arg1[0]);
  x13 = (uint8_t)(x12 & UINT8_C(0xff));
  x14 = (x12 >> 8);
  x15 = (uint8_t)(x14 & UINT8_C(0xff));
  x16 = (x14 >> 8);
  x17 = (uint8_t)(x16 & UINT8_C(0xff));
  x18 = (uint8_t)(x16 >> 8);
  x19 = (uint8_t)(x11 & UINT8_C(0xff));
  x20 = (x11 >> 8);
  x21 = (uint8_t)(x20 & UINT8_C(0xff));
  x22 = (x20 >> 8);
  x23 = (uint8_t)(x22 & UINT8_C(0xff));
  x24 = (uint8_t)(x22 >> 8);
  x25 = (uint8_t)(x10 & UINT8_C(0xff));
  x26 = (x10 >> 8);
  x27 = (uint8_t)(x26 & UINT8_C(0xff));
  x28 = (x26 >> 8);
  x29 = (uint8_t)(x28 & UINT8_C(0xff));
  x30 = (uint8_t)(x28 >> 8);
  x31 = (uint8_t)(x9 & UINT8_C(0xff));
  x32 = (x9 >> 8);
  x33 = (uint8_t)(x32 & UINT8_C(0xff));
  x34 = (x32 >> 8);
  x35 = (uint8_t)(x34 & UINT8_C(0xff));
  x36 = (uint8_t)(x34 >> 8);
  x37 = (uint8_t)(x8 & UINT8_C(0xff));
  x38 = (x8 >> 8);
  x39 = (uint8_t)(x38 & UINT8_C(0xff));
  x40 = (x38 >> 8);
  x41 = (uint8_t)(x40 & UINT8_C(0xff));
  x42 = (uint8_t)(x40 >> 8);
  x43 = (uint8_t)(x7 & UINT8_C(0xff));
  x44 = (x7 >> 8);
  x45 = (uint8_t)(x44 & UINT8_C(0xff));
  x46 = (x44 >> 8);
  x47 = (uint8_t)(x46 & UINT8_C(0xff));
  x48 = (uint8_t)(x46 >> 8);
  x49 = (uint8_t)(x6 & UINT8_C(0xff));
  x50 = (x6 >> 8);
  x51 = (uint8_t)(x50 & UINT8_C(0xff));
  x52 = (x50 >> 8);
  x53 = (uint8_t)(x52 & UINT8_C(0xff));
  x54 = (uint8_t)(x52 >> 8);
  x55 = (uint8_t)(x5 & UINT8_C(0xff));
  x56 = (x5 >> 8);
  x57 = (uint8_t)(x56 & UINT8_C(0xff));
  x58 = (x56 >> 8);
  x59 = (uint8_t)(x58 & UINT8_C(0xff));
  x60 = (uint8_t)(x58 >> 8);
  x61 = (uint8_t)(x4 & UINT8_C(0xff));
  x62 = (x4 >> 8);
  x63 = (uint8_t)(x62 & UINT8_C(0xff));
  x64 = (x62 >> 8);
  x65 = (uint8_t)(x64 & UINT8_C(0xff));
  x66 = (uint8_t)(x64 >> 8);
  x67 = (uint8_t)(x3 & UINT8_C(0xff));
  x68 = (x3 >> 8);
  x69 = (uint8_t)(x68 & UINT8_C(0xff));
  x70 = (x68 >> 8);
  x71 = (uint8_t)(x70 & UINT8_C(0xff));
  x72 = (uint8_t)(x70 >> 8);
  x73 = (uint8_t)(x2 & UINT8_C(0xff));
  x74 = (x2 >> 8);
  x75 = (uint8_t)(x74 & UINT8_C(0xff));
  x76 = (x74 >> 8);
  x77 = (uint8_t)(x76 & UINT8_C(0xff));
  x78 = (uint8_t)(x76 >> 8);
  x79 = (uint8_t)(x1 & UINT8_C(0xff));
  x80 = (x1 >> 8);
  x81 = (uint8_t)(x80 & UINT8_C(0xff));
  x82 = (x80 >> 8);
  x83 = (uint8_t)(x82 & UINT8_C(0xff));
  x84 = (uint8_t)(x82 >> 8);
  out1[0] = x13;
  out1[1] = x15;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x21;
  out1[6] = x23;
  out1[7] = x24;
  out1[8] = x25;
  out1[9] = x27;
  out1[10] = x29;
  out1[11] = x30;
  out1[12] = x31;
  out1[13] = x33;
  out1[14] = x35;
  out1[15] = x36;
  out1[16] = x37;
  out1[17] = x39;
  out1[18] = x41;
  out1[19] = x42;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x54;
  out1[28] = x55;
  out1[29] = x57;
  out1[30] = x59;
  out1[31] = x60;
  out1[32] = x61;
  out1[33] = x63;
  out1[34] = x65;
  out1[35] = x66;
  out1[36] = x67;
  out1[37] = x69;
  out1[38] = x71;
  out1[39] = x72;
  out1[40] = x73;
  out1[41] = x75;
  out1[42] = x77;
  out1[43] = x78;
  out1[44] = x79;
  out1[45] = x81;
  out1[46] = x83;
  out1[47] = x84;
}

/*
 * The function fiat_np384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np384_from_bytes(uint32_t out1[12], const uint8_t arg1[48]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint8_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint8_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint8_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint8_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint8_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint8_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint8_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint8_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint8_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint8_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint8_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint8_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  x1 = ((uint32_t)(arg1[47]) << 24);
  x2 = ((uint32_t)(arg1[46]) << 16);
  x3 = ((uint32_t)(arg1[45]) << 8);
  x4 = (arg1[44]);
  x5 = ((uint32_t)(arg1[43]) << 24);
  x6 = ((uint32_t)(arg1[42]) << 16);
  x7 = ((uint32_t)(arg1[41]) << 8);
  x8 = (arg1[40]);
  x9 = ((uint32_t)(arg1[39]) << 24);
  x10 = ((uint32_t)(arg1[38]) << 16);
  x11 = ((uint32_t)(arg1[37]) << 8);
  x12 = (arg1[36]);
  x13 = ((uint32_t)(arg1[35]) << 24);
  x14 = ((uint32_t)(arg1[34]) << 16);
  x15 = ((uint32_t)(arg1[33]) << 8);
  x16 = (arg1[32]);
  x17 = ((uint32_t)(arg1[31]) << 24);
  x18 = ((uint32_t)(arg1[30]) << 16);
  x19 = ((uint32_t)(arg1[29]) << 8);
  x20 = (arg1[28]);
  x21 = ((uint32_t)(arg1[27]) << 24);
  x22 = ((uint32_t)(arg1[26]) << 16);
  x23 = ((uint32_t)(arg1[25]) << 8);
  x24 = (arg1[24]);
  x25 = ((uint32_t)(arg1[23]) << 24);
  x26 = ((uint32_t)(arg1[22]) << 16);
  x27 = ((uint32_t)(arg1[21]) << 8);
  x28 = (arg1[20]);
  x29 = ((uint32_t)(arg1[19]) << 24);
  x30 = ((uint32_t)(arg1[18]) << 16);
  x31 = ((uint32_t)(arg1[17]) << 8);
  x32 = (arg1[16]);
  x33 = ((uint32_t)(arg1[15]) << 24);
  x34 = ((uint32_t)(arg1[14]) << 16);
  x35 = ((uint32_t)(arg1[13]) << 8);
  x36 = (arg1[12]);
  x37 = ((uint32_t)(arg1[11]) << 24);
  x38 = ((uint32_t)(arg1[10]) << 16);
  x39 = ((uint32_t)(arg1[9]) << 8);
  x40 = (arg1[8]);
  x41 = ((uint32_t)(arg1[7]) << 24);
  x42 = ((uint32_t)(arg1[6]) << 16);
  x43 = ((uint32_t)(arg1[5]) << 8);
  x44 = (arg1[4]);
  x45 = ((uint32_t)(arg1[3]) << 24);
  x46 = ((uint32_t)(arg1[2]) << 16);
  x47 = ((uint32_t)(arg1[1]) << 8);
  x48 = (arg1[0]);
  x49 = (x47 + (uint32_t)x48);
  x50 = (x46 + x49);
  x51 = (x45 + x50);
  x52 = (x43 + (uint32_t)x44);
  x53 = (x42 + x52);
  x54 = (x41 + x53);
  x55 = (x39 + (uint32_t)x40);
  x56 = (x38 + x55);
  x57 = (x37 + x56);
  x58 = (x35 + (uint32_t)x36);
  x59 = (x34 + x58);
  x60 = (x33 + x59);
  x61 = (x31 + (uint32_t)x32);
  x62 = (x30 + x61);
  x63 = (x29 + x62);
  x64 = (x27 + (uint32_t)x28);
  x65 = (x26 + x64);
  x66 = (x25 + x65);
  x67 = (x23 + (uint32_t)x24);
  x68 = (x22 + x67);
  x69 = (x21 + x68);
  x70 = (x19 + (uint32_t)x20);
  x71 = (x18 + x70);
  x72 = (x17 + x71);
  x73 = (x15 + (uint32_t)x16);
  x74 = (x14 + x73);
  x75 = (x13 + x74);
  x76 = (x11 + (uint32_t)x12);
  x77 = (x10 + x76);
  x78 = (x9 + x77);
  x79 = (x7 + (uint32_t)x8);
  x80 = (x6 + x79);
  x81 = (x5 + x80);
  x82 = (x3 + (uint32_t)x4);
  x83 = (x2 + x82);
  x84 = (x1 + x83);
  out1[0] = x51;
  out1[1] = x54;
  out1[2] = x57;
  out1[3] = x60;
  out1[4] = x63;
  out1[5] = x66;
  out1[6] = x69;
  out1[7] = x72;
  out1[8] = x75;
  out1[9] = x78;
  out1[10] = x81;
  out1[11] = x84;
}

/*
 * The function fiat_np384_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_np384_selectznz(uint32_t out1[12], fiat_np384_uint1 arg1, const uint32_t arg2[12], const uint32_t arg3[12]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  fiat_np384_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  fiat_np384_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  fiat_np384_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  fiat_np384_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  fiat_np384_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  fiat_np384_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  fiat_np384_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  fiat_np384_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
  fiat_np384_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
  fiat_np384_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
  fiat_np384_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
  fiat_np384_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
}
