(* TEST
 include dynlink;
 libraries = "";
 readonly_files = "store.ml main.ml Plugin_0.ml Plugin_0_0.ml Plugin_0_0_0.ml Plugin_0_0_0_0.ml Plugin_0_0_0_1.ml Plugin_0_0_0_2.ml Plugin_1.ml Plugin_1_0.ml Plugin_1_0_0.ml Plugin_1_0_0_0.ml Plugin_1_1.ml Plugin_1_2.ml Plugin_1_2_0.ml Plugin_1_2_0_0.ml Plugin_1_2_1.ml Plugin_1_2_2.ml Plugin_1_2_2_0.ml Plugin_1_2_3.ml Plugin_1_2_3_0.ml";
 not-windows;
 {
   shared-libraries;
   setup-ocamlc.byte-build-env;
   module = "store.ml";
   ocamlc.byte;
   module = "Plugin_0.ml";
   ocamlc.byte;
   module = "Plugin_0_0.ml";
   ocamlc.byte;
   module = "Plugin_0_0_0.ml";
   ocamlc.byte;
   module = "Plugin_0_0_0_0.ml";
   ocamlc.byte;
   module = "Plugin_0_0_0_1.ml";
   ocamlc.byte;
   module = "Plugin_0_0_0_2.ml";
   ocamlc.byte;
   module = "Plugin_1.ml";
   ocamlc.byte;
   module = "Plugin_1_0.ml";
   ocamlc.byte;
   module = "Plugin_1_0_0.ml";
   ocamlc.byte;
   module = "Plugin_1_0_0_0.ml";
   ocamlc.byte;
   module = "Plugin_1_1.ml";
   ocamlc.byte;
   module = "Plugin_1_2.ml";
   ocamlc.byte;
   module = "Plugin_1_2_0.ml";
   ocamlc.byte;
   module = "Plugin_1_2_0_0.ml";
   ocamlc.byte;
   module = "Plugin_1_2_1.ml";
   ocamlc.byte;
   module = "Plugin_1_2_2.ml";
   ocamlc.byte;
   module = "Plugin_1_2_2_0.ml";
   ocamlc.byte;
   module = "Plugin_1_2_3.ml";
   ocamlc.byte;
   module = "Plugin_1_2_3_0.ml";
   ocamlc.byte;
   module = "main.ml";
   ocamlc.byte;
   program = "./main.byte.exe";
   libraries = "dynlink";
   all_modules = "store.cmo main.cmo";
   module = "";
   ocamlc.byte;
   run;
   check-program-output;
 }{
   native-dynlink;
   setup-ocamlopt.byte-build-env;
   flags = "";
   module = "store.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0.cmxs";
   module = "";
   all_modules = "Plugin_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0_0.cmxs";
   module = "";
   all_modules = "Plugin_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0_0_0.cmxs";
   module = "";
   all_modules = "Plugin_0_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0_0_0_0.cmxs";
   module = "";
   all_modules = "Plugin_0_0_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0_0_0_1.cmxs";
   module = "";
   all_modules = "Plugin_0_0_0_1.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_0_0_0_2.cmxs";
   module = "";
   all_modules = "Plugin_0_0_0_2.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1.cmxs";
   module = "";
   all_modules = "Plugin_1.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_0.cmxs";
   module = "";
   all_modules = "Plugin_1_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_0_0.cmxs";
   module = "";
   all_modules = "Plugin_1_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_0_0_0.cmxs";
   module = "";
   all_modules = "Plugin_1_0_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_1.cmxs";
   module = "";
   all_modules = "Plugin_1_1.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2.cmxs";
   module = "";
   all_modules = "Plugin_1_2.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_0.cmxs";
   module = "";
   all_modules = "Plugin_1_2_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_0_0.cmxs";
   module = "";
   all_modules = "Plugin_1_2_0_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_1.cmxs";
   module = "";
   all_modules = "Plugin_1_2_1.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_2.cmxs";
   module = "";
   all_modules = "Plugin_1_2_2.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_2_0.cmxs";
   module = "";
   all_modules = "Plugin_1_2_2_0.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_3.cmxs";
   module = "";
   all_modules = "Plugin_1_2_3.ml";
   ocamlopt.byte;
   flags = "-shared";
   program = "Plugin_1_2_3_0.cmxs";
   module = "";
   all_modules = "Plugin_1_2_3_0.ml";
   ocamlopt.byte;
   flags = "";
   module = "main.ml";
   ocamlopt.byte;
   program = "./main.exe";
   libraries = "dynlink";
   all_modules = "store.cmx main.cmx";
   module = "";
   ocamlopt.byte;
   run;
   check-program-output;
 }
*)

(*  This module and all plugin modules are generated by a call to test_generator.ml with parameters:
seed=25, width=8, depth=4, nlinks=4, introns=8, childs=2, domains=12.
*)
(* Link plugins *)
let d0 = Domain.spawn (fun () -> Dynlink.loadfile @@ Dynlink.adapt_filename "Plugin_0.cmo")
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.169495039333ap+1
let wordy = "This" ^ "is" ^ "a" ^ "very" ^ "useful" ^ "code" ^ "fragment: 617." ^ "That's all"
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.5e02683439a8ap-1
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.26dadad08db5dp+0
let d1 = Domain.spawn (fun () -> Dynlink.loadfile @@ Dynlink.adapt_filename "Plugin_1.cmo")
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.22505223b655ap+0
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.2275ac3e51895p-1
let () = Domain.join d0
let wordy = "This" ^ "is" ^ "a" ^ "very" ^ "useful" ^ "code" ^ "fragment: 352." ^ "That's all"
let sqrt2 =
  let rec find c =
    if Float.abs (c *. c -. 2.) < 1e-3 then c
    else find ((c *. c +. 2.) /. (2. *. c))
  in find 0x1.249bde9d3b93ep+2
let () = Store.add "[]->[]"
let () = Store.add "[]->[]"
let () = Domain.join d1
let add x = Store.add x
let () = Store.add "[]->[]"
let () = Store.add "[]->[]"

(* Print result *)

module String_set = Set.Make(String)
let stored = Atomic.get Store.store
let stored_set = String_set.of_list stored
let () =
  List.iter (Printf.printf "%s\n") (String_set.elements stored_set)
