// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_EigenValuesSearcher_HeaderFile
#define _math_EigenValuesSearcher_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_TColStd_HArray1OfReal.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Handle_TColStd_HArray2OfReal.hxx>
#include <Standard_Real.hxx>
#include <math_Vector.hxx>
class TColStd_HArray1OfReal;
class TColStd_HArray2OfReal;
class StdFail_NotDone;
class TColStd_Array1OfReal;


//! This class finds eigen values and vectors of
//! real symmetric tridiagonal matrix
class math_EigenValuesSearcher 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT math_EigenValuesSearcher(const TColStd_Array1OfReal& Diagonal, const TColStd_Array1OfReal& Subdiagonal);
  
  //! Returns Standard_True if computation is performed
  //! successfully.
  Standard_EXPORT   Standard_Boolean IsDone()  const;
  
  //! Returns the dimension of matrix
  Standard_EXPORT   Standard_Integer Dimension()  const;
  
  //! Returns the Index_th eigen value of matrix
  //! Index must be in [1, Dimension()]
  Standard_EXPORT   Standard_Real EigenValue (const Standard_Integer Index)  const;
  
  //! Returns the Index_th eigen vector of matrix
  //! Index must be in [1, Dimension()]
  Standard_EXPORT   math_Vector EigenVector (const Standard_Integer Index)  const;




protected:





private:



  Handle(TColStd_HArray1OfReal) myDiagonal;
  Handle(TColStd_HArray1OfReal) mySubdiagonal;
  Standard_Boolean myIsDone;
  Standard_Integer myN;
  Handle(TColStd_HArray1OfReal) myEigenValues;
  Handle(TColStd_HArray2OfReal) myEigenVectors;


};







#endif // _math_EigenValuesSearcher_HeaderFile
