/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GENERATION_CONTEXT_P_H_
#define _GENERATION_CONTEXT_P_H_

#include <map>

#include <GTLCore/PixelDescription.h>
#include <GTLCore/String.h>

namespace OpenCTL {
  /**
   * @internal
   * @ingroup OpenCTL
   *
   * Generation context used to transform a node of the template AST (@ref TemplateAST::Node) into
   * CTL source code.
   */
  class TemplateGenerationContext {
    public:
      TemplateGenerationContext( const std::map< GTLCore::String, const GTLCore::Type* >& _namedTypes,
                                 const GTLCore::PixelDescription& _pixelDescription );
      void startLocalContext(const GTLCore::String& suffix, int _currentChannel);
      void endLocalContext();
      void append(const GTLCore::String& _c);
      const GTLCore::String& code() const;
      const GTLCore::PixelDescription& pixelDescription() const;
      const GTLCore::String& suffix() const;
      int currentChannel() const;
      const GTLCore::Type* currentChannelType() const;
      const GTLCore::Type* namedType(const GTLCore::String&) const;
    private:
      GTLCore::String m_code;
      bool m_isLocalContext;
      GTLCore::String m_suffix;
      int m_currentChannel;
      GTLCore::PixelDescription m_pixelDescription;
      std::map< GTLCore::String, const GTLCore::Type* > m_namedTypes;
  };
}

#endif
