/*
 *  Copyright (c) 2008,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Value_p.h"

#include <llvm/DerivedTypes.h>
#include <llvm/Type.h>

#include "Debug.h"
#include "Value.h"

namespace GTLCore {

void copyValueToPtr(const GTLCore::Value& _value, const llvm::Type* type, llvm::LLVMContext& context, void* ptr)
{
    if( type == llvm::Type::getInt32Ty(context) )
    {
        *(int*)ptr =_value.asInt32();
    } else if( type == llvm::Type::getInt1Ty(context) )
    {
        *(bool*)ptr = _value.asBoolean();
    } else if( type == llvm::Type::getFloatTy(context) )
    {
        GTL_DEBUG("Set " << _value.asFloat32() << " on ptr " << ptr << " from value = " << *(float*)ptr);
        *(float*)ptr = _value.asFloat32();
        GTL_DEBUG( *(float*)ptr );
    }
}

}
