# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1824-1 (phpmyadmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64312);
 script_cve_id("CVE-2009-1150", "CVE-2009-1151");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1824-1 (phpmyadmin)";
 script_name(name);

 desc = "The remote host is missing an update to phpmyadmin
announced via advisory DSA 1824-1.

Several remote vulnerabilities have been discovered in phpMyAdmin, a tool
to administer MySQL over the web. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-1150

Cross site scripting vulnerability in the export page allow for an
attacker that can place crafted cookies with the user to inject
arbitrary web script or HTML.

CVE-2009-1151

Static code injection allows for a remote attacker to inject arbitrary
code into phpMyAdmin via the setup.php script. This script is in Debian
under normal circumstances protected via Apache authentication.
However, because of a recent worm based on this exploit, we are patching
it regardless, to also protect installations that somehow still expose
the setup.php script.

For the old stable distribution (etch), these problems have been fixed in
version 2.9.1.1-11.

For the stable distribution (lenny), these problems have been fixed in
version 2.11.8.1-5+lenny1.

For the unstable distribution (sid), these problems have been fixed in
version 3.1.3.1-1.

We recommend that you upgrade your phpmyadmin package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201824-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1824-1 (phpmyadmin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpmyadmin", ver:"2.9.1.1-11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpmyadmin", ver:"2.11.8.1-5+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
