#
#VID b3531fe1-2b03-11df-b6db-00248c9b4be7
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID b3531fe1-2b03-11df-b6db-00248c9b4be7
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67051);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: drupal5");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   drupal5
   drupal6

Solution:
Update your system with the appropriate patches or
software upgrades.

http://drupal.org/node/731710
http://www.vuxml.org/freebsd/b3531fe1-2b03-11df-b6db-00248c9b4be7.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: drupal5");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"drupal5");
if(!isnull(bver) && revcomp(a:bver, b:"5.22")<0) {
    security_note(0, data:"Package drupal5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"drupal6");
if(!isnull(bver) && revcomp(a:bver, b:"6.16")<0) {
    security_note(0, data:"Package drupal6 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
