###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_evalsmsi_detect.nasl 7275 2010-02-16 12:25:36Z feb $
#
# evalSMSI Version Detection
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800165);
  script_version("$Revision: 7732 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("evalSMSI Version Detection");
  desc = "
  Overview: This script finds the installed evalSMSI version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of evalSMSI in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

## Get the port where evalSMSI application is running
evalSMSIPort = get_http_port(default:80);
if(!evalSMSIPort){
  exit(0);
}

## Iterate over the list of application paths
foreach path (make_list("/evalsmsi", "/", cgi_dirs()))
{
  ## Send the request and Recieve the response
  sndReq = http_get(item: path + "/evalsmsi.php", port:evalSMSIPort);
  rcvRes = http_send_recv(port:evalSMSIPort, data:sndReq);

  ## Check for EvalSMSI Application in the response
  if(">EvalSMSI" >< rcvRes)
  {
    ## Get EvalSMSI version
    evalSMSIVer = eregmatch(pattern:">EvalSMSI version ([0-9.]+) ?--",
                            string:rcvRes);
    if(evalSMSIVer[1] != NULL)
    {
      set_kb_item(name:"www/" + evalSMSIPort + "/evalSMSI",
                        value:evalSMSIVer[1] + " under " + path);
      security_note(data:"Eval SMSI version " + evalSMSIVer[1] + " running at" + 
                         " location " + path + " was detected on the host");
      exit(0);
    }
  }
}
