###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ekg FEDORA-2007-0791
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861521);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.6");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-0791");
  script_cve_id("CVE-2007-166", "CVE-2007-1663", "CVE-2007-1664", "CVE-2007-1665");
  script_name( "Fedora Update for ekg FEDORA-2007-0791");
  desc = "

  Vulnerability Insight:
  EKG (&quot;Eksperymentalny Klient Gadu-Gadu&quot;) is an open source gadu-gadu
  client for UNIX systems. Gadu-Gadu is an instant messaging program,
  very popular in Poland.
  
  EKG features include:
    - irssi-like ncurses interface
    - sending and receiving files
    - voice conversations
    - launching shell commands on certain events
    - reading input from pipe
    - python scripting support
    - speech synthesis (using an external program)
    - encryption support
  
  Please note that the program is not internationalized and all messages
  are in Polish (although the commands are in English).


  Affected Software/OS:
  ekg on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00010.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ekg");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"ekg", rpm:"ekg~1.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ekg-debuginfo", rpm:"ekg-debuginfo~1.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ekg", rpm:"ekg~1.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ekg-debuginfo", rpm:"ekg-debuginfo~1.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ekg", rpm:"ekg~1.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}