###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ipsec-tools FEDORA-2007-665
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861257);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-665");
  script_cve_id("CVE-2007-1841");
  script_name( "Fedora Update for ipsec-tools FEDORA-2007-665");
  desc = "

  Vulnerability Insight:
  This is the IPsec-Tools package.  You need this package in order to
  really use the IPsec functionality in the linux-2.5+ kernels.  This
  package builds:
  
  	- setkey, a program to directly manipulate policies and SAs
  	- racoon, an IKEv1 keying daemon


  Affected Software/OS:
  ipsec-tools on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00387.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ipsec-tools");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.6.5~8.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/ipsec-tools", rpm:"x86_64/ipsec-tools~0.6.5~8.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/ipsec-tools-debuginfo", rpm:"x86_64/debug/ipsec-tools-debuginfo~0.6.5~8.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/ipsec-tools-debuginfo", rpm:"i386/debug/ipsec-tools-debuginfo~0.6.5~8.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/ipsec-tools", rpm:"i386/ipsec-tools~0.6.5~8.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}