###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firewall_builder_priv_esc_vuln_lin.nasl 7489 2010-03-11 16:50:35Z mar $
#
# Firewall Builder Privilege Escalation Vulnerability (Linux)
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800996);
  script_version("$Revision: 7612 $: 1.0");
  script_tag(name:"cvss_base", value:"3.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-4664");
  script_bugtraq_id(36468);
  script_name("Firewall Builder Privilege Escalation Vulnerability (Linux)");
  desc = "
  Overview: The host is running Firewall Builder and is prone to Privilege
  Escalation vulnerability.

  Vulnerability Insight:
  The flaw is due to the application generating scripts, which are using
  temporary files in an insecure manner. This can be exploited to overwrite
  arbitrary files via symlink attack.

  Impact:
  Successful exploitation will allow local users to perform certain actions
  with escalated privileges.

  Impact Level: Application

  Affected Software/OS:
  Firewall Builder versions 3.0.4 to 3.0.6 on Linux.

  Fix: Update to version 3.0.7
  For updates refer, http://www.fwbuilder.org/

  References:
  http://osvdb.org/58247
  http://secunia.com/advisories/36809
  http://xforce.iss.net/xforce/xfdb/53392
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035112.html

  CVSS Score:
    CVSS Base Score      : 3.3 (AV:L/AC:M/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score  : 2.5
  Risk factor : Medium";

  script_description(desc);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Check through version of Firewall Builder");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_dependencies("gb_firewall_builder_detect_lin.nasl");
  script_require_keys("FirewallBuilder/Linux/Ver");
  exit(0);
}


include("version_func.inc");

fwbuildVer = get_kb_item("FirewallBuilder/Linux/Ver");
if(isnull(fwbuildVer)){
  exit(0);
}

#Check for versions 3.0.4 to 3.0.6
if(version_in_range(version:fwbuildVer, test_version:"3.0.4", test_version2:"3.0.6" )){
   security_warning(0);
}
