###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_justsystems_ichitaro_prdts_dos_vuln.nasl 1144 2009-04-01 17:55:26Z apr $
#
# JustSystems Ichitaro Products Denial Of Service Vulnerability.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800544);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1054");
  script_bugtraq_id(34138);
  script_name("JustSystems Ichitaro Products Denial Of Service Vulnerability");
  desc = "

  Overview: This host has JustSystems Ichitaro product(s) installed and
  is prone to denial of service vulnerability.

  Vulnerability Insight:
  JustSystems products leads to a memory corruption while handling malformed
  documents using Web PURAGUINBYUA.

  Impact:
  This issue is widely exploited by Trojan.Tarodrop.H, a Trojan horse that
  drops several files on to the compromised system leading to arbitrary
  code execution and also crashing of the application.

  Impact Level: Application

  Affected Software/OS:
  JustSystems Ichitaro 13, 2004 thruogh 2008,
  JustSystems Ichitaro viewer 5.1.5.0 on Windows.

  Fix: Apply the security patches.
  http://www.justsystems.com/jp/info/js09001.html

  *****
  NOTE: Ignore this warning, if patch is applied already.
  *****

  References:
  http://secunia.com/advisories/34405/
  http://xforce.iss.net/xforce/xfdb/49280
  http://www.symantec.com/business/security_response/writeup.jsp?docid=2009-031608-2424-99

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Ichitaro Product(s)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_justsystems_ichitaro_prdts_detect.nasl");
  script_require_keys("Ichitaro/Ver", "Ichitaro/Viewer/Ver");
  exit(0);
}


include("version_func.inc");

# Check for Ichitaro 13, 2004 theough 2008
ichitaroVer = get_kb_item("Ichitaro/Ver");
if(ichitaroVer)
{
  if(version_in_range(version:ichitaroVer, test_version:"2004",
                                           test_version2:"2008")||
     ichitaroVer =~ "13")
  {
    security_hole(0);
    exit(0);
  }
}

# Check for Ichitaro viewer 5.1.5.0 => 19.0.1.0 and prior
viewerVer = get_kb_item("Ichitaro/Viewer/Ver");
if(viewerVer)
{
  if(version_is_less_equal(version:viewerVer, test_version:"19.0.1.0")){
    security_hole(0);
  }
}
