###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sonic_spot_audioactive_player_bof_vuln.nasl 2567 2009-06-01 13:14:36Z jun $
#
# Sonic Spot Audioactive Player Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800572);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1815");
  script_bugtraq_id(34987);
  script_name("Sonic Spot Audioactive Player Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running Sonic Spot Audioactive Player and is prone
  to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  A boundary error occurs while processing playlist ('.mp3', '.m3u')
  files containing overly long data leading to a buffer overflow.

  Impact: Successful exploitation will let the attacker execute arbitrary
  codes in the context of the application and may cause stack overflow in
  the application.

  Affected Software/OS:
  Audioactive Player version 1.93b and prior on Windows.

  Fix:
  No solution or patch is available as on 01st June, 2009. Information
  regarding this issue will be updated once the solution details are
  available. For updates refer,
  http://www.sonicspot.com/audioactiveplayer/audioactiveplayer.html

  References:
  http://www.milw0rm.com/exploits/8701
  http://www.milw0rm.com/exploits/8698
  http://www.vupen.com/english/advisories/2009/1339

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Sonic Spot Audioactive Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_sonic_spot_audioactive_player_detect.nasl");
  script_require_keys("SonicSpot/Audoiactive/Player/Ver");
  exit(0);
}


include("version_func.inc");

audiactivepVer = get_kb_item("SonicSpot/Audoiactive/Player/Ver");

if(!audiactivepVer){
  exit(0);
}

# Check for version 1.93b and prior
if(version_is_less_equal(version:audiactivepVer, test_version:"1.93b")){
  security_hole(0);
}
