###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_authorization_service_dos_vuln_win.nasl 5350 2009-10-21 10:33:04Z oct $
#
# VMware Authorization Service Denial of Service Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801027);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3707");
  script_name("VMware Authorization Service Denial of Service Vulnerability (Win)");
  desc = "

  Overview: The host is installed with VMWare product(s) that are vulnerable to
  Denial of Service vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to an error in the VMware Authorization
  Service when processing login requests. This can be exploited to terminate
  the 'vmware-authd' process via 'USER' or 'PASS' strings containing '\xFF'
  characters, sent to TCP port 912.

  Impact:
  Successful exploitation allow attackers to execute arbitrary code on the
  affected application and causes the Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  VMware ACE 2.5.3 and prior.
  VMware Player 2.5.3 build 185404 and prior.
  VMware Workstation 6.5.3 build 185404 and prior.

  Fix: No solution or patch is available as on 22nd October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.vmware.com/

  References:
  http://secunia.com/advisories/36988
  http://securitytracker.com/alerts/2009/Oct/1022997.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  script_require_keys("VMware/Win/Installed", "VMware/Player/Win/Ver",
                      "VMware/Workstation/Win/Ver", "VMware/ACE/Win/Ver");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Win/Installed")){
  exit(0);
}

# VMware Player
vmpVer = get_kb_item("VMware/Player/Win/Ver");
if(vmpVer)
{
  if(version_in_range(version:vmpVer, test_version:"2.0", test_version2:"2.5.3"))
  {
    security_warning(0);
    exit(0);
  }
}

# VMware Workstation
vmwtnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmwtnVer)
{
  if(version_in_range(version:vmwtnVer, test_version:"6.0", test_version2:"6.5.3"))
  {
    security_warning(0);
    exit(0);
  }
}

# VMware ACE
aceVer = get_kb_item("VMware/ACE/Win/Ver");
if(aceVer)
{
  if(version_in_range(version:aceVer, test_version:"2.0", test_version2:"2.5.3")){
    security_warning(0);
  }
}
