///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __LAMMPS_DUMP_WRITER_SETTINGS_DIALOG_H
#define __LAMMPS_DUMP_WRITER_SETTINGS_DIALOG_H

#include <core/Core.h>
#include <core/gui/SpinnerWidget.h>
#include "LAMMPSDumpWriter.h"
#include "../ChannelColumnMappingEditor.h"

namespace AtomViz {

/******************************************************************************
* This dialog box lets the user adjust the settings of the LAMMPS dump file writer.
******************************************************************************/
class LAMMPSDumpWriterSettingsDialog : public QDialog
{
	Q_OBJECT
	
public:
	/// Constructor.
	LAMMPSDumpWriterSettingsDialog(LAMMPSDumpWriter* writer, AtomsObject* atomsObj, QWidget* parent = 0);

protected Q_SLOTS:

	/// This is called when the user has pressed the OK button.
	void onOk();

protected:

	/// The writer whos settings are being edited.
	intrusive_ptr<LAMMPSDumpWriter> writer;
	
	SpinnerWidget* startTimeSpinner;
	SpinnerWidget* endTimeSpinner;
	QButtonGroup* multiframeButtonGroup;
	QLineEdit* wildcardTextbox;
	ChannelColumnMappingEditor* mappingEditor;	
};

};	// End of namespace AtomViz

#endif // __LAMMPS_DUMP_WRITER_SETTINGS_DIALOG_H
