package TkAB;

#
# $Id: TkAB.pm,v 2.2 1999/02/02 22:57:26 bodo Exp $
#
# graphical interface to data created by
# SyncAB, part of PilotManager.
# Userinterface funktions.
#
# (C) 1998, 1999 Bodo Bellut bodo@garfield.ping.de
#                      http://www.ping.de/sites/garfield/pilotmgr.html
#
# Partly based on SyncAB and PilotManager.
# 
# SyncAB contains the following notices:
# -----cut----- 
# Address Book conduit for PilotManager
# 3/17/98 Alan.Harder@Sun.COM
# http://www.moshpit.org/pilotmgr
# -----cut----- 
#
# PilotManager contains the following notices:
# -----cut-----
# Copyright (c) 1997 Sun Microsystems, Inc.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL SUN MICROSYSTEMS, INC. BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN
# MICROSYSTEMS, INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# SUN MICROSYSTEMS, INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED
# HEREUNDER IS ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS, INC. HAS NO
# OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
# MODIFICATIONS.
# -----cut-----
#
# The new code is placed under the GPL,             
# so the following applies:
# -----cut-----
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# -----cut-----
#
# This is a standalone program and not part of PilotManager, although
# it uses part of the data created by it, and is intended to be used
# alongside with it.
#

# Add path here
use lib "/tmp-mnt/home/bodo/pilot/pilotmgr/lib/perl5";
# nothing to modify beyond this line

use strict;
use TkUtils;

require Tk::Dialog;
require Tk::Font;


##############################################################################
#
# GUI code
#
##############################################################################

############# globals ###############
## database fields:
my ($gLastName);
my ($gFirstName);
my ($gCompany);
my ($gAddress);
my ($gCity);
my ($gState);
my ($gZIP);
my ($gCountry);
my ($gTitle);
my (@gPhone);
my (@gCustom);
my ($gNote);
my ($gCategory);
my ($gNewCategory);
my ($gWPhone);
my (@gPhoneLabels);
my ($gPrivate);


## copy of database fields
## used to recognize fields have changed
## THIS IS A HACK!!
my ($gLastName_SAVE);
my ($gFirstName_SAVE);
my ($gCompany_SAVE);
my ($gAddress_SAVE);
my ($gCity_SAVE);
my ($gState_SAVE);
my ($gZIP_SAVE);
my ($gCountry_SAVE);
my ($gTitle_SAVE);
my (@gPhone_SAVE);
my (@gCustom_SAVE);
my ($gNote_SAVE);
my ($gCategory_SAVE);
my ($gWPhone_SAVE);
my (@gPhoneLabels_SAVE);
my ($gPrivate_SAVE);


## UI globals
my ($gWm);			# Main window
my ($gAboutDialog);		# About PilotManager Dialog
my ($gDocDialog);		# PilotManager Document Reader Dialog
my ($gDocText);			# Contents of DocDialog text window
my ($gDocTitle);		# Title of DocDialog text window
my ($gGotoDialog);		# Goto Dialog and associated variables
my ($gGotoDialogDisplayed);
my ($gGotoNewRecNo);
my ($gSearchDialog);		# Search Dialog and associated variables
my ($gSearchDialogDisplayed);
my ($gRecSearchFor);
my ($gRenameDialog);		# Rename Custom Dialog and associated variables
my ($gRenameDialogDone);
my (@gCustomNames);
my (@gCustomLabel);
my ($gEditCategoriesDialog);	# Edit Categories Dialog and ass. vars
my ($gEditCategoriesDone);
my ($gCategoryList);
my ($gEditCategoriesNameDialog);
my ($gEditCategoriesNameLabel);
my ($gEditCategoriesNameDone);
my ($gEditCategoriesName);
my ($gListViewDialog);		# ListView Dialog and ass. vars
my ($gListViewDialogDisplayed);
my ($gListViewList);

my ($gCategoryMenu);
my ($gWPhoneMenu);
my (@gPhoneMenu);

my (@gCatList);
my ($catMenu);			# Why must this be global?

my ($gListViewMenu);
my ($gListViewCategory);
my ($gNewListViewCategory);

my ($gDispMode) = 0;		# display public/private/all records

############# end of globals ########

sub createGUI
{
    my (@frame);
    my ($menu);
    my ($label);
    my ($button);
    my ($obj);

    my (@FILEMENU) =
	(
	 "Load...", [],
	 "Save...", [],
	 "ListView...", [],
	 "-", [],
	 "Quit", [],
	 );

    my (@EDITMENU) =
	(
	 "New record...", [],
	 "Delete record...", [],
	 "Search record...", [],
	 "-", [],
	 "Rename custom fields...", [],
	 "Edit categories...", [],
	 "-", [],
	 "Cut", [],
	 "Copy", [],
	 "Paste", [],
	);

    my (@HELPMENU) =
	(
	 "About...", [],
	 "-", [],
	 "Copyright...", [],
	 );

    my (@PHONEMENU) =
	(
	 "Work", [],
	 "Home", [],
	 "Fax", [],
	 "Other", [],
	 "E-mail", [],
	 "Main", [],
	 "Pager", [],
	 "Mobile", []
	);

    my (@CATEGORYMENU) =
	(
	 "Unfiled" , [],
	 "Business", [],
	 "Personal", [],
	 "QuickList", [],
	);

    #########################################
    # Main Window
    #########################################


    $gWm = MainWindow->new;
    $gWm->title("Address Book");
    $gWm->bind("<Destroy>", sub { if ($_[0] eq $gWm) { &quit; } });

    $frame[0] = $gWm->Frame(-relief => "raised",
			    -borderwidth => 2);


    $menu = &Menu($frame[0], "File", \&menuChoice, @FILEMENU);
    $menu->configure(-relief => "flat");
    $menu->cget(-menu)->configure(-tearoff => 0);
    $menu->pack(-side => "left");

    $menu = &Menu($frame[0], "Edit", \&menuChoice, @EDITMENU);
    $menu->configure(-relief => "flat");
    $menu->cget(-menu)->configure(-tearoff => 0);
    $menu->pack(-side => "left");

    $menu = $frame[0]->Menubutton(-text => "Display",
				  -relief => "flat");
    $menu->radiobutton(-label => "Public",
		       -value => "1",
		       -variable => \$gDispMode,
		       -command => \&dispModeChanged);
    $menu->radiobutton(-label => "Private",
		       -value => "2",
		       -variable => \$gDispMode,
		       -command => \&dispModeChanged);
    $menu->radiobutton(-label => "All",
		       -value => "0",
		       -variable => \$gDispMode,
		       -command => \&dispModeChanged);
#    $menu->cget(-menu)->configure(-tearoff => 0);
    $menu->pack(-anchor => "nw",
		-side => "left");

    $menu = &Menu($frame[0], "Help", \&menuChoice, @HELPMENU);
    $menu->configure(-relief => "flat");
    $menu->cget(-menu)->configure(-tearoff => 0);
    $menu->pack(-side => "right");


    $frame[0]->pack(-side => "top",
		    -fill => "x");

    $frame[0] = $gWm->Frame;

    $frame[1] = $frame[0]->Frame;
    $frame[2] = $frame[0]->Frame;
    $frame[3] = $frame[0]->Frame;
    $frame[4] = $frame[0]->Frame;

    $label = TkUtils::Label($frame[1], "Last Name");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "First Name");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Company");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Address");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "City");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "State");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "ZIP Code");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Country");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Title");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Category");
    $label->pack(-side => "top");
    $label = TkUtils::Label($frame[1], "Private");
    $label->pack(-side => "left");

    $frame[1]->pack(-side => "left");

    $obj = $frame[2]->Entry(-textvariable => \$gLastName, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gFirstName, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gCompany, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gAddress, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gCity, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gState, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gZIP, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gCountry, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[2]->Entry(-textvariable => \$gTitle, -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');

    $gCategoryMenu = &Menu($frame[2], 
		       $gCategory || $CATEGORYMENU[0], 
		       sub{
			   ($gCategory = $_[0]) =~ s|.*/ ||;
			   $gCategoryMenu->configure(-text => $gCategory);
			   },
		       @CATEGORYMENU);
    $gCategoryMenu->configure(-bd => 2);
    $gCategoryMenu->cget(-menu)->configure(-tearoff => 0);
    $gCategoryMenu->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");
    
    $obj = $frame[2]->Checkbutton(-offvalue => "",
				  -onvalue  => "1",
				  -bd => 2,
				  -variable => \$gPrivate);
    $obj->pack(-side => "left",
	       -anchor => "w");

    $frame[2]->pack(-side => "left");


    $gPhoneMenu[0] = &Menu($frame[3], 
		       $gPhoneLabels[0] || $PHONEMENU[0], 
		       sub{
			   ($gPhoneLabels[0] = $_[0]) =~ s|.*/ ||;
			   $gPhoneMenu[0]->configure(-text => $gPhoneLabels[0]);
			   },
		       @PHONEMENU);
    $gPhoneMenu[0]->configure(-bd => 2);
    $gPhoneMenu[0]->cget(-menu)->configure(-tearoff => 0);
    $gPhoneMenu[0]->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");

    $gPhoneMenu[1] = &Menu($frame[3], 
		       $gPhoneLabels[1] || $PHONEMENU[0], 
		       sub{
			   ($gPhoneLabels[1] = $_[0]) =~ s|.*/ ||;
			   $gPhoneMenu[1]->configure(-text => $gPhoneLabels[1]);
			   },
		       @PHONEMENU);
    $gPhoneMenu[1]->configure(-bd => 2);
    $gPhoneMenu[1]->cget(-menu)->configure(-tearoff => 0);
    $gPhoneMenu[1]->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");

    $gPhoneMenu[2] = &Menu($frame[3], 
		       $gPhoneLabels[2] || $PHONEMENU[0], 
		       sub{
			   ($gPhoneLabels[2] = $_[0]) =~ s|.*/ ||;
			   $gPhoneMenu[2]->configure(-text => $gPhoneLabels[2]);
			   },
		       @PHONEMENU);
    $gPhoneMenu[2]->configure(-bd => 2);
    $gPhoneMenu[2]->cget(-menu)->configure(-tearoff => 0);
    $gPhoneMenu[2]->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");

    $gPhoneMenu[3] = &Menu($frame[3], 
		       $gPhoneLabels[3] || $PHONEMENU[0], 
		       sub{
			   ($gPhoneLabels[3] = $_[0]) =~ s|.*/ ||;
			   $gPhoneMenu[3]->configure(-text => $gPhoneLabels[3]);
			   },
		       @PHONEMENU);
    $gPhoneMenu[3]->configure(-bd => 2);
    $gPhoneMenu[3]->cget(-menu)->configure(-tearoff => 0);
    $gPhoneMenu[3]->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");

    $gPhoneMenu[4] = &Menu($frame[3], 
		       $gPhoneLabels[4] || $PHONEMENU[0], 
		       sub{
			   ($gPhoneLabels[4] = $_[0]) =~ s|.*/ ||;
			   $gPhoneMenu[4]->configure(-text => $gPhoneLabels[4]);
			   },
		       @PHONEMENU);
    $gPhoneMenu[4]->configure(-bd => 2);
    $gPhoneMenu[4]->cget(-menu)->configure(-tearoff => 0);
    $gPhoneMenu[4]->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");

    $gCustomLabel[0] = TkUtils::Label($frame[3], "Custom 1");
    $gCustomLabel[0]->pack(-side => "top");
    $gCustomLabel[1] = TkUtils::Label($frame[3], "Custom 2");
    $gCustomLabel[1]->pack(-side => "top");
    $gCustomLabel[2] = TkUtils::Label($frame[3], "Custom 3");
    $gCustomLabel[2]->pack(-side => "top");
    $gCustomLabel[3] = TkUtils::Label($frame[3], "Custom 4");
    $gCustomLabel[3]->pack(-side => "top");
    $label = TkUtils::Label($frame[3], "WhichPhone");
    $label->pack(-side => "top");

    $frame[3]->pack(-side => "left",
		    -anchor => "n");

    $obj = $frame[4]->Entry(-textvariable => \$gPhone[0], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gPhone[1], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gPhone[2], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gPhone[3], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gPhone[4], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gCustom[0], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gCustom[1], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gCustom[2], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');
    $obj = $frame[4]->Entry(-textvariable => \$gCustom[3], -width => 15, -bd => 2);
    $obj->bind("<Return>", 'focusNext');
    $obj->pack(-side => 'top');

    $gWPhoneMenu = &Menu($frame[4], 
		       $gWPhone || $PHONEMENU[0], 
		       sub{
			   ($gWPhone = $_[0]) =~ s|.*/ ||;
			   $gWPhoneMenu->configure(-text => $gWPhone);
			   },
		       @PHONEMENU);
    $gWPhoneMenu->configure(-bd => 2);
    $gWPhoneMenu->cget(-menu)->configure(-tearoff => 0);
    $gWPhoneMenu->pack(-side => "top",
		     -expand => "true",
		     -fill => "x");
    
    $frame[4]->pack(-side => "left",
		    -anchor => "n");
    
    $frame[0]->pack(-expand => "true",
    		    -fill => "both");


    $frame[0] = $gWm->Frame;
    $button = TkUtils::Button($frame[0], "Search...",
				sub{ &buttonChoice("SearchRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], "Goto...",
				sub { &buttonChoice("GotoRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], "New",
				sub{ &buttonChoice("NewRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], "Delete...",
				sub{ &buttonChoice("DelRec") });
    $button->pack(-side => 'left');
    $frame[0]->pack(-side => 'bottom');


    $frame[0] = $gWm->Frame;
    $button = TkUtils::Button($frame[0], "|<",
				sub{ &buttonChoice("FirstRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], "<",
				sub{ &buttonChoice("BackRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], ">",
				sub{ &buttonChoice("ForRec") });
    $button->pack(-side => 'left');
    $button = TkUtils::Button($frame[0], ">|",
				sub{ &buttonChoice("LastRec") });
    $button->pack(-side => 'left');
    $frame[0]->pack(-side => 'bottom');


    $frame[0] = $gWm->Frame;
    ($gNote, $label) = TkUtils::Text($frame[0], "Note");
    $gNote->configure(-wrap => "word",
		      -width => "50",
		      -bd => 2);
    $gNote->parent->pack(-fill => "both",
			 -expand => "true");
    $gNote->pack(-fill => "both",
    		 -expand => "true");
    $frame[0]->pack(-side => "bottom");
    
    $gWm->iconname("Address Book");
}

sub displayRecord
{
    my ($db, $recNo) = @_;
    $recNo = 0 unless defined $recNo;
    my (@rec) = @{$db->{'__RECORDS'}[$recNo]->{'entry'}};
    my (@pl)  = @{$db->{'__RECORDS'}[$recNo]->{'phoneLabel'}};
    my ($ai)  = $db->{'__APPINFO'};


    $gLastName  = $rec[ 0];
    $gFirstName = $rec[ 1];
    $gCompany   = $rec[ 2];
    $gPhone[0]  = $rec[ 3];
    $gPhone[1]  = $rec[ 4];
    $gPhone[2]  = $rec[ 5];
    $gPhone[3]  = $rec[ 6];
    $gPhone[4]  = $rec[ 7];
    $gAddress   = $rec[ 8];
    $gCity      = $rec[ 9];
    $gState     = $rec[10];
    $gZIP       = $rec[11];
    $gCountry   = $rec[12];
    $gTitle     = $rec[13];
    $gCustom[0] = $rec[14];
    $gCustom[1] = $rec[15];
    $gCustom[2] = $rec[16];
    $gCustom[3] = $rec[17];

    $gCategory  = $ai->{'categoryName'}[$db->{'__RECORDS'}[$recNo]->{'category'}];
    $gWPhone    = $ai->{'phoneLabel'}[$db->{'__RECORDS'}[$recNo]->{'showPhone'}];
    $gPhoneLabels[0] = $ai->{'phoneLabel'}[$pl[0]];
    $gPhoneLabels[1] = $ai->{'phoneLabel'}[$pl[1]];
    $gPhoneLabels[2] = $ai->{'phoneLabel'}[$pl[2]];
    $gPhoneLabels[3] = $ai->{'phoneLabel'}[$pl[3]];
    $gPhoneLabels[4] = $ai->{'phoneLabel'}[$pl[4]];
    
    $gPrivate = $db->{'__RECORDS'}[$recNo]->{'secret'};
    

    $gCategoryMenu->configure(-text => $gCategory);
    $gPhoneMenu[0]->configure(-text => $gPhoneLabels[0]);
    $gPhoneMenu[1]->configure(-text => $gPhoneLabels[1]);
    $gPhoneMenu[2]->configure(-text => $gPhoneLabels[2]);
    $gPhoneMenu[3]->configure(-text => $gPhoneLabels[3]);
    $gPhoneMenu[4]->configure(-text => $gPhoneLabels[4]);
    $gWPhoneMenu->configure(-text => $gWPhone);

    $gNote->delete("0.0", 'end');
    $gNote->insert('end', $rec[18]);

    &SAVE_rec;
}

sub updateAIData
{
    my ($ai) = @_;
    my ($i);
    my ($catMenu) = $gCategoryMenu->cget(-menu);
    my ($cmd) = sub{ ($gCategory = $_[0]) =~ s|.*/ ||;
		     $gCategoryMenu->configure(-text => $gCategory);
		   };

    return unless defined($ai);

    $catMenu->delete(0, 'last');
    for ($i=0; $i <= $#{$ai->{'categoryName'}}; $i++) {
	if ($ai->{'categoryName'}[$i] ne '') {
	    $gCategoryMenu->command(-label => $ai->{'categoryName'}[$i],
				    -command => eval qq{sub{\&\$cmd("$ai->{'categoryName'}[$i] / $ai->{'categoryName'}[$i]")}});
	}
    }
    $gCategoryMenu->configure(-text => $gCategory);

    &updateListViewCategory(@{$ai->{'categoryName'}});

    $gCustomLabel[0]->configure(-text => $ai->{'label'}[14]);
    $gCustomLabel[1]->configure(-text => $ai->{'label'}[15]);
    $gCustomLabel[2]->configure(-text => $ai->{'label'}[16]);
    $gCustomLabel[3]->configure(-text => $ai->{'label'}[17]);
}

sub createGotoDialog
{
    my (@frame);
    my ($label);
    my ($obj);

    return if ((defined($gGotoDialogDisplayed)) && ($gGotoDialogDisplayed == 1));

    unless (defined($gGotoDialog) && $gGotoDialog->Exists)
    {
	$gGotoDialog = $gWm->Toplevel(-title => "Goto record");
	$gGotoDialog->transient($gWm);
	
	$frame[0] = $gGotoDialog->Frame;
	$frame[1] = $frame[0]->Frame;
	$frame[2] = $frame[0]->Frame;
	
	$label = TkUtils::Label($frame[1], "Record N");
	$label->pack(-side => "top");
	$frame[1]->pack(-side => "left");
	
	$obj = $frame[2]->Entry(-textvariable => \$gGotoNewRecNo,
				-width => 15);
	$obj->bind("<Return>", sub { &main::gotoRecord($gGotoNewRecNo); });
	$obj->focus();
	$obj->pack(-side => "top");
	$frame[2]->pack(-side => "left");
	$frame[0]->pack(-side => "top");
	
	$frame[0] = $gGotoDialog->Frame;

	$obj = $frame[0]->Button(-text => 'Apply',
				 -command => sub { &main::gotoRecord($gGotoNewRecNo); });
	$obj->pack(-side => "left");
	
	$obj = $frame[0]->Button(-text => 'Dismiss',
				 -command => sub { $gGotoDialog->withdraw;
						   $gGotoDialogDisplayed = 0;
						 } );
	$obj->pack(-side => "left");
	$frame[0]->pack(-side => "bottom");
    }
    
    $gGotoDialogDisplayed = 1;
    $gGotoDialog->Popup(-popanchor => 'c',
			-popover => $gWm,
			-overanchor => 'c');
}

sub createSearchDialog
{
    my (@frame);
    my ($label);
    my ($obj);

    return if ((defined($gSearchDialogDisplayed)) && ($gSearchDialogDisplayed == 1));

    unless (defined($gSearchDialog) && $gSearchDialog->Exists)
    {
	$gSearchDialog = $gWm->Toplevel(-title => "Search record");
	$gSearchDialog->transient($gWm);
	
	$frame[0] = $gSearchDialog->Frame;
	$frame[1] = $frame[0]->Frame;
	$frame[2] = $frame[0]->Frame;
	
	$label = TkUtils::Label($frame[1], "Search for");
	$label->pack(-side => "top");
	$frame[1]->pack(-side => "left");
	
	$obj = $frame[2]->Entry(-textvariable => \$gRecSearchFor,
				-width => 15);
	$obj->bind("<Return>", sub { &main::searchRecord($gRecSearchFor); });
	$obj->focus();
	$obj->pack(-side => "top");
	$frame[2]->pack(-side => "left");
	$frame[0]->pack(-side => "top");
	
	$frame[0] = $gSearchDialog->Frame;

	$obj = $frame[0]->Button(-text => 'Apply',
				 -command => sub { &main::searchRecord($gRecSearchFor); });
	$obj->pack(-side => "left");
	
	$obj = $frame[0]->Button(-text => 'Dismiss',
				 -command => sub { $gSearchDialog->withdraw;
						   $gSearchDialogDisplayed = 0;
						 } );
	$obj->pack(-side => "left");
	$frame[0]->pack(-side => "bottom");
    }
    
    $gSearchDialogDisplayed = 1;
    $gSearchDialog->Popup(-popanchor => 'c',
			-popover => $gWm,
			-overanchor => 'c');
}

sub createRenameCustomDialog
{
    my (@frame);
    my ($label);
    my ($obj);

    unless (defined($gRenameDialog) && $gRenameDialog->Exists)
    {
	$gRenameDialog = $gWm->Toplevel(-title => "Rename custom fields");
	$gRenameDialog->transient($gWm);
	
	$frame[0] = $gRenameDialog->Frame;
	$frame[1] = $gRenameDialog->Frame;
	
	$label = TkUtils::Label($frame[0], "Custom 1");
	$label->pack(-side => "top");
	$label = TkUtils::Label($frame[0], "Custom 2");
	$label->pack(-side => "top");
	$label = TkUtils::Label($frame[0], "Custom 3");
	$label->pack(-side => "top");
	$label = TkUtils::Label($frame[0], "Custom 4");
	$label->pack(-side => "top");
	$frame[0]->pack(-side => "left");
	
	$obj = $frame[1]->Entry(-textvariable => \$gCustomNames[0],
				-width => 15);
	$obj->bind("<Return>", 'focusNext');
	$obj->pack(-side => "top");
	$obj = $frame[1]->Entry(-textvariable => \$gCustomNames[1],
				-width => 15);
	$obj->bind("<Return>", 'focusNext');
	$obj->pack(-side => "top");
	$obj = $frame[1]->Entry(-textvariable => \$gCustomNames[2],
				-width => 15);
	$obj->bind("<Return>", 'focusNext');
	$obj->pack(-side => "top");
	$obj = $frame[1]->Entry(-textvariable => \$gCustomNames[3],
				-width => 15);
	$obj->bind("<Return>", 'focusNext');
	$obj->pack(-side => "top");
	$frame[1]->pack(-side => "left");
	
	$frame[0] = $gRenameDialog->Frame;
	$obj = $frame[0]->Button(-text => 'Ok',
				 -command => sub { $gRenameDialogDone = 1; });
	$obj->pack(-side => "left");
	$obj = $frame[0]->Button(-text => 'Cancel',
				 -command => sub { $gRenameDialogDone = 2; });
	$obj->pack(-side => "left");
	$frame[0]->pack(-side => "bottom");
    }
    
    $gCustomNames[0] = $gCustomLabel[0]->cget(-text);
    $gCustomNames[1] = $gCustomLabel[1]->cget(-text);
    $gCustomNames[2] = $gCustomLabel[2]->cget(-text);
    $gCustomNames[3] = $gCustomLabel[3]->cget(-text);
    $gRenameDialogDone = 0;
    $gRenameDialog->Popup(-popanchor => 'c',
			-popover => $gWm,
			-overanchor => 'c');
    $gRenameDialog->grab;
    $gRenameDialog->waitVariable(\$gRenameDialogDone);
    $gRenameDialog->grabRelease;
    $gRenameDialog->withdraw;
    
    if ($gRenameDialogDone == 1)
    {
	$gCustomLabel[0]->configure(-text => $gCustomNames[0]);
	$gCustomLabel[1]->configure(-text => $gCustomNames[1]);
	$gCustomLabel[2]->configure(-text => $gCustomNames[2]);
	$gCustomLabel[3]->configure(-text => $gCustomNames[3]);
	&main::updateAI( { 'customNames' => [ @gCustomNames[0..3] ],
			   'categoryNames' => [] } );
    }
}

sub createEditCategoriesDialog
{
    my (@frame);
    my ($label);
    my ($obj);

    my ($last);
    my ($name);
    my ($i);

    unless (defined($gEditCategoriesDialog) && $gEditCategoriesDialog->Exists)
    {
	$gEditCategoriesDialog = $gWm->Toplevel(-title => "Edit categories");
	$gEditCategoriesDialog->transient($gWm);
	
	$frame[0] = $gEditCategoriesDialog->Frame;
	$frame[1] = $gEditCategoriesDialog->Frame;
	
	($gCategoryList, $label) = TkUtils::List($frame[0], "Categories", "vertical");
	$gCategoryList->configure(-height => 16);
	$gCategoryList->pack(-fill => "both",
			     -expand => "true");
	$frame[0]->pack(-side => "top",
			-expand => "true",
			-fill => "both");
	
	$obj = $frame[1]->Button(-text => 'Ok',
				 -command => sub { $gEditCategoriesDone = 1; });
	$obj->pack(-side => "left");
	$obj = $frame[1]->Button(-text => 'New',
				 -command => \&EditCategoriesNew);
	$obj->pack(-side => "left");
	$obj = $frame[1]->Button(-text => 'Rename',
				 -command => \&EditCategoriesRename);
	$obj->pack(-side => "left");
	$obj = $frame[1]->Button(-text => 'Delete',
				 -command => \&EditCategoriesDelete);
	$obj->pack(-side => "left");
	$frame[1]->pack(-side => "bottom");
    }

    $catMenu = $gCategoryMenu->cget(-menu);
    $last = $catMenu->index("last");
    return if ($last eq 'none');

    $gCategoryList->delete(0, "end");
    splice(@gCatList, 0);  # empty gCatList
    for ($i=0; $i <= $last; $i++) {
	$name = $catMenu->entrycget($i, "-label");
	push(@gCatList, $name) if (defined $name);
	$gCategoryList->insert("end", $name) if ((defined $name) and ($name ne "Unfiled"));
    }

    $gEditCategoriesDone = 0;
    $gNewCategory = "";
    $gNewListViewCategory = "";
    $gEditCategoriesDialog->Popup(-popanchor => 'c',
				  -popover => $gWm,
				  -overanchor => 'c');
    $gEditCategoriesDialog->grab;
    $gEditCategoriesDialog->waitVariable(\$gEditCategoriesDone);
    $gEditCategoriesDialog->grabRelease;
    $gEditCategoriesDialog->withdraw;
    
    if ($gEditCategoriesDone == 1)
    {

	&main::updateAI( { 'categoryNames' => [@gCatList],
			   'customNames' => [] } );

	$gListViewCategory = $gNewListViewCategory unless ($gNewListViewCategory eq "");
	$gCategory = $gNewCategory unless ($gNewCategory eq "");

	if (! &main::categoryExists($gCategory)) {
	    $gCategory = "Unfiled";
	}

	$gCategoryMenu->configure(-text => $gCategory);

	&updateListViewCategory(@gCatList);

    }
}

sub EditCategoriesAskForName
{
    my ($oldName) = @_;

    my (@frame);
    my ($obj);

    unless (defined($gEditCategoriesNameDialog) && $gEditCategoriesNameDialog->Exists)
    {
	$gEditCategoriesNameDialog = $gWm->Toplevel(-title => "Edit categories");
	$gEditCategoriesNameDialog->transient($gWm);
	
	$frame[0] = $gEditCategoriesNameDialog->Frame;
	$frame[1] = $gEditCategoriesNameDialog->Frame;
	
	$gEditCategoriesNameLabel = TkUtils::Label($frame[0], "Enter new category name");
	$gEditCategoriesNameLabel->pack(-side => "top");
	$obj = $frame[0]->Entry(-textvariable => \$gEditCategoriesName,
				-width => 15);
	$obj->bind("<Return>", sub { $gEditCategoriesNameDone = 1; });
	$obj->focus();
	$obj->pack(-side => "bottom");
	$frame[0]->pack(-side => "top");
	
	$obj = $frame[1]->Button(-text => 'Ok',
				 -command => sub { $gEditCategoriesNameDone = 1; });
	$obj->pack(-side => "left");
	$obj = $frame[1]->Button(-text => 'Cancel',
				 -command => sub { $gEditCategoriesNameDone = 2; });
	$obj->pack(-side => "left");
	$frame[1]->pack(-side => "bottom");
    }
    
    if (defined($oldName)) {
	$gEditCategoriesNameLabel->configure(-text => "Enter new category name");
	$gEditCategoriesName = $oldName;
    } else {
	$gEditCategoriesNameLabel->configure(-text => "Enter category name");
    }

    $gEditCategoriesNameDone = 0;
    $gEditCategoriesNameDialog->Popup(-popanchor => 'c',
				      -popover => $gEditCategoriesDialog,
				      -overanchor => 'c');
    $gEditCategoriesNameDialog->grab;
    $gEditCategoriesNameDialog->waitVariable(\$gEditCategoriesNameDone);
    $gEditCategoriesNameDialog->grabRelease;
    $gEditCategoriesNameDialog->withdraw;

    $gEditCategoriesDialog->grab;  # Ugh!
    
    return $gEditCategoriesName if ($gEditCategoriesNameDone == 1);
    return undef;
}

sub CategoryInvalid
{
    my ($cat) = @_;
    my ($i);
    
    return 1 unless defined($cat);
    
    return 1 if ($cat eq "Unfiled");
    
    for ($i=0; $i <= scalar(@gCatList)-1; $i++) {
	return 1 if ($cat eq $gCatList[$i]);
    }
    
    return 0;
}

sub EditCategoriesNew
{
    my ($newName) = EditCategoriesAskForName;
    my ($cmd) = sub{ ($gCategory = $_[0]) =~ s|.*/ ||;
		     $gCategoryMenu->configure(-text => $gCategory);
		   };

    return unless defined($newName);

    if (&CategoryInvalid($newName)) {
	tellUser("Invalid category name!");
	return undef;
    }
    $gCategoryList->insert("end", $newName);
	$gCategoryMenu->command(-label => $newName,
				-command => eval qq{sub{\&\$cmd("$newName / $newName")}});
    push(@gCatList, $newName);
}

sub EditCategoriesRename
{
    my ($renIdx) = $gCategoryList->curselection;
    my ($oldName);
    my ($cmd) = sub{ ($gCategory = $_[0]) =~ s|.*/ ||;
		     $gCategoryMenu->configure(-text => $gCategory);
		   };

    unless (defined($renIdx)) {
	tellUser("Select a category first!");
	return;
    }
    $oldName = $gCategoryList->get($renIdx);

    my ($newName) = EditCategoriesAskForName($oldName);

    return unless defined($newName);
    
    if (&CategoryInvalid($newName) and &main::categoryUsed($oldName)) {
	return unless askUser("Refile $oldName to $newName?", ("Yes", "No")) eq "Yes";
	main::refile($oldName, $newName);
	$gCategoryList->delete($renIdx);
	$catMenu->delete($renIdx+1);
	splice(@gCatList, $renIdx+1, 1);
	if ($oldName eq $gListViewCategory) {
	    $gNewListViewCategory = $newName;
	}
	if ($oldName eq $gCategory) {
	    $gNewCategory = $newName;
	}
	return;
    }
    $gCategoryList->delete($renIdx);
    $catMenu->delete($renIdx+1);
    splice(@gCatList, $renIdx+1, 1);
    $gCategoryList->insert("end", $newName);
	$gCategoryMenu->command(-label => $newName,
				-command => eval qq{sub{\&\$cmd("$newName / $newName")}});
    push(@gCatList, $newName);
    if ($oldName eq $gListViewCategory) {
	$gNewListViewCategory = $newName;
    }
    if ($oldName eq $gCategory) {
	$gNewCategory = $newName;
    }
}

sub EditCategoriesDelete
{
    my ($delIdx) = $gCategoryList->curselection;
    my ($oldName);

    unless (defined($delIdx)) {
	tellUser("Select a category first!");
	return;
    }
    $oldName = $gCategoryList->get($delIdx);

    if (&main::categoryUsed($oldName)) {
	return unless askUser("Refile $oldName to Unfiled?", ("Yes", "No")) eq "Yes";
	main::refile($oldName, "Unfiled");
    }

    $gCategoryList->delete($delIdx);
    $catMenu->delete($delIdx+1);
    splice(@gCatList, $delIdx+1, 1);
}


sub createListViewDialog
{
    my (@frame);
    my ($label);
    my ($button);
    my ($obj);
    
    my (@recList);
    my ($i);
    
    return if ((defined($gListViewDialogDisplayed)) && ($gListViewDialogDisplayed == 1));

    unless (defined($gListViewDialog) && $gListViewDialog->Exists)
    {
	$gListViewDialog = $gWm->Toplevel(-title => "Address list");
	$gListViewDialog->transient($gWm);
	$frame[0] = $gListViewDialog->Frame;
	$frame[1] = $gListViewDialog->Frame;
	$frame[2] = $gListViewDialog->Frame;
	
	$label = TkUtils::Label($frame[0], "Addresses");
	$label->pack(-anchor => "c",
		     -side => "left",
		     -expand => "true",
		     -fill => "x");

	$gListViewMenu = $frame[0]->Menubutton(-text => "All",
					       -relief => "raised",
					       -tearoff => "no");

	$gListViewMenu->pack(-anchor => "ne",
			     -side => "right");

	$frame[0]->pack(-side => "top",
			-expand => "true",
			-fill => "x");
	
	$gListViewList = $frame[1]->Listbox(-selectmode => "browse");
	$obj = $frame[1]->Scrollbar(-command => [$gListViewList => "yview"]);
	$obj->pack(-side => "right",
		   -fill => "y");
	$gListViewList->configure(-yscrollcommand => [$obj => "set"]);
	$gListViewList->pack(-side => "top",
			     -expand => "true",
			     -fill => "both");
	
	$gListViewList->configure(-height => 11,
				  -width => 34,
				  -font => $gWm->Canvas()->Font(family => 'courier', slant => 'r'));
	$gListViewList->bind("<ButtonPress-1>", sub { my ($foo);
						      ($foo = $gListViewList->get($gListViewList->curselection)) =~ s/^(.*),.*$/$1/ ;
						      &main::searchRecord($foo);
						    });
	$gListViewList->pack(-fill => "both",
			     -expand => "true");
	$frame[1]->pack(-side => "top",
			-expand => "true",
			-fill => "both");
	
	$obj = $frame[2]->Button(-text => 'Dismiss',
				 -command => sub { $gListViewDialog->withdraw;
						   $gListViewDialogDisplayed = 0;
						 } );
	$obj->pack(-anchor => "c");
	$frame[2]->pack(-side => "bottom");

    }
    
    $gListViewDialogDisplayed = 1;
    @recList = &main::getAllRecs();
    $gListViewList->delete(0, "end");
    for ($i=0; $i <= $#{@recList}; $i++) {
	$gListViewList->insert("end", $recList[$i]) if (defined $recList[$i]);
    }
    

    &updateListViewCategory(&main::getAllCategories);

    $gListViewDialog->Popup(-popanchor => 'c',
			    -popover => $gWm,
			    -overanchor => 'c');
}

sub updateListView
{
    my (@recList) = &main::getAllRecs($gListViewCategory);
    my ($i);
    
    return unless ((defined($gListViewDialogDisplayed)) && ($gListViewDialogDisplayed == 1));
    
    $gListViewList->delete(0, "end");
    for ($i=0; $i <= $#{@recList}; $i++) {
	$gListViewList->insert("end", $recList[$i]) if (defined $recList[$i]);
    }
}

sub updateListViewCategory
{
    return unless (defined($gListViewMenu) && $gListViewMenu->Exists);

    my (@catList) = @_;
    
    return unless (defined(@catList));
    
    my ($lvwMenu) = $gListViewMenu->cget(-menu);
    my ($cmd) = sub{ ($gListViewCategory = $_[0]) =~ s|.*/ ||;
		     $gListViewMenu->configure(-text => $gListViewCategory);
		     &updateListView;
		   };
    my ($i);

    unshift(@catList, "All");
    $lvwMenu->delete(0, 'last');
    for ($i=0; $i <= $#catList; $i++) {
	if ($catList[$i] ne '') {
	    $gListViewMenu->command(-label => $catList[$i],
				    -command => eval qq{sub{\&\$cmd("$catList[$i] / $catList[$i]")}});
	}
    }
    if (! &main::categoryExists($gListViewCategory)) {
	$gListViewCategory = "All";
    }
    $gListViewMenu->configure(-text => $gListViewCategory);
    &updateListView;
}


sub createAboutDialog
{
    my (@frame);
    my ($label);
    my ($button);
    my (@saveLabels);

    $gAboutDialog = $gWm->Toplevel(-title => "About");
    $gAboutDialog->transient($gWm);
    $frame[0] = $gAboutDialog->Frame;

    $label = TkUtils::Label($frame[0], "Address Book");
    $label->pack(-side => 'top',
		 -anchor => 'center');
    push(@saveLabels, $label);

    $label = TkUtils::Label($frame[0], 
			    "Address Book is a graphical interface to the data\n" .
			    "created by SyncAB, part of PilotManager");
    $label->pack(-side => 'top',
		 -anchor => 'center');

    $label = TkUtils::Label($frame[0], "http://www.ping.de/sites/garfield/pilotmgr.html");
    $label->pack(-side => 'top',
		 -anchor => 'center');
    push(@saveLabels, $label);

    $label = TkUtils::Label($frame[0], 
			    "Copyright (C) 1998, 1999 Bodo Bellut\n" .
			    "bodo\@garfield.ping.de\n" .
			    "Partly based on SyncAB by Alan Harder\n" .
			    "and PilotManager by Bharat Mediratta, Alan Harder");
    $label->pack(-side => 'top',
		 -anchor => 'center');


    $button = TkUtils::Button($frame[0], "Dismiss",
			      sub{ $gAboutDialog->withdraw});
    $button->pack;

    $frame[0]->pack;

    foreach $label (@saveLabels)
    {
	$label->configure('foreground' => 'red4');
    }

    $gAboutDialog->withdraw;
}


sub showAbout
{
    &createAboutDialog
	unless (defined($gAboutDialog) && $gAboutDialog->Exists);

    $gAboutDialog->Popup(-popanchor => 'c',
			 -popover => $gWm,
			 -overanchor => 'c');
}


sub showDoc
{
    my ($doc, $title) = @_;
    my ($ret);

    unless (defined($gDocDialog) && $gDocDialog->Exists)
    {
	my (@frame);
	my ($button);
	$gDocDialog = $gWm->Toplevel(-title => "PilotManager Documentation");
	$gDocDialog->transient($gWm);
	$frame[0] = $gDocDialog->Frame;

	($gDocText, $gDocTitle) = TkUtils::Text($frame[0], $title);
	$gDocText->configure(-height => 20,
			     -state => "disabled");
	$gDocText->pack(-expand => "true",
			-fill => "both");
			     

	$button = TkUtils::Button($frame[0], "Dismiss",
				  sub{ $gDocDialog->withdraw});
	$button->pack;

	$frame[0]->pack(-expand => 'true',
			-fill => 'both');
    }

    $gDocText->configure(-state => "normal");
    $gDocText->delete("0.0", "end");

    if(open(FD, "<$doc"))
    {
	$gDocTitle->configure(-text => $title);
	while (<FD>)
	{
	    $gDocText->insert("end", $_);
	}
	close(FD);
	$ret = 1;
    }
    else
    {
	$gDocTitle->configure(-text => "Error!");
	$gDocText->insert("end", "Error loading $doc!\n"); 
	$ret = 0;
    }

    $gDocText->configure(-state => "disabled");
    $gDocDialog->Popup(-popanchor => 'c',
		       -popover => $gWm,
		       -overanchor => 'c');

    return $ret;
}


sub menuChoice
{
    my ($choice) = @_;

    ($choice eq "File / Quit") and (&main::quit && $gWm->destroy);
    ($choice eq "File / Load...") and &main::loadFile;
    ($choice eq "File / Save...") and &main::saveFile;
    ($choice eq "File / ListView...") and &createListViewDialog;
    ($choice eq "Help / About...") and &showAbout;
    ($choice eq "Help / Copyright...") and &showDoc("COPYRIGHT", "Copyright");
    ($choice eq "Edit / New record...") and &main::newRecord;
    ($choice eq "Edit / Delete record...") and &main::deleteRecord;
    ($choice eq "Edit / Search record...") and &createSearchDialog;
    ($choice eq "Edit / Rename custom fields...") and &createRenameCustomDialog;
    ($choice eq "Edit / Edit categories...") and &createEditCategoriesDialog;
    ($choice eq "Edit / Cut") and &main::cutRec;
    ($choice eq "Edit / Copy") and &main::copyRec;
    ($choice eq "Edit / Paste") and &main::pasteRec;

}

sub buttonChoice
{
    my ($choice) = @_;

    ($choice eq "SearchRec") and &createSearchDialog;
    ($choice eq "GotoRec") and &createGotoDialog;
    ($choice eq "NewRec") and &main::newRecord;
    ($choice eq "DelRec") and &main::deleteRecord;
    ($choice eq "FirstRec") and &main::firstRecord;
    ($choice eq "LastRec") and &main::lastRecord;
    ($choice eq "ForRec") and &main::forwardRecord;
    ($choice eq "BackRec") and &main::backwardRecord;

}

sub dispModeChanged
{

}

sub update
{
    $gWm->update;
}


##############################################################################
#
# Glue routines
#
##############################################################################


sub SAVE_rec
{
    $gLastName_SAVE	= $gLastName;
    $gFirstName_SAVE	= $gFirstName;
    $gCompany_SAVE	= $gCompany;
    @gPhone_SAVE	= @gPhone;
    $gAddress_SAVE	= $gAddress;
    $gCity_SAVE		= $gCity;
    $gState_SAVE	= $gState;
    $gZIP_SAVE		= $gZIP;
    $gCountry_SAVE	= $gCountry;
    $gTitle_SAVE	= $gTitle;
    @gCustom_SAVE	= @gCustom;
    $gNote_SAVE		= $gNote->get("0.0", 'end');
    $gWPhone_SAVE	= $gWPhone;
    @gPhoneLabels_SAVE	= @gPhoneLabels;
    $gCategory_SAVE	= $gCategory;
    $gPrivate_SAVE	= $gPrivate;
}

sub CHECK_rec
{
    sub CHECK_fields
    {
	my ($fld1, $fld2) = @_;
	
	return 0 unless defined($fld2);
	return 1 unless defined($fld1);
	return 0 if ($fld1 eq $fld2);
	return 1;  # they were different
    }

    sub CHECK_arrays
    {
	my ($arrays) = @_;
	my (@arr1) = @{$arrays->{'1'}};
	my (@arr2) = @{$arrays->{'2'}};
	my ($i, $j);
	
	unless (defined(@arr2)) {
	    return 0;
	}
	unless (defined(@arr1)) {
	    return 1;
	}
	$j = $#{@arr1};
	$j = $#{@arr2} if ($#{@arr2} > $j);
	for ($i=0; $i <= $j; $i++) {
	    if (CHECK_fields($arr1[$i], $arr2[$i])) {
		return 1;
	    }
	}
	return 0;
    }

    my ($tmpNote);

    return 1 if (CHECK_fields($gLastName_SAVE, $gLastName) == 1);
    return 1 if (CHECK_fields($gFirstName_SAVE, $gFirstName) == 1);
    return 1 if (CHECK_fields($gCompany_SAVE, $gCompany) == 1);
    return 1 if (CHECK_arrays( { '1' => [ @gPhone_SAVE ],
				 '2' => [ @gPhone ] } ) == 1);    
    return 1 if (CHECK_fields($gAddress_SAVE, $gAddress) == 1);
    return 1 if (CHECK_fields($gCity_SAVE, $gCity) == 1);
    return 1 if (CHECK_fields($gState_SAVE, $gState) == 1);
    return 1 if (CHECK_fields($gZIP_SAVE, $gZIP) == 1);
    return 1 if (CHECK_fields($gCountry_SAVE, $gCountry) == 1);
    return 1 if (CHECK_fields($gTitle_SAVE, $gTitle) == 1);
    return 1 if (CHECK_arrays( { '1' => [ @gCustom_SAVE ],
				 '2' => [ @gCustom ] } ) == 1);
    ($tmpNote = $gNote->get("0.0", 'end')) =~ s/^\n$//s;  # Ugh
    $tmpNote = undef if ($tmpNote eq "");
    return 1 if (CHECK_fields($gNote_SAVE, $tmpNote) == 1);
    return 1 if (CHECK_fields($gWPhone_SAVE, $gWPhone) == 1);
    return 1 if (CHECK_arrays( { '1' => [ @gPhoneLabels_SAVE ],
				 '2' => [ @gPhoneLabels ] } ) == 1);
    return 1 if (CHECK_fields($gCategory_SAVE, $gCategory) == 1);
    return 1 if (CHECK_fields($gPrivate_SAVE, $gPrivate) == 1);
    
    return 0;  # no data has changed
}

sub getAktRecord
{
    return (undef) unless &CHECK_rec == 1;
    
    my ($rec);

    $rec = { 'entry' => [],
	     'showPhone' => 0,
	     'phoneLabel' => [0,1,2,3,4],
	     'category' => 0,
	     'rolo_id' => 0,
	     'secret' => '' };
    $rec->{'entry'}->[18] = undef;  # ensure right array length



    @{$rec->{'entry'}} = ($gLastName, $gFirstName, $gCompany,
		       @gPhone[0..4], $gAddress, $gCity,
		       $gState, $gZIP, $gCountry, $gTitle,
		       @gCustom[0..3], $gNote->get("0.0", 'end'));
    $rec->{'showPhone'}  = &PhoneStrToIDX(($gWPhone));
    @{$rec->{'phoneLabel'}} = &PhoneStrToIDX(@gPhoneLabels[0..4]);
    $rec->{'category'} = &CategoryStrToIDX($gCategory);
    $rec->{'secret'} = $gPrivate;
    
    return $rec;
}

sub PhoneStrToIDX
{
    my (@PhoneStr) = @_;
    my ($pm) = $gWPhoneMenu->cget(-menu);
    my ($last) = $pm->index("last");
    my ($i);
    
    if (scalar(@PhoneStr) == 1) {
	for ($i=0; $i <= $last; $i++) {
	    if ($PhoneStr[0] eq $pm->entrycget($i, "-label")) {
		return $i;
	    }
	}
    } else {
	my (@retList);
	my ($j);
	
	for ($j=0; $j <= 4; $j++) {
	    for ($i=0; $i <= $last; $i++) {
		if ($PhoneStr[$j] eq $pm->entrycget($i, "-label")) {
		    $retList[$j] = $i;
		}
	    }
	}
	return @retList;
    }
}

sub CategoryStrToIDX
{
    my ($CategoryStr) = @_;
    my ($cm) = $gCategoryMenu->cget(-menu);
    my ($last) = $cm->index("last");
    my ($i);
    
    for ($i=0; $i <= $last; $i++) {
	if ($CategoryStr eq $cm->entrycget($i, "-label")) {
	    return $i;
	}
    }
}

sub quit
{
    exit;
}

sub askUser
{
    my ($question, @answers) = @_;
    my ($dialog, $chk);

    $dialog = $gWm->Dialog(
    		   -title  => "Riddle me this...",
    		   -text   => $question,
    		   -bitmap => 'question',
    		   -default_button => $answers[0],
    		   -buttons => [@answers]
    		   );
    $dialog->configure(-wraplength => '4i');
    $dialog->transient($gWm);
    return $dialog->Show;
}

sub tellUser
{
    my ($msg) = @_;
    my ($dialog);

    $dialog = $gWm->Dialog(
    		   -title  => "Pay attention!",
    		   -text   => $msg,
    		   -bitmap => 'info',
    		   -default_button => "Ok",
    		   -buttons => ["Ok"]
    		   );
    $dialog->configure(-wraplength => '4i');
    $dialog->transient($gWm);
    return $dialog->Show;
}


##############################################################################
#
# Main code
#
##############################################################################

1;
