/*	test_UNIX_Process

PIRL CVS ID: test_UNIX_Process.java,v 1.3 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2009-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.UNIX_Process;
import	java.io.*;


public class test_UNIX_Process
{
private static final String
	TEST_COMMAND	= "sleep";
private static int
	run_time		= 3,
	wait_time		= 1;

public static void main
	(
	String[]	args
	)
{
if (args.length > 0)
	{
	try {run_time = Integer.parseInt (args[0]);}
	catch (NumberFormatException exception) {Usage ();}
	}
if (args.length > 1)
	{
	try {wait_time = Integer.parseInt (args[1]);}
	catch (NumberFormatException exception) {Usage ();}
	}

String
	command = TEST_COMMAND + " " + run_time;
System.out.println ("Executing process: " + command);
UNIX_Process
	process = null;
try {process = new UNIX_Process
		(Runtime.getRuntime ().exec (command));}
catch (Exception exception)
	{
	System.out.println
		("Unable to execute the process.\n"
		+ exception.getMessage ());
	System.exit (2);
	}

System.out.println ("Process ID = " + process.ID ());

System.out.println
	("Waiting " + wait_time + " second" + ((wait_time == 1) ? "" : "s")
		+ " for the process to exit...");
try
	{
	int
		exit_status = process.waitFor (wait_time * 1000);
	System.out.println ("Process exit status: " + exit_status);
	}
catch (Exception exception)
	{
	System.out.println
		("An exception was thrown: " + exception);
	//	Kill the process.
	System.out.println ("Destroying the process.");
	process.destroy ();
	}

System.exit (0);
}


public static void Usage ()
{
System.out.println
	("Usage: test_UNIX_Process [<run time seconds> [<wait time seconds>]]");
System.exit (1);
}

}
