# Contributing to _pygls_

Welcome, and thank you for your interest in contributing to _pygls_!

There are many ways in which you can contribute, beyond writing code. The goal of this document is to provide a high-level overview of how you can get involved.

## Reporting Issues

Have you identified a reproducible problem in _pygls_? Have a feature request? We want to hear about it! Here's how you can make reporting your issue as effective as possible.

### Look For an Existing Issue

Before you create a new issue, please do a search in [open issues](https://github.com/openlawlibrary/pygls/issues) to see if the issue or feature request has already been filed.

Be sure to scan through the [most popular](https://github.com/openlawlibrary/pygls/issues?q=is%3Aopen+is%3Aissue+label%3Afeature-request+sort%3Areactions-%2B1-desc) feature requests.

If you find your issue already exists, make relevant comments and add your [reaction](https://github.com/blog/2119-add-reactions-to-pull-requests-issues-and-comments). Use a reaction in place of a "+1" comment:

* 👍 - upvote
* 👎 - downvote

If you cannot find an existing issue that describes your bug or feature, create a new issue using the guidelines below.

### Writing Good Bug Reports and Feature Requests

File a single issue per problem and feature request. Do not enumerate multiple bugs or feature requests in the same issue.

Do not add your issue as a comment to an existing issue unless it's for the identical input. Many issues look similar, but have different causes.

The more information you can provide, the more likely someone will be successful at reproducing the issue and finding a fix.

Please include the following with each issue:

* Reproducible steps (1... 2... 3...) that cause the issue

* What you expected to see, versus what you actually saw

* Images, animations, or a link to a video showing the issue occurring, if appropriate

* A code snippet that demonstrates the issue or a link to a code repository the developers can easily pull down to recreate the issue locally

  * **Note:** Because the developers need to copy and paste the code snippet, including a code snippet as a media file (i.e. .gif) is not sufficient.

* If using VS Code, errors from the Dev Tools Console (open from the menu: Help > Toggle Developer Tools)

### Final Checklist

Please remember to do the following:

* [ ] Search the issue repository to ensure your report is a new issue

* [ ] Simplify your code around the issue to better isolate the problem

* [ ] If you are committing a PR, please update the [changelog] and [contributors] documents, as appropriate. For the [changelog], only _notable_ changes should be added following the _[Keep a Changelog][keepachangelog]_ format.

Don't feel bad if the developers can't reproduce the issue right away. They will simply ask for more information!

## Thank You

Your contributions to open source, large or small, make great projects like this possible. Thank you for taking the time to contribute.

## Attribution

This _Contributing to pygls_ document is adapted from VS Code's _[Contributing to VS Code](https://github.com/Microsoft/vscode/blob/master/CONTRIBUTING.md)_.

[changelog]: https://github.com/openlawlibrary/pygls/blob/master/CHANGELOG.md
[contributors]: https://github.com/openlawlibrary/pygls/blob/master/CONTRIBUTORS.md
[keepachangelog]: https://keepachangelog.com/en/1.0.0/
