import numpy as np

from ase.spacegroup import crystal
from ase.io import write

# A diamond unit cell
diamond = crystal('C', [(0, 0, 0)], spacegroup=227,
                  cellpar=[3.57, 3.57, 3.57, 90, 90, 90])

# Check that we can write to trajectory:
write('c.traj', diamond)

assert len(diamond) == 8
correct_pos = np.array([[0., 0., 0.],
                        [0., 0.5, 0.5],
                        [0.5, 0.5, 0.],
                        [0.5, 0., 0.5],
                        [0.75, 0.25, 0.75],
                        [0.25, 0.25, 0.25],
                        [0.25, 0.75, 0.75],
                        [0.75, 0.75, 0.25]])
assert np.allclose(diamond.get_scaled_positions(), correct_pos)


# A CoSb3 skutterudite unit cell containing 32 atoms
skutterudite = crystal(('Co', 'Sb'),
                       basis=[(0.25, 0.25, 0.25), (0.0, 0.335, 0.158)],
                       spacegroup=204, cellpar=[9.04, 9.04, 9.04, 90, 90, 90])

assert len(skutterudite) == 32

correct_pos = np.array([[0.25, 0.25, 0.25], [0.75, 0.75, 0.25],
                        [0.75, 0.25, 0.75], [0.25, 0.75, 0.75],
                        [0.75, 0.75, 0.75], [0.25, 0.25, 0.75],
                        [0.25, 0.75, 0.25], [0.75, 0.25, 0.25],
                        [0., 0.335, 0.158], [0., 0.665, 0.158],
                        [0., 0.335, 0.842], [0., 0.665, 0.842],
                        [0.158, 0., 0.335], [0.158, 0., 0.665],
                        [0.842, 0., 0.335], [0.842, 0., 0.665],
                        [0.335, 0.158, 0.], [0.665, 0.158, 0.],
                        [0.335, 0.842, 0.], [0.665, 0.842, 0.],
                        [0.5, 0.835, 0.658], [0.5, 0.165, 0.658],
                        [0.5, 0.835, 0.342], [0.5, 0.165, 0.342],
                        [0.658, 0.5, 0.835], [0.658, 0.5, 0.165],
                        [0.342, 0.5, 0.835], [0.342, 0.5, 0.165],
                        [0.835, 0.658, 0.5], [0.165, 0.658, 0.5],
                        [0.835, 0.342, 0.5], [0.165, 0.342, 0.5]])

assert np.allclose(skutterudite.get_scaled_positions(), correct_pos)
