% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vorob.R
\name{vorobT}
\alias{vorobT}
\alias{vorobDev}
\alias{symDifPlot}
\title{Vorob'ev computations}
\usage{
vorobT(x, reference)

vorobDev(x, VE, reference)

symDifPlot(
  x,
  VE,
  threshold,
  nlevels = 11,
  ve.col = "blue",
  xlim = NULL,
  ylim = NULL,
  legend.pos = "topright",
  main = "Symmetric deviation function",
  col.fun = function(n) gray(seq(0, 0.9, length.out = n)^2)
)
}
\arguments{
\item{x}{Either a matrix of data values, or a data frame, or a list of data
frames of exactly three columns.  The third column gives the set (run,
sample, ...) identifier.}

\item{reference}{(\code{numeric()}) \cr Reference point as a vector of numerical values.}

\item{VE, threshold}{Vorob'ev expectation and threshold, e.g., as returned
by \code{\link[=vorobT]{vorobT()}}.}

\item{nlevels}{number of levels in which is divided the range of the
symmetric deviation.}

\item{ve.col}{plotting parameters for the Vorob'ev expectation.}

\item{xlim, ylim, main}{Graphical parameters, see
\code{\link[graphics:plot.default]{plot.default()}}.}

\item{legend.pos}{the position of the legend, see
\code{\link[graphics:legend]{legend()}}. A value of \code{"none"} hides the legend.}

\item{col.fun}{function that creates a vector of \code{n} colors, see
\code{\link[grDevices:palettes]{heat.colors()}}.}
}
\value{
\code{vorobT} returns a list with elements \code{threshold},
\code{VE}, and \code{avg_hyp} (average hypervolume)

\code{vorobDev} returns the Vorob'ev deviation.
}
\description{
Compute Vorob'ev threshold, expectation and deviation. Also, displaying the
symmetric deviation function is possible.  The symmetric deviation
function is the probability for a given target in the objective space to
belong to the symmetric difference between the Vorob'ev expectation and a
realization of the (random) attained set.
}
\examples{
data(CPFs)
res <- vorobT(CPFs, reference = c(2, 200))
print(res$threshold)

## Display Vorob'ev expectation and attainment function
# First style
eafplot(CPFs[,1:2], sets = CPFs[,3], percentiles = c(0, 25, 50, 75, 100, res$threshold),
        main = substitute(paste("Empirical attainment function, ",beta,"* = ", a, "\%"),
                          list(a = formatC(res$threshold, digits = 2, format = "f"))))

# Second style
eafplot(CPFs[,1:2], sets = CPFs[,3], percentiles = c(0, 20, 40, 60, 80, 100),
        col = gray(seq(0.8, 0.1, length.out = 6)^0.5), type = "area", 
        legend.pos = "bottomleft", extra.points = res$VE, extra.col = "cyan",
        extra.legend = "VE", extra.lty = "solid", extra.pch = NA, extra.lwd = 2,
        main = substitute(paste("Empirical attainment function, ",beta,"* = ", a, "\%"),
                          list(a = formatC(res$threshold, digits = 2, format = "f"))))

# Now print Vorob'ev deviation
VD <- vorobDev(CPFs, res$VE, reference = c(2, 200))
print(VD)
# Now display the symmetric deviation function.
symDifPlot(CPFs, res$VE, res$threshold, nlevels = 11)
# Levels are adjusted automatically if too large.
symDifPlot(CPFs, res$VE, res$threshold, nlevels = 200, legend.pos = "none")

# Use a different palette.
symDifPlot(CPFs, res$VE, res$threshold, nlevels = 11, col.fun = heat.colors)
}
\references{
\insertRef{BinGinRou2015gaupar}{eaf}

C. Chevalier (2013), Fast uncertainty reduction strategies relying on
Gaussian process models, University of Bern, PhD thesis.

I. Molchanov (2005), Theory of random sets, Springer.
}
\author{
Mickael Binois
}
