% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_chisq.R
\name{chisq_to_phi}
\alias{chisq_to_phi}
\alias{convert_chisq_to_phi}
\alias{phi_to_chisq}
\alias{convert_phi_to_chisq}
\alias{chisq_to_cramers_v}
\alias{convert_chisq_to_cramers_v}
\title{Conversion between Effect sizes for Contingency Tables (Chi2, Phi, Cramer's V...)}
\usage{
chisq_to_phi(chisq, n, ...)

convert_chisq_to_phi(chisq, n, ...)

phi_to_chisq(phi, n, ...)

convert_phi_to_chisq(phi, n, ...)

chisq_to_cramers_v(chisq, n, nrow, ncol, ...)

convert_chisq_to_cramers_v(chisq, n, nrow, ncol, ...)
}
\arguments{
\item{chisq}{The Chi2 statistic.}

\item{n}{Sample size.}

\item{...}{Arguments passed to or from other methods.}

\item{phi}{The Phi statistic.}

\item{nrow}{The number of rows in the contingency table.}

\item{ncol}{The number of columns in the contingency tables.}
}
\value{
A numeric value between 0-1.
}
\description{
Convert between Chi square, (\eqn{chi^2}), phi (\eqn{\phi}) and Cramer's V.
}
\details{
These functions use the following formulae:
\cr\cr
\deqn{Cramer's V = \sqrt{\chi^2 / (n * (min(nrow,ncol)-1))}}
\cr\cr
\deqn{\phi = \sqrt{\chi^2 / n}}
}
\examples{
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))

chisq.test(contingency_table)
#
#         Pearson's Chi-squared test
#
# data:  ctab
# X-squared = 41.234, df = 4, p-value = 2.405e-08

chisq_to_phi(41.234, n = sum(contingency_table))
chisq_to_cramers_v(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
}
