% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{ConfusionDF}
\alias{ConfusionDF}
\title{Confusion Matrix (Data Frame Format)}
\usage{
ConfusionDF(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
a data.frame of Confusion Matrix
}
\description{
Compute data frame format confusion matrix for internal usage.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
pred <- ifelse(logreg$fitted.values < 0.5, 0, 1)
ConfusionDF(y_pred = pred, y_true = mtcars$vs)
}
\keyword{internal}

