% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plogr-package.R
\docType{package}
\name{plogr-package}
\alias{plogr}
\alias{plogr-package}
\title{plogr: The 'plog' C++ Logging Library}
\description{
A simple header-only logging library for C++.
Add 'LinkingTo: plogr' to 'DESCRIPTION', and '#include <plogr.h>' in your C++ modules to use it.
}
\examples{
plogr_demo <- Rcpp::cppFunction(depends = "plogr", '
// C++ code begin
#include <plogr.h>

RObject plogr_demo() {
  plog::init_r(plog::info);
  LOG_INFO << "shown";
  LOG_DEBUG << "not shown";
  plog::init_r("DEBUG");
  LOG_DEBUG << "shown now";
  return R_NilValue;
}

#include <Rcpp.h> // not necessary to use plogr
// C++ code end
'
)

plogr_demo()
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/krlmlr/plogr#readme}
  \item Report bugs at \url{https://github.com/krlmlr/plogr/issues}
}

}
\author{
\strong{Maintainer}: Kirill Müller \email{krlmlr+r@mailbox.org}

Other contributors:
\itemize{
  \item Sergey Podobry (Author of the bundled plog library) [copyright holder]
}

}
