% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_package}
\alias{parse_package}
\alias{parse_file}
\alias{parse_text}
\alias{env_file}
\alias{env_package}
\title{Parse a package, file, or inline code}
\usage{
parse_package(path = ".", env = env_package(path))

parse_file(file, env = env_file(file), srcref_path = NULL)

parse_text(text, env = env_file(file))

env_file(file)

env_package(path)
}
\arguments{
\item{path, file, text}{Either specify a \code{path} to the root directory of
a package, an R \code{file}, or a character vector \code{text}.}

\item{env}{An environment environment containing the result of evaluating
the input code. The defaults will do this for you in a test environment:
for real code you'll need to generate the environment yourself.

You can also set to \code{NULL} if you only want to get the tokenized code
blocks only. This suppresses evaluation of \verb{@eval} tags, and will not
find the code object associated with each block.}
}
\value{
A list of roxy_block objects
}
\description{
\code{parse_package()}, \code{parse_file()}, and \code{parse_text()} allow you to use
roxygen's parsing code to parse the roxygen blocks from a package, file, or
character vector of code. \code{env_package()} and \code{env_file()} provide
defaults that generate a temporary environment making it possible to
associate each block with the corresponding live object.
}
\keyword{internal}
