% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.R
\name{na.locf.xts}
\alias{na.locf.xts}
\title{Last Observation Carried Forward}
\usage{
\method{na.locf}{xts}(object, na.rm = FALSE, fromLast = FALSE, maxgap = Inf, ...)
}
\arguments{
\item{object}{An xts object.}

\item{na.rm}{Logical indicating whether leading/trailing \code{NA} should be
removed. The default is \code{FALSE} unlike the zoo method.}

\item{fromLast}{Logical indicating whether observations should be carried
backward rather than forward. Default is \code{FALSE}.}

\item{maxgap}{Consecutive runs of observations more than 'maxgap' will
remain \code{NA}. See \code{\link[zoo:zoo]{na.locf()}} for details.}

\item{\dots}{Unused.}
}
\value{
An object where each \code{NA} in \code{object} is replaced by the most recent
non-NA prior to it. See \code{\link[zoo:zoo]{na.locf()}} for details.
}
\description{
\pkg{xts} method replace \code{NA} with most recent non-NA
}
\details{
This is the \pkg{xts} method for the S3 generic \code{na.locf()}. The primary
difference to note is that after the \code{NA} fill action is carried out, the
default it to leave trailing or leading \code{NA}'s in place. This is different
than \pkg{zoo} behavior.
}
\examples{

x <- xts(1:10, Sys.Date()+1:10)
x[c(1,2,5,9,10)] <- NA

x
na.locf(x)
na.locf(x, fromLast=TRUE)
na.locf(x, na.rm=TRUE, fromLast=TRUE)

}
\seealso{
\code{\link[zoo:zoo]{na.locf()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{misc}
