#lang scribble/doc
@(require "common.rkt" 
          (for-label mrlib/terminal string-constants))

@title{Terminal Window}

@defmodule[mrlib/terminal]{The @racketmodname[mrlib/terminal] library provides
a simple GUI wrapper around functions that normally would run
in command-line scripts.}

@defproc[(in-terminal [doit (-> eventspace? (is-a?/c top-level-window<%>) void?)]
                      [#:cleanup-thunk cleanup-thunk (-> void?) void]
                      [#:title title string? "mrlib/terminal"]
                      [#:abort-label abort-label string? (string-constant plt-installer-abort-installation)]
                      [#:aborted-message aborted-message string? (string-constant plt-installer-aborted)])
         void?]{
                
  Creates a dialog, sets up the current error and output ports to
  print into the dialog's contents
  and calls @racket[doit] in a separate thread under a separate
  custodian. The @racket[exit-handler] is set to a function that
  shuts down the new custodian.

  Returns before @racket[doit] is complete (unless @racket[doit]
  completes quickly);
  @racket[cleanup-thunk] is called on a queued callback to the
  eventspace active when @racket[with-installer-window] is
  invoked after @racket[doit] completes.
  
  The @racket[title] is the dialog of the dialog. In addition to the IO
  generated by @racket[doit], the dialog also contains two buttons,
  the abort button (with label @racket[abort-label]) and the close
  button (with label @racket[(string-constant close)]). When the
  abort button is pushed, the newly created custodian is shut down and
  the @racket[aborted-message] is printed in the dialog. The close
  button becomes active when @racket[doit] returns or when the thread
  running it is killed (via a custodian shut down, typically).
  
  The value of @racket[on-terminal-run] is invoked after @racket[doit]
  returns, but not if it is aborted or an exception is raised.
}

@defparam[on-terminal-run run (-> void?)]{
  Invoked by @racket[in-terminal].                                          
}