///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// geo adaptation with field interpolation
// on the new mesh
//
// author:
//      Pierre.Saramito@imag.fr
//
// date: 4 may 2001
//
// ============================================================================
//  includes
// ============================================================================

#include "rheolef/field.h"
#include "rheolef/iorheo.h"
#include "rheolef/rheostream.h" // i/o utility
#include "rheolef/form.h"
#include "rheolef/tiny_element.h"
using namespace rheolef;
using namespace std;
namespace rheolef { 

// =======================================================================
// adapt
// =======================================================================
field
adapt (const field& u0, const adapt_option_type& opt)
{
    bool verbose = iorheo::getverbose(clog);
    //
    // build adapted mesh and interpolated field
    //
    bool do_interpolate = true;
    geo g1 = geo_adapt (u0, opt, do_interpolate);
    //
    // load bamg interpolated field
    //
    string u1_name = g1.name() + ".bb";
    ifstream u1_in (u1_name.c_str());
    space V1 (g1, "P1");
    field u1 (V1);
    if (verbose) clog << "! load `" << u1_name << "'" << endl;
    u1.get_bamg_mbb (u1_in);
    u1_in.close();
    return u1;
}
}// namespace rheolef
