///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test de la classe base
//
// exemple: tst_base Q0 q

#include "rheolef/geo_element.h"
#include "rheolef/base.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv)
{

  if (argc <= 1)
    {
      cerr << "tst_base approx element_type\n" ;
      exit(1) ;
    }
  
  string a = argv[1]    ;
  char   t = argv[2][0] ;

  geo_element K;
  K.type(t) ;
  geo_element::size_type d = K.dimension() ;
  base b(a, d) ;
  
  cout << "Dimension: " << b.dimension() << "\n"
       << "nb_dof(" << t << "):" 
       << b.nb_dof(K) << "\n" ;

  geo_element S;
  if (d==2)
    S.type('e') ;
  else if (d==3)
    {
      if (t=='T')
	S.type('t') ;
      else if (t=='H')
	S.type('q') ;
    }
  cout << "nb_dof_bdr(" << S.type() << "):" 
       << b.nb_dof_bdr(S) << "\n" ;
}
