//pointer.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2009-2014
 *
 *  This file is part of RoarAudio PlayList Daemon,
 *  a playlist management daemon for RoarAudio.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _RPLD_POINTER_H_
#define _RPLD_POINTER_H_

#define POINTER_DEFAULT      0
#define POINTER_CURRENT      1
#define POINTER_STARTUP      2
#define POINTER_TEMP         3
#define POINTER_FALLBACK     4

#define POINTER_NUM          5

char                         * rpld_pointer_get_name(const int pointer, pli_t queue, const int client);
int                            rpld_pointer_parse_name(int * pointer, pli_t * queue, int * client, int client_hint, const char * name);
int                            rpld_pointer_is_set(const int pointer, pli_t queue, const int client);
struct rpld_playlist_pointer * rpld_pointer_get(const int pointer, pli_t queue, const int client);
struct rpld_playlist_pointer * rpld_pointer_get_by_name(const char * name, int client_hint);
int                            rpld_pointer_set(const int pointer, pli_t queue, const int client, struct rpld_playlist_pointer * plp);
int                            rpld_pointer_set_by_name(const char * name, int client_hint, struct rpld_playlist_pointer * plp);
struct rpld_playlist_entry   * rpld_pointer_search(const int pointer, pli_t queue, const int client);

#endif

//ll
