<?php

require_once(__DIR__ . '/DealabsBridge.php');
class HotUKDealsBridge extends PepperBridgeAbstract {

	const NAME = 'HotUKDeals bridge';
	const URI = 'https://www.hotukdeals.com/';
	const DESCRIPTION = 'Return the HotUKDeals search result using keywords';
	const MAINTAINER = 'sysadminstory';
	const PARAMETERS = array(
		'Search by keyword(s))' => array (
			'q' => array(
				'name' => 'Keyword(s)',
				'type' => 'text',
				'required' => true
			),
			'hide_expired' => array(
				'name' => 'Hide expired deals',
				'type' => 'checkbox',
			),
			'hide_local' => array(
				'name' => 'Hide local deals',
				'type' => 'checkbox',
				'title' => 'Hide deals in physical store',
			),
			'priceFrom' => array(
				'name' => 'Minimal Price',
				'type' => 'text',
				'title' => 'Minmal Price in Pounds',
				'required' => false
			),
			'priceTo' => array(
				'name' => 'Maximum Price',
				'type' => 'text',
				'title' => 'Maximum Price in Pounds',
				'required' => false
			),
		),

		'Deals per group' => array(
			'group' => array(
				'name' => 'Group',
				'type' => 'list',
				'title' => 'Group whose deals must be displayed',
				'values' => array(
					'3D Blu-ray' => '3d-bluray',
					'3D Printer' => '3d-printer',
					'3D TV' => '3d-tv',
					'4K Blu-ray' => '4k-bluray',
					'4K Monitor' => '4k-monitor',
					'4K TV' => '4k-tv',
					'5G Phones' => '5g-phones',
					'7 Up' => '7up',
					'8K TV' => '8k-tv',
					'32 inch TV' => '32-inch-tv',
					'40 inch TV' => '40-inch-tv',
					'55 inch TV' => '55-inch-tv',
					'65 inch TV' => '65-inch-tv',
					'75 inch TV' => '75-inch-tv',
					'144Hz Monitor' => '144hz',
					'A4 Paper' => 'a4-paper',
					'AAA Battery' => 'aaa',
					'AA Battery' => 'aa',
					'Abercrombie' => 'abercrombie',
					'Aberlour' => 'aberlour',
					'Accommodation' => 'accomodation',
					'Accurist' => 'accurist',
					'Ace Combat 7: Skies Unknown' => 'ace-combat-7',
					'Acer' => 'acer',
					'Acer Aspire' => 'acer-aspire',
					'Acer Laptop' => 'acer-laptop',
					'Acer PC Monitor' => 'acer-pc-monitor',
					'Acer Predator' => 'acer-predator',
					'Action Camera' => 'action-camera',
					'Action Figure &amp; Playsets' => 'playsets',
					'Activewear' => 'sports-clothes',
					'Activia' => 'activia',
					'adidas' => 'adidas',
					'adidas Continental' => 'continental',
					'Adidas Gazelle' => 'gazelle',
					'Adidas Originals' => 'adidas-originals',
					'Adidas Samba' => 'samba',
					'Adidas Stan Smith' => 'stan-smith',
					'Adidas Superstar' => 'adidas-superstar',
					'Adidas Trainers' => 'adidas-shoes',
					'Adidas Ultraboost' => 'adidas-ultraboost',
					'Adidas ZX Flux' => 'adidas-zx-flux',
					'Adobe' => 'adobe',
					'Adobe Lightroom' => 'lightroom',
					'Adobe Photoshop' => 'photoshop',
					'Adult Products' => 'adult',
					'Advent Calendar' => 'advent-calendar',
					'Adventure Time' => 'adventure-time',
					'AEG' => 'aeg',
					'Aftershave' => 'aftershave',
					'Age Of Empires' => 'age-of-empires',
					'Air Bed' => 'air-bed',
					'Air Conditioner' => 'air-con',
					'Airer' => 'airer',
					'Airfix' => 'airfix',
					'Air Fryer' => 'air-fryer',
					'Airline' => 'airline',
					'Airport' => 'airport',
					'Airport Parking' => 'airport-parking',
					'Air Purifier' => 'air-purifier',
					'AirTag' => 'airtag',
					'Air Treatment' => 'air-treatment',
					'AKG' => 'akg',
					'Alarm Clock' => 'alarm-clock',
					'Alarm System' => 'alarm-system',
					'Alcatel' => 'alcatel',
					'Alcohol' => 'alcohol',
					'Alesis' => 'alesis',
					'Alien: Isolation' => 'alien-isolation',
					'Alienware' => 'alienware',
					'All-in-One PC' => 'all-in-one-pc',
					'All-in-One Printer' => 'all-in-one-printer',
					'Alloy Wheel' => 'alloy-wheels',
					'All Saints' => 'all-saints',
					'Almonds' => 'almonds',
					'Alpro' => 'alpro',
					'Alton Towers' => 'alton-towers',
					'Amazfit' => 'xiaomi-amazfit',
					'Amazfit Bip' => 'xiaomi-amazfit-bip',
					'Amazfit GTS' => 'amazfit-gts',
					'Amazfit Verge' => 'amazfit-verge',
					'Amazfit Verge Lite' => 'amazfit-verge-lite',
					'Amazfit Watch' => 'amazfit-watch',
					'Amazon Add On Item' => 'add-on-item',
					'Amazon Business' => 'amazon-business',
					'Amazon Echo' => 'amazon-echo',
					'Amazon Echo Dot' => 'amazon-echo-dot',
					'Amazon Echo Plus' => 'amazon-echo-plus',
					'Amazon Echo Show' => 'amazon-echo-show',
					'Amazon Echo Show 5' => 'echo-show-5',
					'Amazon Echo Show 8' => 'amazon-echo-show-8',
					'Amazon Echo Spot' => 'amazon-echo-spot',
					'Amazon Fire 7' => 'amazon-fire-7',
					'Amazon Fire HD 8' => 'amazon-fire-hd-7',
					'Amazon Fire HD 10 Tablet' => 'amazon-fire-hd-10',
					'Amazon Fire Tablet' => 'amazon-tablet',
					'Amazon Fire TV Cube' => 'fire-tv-cube',
					'Amazon Fire TV Stick' => 'amazon-fire-stick',
					'Amazon Pantry' => 'amazon-pantry',
					'Amazon Prime' => 'amazon-prime',
					'Amazon Prime Video' => 'amazon-video',
					'Amazon Warehouse' => 'amazon-warehouse',
					'AMD' => 'amd',
					'AMD Radeon' => 'radeon',
					'AMD Ryzen' => 'amd-ryzen',
					'AMD Ryzen 5 5600X' => 'amd-ryzen-5-5600x',
					'AMD Ryzen 7 5800X' => 'amd-ryzen-7-5800x',
					'AMD Ryzen 9 5900X' => 'amd-ryzen-9-5900x',
					'AMD Ryzen 9 5950X' => 'amd-ryzen-9-5950x',
					'Amex' => 'amex',
					'Amiibo' => 'amiibo',
					'Amplifier' => 'amplifier',
					'Anchor Butter' => 'anchor-butter',
					'Andrex' => 'andrex',
					'Android Apps' => 'android-app',
					'Android Smartphone' => 'android-smartphone',
					'Android Tablet' => 'android-tablet',
					'Angelcare' => 'angelcare',
					'Angle Grinder' => 'grinder',
					'Anglepoise' => 'anglepoise',
					'Angry Birds' => 'angry-birds',
					'Animal Crossing' => 'animal-crossing',
					'Anime' => 'anime',
					'Anker' => 'anker',
					'Ankle Boots' => 'ankle-boots',
					'Anno 1800' => 'anno-1800',
					'Anthem' => 'anthem',
					'Antibacterial Hand Gel' => 'hand-gel',
					'Antibacterial Wipes' => 'cleaning-wipes',
					'Antivirus' => 'antivirus',
					'Antler' => 'antler',
					'AOC' => 'aoc',
					'Apex Legends' => 'apex-legends',
					'A Plague Tale: Innocence' => 'a-plague-tale-innocence',
					'App' => 'app',
					'Apple' => 'apple',
					'Apple AirPods' => 'apple-airpods',
					'Apple Airpods 2' => 'airpods-2',
					'Apple Airpods Max' => 'airpods-max',
					'Apple Airpods Pro' => 'airpods-pro',
					'Apple EarPods' => 'earpods',
					'Apple Headphones' => 'apple-headphones',
					'Apple HomePod' => 'apple-homepod',
					'Apple HomePod mini' => 'apple-homepod-mini',
					'Apple Keyboard' => 'apple-keyboard',
					'Apple Pencil' => 'apple-pencil',
					'Apple TV' => 'apple-tv',
					'Apple TV 4K' => 'apple-tv-4k',
					'Apple Watch' => 'apple-watch',
					'Apple Watch 3' => 'apple-watch-3',
					'Apple Watch 4' => 'apple-watch-4',
					'Apple Watch 5' => 'apple-watch-5',
					'Apple Watch 6' => 'apple-watch-6',
					'Apple Watch SE' => 'apple-watch-se',
					'Apron' => 'apron',
					'Aquadoodle' => 'aquadoodle',
					'Aqua Optima' => 'aqua-optima',
					'Aquarium' => 'aquarium',
					'Aramis' => 'aramis',
					'Argan Oil' => 'argan-oil',
					'Ariel' => 'ariel',
					'Ark' => 'ark',
					'Armani' => 'armani',
					'Armchair' => 'armchair',
					'Armed Forces Discount' => 'armed-forces',
					'Arsenal F. C.' => 'arsenal',
					'Arts and Crafts' => 'craft',
					'Asics' => 'asics',
					'Ask' => 'ask',
					'ASRock' => 'asrock',
					'Assassin&#039;s Creed' => 'assassins-creed',
					'Assassin&#039;s Creed: Odyssey' => 'assassins-creed-odyssey',
					'Assassin&#039;s Creed: Origins' => 'assassins-creed-origins',
					'Assassin&#039;s Creed: Unity' => 'assassins-creed-unity',
					'Assassin&#039;s Creed: Valhalla' => 'assasins-creed-valhalla',
					'Astral Chain' => 'astral-chain',
					'ASTRO Gaming' => 'astro-gaming',
					'Astro Gaming A40' => 'astro-gaming-a40',
					'Astro Gaming A50' => 'astro-gaming-a50',
					'Asus' => 'asus',
					'ASUS Laptop' => 'asus-laptop',
					'ASUS Monitor' => 'asus-monitor',
					'ASUS ROG' => 'asus-rog',
					'Asus ROG Phone' => 'asus-rog-phone',
					'Asus ROG Phone 2' => 'asus-rog-phone-2',
					'ASUS Router' => 'asus-router',
					'Asus Smartphone' => 'asus-smartphone',
					'ASUS Vivobook' => 'asus-vivobook',
					'ASUS Zenbook' => 'zenbook',
					'Asus ZenFone 6' => 'asus-zenfone-6',
					'Atari' => 'atari',
					'Audi' => 'audi',
					'Audio &amp; Hi-Fi' => 'audio',
					'Audio Accessories' => 'audio-accessories',
					'Audiobook' => 'audiobook',
					'Audio Technica' => 'audio-technica',
					'Aukey' => 'aukey',
					'Aussie' => 'aussie',
					'Autoglym' => 'autoglym',
					'Aveeno' => 'aveeno',
					'Avengers' => 'avengers',
					'AVG' => 'avg',
					'Aviva' => 'aviva',
					'Avon' => 'avon',
					'AV Receiver' => 'av-receiver',
					'Axe' => 'axe',
					'Baby Annabell' => 'baby-annabell',
					'Baby Bath' => 'baby-bath',
					'Baby Born' => 'baby-born',
					'Baby Bottle' => 'baby-bottles',
					'Baby Bouncer' => 'bouncer',
					'Baby Carrier' => 'baby-carrier',
					'Baby Clothes' => 'baby-clothes',
					'Baby Food' => 'baby-food',
					'Baby Gym' => 'baby-gym',
					'Baby Jogger' => 'baby-jogger',
					'Babyliss' => 'babyliss',
					'Baby Monitor' => 'baby-monitor',
					'Baby Shoes' => 'baby-shoes',
					'Baby Swing' => 'baby-swing',
					'Baby Walker' => 'baby-walker',
					'Baby Wipes' => 'wipes',
					'Bacardi' => 'bacardi',
					'Backpack' => 'backpack',
					'Back to the Future' => 'back-to-the-future',
					'Bacon' => 'bacon',
					'Badminton' => 'badminton',
					'Bag' => 'bag',
					'Bagless Vacuum Cleaner' => 'bagless-vacuum-cleaner',
					'Bahco' => 'bahco',
					'Baileys' => 'baileys',
					'Baked Beans' => 'baked-beans',
					'Bakery Products' => 'bakery-products',
					'Baking' => 'baking',
					'Ball Pit' => 'ball-pit',
					'Ballpoint Pen' => 'pen',
					'Band of Brothers' => 'band-of-brothers',
					'Bang &amp; Olufsen' => 'bang-olufsen',
					'Bank' => 'bank',
					'Bank Account' => 'bank-account',
					'Banks &amp; Credit Cards' => 'bank-credit-card',
					'Barbell' => 'barbell',
					'Barbie' => 'barbie',
					'Barbour' => 'barbour',
					'Barclaycard' => 'barclaycard',
					'Barclays' => 'barclays',
					'Barebones PC' => 'barebones',
					'bareMinerals' => 'bareminerals',
					'Barry M' => 'barry-m',
					'Bar Stools' => 'bar-stools',
					'Base Layer' => 'base-layer',
					'Basket' => 'basket',
					'Basketball' => 'basketball',
					'Basmati Rice' => 'basmati-rice',
					'Bath Mat' => 'bath-mat',
					'Bathroom Accessories' => 'bathroom',
					'Bathroom Cabinet' => 'bathroom-cabinet',
					'Bathroom Scale' => 'bathroom-scales',
					'Bathroom Tap' => 'tap',
					'Batman' => 'batman',
					'Battery' => 'battery',
					'Battleborn' => 'battleborn',
					'Battlefield' => 'battlefield',
					'Battlefield 1' => 'battlefield-1',
					'Battlefield 4' => 'battlefield-4',
					'Battlefield 5' => 'battlefield-5',
					'Battlestar Galactica' => 'battlestar-galactica',
					'Baylis &amp; Harding' => 'baylis-and-harding',
					'Bayonetta' => 'bayonetta',
					'Bayonetta 2' => 'bayonetta-2',
					'Baywatch' => 'baywatch',
					'BB-8' => 'bb-8',
					'BBC' => 'bbc',
					'BBQ Food' => 'bbq',
					'BBQs and Grills' => 'grill',
					'Bean Bag' => 'bean-bag',
					'Beanie Hat' => 'beanie-hat',
					'Bean to Cup Machine' => 'bean-to-cup',
					'Beard Trimmer' => 'beard-trimmer',
					'Beats by Dre' => 'beats-by-dre',
					'Beats Solo 3' => 'beats-solo-3',
					'Beats Studio 3' => 'beats-studio-3',
					'Beauty' => 'beauty-care',
					'Beauty and the Beast' => 'beauty-and-the-beast',
					'Becks' => 'becks',
					'Bed' => 'bed',
					'Bedding' => 'bedding',
					'Bedding &amp; Linens' => 'bedding-linens',
					'Bed Frame' => 'bed-frame',
					'Bedroom' => 'bedroom-furniture',
					'Beef' => 'beef',
					'Beer' => 'beer',
					'Beer Advent Calendar' => 'beer-advent-calendar',
					'Beko' => 'beko',
					'Belkin' => 'belkin',
					'Belstaff' => 'belstaff',
					'Belt' => 'belt',
					'BelVita' => 'belvita',
					'Ben &amp; Jerry&#039;s' => 'ben-jerrys',
					'Benefit Cosmetics' => 'benefit-cosmetics',
					'BenQ' => 'benq',
					'BenQ Monitor' => 'benq-monitor',
					'Ben Sherman' => 'ben-sherman',
					'BeoPlay Headphones' => 'beoplay-headphones',
					'Beoplay Speakers' => 'beoplay',
					'Berghaus' => 'berghaus',
					'Bestway' => 'bestway',
					'Betting' => 'betting',
					'Beyerdynamic' => 'beyerdynamic',
					'Bic' => 'bic',
					'Bike' => 'bike',
					'Bike Accessories' => 'bike-accessories',
					'Bike Brake' => 'brakes',
					'Bike Computer' => 'bike-computer',
					'Bike Helmet' => 'bicycle-helmet',
					'Bike Inner Tube' => 'inner-tube',
					'Bike Lights' => 'bike-lights',
					'Bike Lock' => 'bike-lock',
					'Bike Parts' => 'bike-parts',
					'Bike Pump' => 'bike-pump',
					'Biker Equipment' => 'biker-equipment',
					'Bike Saddle' => 'saddle',
					'Biking &amp; Urban Sports' => 'biking-urban-sports',
					'Bikini' => 'bikini',
					'Billabong' => 'billabong',
					'Bin' => 'bin',
					'Binatone' => 'binatone',
					'Bingo' => 'bingo',
					'Binoculars' => 'binoculars',
					'Bio Oil' => 'bio-oil',
					'Bioshock' => 'bioshock',
					'Birds Eye' => 'birds-eye',
					'Birkenstock' => 'birkenstock',
					'Biscuits' => 'biscuits',
					'Bissell' => 'bissell',
					'Bistro Set' => 'bistro-set',
					'Bitdefender' => 'bitdefender',
					'Black &amp; Decker' => 'black-decker',
					'Blackberry Smartphone' => 'blackberry',
					'Blanket' => 'blanket',
					'Blaupunkt' => 'blaupunkt',
					'Blazer' => 'blazer',
					'Bleach' => 'bleach',
					'Blended Malt' => 'malt',
					'Blender' => 'blender',
					'Blinds' => 'blinds',
					'Blink XT2 Smart Security Camera' => 'blink-xt2',
					'Blizzard' => 'blizzard',
					'Blood &amp; Truth' => 'blood-and-truth',
					'Bloodborne' => 'bloodborne',
					'Blood Pressure Monitor' => 'blood-pressure',
					'Blu-ray' => 'blu-ray',
					'Blu-ray Player' => 'blu-ray-player',
					'Bluetooth Headphones' => 'bluetooth-headphones',
					'Bluetooth Speaker' => 'bluetooth-speaker',
					'BMW' => 'bmw',
					'BMW Mini Cooper' => 'mini-cooper',
					'BMX' => 'bmx',
					'Board Game' => 'board-game',
					'Boardman' => 'boardman',
					'Boat Shoes' => 'boat-shoes',
					'Bodum' => 'bodum',
					'Bogof' => 'bogof',
					'Boiler' => 'boiler',
					'Bold' => 'bold',
					'Bombay Sapphire' => 'bombay-sapphire',
					'Bomber Jacket' => 'bomber-jacket',
					'Bonne Maman' => 'bonne-maman',
					'Bonsai' => 'bonsai',
					'Book' => 'book',
					'Bookcase' => 'bookcase',
					'Books &amp; Magazines' => 'books-magazines',
					'Booster Seat' => 'booster-seat',
					'Boots' => 'boots',
					'Borderlands' => 'borderlands',
					'Borderlands 3' => 'borderlands-3',
					'Bosch' => 'bosch',
					'Bosch Dishwasher' => 'bosch-dishwasher',
					'Bosch Drill' => 'bosch-drill',
					'Bosch Fridge' => 'bosch-fridge',
					'Bosch Rotak' => 'rotak',
					'Bosch Washing Machine' => 'bosch-washing-machine',
					'Bose' => 'bose',
					'Bose Headphones' => 'bose-headphones',
					'Bose Noise Cancelling Headphones 700' => 'bose-headphones-700',
					'Bose QuietComfort' => 'bose-quietcomfort',
					'Bose QuietComfort 35 II' => 'bose-quietcomfort-35-ii',
					'Bose SoundLink' => 'bose-soundlink',
					'Bose SoundLink Around-Ear II' => 'bose-soundlink-2',
					'Bose SoundTouch' => 'bose-soundtouch',
					'BOSS' => 'hugo-boss',
					'Boss Bottled' => 'boss-bottled',
					'Bouncy Castle' => 'bouncy-castle',
					'Bourbon' => 'bourbon',
					'Bourjois' => 'bourjois',
					'Bowers &amp; Wilkins' => 'bowers-wilkins',
					'Bowling' => 'bowling',
					'Bowmore' => 'bowmore',
					'Boxers' => 'boxers',
					'Boxing' => 'boxing',
					'Boxing Gloves' => 'boxing-gloves',
					'Boy&#039;s Clothes' => 'clothes-for-boys',
					'Bra' => 'bra',
					'Brabantia' => 'brabantia',
					'Bracelet' => 'bracelet',
					'Brands' => 'brand',
					'Brandy' => 'brandy',
					'Branston' => 'branston',
					'Branston Beans' => 'branston-beans',
					'Braun' => 'braun',
					'Braun Series 3' => 'braun-series-3',
					'Braun Series 5' => 'braun-series-5',
					'Braun Series 7' => 'braun-series-7',
					'Braun Series 9' => 'braun-series-9',
					'Braun Shaver' => 'braun-shaver',
					'Bread' => 'bread',
					'Breadmaker' => 'breadmaker',
					'Breakdown Cover' => 'breakdown',
					'Breaking Bad' => 'breaking-bad',
					'Breast Pump' => 'breast-pump',
					'Breville' => 'breville',
					'Breville Blend Active' => 'blendactive',
					'Brewdog' => 'brewdog',
					'Bridge Camera' => 'bridge-camera',
					'Briefcase' => 'briefcase',
					'Brita' => 'brita',
					'Britax' => 'britax',
					'British Airways' => 'british-airways',
					'Broadband' => 'broadband',
					'Broadband &amp; Phone Contracts' => 'broadband-phone-service',
					'Brogues' => 'brogues',
					'Brother' => 'brother',
					'Brother Printer' => 'brother-printer',
					'Brownie' => 'brownie',
					'BT' => 'bt',
					'BT Sport' => 'bt-sport',
					'Budweiser' => 'budweiser',
					'Buffalo' => 'buffalo',
					'Bugaboo' => 'bugaboo',
					'Buggy' => 'buggy',
					'Build-A-Bear' => 'build-a-bear',
					'Bulb' => 'bulbs',
					'Bulletstorm' => 'bulletstorm',
					'Bulmers' => 'bulmers',
					'Bulova' => 'bulova',
					'Burberry' => 'burberry',
					'Burger' => 'burger',
					'Burnout Paradise' => 'burnout-paradise',
					'Burt&#039;s Bees' => 'burts-bees',
					'Bus and Coach Ticket' => 'bus',
					'Bush' => 'bush',
					'Bushmills' => 'bushmills',
					'Butter' => 'butter',
					'Buying From Abroad' => 'buying-from-abroad',
					'Bvlgari' => 'bvlgari',
					'Cabin Case' => 'cabin-case',
					'Cabinet' => 'cabinet',
					'Cable Reel' => 'cable-reel',
					'Cables' => 'cables',
					'Cadbury&#039;s' => 'cadbury',
					'Café Rouge' => 'cafe-rouge',
					'Cafetière' => 'cafetiere',
					'Caffè Nero' => 'cafe-nero',
					'Cake' => 'cake',
					'Calculator' => 'calculator',
					'Calendar' => 'calendar',
					'Call of Duty' => 'call-of-duty',
					'Call of Duty: Black Ops' => 'black-ops',
					'Call of Duty: Black Ops 3' => 'black-ops-3',
					'Call of Duty: Black Ops 4' => 'black-ops-4',
					'Call of Duty: Black Ops Cold War' => 'call-of-duty-black-ops-cold-war',
					'Call of Duty: Infinite Warfare' => 'call-of-duty-infinite-warfare',
					'Call of Duty: Modern Warfare' => 'modern-warfare',
					'Call of Duty: WW2' => 'call-of-duty-ww2',
					'Calpol' => 'calpol',
					'Calvin Klein' => 'calvin-klein',
					'Camcorder' => 'camcorder',
					'Camelbak' => 'camelbak',
					'Camera' => 'camera',
					'Camera Accessories' => 'camera-accessories',
					'Camera Bag' => 'camera-bag',
					'Camera Lens' => 'lens',
					'Camping' => 'camping',
					'Campingaz' => 'campingaz',
					'Candle' => 'candle',
					'Cannondale' => 'cannondale',
					'Canon' => 'canon',
					'Canon Camera' => 'canon-camera',
					'Canon EOS' => 'canon-eos',
					'Canon Lens' => 'canon-lens',
					'Canon Pixma' => 'canon-pixma',
					'Canon PowerShot' => 'canon-powershot',
					'Canon PowerShot SX430 IS' => 'canon-powershot-sx430-is',
					'Canon Printer' => 'canon-printer',
					'Canterbury' => 'canterbury',
					'Canton' => 'canton',
					'Canvas Print' => 'canvas-print',
					'Cap' => 'cap',
					'Capsule Machine' => 'capsule-machine',
					'Captain America' => 'captain-america',
					'Captain Morgan' => 'captain-morgan',
					'Captain Toad: Treasure Tracker' => 'captain-toad-treasure-tracker',
					'Car' => 'car',
					'Car &amp; Motorcycle' => 'car-motorcycle',
					'Car Accessories' => 'car-accessories',
					'Caravan' => 'caravan',
					'Car Battery' => 'car-battery',
					'Carbon Monoxide Detector' => 'carbon-monoxide',
					'Car Care' => 'car-care',
					'Car Charger' => 'car-charger',
					'Cardhu' => 'cardhu',
					'Cardigan' => 'cardigan',
					'Card Reader' => 'card-reader',
					'Carex' => 'carex',
					'Carhartt' => 'carhartt',
					'Car Hire' => 'car-hire',
					'Car Insurance' => 'car-insurance',
					'Car Leasing' => 'car-lease',
					'Carling' => 'carling',
					'Car Lock' => 'lock',
					'Carlsberg' => 'carlsberg',
					'Car Mats' => 'car-mats',
					'Carolina Herrera' => 'carolina-herrera',
					'Car Parts' => 'car-parts',
					'Carpet' => 'carpet',
					'Carpet Cleaner' => 'carpet-cleaner',
					'CarPlan' => 'carplan',
					'Car Polish' => 'car-polish',
					'Carrera Bikes' => 'carrera',
					'Car Seat' => 'car-seat',
					'Car Service' => 'car-service',
					'Car Stereo' => 'car-stereo',
					'Car Wash' => 'car-wash',
					'Car Wax' => 'car-wax',
					'Casio' => 'casio',
					'Casio Eco-Drive' => 'eco-drive',
					'Casio Edifice' => 'edifice',
					'Casio G-Shock' => 'g-shock',
					'Casserole' => 'casserole',
					'Cast Iron Pots and Pans' => 'cast-iron',
					'Castrol' => 'castrol',
					'Caterpillar' => 'caterpillar',
					'Cat Flap' => 'cat-flap',
					'Cat Food' => 'cat-food',
					'Cath Kidston' => 'cath-kidston',
					'Cat Supplies' => 'cat-supplies',
					'CCTV' => 'cctv',
					'CD' => 'cd',
					'CD Player' => 'cd-player',
					'Ceiling Light' => 'ceiling-light',
					'Celebrations' => 'celebrations',
					'Cereal' => 'cereal',
					'Cetirizine' => 'cetirizine',
					'Chad Valley' => 'chad-valley',
					'Chainsaw' => 'chainsaw',
					'Champagne' => 'champagne',
					'Champneys' => 'champneys',
					'Chanel' => 'chanel',
					'Chanel Coco Mademoiselle' => 'coco-mademoiselle',
					'Changing Bag' => 'changing-bag',
					'Channel 4' => 'channel-4',
					'Charger' => 'charger',
					'Cheese' => 'cheese',
					'Chelsea Boots' => 'chelsea-boots',
					'Chelsea F. C.' => 'chelsea',
					'Chess' => 'chess',
					'Chessington' => 'chessington',
					'Chest Freezer' => 'chest-freezer',
					'Chest of Drawers' => 'chest-of-drawers',
					'Chicco' => 'chicco',
					'Chicken' => 'chicken',
					'Childcare' => 'baby',
					'Children&#039;s Books' => 'childrens-books',
					'Chino' => 'chino',
					'Chisel' => 'chisel',
					'Chloe' => 'chloe',
					'Chocolate' => 'chocolate',
					'Chocolate Advent Calendar' => 'chocolate-advent-calendar',
					'Chopper' => 'chopper',
					'Chopping Board' => 'chopping-board',
					'Christmas Card' => 'christmas-card',
					'Christmas Decoration' => 'christmas-decorations',
					'Christmas Gift' => 'christmas-gifts',
					'Christmas Jumper' => 'christmas-jumper',
					'Christmas Lights' => 'christmas-lights',
					'Christmas Stocking Fillers' => 'christmas-stocking-fillers',
					'Christmas Toys' => 'christmas-toys',
					'Christmas Tree' => 'christmas-tree',
					'Chromebook' => 'chromebook',
					'Chromecast' => 'chromecast',
					'Chromecast Ultra' => 'chromecast-ultra',
					'Chromecast with Google TV' => 'chromecast-google-tv',
					'Chronograph' => 'chronograph',
					'Chupa Chups' => 'chupa-chups',
					'Chuwi' => 'chuwi',
					'Cider' => 'cider',
					'Cinema' => 'cinema',
					'Cineworld' => 'cineworld',
					'Circular Saw' => 'circular-saw',
					'Circulon' => 'circulon',
					'Ciroc' => 'ciroc',
					'Cities Skylines' => 'cities-skylines',
					'Citizen' => 'citizen',
					'Citroen' => 'citroen',
					'City Break' => 'city-breaks',
					'Civilization' => 'civilization',
					'Clarins' => 'clarins',
					'Clarks' => 'clarks',
					'Clearance' => 'clearance',
					'Climbing' => 'climbing',
					'Climbing Frame' => 'climbing-frame',
					'Clinique' => 'clinique',
					'Clothes' => 'clothes',
					'Cloud Service' => 'cloud',
					'Clutch Bag' => 'clutch',
					'Coat' => 'coat',
					'Coca Cola' => 'coke',
					'Cocktail' => 'cocktail',
					'Coconut Oil' => 'coconut',
					'Coffee' => 'coffee',
					'Coffee Beans' => 'coffee-beans',
					'Coffee Machine' => 'coffee-machine',
					'Coffee Pods' => 'coffee-pods',
					'Coffee Table' => 'coffee-table',
					'Cognac' => 'cognac',
					'Cola' => 'cola',
					'Coleman' => 'coleman',
					'Colgate' => 'colgate',
					'Combi Drill' => 'combi',
					'Comfort' => 'comfort',
					'Comic' => 'comic',
					'Command &amp; Conquer' => 'command-and-conquer',
					'Compact Camera' => 'compact-camera',
					'Compact Flash' => 'compact-flash',
					'Competitions' => 'competitions',
					'Compost' => 'compost',
					'Compressor' => 'compressor',
					'Computer Accessories' => 'computer-accessories',
					'Computers &amp; Tablets' => 'computers',
					'Concert' => 'concert',
					'Condé Nast' => 'conde-nast',
					'Conditioner' => 'conditioner',
					'Condom' => 'condom',
					'Connectors' => 'connectors',
					'Contact Lenses' => 'contact-lenses',
					'Contents Insurance' => 'contents-insurance',
					'Controller' => 'controller',
					'Converse' => 'converse',
					'Converse Chuck Taylor' => 'chuck-taylor',
					'Cooker' => 'cooker',
					'Cooking Oil' => 'cooking-oil',
					'Cookware' => 'cooking',
					'Cookware Set' => 'cookware-set',
					'Cookworks' => 'cookworks',
					'Cool Box' => 'cool-box',
					'Coors Light' => 'coors-light',
					'Cordless Drill' => 'cordless-drill',
					'Cordless Phone' => 'cordless-phone',
					'Cornetto' => 'cornetto',
					'Corona Beer' => 'corona',
					'Corsair' => 'corsair',
					'Cosatto' => 'cosatto',
					'Costa Coffee' => 'costa-coffee',
					'Costume' => 'costume',
					'Cot' => 'cot',
					'Counter Strike' => 'counter-strike',
					'Courses and Training' => 'education',
					'Cow &amp; Gate' => 'cow-and-gate',
					'Cozy Coupe' => 'cozy-coupe',
					'CPU' => 'cpu',
					'CPU Cooler' => 'cpu-cooler',
					'Craghoppers' => 'craghoppers',
					'Crash Bandicoot' => 'crash-bandicoot',
					'Crash Team Racing Nitro-Fueled' => 'crash-team-racing-nitro-fueled',
					'Crayola' => 'crayola',
					'Creatine' => 'creatine',
					'Credit Card' => 'credit-card',
					'Creme Egg' => 'creme-egg',
					'Cricket' => 'cricket',
					'Crisps' => 'crisps',
					'Crocs' => 'crocs',
					'Cross Trainer' => 'cross-trainer',
					'Crown Paint' => 'crown',
					'Crucial' => 'crucial',
					'Cruelty Free Makeup' => 'cruelty-free-makeup',
					'Cruises' => 'cruise',
					'Cube Bikes' => 'cube',
					'Cubot' => 'cubot',
					'Cufflinks' => 'cufflinks',
					'Culture &amp; Leisure' => 'entertainment',
					'Cuphead' => 'cuphead',
					'Cuprinol' => 'cuprinol',
					'Curling Wand' => 'curling-wand',
					'Curtain' => 'curtain',
					'Cushelle' => 'cushelle',
					'Cushion' => 'cushion',
					'Cutlery' => 'cutlery',
					'CyberLink' => 'cyberlink',
					'Cyberpunk 2077' => 'cyberpunk-2077',
					'Cybex' => 'cybex',
					'Cycling' => 'cycling',
					'Cycling Jacket' => 'cycling-jacket',
					'D-Link' => 'd-link',
					'DAB Radio' => 'dab-radio',
					'Dacia' => 'dacia',
					'Daily Mail' => 'daily-mail',
					'Dairy Milk' => 'dairy-milk',
					'Darksiders' => 'darksiders',
					'Dark Souls' => 'dark-souls',
					'Dark Souls 3' => 'dark-souls-3',
					'Dartboard' => 'dartboard',
					'Darts' => 'darts',
					'Dash Cam' => 'dash-cam',
					'Data Storage' => 'storage',
					'Davidoff' => 'davidoff',
					'Days Gone' => 'days-gone',
					'Days Out' => 'days-out',
					'Daz' => 'daz',
					'DC Comic' => 'dc',
					'DDR3' => 'ddr3',
					'DDR4' => 'ddr4',
					'Dead Island' => 'dead-island',
					'Dead or Alive 6' => 'dead-or-alive-6',
					'Deadpool' => 'deadpool',
					'Dead Rising' => 'dead-rising',
					'Death Stranding' => 'death-stranding',
					'Deezer' => 'deezer',
					'Dehumidifier' => 'dehumidifier',
					'Dell' => 'dell',
					'Dell Laptop' => 'dell-laptop',
					'Dell Monitor' => 'dell-monitor',
					'Dell XPS' => 'xps',
					'Delonghi' => 'delonghi',
					'Demon&#039;s Souls' => 'demon-souls',
					'Denby' => 'denby',
					'Denon' => 'denon',
					'Deodorant' => 'deodorant',
					'Desk' => 'desk',
					'Desperados Beer' => 'desperados',
					'Despicable Me' => 'despicable-me',
					'Destiny' => 'destiny',
					'Destiny 2' => 'destiny-2',
					'Detergent' => 'detergent',
					'Detroit: Become Human' => 'detroit-become-human',
					'Dettol' => 'dettol',
					'Deus Ex' => 'deus-ex',
					'Deus Ex: Mankind Divided' => 'deus-ex-mankind-divided',
					'Development Boards' => 'development-boards',
					'Devil May Cry 5' => 'devil-may-cry-5',
					'DeWalt' => 'dewalt',
					'DFDS' => 'dfds',
					'Diablo 3' => 'diablo-3',
					'Diary' => 'diary',
					'Dickies' => 'dickies',
					'Diesel' => 'diesel',
					'Diet' => 'diet',
					'Diggerland' => 'diggerland',
					'Digihome' => 'digihome',
					'Digimon' => 'digimon',
					'Digital Camera' => 'digital-camera',
					'Digital Watch' => 'digital-watch',
					'Dildo' => 'dildo',
					'Dimplex' => 'dimplex',
					'Dining Room' => 'dining-room',
					'Dining Room Chair' => 'chair',
					'Dining Set' => 'dining-set',
					'Dining Table' => 'dining-table',
					'Dinner Plate' => 'plates',
					'Dinner Set' => 'dinner-set',
					'Dinosaur' => 'dinosaur',
					'Dior' => 'dior',
					'Dior Sauvage' => 'dior-sauvage',
					'Dirt' => 'dirt',
					'Dirt 4' => 'dirt-4',
					'DIRT 5' => 'dirt-5',
					'Dirt Rally 2.0' => 'dirt-rally-2',
					'Disaronno' => 'disaronno',
					'Discord Nitro' => 'discord-nitro',
					'Disgaea' => 'disgaea',
					'Dishonored' => 'dishonored',
					'Dishonored 2' => 'dishonored-2',
					'Dishwasher' => 'dishwasher',
					'Dishwasher Tablets' => 'dishwasher-tablets',
					'Disinfectants' => 'disinfectants',
					'Disney' => 'disney',
					'Disney&#039;s Cars' => 'disney-cars',
					'Disney&#039;s Frozen' => 'disney-frozen',
					'Disney+' => 'disney-plus',
					'Disney Infinity' => 'disney-infinity',
					'Disneyland' => 'disneyland',
					'Disney Princess' => 'disney-princess',
					'Disney Tsum Tsum' => 'tsum-tsum',
					'Disney World' => 'disney-world',
					'Divan' => 'divan',
					'DIY' => 'diy',
					'DJ Equipment' => 'dj',
					'DJI Phantom' => 'dji-phantom',
					'DKNY' => 'dkny',
					'Doctor Who' => 'doctor-who',
					'Dog Bed' => 'dog-bed',
					'Dog Food' => 'dog-food',
					'Dog Supplies' => 'dog',
					'Dolce &amp; Gabbana' => 'dolce',
					'Dolce Gusto' => 'dolce-gusto',
					'Dolce Gusto Coffee Machine' => 'dolce-gusto-coffee-machine',
					'Doll' => 'doll',
					'Dolls House' => 'dolls-house',
					'Domain Service' => 'domain',
					'Doogee' => 'doogee',
					'Doom' => 'doom',
					'Door' => 'door',
					'Doorbell' => 'doorbell',
					'Door Handles' => 'door-handles',
					'Doormat' => 'doormat',
					'Doritos' => 'doritos',
					'Dove' => 'dove',
					'Down Jacket' => 'down-jacket',
					'Downton Abbey' => 'downton-abbey',
					'Dr. Martens' => 'dr-martens',
					'Dragon Age' => 'dragon-age',
					'Dragon Ball' => 'dragon-ball',
					'Dragon Ball: FighterZ' => 'dragon-ball-fighterz',
					'Dragon Quest' => 'dragon-quest',
					'Dragon Quest Builders' => 'dragon-quest-builders',
					'Dragon Quest Builders 2' => 'dragon-quest-builders-2',
					'Dragon Quest XI: Echoes of an Elusive Age' => 'dragon-quest-xi',
					'Draper' => 'draper',
					'Drayton Manor' => 'drayton-manor',
					'Dreame T20' => 'dreame-t20',
					'Dreame V9' => 'dreame-v9',
					'Dreame V9P' => 'dreame-v9p',
					'Dreame V10' => 'dreame-v10',
					'Dreame V11' => 'dreame-v11',
					'Dreame Vacuum Cleaner' => 'xiaomi-vacuum-cleaner',
					'Dremel' => 'dremel',
					'Dress' => 'dress',
					'Dressing Gown' => 'dressing-gown',
					'Drill' => 'drill',
					'Drill Driver' => 'driver',
					'Drinks' => 'drinks',
					'Driveclub' => 'driveclub',
					'Driving Lessons' => 'driving-lessons',
					'Drone' => 'drone',
					'Dryer' => 'dryer',
					'DSLR Camera' => 'dslr',
					'Dual Fuel Cooker' => 'dual-fuel',
					'Dualit' => 'dualit',
					'Dual Sim' => 'sim',
					'Dulux' => 'dulux',
					'Duracell' => 'duracell',
					'Durex' => 'durex',
					'Duvet' => 'duvet',
					'DVD' => 'dvd',
					'DVD Player' => 'dvd-player',
					'Dying Light' => 'dying-light',
					'Dymo' => 'dymo',
					'Dyson' => 'dyson',
					'Dyson Supersonic' => 'dyson-supersonic',
					'Dyson V6' => 'dyson-v6',
					'Dyson V7' => 'dyson-v7',
					'Dyson V8' => 'dyson-v8',
					'Dyson V10' => 'dyson-v10',
					'Dyson V11' => 'dyson-v11',
					'Dyson Vacuum Cleaner' => 'dyson-vacuum-cleaner',
					'e-Reader' => 'ereader',
					'EA' => 'ea',
					'EA Access' => 'ea-access',
					'Earphones' => 'earphones',
					'Earrings' => 'earrings',
					'EA Sports' => 'ea-sports',
					'EA Sports UFC' => 'ufc',
					'Easter Eggs' => 'egg',
					'Eastpak' => 'eastpak',
					'eBook' => 'ebook',
					'Ecovacs' => 'ecovacs',
					'Ecover' => 'ecover',
					'Educational Toys' => 'educational-toys',
					'EE' => 'ee',
					'eFootball PES 2021' => 'pes-2021',
					'ELC Happyland' => 'happyland',
					'Electrical Accessories' => 'electrical-accessories',
					'Electric Bike' => 'electric-bike',
					'Electric Blanket' => 'electric-blanket',
					'Electric Cooker' => 'electric-cooker',
					'Electric Fires' => 'electric-fire',
					'Electric Scooter' => 'electric-scooter',
					'Electric Shower' => 'electric-shower',
					'Electric Toothbrush' => 'electric-toothbrush',
					'Electronic Accessories' => 'electronics-accessories',
					'Electronics' => 'electronics',
					'Elemis' => 'elemis',
					'Elephone' => 'elephone',
					'Elgato' => 'elgato',
					'Elite Dangerous' => 'elite-dangerous',
					'Elizabeth Arden' => 'elizabeth-arden',
					'Emirates' => 'emirates',
					'Endura' => 'endura',
					'Eneloop' => 'eneloop',
					'Energizer' => 'energizer',
					'Energy' => 'energy',
					'Energy, Heating &amp; Gas' => 'energy-heating-gas',
					'Energy Drinks' => 'energy-drinks',
					'Engine Oil' => 'engine-oil',
					'Epilator' => 'epilator',
					'Epson' => 'epson',
					'Epson Printer' => 'epson-printer',
					'Espresso' => 'espresso',
					'Espresso Machine' => 'espresso-machine',
					'Esprit' => 'esprit',
					'Estée Lauder' => 'estee-lauder',
					'Ethernet' => 'ethernet',
					'Etnies' => 'etnies',
					'Eurostar Ticket' => 'eurostar',
					'Eurotunnel' => 'eurotunnel',
					'Everton F. C.' => 'everton',
					'EVGA' => 'evga',
					'Evian' => 'evian',
					'Exercise Equipment' => 'exercise-equipment',
					'Exercise Weights' => 'weight',
					'Extension Lead' => 'extension-lead',
					'External Hard Drive' => 'external-hard-drive',
					'F1' => 'formula-one',
					'F1 2017' => 'f1-2017',
					'F1 2018' => 'f1-2018',
					'F1 2019' => 'f1-2019',
					'F1 2020' => 'f1-2020',
					'Fabric Conditioner' => 'fabric-conditioner',
					'Face Cream' => 'face-cream',
					'Face Mask' => 'face-mask',
					'Fairy' => 'fairy',
					'Fairy Light' => 'fairy-light',
					'Fallout' => 'fallout',
					'Fallout 4' => 'fallout-4',
					'Fallout 76' => 'fallout-76',
					'Family &amp; Kids' => 'kids',
					'Family Break' => 'family-break',
					'Family Guy' => 'family-guy',
					'Famous Grouse' => 'famous-grouse',
					'Fancy Dress' => 'fancy-dress',
					'Fans' => 'fan',
					'Fanta' => 'fanta',
					'Far Cry' => 'far-cry',
					'Far Cry 4' => 'far-cry-4',
					'Far Cry 5' => 'far-cry-5',
					'Far Cry New Dawn' => 'far-cry-new-dawn',
					'Far Cry Primal' => 'far-cry-primal',
					'Farming Simulator' => 'farming-simulator',
					'Fashion &amp; Accessories' => 'fashion',
					'Fashion Accessories' => 'fashion-accessories',
					'Fashion for Men' => 'mens-clothing',
					'Fashion for Women' => 'womens-clothes',
					'Fast and Furious' => 'fast-and-furious',
					'Father&#039;s Day' => 'fathers-day',
					'FatMax' => 'fatmax',
					'FC Barcelona' => 'fc-barcelona',
					'Felix' => 'felix',
					'Fence' => 'fence',
					'Fender Guitar' => 'fender',
					'Ferrero Rocher' => 'ferrero-rocher',
					'Ferry' => 'ferry',
					'Festival' => 'festival',
					'Fever Thermometer' => 'thermometer',
					'Fiat' => 'fiat',
					'Fidget Spinner' => 'spinner',
					'FIFA' => 'fifa',
					'FIFA 17' => 'fifa-17',
					'FIFA 18' => 'fifa-18',
					'FIFA 19' => 'fifa-19',
					'FIFA 20' => 'fifa-20',
					'FIFA 21' => 'fifa-21',
					'FightStick' => 'fightstick',
					'Figures' => 'figures',
					'Fila Trainers' => 'fila-trainers',
					'Filing Cabinet' => 'filing-cabinet',
					'Final Fantasy' => 'final-fantasy',
					'Final Fantasy 15' => 'final-fantasy-15',
					'Finance &amp; Insurance' => 'personal-finance',
					'Finish' => 'finish',
					'Finlux' => 'finlux',
					'Fiorelli' => 'fiorelli',
					'Fire Emblem' => 'fire-emblem',
					'Fire Pit' => 'fire-pit',
					'Fireplace' => 'fireplace',
					'Firewall: Zero Hour' => 'firewall-zero-hour',
					'First Aid' => 'first-aid',
					'Fish &amp; Seafood' => 'fish-and-seafood',
					'Fish and Aquatic Pet Supplies' => 'fish',
					'Fisher Price' => 'fisher-price',
					'Fisher Price Imaginext' => 'imaginext',
					'Fisher Price Jumperoo' => 'jumperoo',
					'Fisher Price Little People' => 'little-people',
					'Fishing' => 'fishing',
					'Fiskars' => 'fiskars',
					'Fitbit' => 'fitbit',
					'Fitbit Alta' => 'fitbit-alta',
					'Fitbit Blaze' => 'fitbit-blaze',
					'Fitbit Charge 2' => 'fitbit-charge-2',
					'Fitbit Inspire' => 'fitbit-inspire',
					'Fitbit Versa' => 'fitbit-versa',
					'Fitness &amp; Running' => 'fitness',
					'Fitness App' => 'fitness-app',
					'Fitness Tracker' => 'fitness-tracker',
					'Flamingo Land' => 'flamingo-land',
					'Flea Treatment' => 'flea',
					'Fleece Clothing' => 'fleece',
					'Flights' => 'flight',
					'Flip Flops' => 'flip-flops',
					'Floodlight' => 'floodlight',
					'Flooring' => 'flooring',
					'Flowers' => 'flowers',
					'Flymo' => 'flymo',
					'FM Transmitter' => 'fm-transmitter',
					'Food' => 'food',
					'Food Containers' => 'food-containers',
					'Food Processor' => 'food-processor',
					'Food Server' => 'food-server',
					'Football' => 'football',
					'Football Boots' => 'football-boots',
					'Football Manager' => 'football-manager',
					'Football Matches' => 'football-matches',
					'Football Shirt' => 'football-shirt',
					'Foot Pump' => 'foot-pump',
					'Ford' => 'ford',
					'For Honor' => 'for-honor',
					'Fortnite' => 'fortnite',
					'Fortnite: Darkfire' => 'fortnite-darkfire',
					'Forza' => 'forza',
					'Forza 7' => 'forza-7',
					'Forza Horizon' => 'forza-horizon',
					'Forza Horizon 3' => 'forza-horizon-3',
					'Forza Horizon 4' => 'forza-horizon-4',
					'Forza Motorsport' => 'forza-motorsport',
					'Foscam' => 'foscam',
					'Fossil' => 'fossil',
					'Foster&#039;s' => 'fosters',
					'Foundation' => 'foundation',
					'Fountain Pen' => 'fountain-pen',
					'Fred Perry' => 'fred-perry',
					'Freesat' => 'freesat',
					'Freeview' => 'freeview',
					'Freezer' => 'freezer',
					'Fridge' => 'fridge',
					'Fridge Freezer' => 'fridge-freezer',
					'Frontline' => 'frontline',
					'Frozen Food' => 'frozen',
					'Fruit' => 'fruit',
					'Fruit and Vegetables' => 'fruit-and-vegetable',
					'Fruit of the Loom' => 'fruit-of-the-loom',
					'Fryer' => 'fryer',
					'Frying Pan' => 'frying-pan',
					'Fujifilm' => 'fuji',
					'Fujitsu' => 'fujitsu',
					'Funko Pop' => 'funko-pop',
					'Furby' => 'furby',
					'Furniture' => 'furniture',
					'G-Star' => 'g-star',
					'G-Sync Monitor' => 'g-sync',
					'Gaggia' => 'gaggia',
					'Gambling' => 'gambling',
					'Game App' => 'game-app',
					'Game of Thrones' => 'game-of-thrones',
					'Games &amp; Board Games' => 'board-games',
					'Games Consoles' => 'console',
					'Gaming' => 'gaming',
					'Gaming Accessories' => 'gaming-accessories',
					'Gaming Chair' => 'gaming-chair',
					'Gaming Headset' => 'gaming-headset',
					'Gaming Keyboard' => 'gaming-keyboard',
					'Gaming Laptop' => 'gaming-laptop',
					'Gaming Monitor' => 'gaming-monitor',
					'Gaming Mouse' => 'gaming-mouse',
					'Gaming PC' => 'gaming-pc',
					'Gant' => 'gant',
					'Garage' => 'garage',
					'Garage &amp; Service' => 'garage-service',
					'Garden' => 'garden',
					'Garden &amp; Do It Yourself' => 'garden-diy',
					'Garden Furniture' => 'garden-furniture',
					'Gardening' => 'gardening',
					'Garden Storage' => 'garden-storage',
					'Garden Table' => 'table',
					'Garmin' => 'garmin',
					'Garmin Fenix' => 'garmin-fenix',
					'Garmin Fenix 6' => 'garmin-fenix-6',
					'Garmin Fenix 6 Pro' => 'garmin-fenix-6-pro',
					'Garmin Forerunner' => 'garmin-forerunner',
					'Garmin Vivoactive' => 'garmin-vivoactive',
					'Garmin Watch' => 'garmin-watch',
					'Garnier' => 'garnier',
					'Gas' => 'gas',
					'Gas Canister' => 'butane',
					'Gas Cooker' => 'gas-cooker',
					'Gatwick' => 'gatwick',
					'Gazebo' => 'gazebo',
					'GBK' => 'gbk',
					'Gears 5' => 'gears-5',
					'Gears of War' => 'gears-of-war',
					'Gears of War 4' => 'gears-of-war-4',
					'George Foreman' => 'george-foreman',
					'Geox' => 'geox',
					'GHD' => 'ghd',
					'Ghostbusters' => 'ghostbusters',
					'Ghostbusters: The Video Game Remastered' => 'ghostbusters-the-video-game',
					'Ghost of Tsushima' => 'ghost-of-tsushima',
					'Gibson Guitar' => 'gibson',
					'giffgaff' => 'giffgaff',
					'Gift Card' => 'gift-card',
					'Gift Hamper' => 'hamper',
					'Gifts' => 'gifts',
					'Gift Set' => 'gift-set',
					'GIGABYTE' => 'gigabyte',
					'Gigaset' => 'gigaset',
					'Gilet' => 'gilet',
					'Gillette Fusion' => 'fusion',
					'Gillette Mach3' => 'mach-3',
					'Gillette Razor' => 'gillette',
					'Gimbal' => 'gimbal',
					'Gin' => 'gin',
					'Girl&#039;s Clothes' => 'girls-clothes',
					'Glasses' => 'glasses',
					'Glassware' => 'glassware',
					'Glenfiddich' => 'glenfiddich',
					'Glenlivet' => 'glenlivet',
					'Glenmorangie' => 'glenmorangie',
					'Gloves' => 'gloves',
					'Glue' => 'glue',
					'Glue Gun' => 'glue-gun',
					'Gluten-Free' => 'gluten-free',
					'God of War' => 'god-of-war',
					'Go Kart' => 'go-kart',
					'Golf' => 'golf',
					'Golf Balls' => 'golf-balls',
					'Golf Clubs' => 'golf-clubs',
					'Goodfellas' => 'goodfellas',
					'Goodmans' => 'goodmans',
					'Goodyear' => 'goodyear',
					'Google' => 'google',
					'Google Home' => 'google-home',
					'Google Home Max' => 'google-home-max',
					'Google Home Mini' => 'google-home-mini',
					'Google Nest' => 'nest',
					'Google Nest Audio' => 'google-nest-audio',
					'Google Nest Hub' => 'google-home-hub',
					'Google Nest Mini' => 'nest-mini',
					'Google Nest Protect' => 'google-nest-protect',
					'Google Nexus' => 'nexus',
					'Google Pixel' => 'google-pixel',
					'Google Pixel 2' => 'google-pixel-2',
					'Google Pixel 2 XL' => 'google-pixel-2-xl',
					'Google Pixel 3' => 'google-pixel-3',
					'Google Pixel 3 XL' => 'google-pixel-3-xl',
					'Google Pixel 3a' => 'google-pixel-3a',
					'Google Pixel 3a XL' => 'google-pixel-3a-xl',
					'Google Pixel 4' => 'google-pixel-4',
					'Google Pixel 4 XL' => 'google-pixel-4-xl',
					'Google Pixel 4a' => 'google-pixel-4a',
					'Google Pixel 4a 5G' => 'google-pixel-4a-5g',
					'Google Pixel 5' => 'google-pixel-5',
					'Google Pixelbook' => 'google-pixelbook',
					'Google Pixel XL' => 'google-pixel-xl',
					'Google Smartphone' => 'google-smartphone',
					'Google Stadia' => 'google-stadia',
					'GoPro' => 'gopro',
					'GoPro HERO 6' => 'gopro-hero-6',
					'GoPro HERO 7' => 'gopro-hero-7',
					'GoPro HERO 8' => 'gopro-hero-8',
					'GoPro HERO 9' => 'gopro-hero-9',
					'Gore-Tex Clothing and Shoes' => 'gore-tex',
					'Graco' => 'graco',
					'Grand National' => 'grand-national',
					'Gran Turismo' => 'gran-turismo',
					'Gran Turismo Sport' => 'gran-turismo-sport',
					'Graphics Card' => 'graphics-card',
					'Gravity Rush' => 'gravity-rush',
					'Graze' => 'graze',
					'GreedFall' => 'greedfall',
					'Greenhouse' => 'greenhouse',
					'Greeting Cards and Wrapping Paper' => 'wrapping-paper-and-cards',
					'Greggs' => 'greggs',
					'Grey Goose' => 'grey-goose',
					'Griffin Technology' => 'griffin',
					'GroBag' => 'grobag',
					'Groceries' => 'groceries',
					'Gruffalo' => 'gruffalo',
					'Grundig' => 'grundig',
					'GTA' => 'gta',
					'GTA V' => 'gta-v',
					'GTX 970' => 'gtx-970',
					'GTX 980' => 'gtx-980',
					'GTX 1060' => 'gtx-1060',
					'GTX 1070' => 'gtx-1070',
					'GTX 1080' => 'gtx-1080',
					'GTX 1080 Ti' => 'gtx-1080-ti',
					'GTX 1660' => 'gtx-1660',
					'GTX 1660 Ti' => 'gtx-1660-ti',
					'Guardians of the Galaxy' => 'guardians-of-the-galaxy',
					'Gucci' => 'gucci',
					'Guinness' => 'guinness',
					'Guitar' => 'guitar',
					'Guitar Amp' => 'guitar-amp',
					'Guitar Hero' => 'guitar-hero',
					'Gulliver&#039;s' => 'gullivers',
					'Gym' => 'gym',
					'Gym Membership' => 'gym-membership',
					'H1Z1' => 'h1z1',
					'Häagen Dazs' => 'haagen-dazs',
					'Habitat' => 'habitat',
					'Hacksaw' => 'hacksaw',
					'Hair Brush' => 'hair-brush',
					'Hair Care' => 'hair',
					'Hair Clipper' => 'hair-clipper',
					'Hair Colour' => 'hair-colour',
					'Haircut' => 'haircut',
					'Hair Dryer' => 'hair-dryer',
					'Hair Dye' => 'hair-dye',
					'Hair Removal Devices' => 'hair-removal-devices',
					'Halifax' => 'halifax',
					'Hall' => 'hall',
					'Halloween' => 'halloween',
					'Halo' => 'halo',
					'Halo 5' => 'halo-5',
					'Ham' => 'ham',
					'Hammer' => 'hammer',
					'Hammer Drill' => 'hammer-drill',
					'Hammock' => 'hammock',
					'Handbag' => 'handbag',
					'Hand Blender' => 'hand-blender',
					'Hand Cream' => 'hand-cream',
					'Hand Mixer' => 'hand-mixer',
					'Hand Tools' => 'hand-tools',
					'Handwash' => 'handwash',
					'Hard Drive' => 'hard-drive',
					'Haribo' => 'haribo',
					'Harman Kardon' => 'harman-kardon',
					'Harry Potter' => 'harry-potter',
					'Hasbro' => 'hasbro',
					'Hat' => 'hat',
					'Hatchimals' => 'hatchimals',
					'Hats &amp; Caps' => 'hats-caps',
					'Hauck' => 'hauck',
					'Hayfever Remedies' => 'hayfever',
					'Headboard' => 'headboard',
					'Headphones' => 'headphones',
					'Headset' => 'headset',
					'Health &amp; Beauty' => 'beauty',
					'Healthcare' => 'health-care',
					'Heart Rate Monitor' => 'heart-rate-monitor',
					'Heater' => 'heater',
					'Heating' => 'heating',
					'Heating Appliances' => 'heating-appliances',
					'Hedge Trimmer' => 'hedge-trimmer',
					'Heineken' => 'heineken',
					'Heinz' => 'heinz',
					'Heinz Beanz' => 'heinz-baked-beans',
					'Hello Kitty' => 'hello-kitty',
					'Hello Neighbour' => 'hello-neighbour',
					'Helly Hansen' => 'helly-hansen',
					'Henry Hoover' => 'henry-hoover',
					'Hermes' => 'hermes',
					'High5' => 'high-5',
					'Highchair' => 'highchair',
					'Hiking' => 'hiking',
					'Hilton' => 'hilton',
					'Hisense' => 'hisense',
					'Hisense TVs' => 'hisense-tv',
					'Hitachi' => 'hitachi',
					'Hitman' => 'hitman',
					'Hive' => 'hive',
					'Hive Active Heating' => 'hive-active-heating',
					'Hob' => 'hob',
					'Hobbit' => 'hobbit',
					'Hockey' => 'hockey',
					'Holiday Inn' => 'holiday-inn',
					'Holiday Park' => 'holiday-parks',
					'Holidays and Trips' => 'holidays-and-trips',
					'Hollow Knight' => 'hollow-knight',
					'Home &amp; Living' => 'home',
					'Home Accessories' => 'home-accessories',
					'Home Appliances' => 'home-appliances',
					'Home Care' => 'home-care',
					'Home Cinema' => 'home-cinema',
					'HoMedics' => 'homedics',
					'Homefront' => 'homefront',
					'Home Networking' => 'network',
					'Homeplug' => 'homeplug',
					'Home Security' => 'home-security',
					'Homeware' => 'homeware',
					'Honda' => 'honda',
					'Honey' => 'honey',
					'Honeywell' => 'honeywell',
					'Honor 6X' => 'honor-6x',
					'Honor 7' => 'honor-7',
					'Honor 8S' => 'honor-8s',
					'Honor 8X' => 'honor-8x',
					'Honor 8X Max' => 'honor-8x-max',
					'Honor 9' => 'honor-9',
					'Honor 9X' => 'honor-9x',
					'Honor 10' => 'honor-10',
					'Honor Band 5' => 'honor-band-5',
					'Honor Play' => 'honor-play',
					'Honor Smartphone' => 'honor',
					'Honor View 20' => 'honor-view-20',
					'Hoodie' => 'hoodie',
					'Hoover' => 'hoover',
					'Hori' => 'hori',
					'Horizon: Zero Dawn' => 'horizon-zero-dawn',
					'Hornby' => 'hornby',
					'Horse Races' => 'horse-races',
					'Hose' => 'hose',
					'HOTAS' => 'hotas',
					'Hotel' => 'hotel',
					'Hotpoint' => 'hotpoint',
					'Hotspot' => 'hotspot',
					'Hot Tub' => 'hot-tub',
					'Hot Water Bottle' => 'hot-water-bottle',
					'Hot Wheels' => 'hot-wheels',
					'Hozelock' => 'hozelock',
					'HP' => 'hp',
					'HP Envy' => 'hp-envy',
					'HP Laptop' => 'hp-laptop',
					'HP Omen' => 'hp-omen',
					'HP Printer' => 'hp-printer',
					'HTC' => 'htc',
					'HTC 10' => 'htc-10',
					'HTC Desire' => 'htc-desire',
					'HTC One' => 'htc-one',
					'HTC Smartphone' => 'htc-smartphone',
					'HTC U11' => 'htc-u11',
					'HTC Vive' => 'htc-vive',
					'Huawei' => 'huawei',
					'Huawei Freebuds 3' => 'huawei-freebuds-3',
					'Huawei Headphones' => 'huawei-headphones',
					'Huawei Mate 20' => 'huawei-mate-20',
					'Huawei Mate 20 Pro' => 'huawei-mate-20-pro',
					'Huawei Mate 30' => 'huawei-mate-30',
					'Huawei Mate 30 Lite' => 'huawei-mate-30-lite',
					'Huawei Mate 30 Pro' => 'huawei-mate-30-pro',
					'Huawei Matebook' => 'huawei-matebook',
					'Huawei MediaPad M3' => 'huawei-mediapad-m3',
					'Huawei MediaPad M5' => 'huawei-mediapad-m5',
					'Huawei MediaPad T3' => 'huawei-mediapad-t3',
					'Huawei MediaPad T5' => 'huawei-mediapad-t5',
					'Huawei P9' => 'huawei-p9',
					'Huawei P10' => 'huawei-p10',
					'Huawei P20' => 'huawei-p20',
					'Huawei P20 Lite' => 'huawei-p20-lite',
					'Huawei P20 Pro' => 'huawei-p20-pro',
					'Huawei P30' => 'huawei-p30',
					'Huawei P30 Lite' => 'huawei-p30-lite',
					'Huawei P30 Pro' => 'huawei-p30-pro',
					'Huawei P40' => 'huawei-p40',
					'Huawei P40 Lite' => 'huawei-p40-lite',
					'Huawei P40 Pro' => 'huawei-p40-pro',
					'Huawei P Smart' => 'huawei-p-smart',
					'Huawei Smartphone' => 'huawei-smartphone',
					'Huawei Smartwatch' => 'huawei-smartwatch',
					'Huawei Tablet' => 'huawei-tablet',
					'Huawei Watch 2' => 'huawei-watch-2',
					'Huawei Watch GT' => 'huawei-watch-gt',
					'Huawei Watch GT2' => 'huawei-watch-gt2',
					'Huawei Watch GT 2 Pro' => 'huawei-watch-gt-2-pro',
					'Huawei Y7' => 'huawei-y7',
					'Huggies' => 'huggies',
					'Hulk' => 'hulk',
					'Humax' => 'humax',
					'Humidifier' => 'humidifier',
					'Hunter' => 'hunter',
					'HyperX' => 'hyperx',
					'Hyrule Warriors' => 'hyrule-warriors',
					'Hyundai' => 'hyundai',
					'IAMS' => 'iams',
					'iCandy' => 'icandy',
					'Ice-Watch' => 'ice-watch',
					'Ice Cream' => 'ice-cream',
					'Ice Cream Maker' => 'ice-cream-maker',
					'iMac' => 'apple-imac',
					'iMac 2021' => 'imac-2021',
					'Impact Driver' => 'impact-driver',
					'Indesit' => 'indesit',
					'Inflatable Boats' => 'boat',
					'Inflatable Toys' => 'inflatable',
					'Injustice' => 'injustice',
					'Injustice 2' => 'injustice-2',
					'Ink Cartridge' => 'ink',
					'Inkjet Printer' => 'inkjet-printer',
					'Innocent' => 'innocent',
					'Instant Cameras' => 'instant-cameras',
					'Instant Ink' => 'instant-ink',
					'Instax Mini 9' => 'instax-mini-9',
					'Insulation' => 'insulation',
					'Insurance' => 'insurance',
					'Intel' => 'intel',
					'Intel Atom' => 'atom',
					'Intel i3' => 'i3',
					'Intel i5' => 'i5',
					'Intel i7' => 'i7',
					'Intel i9' => 'intel-i9',
					'Internet' => 'internet',
					'Internet Security' => 'internet-security',
					'In the Night Garden' => 'in-the-night-garden',
					'Intimate Care' => 'intimate-care',
					'Introduce Yourself' => 'introduce-yourself',
					'iOS Apps' => 'ios-apps',
					'iPad' => 'ipad',
					'iPad 2019' => 'ipad-2019',
					'iPad 2020' => 'ipad-2020',
					'iPad Air' => 'ipad-air',
					'iPad Air 2019' => 'ipad-air-2019',
					'iPad Air 2020' => 'ipad-air-2020',
					'iPad Case' => 'ipad-case',
					'iPad mini' => 'ipad-mini',
					'iPad Pro' => 'ipad-pro',
					'iPad Pro 11' => 'ipad-pro-11',
					'iPad Pro 12.9' => 'ipad-pro-12-9',
					'iPad Pro 2020' => 'ipad-pro-2020',
					'iPad Pro 2021' => 'ipad-pro-2021',
					'IP Camera' => 'ip-camera',
					'iPhone' => 'iphone',
					'iPhone 5s' => 'iphone-5s',
					'iPhone 6' => 'iphone-6',
					'iPhone 6 Plus' => 'iphone-6-plus',
					'iPhone 6s' => 'iphone-6s',
					'iPhone 6s Plus' => 'iphone-6s-plus',
					'iPhone 7' => 'iphone-7',
					'iPhone 7 Plus' => 'iphone-7-plus',
					'iPhone 8' => 'iphone-8',
					'iPhone 8 Plus' => 'iphone-8-plus',
					'iPhone 11' => 'iphone-11',
					'iPhone 11 Pro' => 'iphone-11-pro',
					'iPhone 11 Pro Max' => 'iphone-11-pro-max',
					'iPhone 12' => 'iphone-12',
					'iPhone 12 mini' => 'iphone-12-mini',
					'iPhone 12 Pro' => 'iphone-12-pro',
					'iPhone 12 Pro Max' => 'iphone-12-pro-max',
					'iPhone Accessories' => 'iphone-accessories',
					'iPhone Case' => 'iphone-case',
					'iPhone SE' => 'iphone-se',
					'iPhone X' => 'iphone-x',
					'iPhone Xr' => 'iphone-xr',
					'iPhone Xs' => 'iphone-xs',
					'iPhone Xs Max' => 'iphone-xs-max',
					'iPod' => 'ipod',
					'iPod Nano' => 'ipod-nano',
					'iPod Shuffle' => 'ipod-shuffle',
					'iPod Touch' => 'ipod-touch',
					'Irish Whiskey' => 'irish-whisky',
					'Irn Bru' => 'irn-bru',
					'iRobot' => 'irobot',
					'Iron' => 'iron',
					'Ironing' => 'ironing',
					'Ironing Board' => 'ironing-board',
					'Iron Man' => 'iron-man',
					'Issey Miyake' => 'issey-miyake',
					'ITV' => 'itv',
					'Jabra' => 'jabra',
					'Jabra Elite 85h' => 'jabra-elite-85h',
					'Jabra Elite Active 65t' => 'jabra-elite-active-65t',
					'Jabra Elite Active 75t' => 'jabra-elite-active-75t',
					'Jabra Headphones' => 'jabra-headphones',
					'Jack &amp; Jones' => 'jack-and-jones',
					'Jack Daniel&#039;s' => 'jack-daniels',
					'Jacket' => 'jacket',
					'Jack Wills' => 'jack-wills',
					'Jack Wolfskin' => 'jack-wolfskin',
					'Jaffa Cakes' => 'jaffa-cakes',
					'Jägermeister' => 'jagermeister',
					'Jameson' => 'jameson',
					'Jamie Oliver' => 'jamie-oliver',
					'Jaybird' => 'jaybird',
					'JBL' => 'jbl',
					'JBL Flip' => 'jbl-flip',
					'JBL GO' => 'jbl-go',
					'JBL Headphones' => 'jbl-headphones',
					'JBL Link' => 'jbl-link',
					'JBL Live' => 'jbl-live',
					'JBL Tune' => 'jbl-tune',
					'JCB' => 'jcb',
					'Jean Paul Gaultier' => 'jean-paul-gautier',
					'Jean Paul Gaultier Le Male' => 'le-male',
					'Jeans' => 'jeans',
					'Jelly Belly' => 'jelly-belly',
					'Jewellery' => 'jewellery',
					'Jigsaw' => 'jigsaw',
					'Jim Beam' => 'jim-beam',
					'Jimmy Choo' => 'jimmy-choo',
					'JML' => 'jml',
					'Jogging Bottoms' => 'jogging-bottoms',
					'Johnnie Walker' => 'johnnie-walker',
					'Johnson&#039;s' => 'johnsons',
					'John West' => 'john-west',
					'John Wick' => 'john-wick',
					'JoJo Siwa' => 'jojo',
					'Joop' => 'joop',
					'Joseph Joseph' => 'joseph-joseph',
					'Joules' => 'joules',
					'Juice' => 'juice',
					'Juicer' => 'juicer',
					'Jumper' => 'jumper',
					'Jurassic World' => 'jurassic-world',
					'Jura Whisky' => 'jura',
					'Just Cause' => 'just-cause',
					'Just Cause 3' => 'just-cause-3',
					'Just Cause 4' => 'just-cause-4',
					'Just Dance' => 'just-dance',
					'JVC' => 'jvc',
					'K-Swiss' => 'k-swiss',
					'Karcher' => 'karcher',
					'Karcher Window Vacuum' => 'karcher-window-cleaner',
					'Karen Millen' => 'karen-millen',
					'Karrimor' => 'karrimor',
					'Kaspersky' => 'kaspersky',
					'Kayak' => 'kayak',
					'Keg' => 'keg',
					'Kellogg&#039;s' => 'kelloggs',
					'Kellogg&#039;s Cornflakes' => 'cornflakes',
					'Kellogg&#039;s Crunchy Nut' => 'crunchy-nut',
					'Kenco' => 'kenco',
					'Kenwood' => 'kenwood',
					'Kenwood kMix' => 'kmix',
					'Kenzo' => 'kenzo',
					'Ketchup' => 'ketchup',
					'Keter' => 'keter',
					'Kettle' => 'kettle',
					'Kettlebell' => 'kettlebell',
					'Keyboard' => 'keyboard',
					'KIA' => 'kia',
					'Kickers' => 'kickers',
					'Kid&#039;s Bike' => 'kids-bike',
					'Kid&#039;s Clothes' => 'kids-clothes',
					'Kid&#039;s Room' => 'kids-rooms',
					'Kid&#039;s Shoes' => 'kids-shoes',
					'Kidizoom' => 'kidizoom',
					'Killzone' => 'killzone',
					'Kilner' => 'kilner',
					'Kinder' => 'kinder',
					'Kindle' => 'kindle',
					'Kindle Book' => 'kindle-book',
					'Kindle Fire' => 'kindle-fire',
					'Kindle Oasis' => 'kindle-oasis',
					'Kindle Paperwhite' => 'kindle-paperwhite',
					'Kingdom Come: Deliverance' => 'kingdom-come-deliverance',
					'Kingdom Hearts' => 'kingdom-hearts',
					'Kingdom Hearts 3' => 'kingdom-hearts-3',
					'Kingdom Hearts: The Story So Far' => 'kingdom-hearts-the-story-so-far',
					'King Kong' => 'king-kong',
					'King Size Bed' => 'king-size',
					'Kingsmill' => 'kingsmill',
					'Kingston' => 'kingston',
					'Kitchen' => 'kitchen',
					'KitchenAid' => 'kitchenaid',
					'Kitchen Appliances' => 'kitchen-appliances',
					'Kitchen Knife' => 'knife',
					'Kitchen Roll' => 'kitchen-roll',
					'Kitchen Scale' => 'kitchen-scales',
					'Kitchen Tap' => 'kitchen-tap',
					'Kitchen Utensils' => 'kitchen-utensils',
					'Kite' => 'kite',
					'KitSound' => 'kitsound',
					'Knickers' => 'knickers',
					'Kobo' => 'kobo',
					'Kodak' => 'kodak',
					'Kodi' => 'kodi',
					'Kohinoor' => 'kohinoor',
					'Kopparberg' => 'kopparberg',
					'Kraken' => 'kraken',
					'Krispy Kreme' => 'krispy-kreme',
					'Krups' => 'krups',
					'KTC' => 'ktc',
					'Kurt Geiger' => 'kurt-geiger',
					'L&#039;Occitane' => 'loccitane',
					'L.O.L. Surprise!' => 'lol-surprise',
					'Lacoste' => 'lacoste',
					'Ladder' => 'ladder',
					'Lamaze' => 'lamaze',
					'Lamb' => 'lamb',
					'Laminate' => 'laminate',
					'Laminator' => 'laminator',
					'Lamp' => 'lamp',
					'Lancôme' => 'lancome',
					'Landmann' => 'landmann',
					'Lantern' => 'lantern',
					'Laphroaig' => 'laphroaig',
					'Laptop' => 'laptop',
					'Laptop Accessories' => 'laptop-accessories',
					'Laptop Case' => 'laptop-case',
					'Laptop Sleeve' => 'laptop-sleeve',
					'Laser Printer' => 'laser-printer',
					'Last Minute' => 'last-minute',
					'Laundry Basket' => 'laundry-basket',
					'Laura Ashley' => 'laura-ashley',
					'Lavazza' => 'lavazza',
					'Lavender' => 'lavender',
					'Lawnmower' => 'lawnmower',
					'Lay-Z-Spa' => 'lay-z-spa',
					'LeapFrog' => 'leapfrog',
					'Le Creuset' => 'le-creuset',
					'LED Bulb' => 'led-bulbs',
					'LED Light' => 'led-light',
					'LED Strip Lights' => 'led-strip-lights',
					'LED TV' => 'led-tv',
					'Lee Stafford' => 'lee-stafford',
					'Leffe' => 'leffe',
					'Leggings' => 'leggings',
					'Lego' => 'lego',
					'Lego Advent Calendar' => 'lego-advent-calendar',
					'Lego Architecture' => 'lego-architecture',
					'Lego Art' => 'lego-art',
					'Lego Batman' => 'lego-batman',
					'Lego BrickHeadz' => 'lego-brickheadz',
					'Lego City' => 'lego-city',
					'Lego Classic' => 'lego-classic',
					'Lego Creator' => 'lego-creator',
					'Lego Dimensions' => 'lego-dimensions',
					'Lego Disney' => 'lego-disney',
					'Lego Dots' => 'lego-dots',
					'Lego Duplo' => 'lego-duplo',
					'Lego Friends' => 'lego-friends',
					'LEGO Harry Potter' => 'lego-harry-potter',
					'Lego Hidden Side' => 'lego-hidden-side',
					'Legoland' => 'legoland',
					'Lego Marvel' => 'lego-marvel',
					'Lego Mindstorms' => 'lego-mindstorms',
					'Lego Nexo Knights' => 'lego-nexo-knights',
					'Lego Ninjago' => 'lego-ninjago',
					'Lego Porsche' => 'lego-porsche',
					'Lego Simpsons' => 'lego-simpsons',
					'Lego Speed Champions' => 'lego-speed-champions',
					'Lego Star Wars' => 'lego-star-wars',
					'Lego Star Wars Millennium Falcon' => 'lego-star-wars-millennium-falcon',
					'Lego Super Mario' => 'lego-mario',
					'Lego Technic' => 'lego-technic',
					'Lego VIDIYO' => 'lego-vidiyo',
					'Lemonade' => 'lemonade',
					'Lenor' => 'lenor',
					'Lenovo' => 'lenovo',
					'Lenovo IdeaPad' => 'lenovo-ideapad',
					'Lenovo Laptop' => 'lenovo-laptop',
					'Lenovo Tablet' => 'lenovo-tablet',
					'Lenovo Thinkpad' => 'thinkpad',
					'Lenovo Yoga Laptop' => 'lenovo-yoga-laptop',
					'Lenovo Yoga Tablet' => 'lenovo-yoga',
					'Les Paul' => 'les-paul',
					'Levi&#039;s' => 'levi',
					'Lexar' => 'lexar',
					'LG' => 'lg',
					'LG G3' => 'lg-g3',
					'LG G5' => 'lg-g5',
					'LG G6' => 'lg-g6',
					'LG G7' => 'lg-g7',
					'LG G8S ThinQ' => 'lg-g8s-thinq',
					'LG OLED TV' => 'lg-oled-tv',
					'LG Smartphone' => 'lg-smartphone',
					'LG TV' => 'lg-tv',
					'LG V30' => 'lg-v30',
					'LG V40 ThinQ' => 'lg-v40-thinq',
					'Life Insurance' => 'life-insurance',
					'Life is Strange' => 'life-is-strange',
					'Light Box' => 'light-box',
					'Lighting' => 'lighting',
					'Lightning Cable' => 'lightning-cable',
					'Lightsaber' => 'lightsaber',
					'Lindor' => 'lindor',
					'Lindt' => 'lindt',
					'Lingerie' => 'lingerie',
					'Linksys' => 'linksys',
					'Linx' => 'linx',
					'Lion King' => 'lion-king',
					'Lipstick' => 'lipstick',
					'Lipsy' => 'lipsy',
					'Little Tikes' => 'little-tikes',
					'Liverpool F. C.' => 'liverpool-fc',
					'Living Room' => 'living-room',
					'Local Traffic' => 'local-traffic',
					'Lodge' => 'lodge',
					'Loft' => 'loft',
					'Logitech' => 'logitech',
					'Logitech G430' => 'logitech-g430',
					'Logitech G703' => 'logitech-g703',
					'Logitech G903' => 'logitech-g903',
					'Logitech Harmony' => 'harmony',
					'Logitech Keyboard' => 'logitech-keyboard',
					'Logitech Mouse' => 'logitech-mouse',
					'Logitech MX Master' => 'logitech-mx-master',
					'Logitech MX Master 2S' => 'logitech-mx-master-2s',
					'London Eye' => 'london-eye',
					'London Zoo' => 'london-zoo',
					'Longleat' => 'longleat',
					'Long Sleeve' => 'long-sleeve',
					'Lord of the Rings' => 'lord-of-the-rings',
					'Lottery' => 'lottery',
					'Lounger' => 'lounger',
					'Lowepro' => 'lowepro',
					'Lucozade' => 'lucozade',
					'Luigi' => 'luigi',
					'Luigi&#039;s Mansion' => 'luigis-manison',
					'Luigi&#039;s Mansion 3' => 'luigis-mansion-3',
					'Lunch Bag' => 'lunch-bag',
					'Lunch Box' => 'lunch-box',
					'Lurpak' => 'lurpak',
					'Luton' => 'luton',
					'Lyle &amp; Scott' => 'lyle-and-scott',
					'Lynx' => 'lynx',
					'M.2 SSD' => 'm2-ssd',
					'MacBook' => 'macbook',
					'MacBook Air' => 'macbook-air',
					'MacBook Pro' => 'macbook-pro',
					'MacBook Pro 13' => 'macbook-pro-13',
					'MacBook Pro 15' => 'macbook-pro-15',
					'MacBook Pro 16' => 'macbook-pro-16',
					'Maclaren' => 'maclaren',
					'Mac mini' => 'mac-mini',
					'Madame Tussauds' => 'madame-tussauds',
					'Mad Catz' => 'madcatz',
					'Madden NFL' => 'madden',
					'Madden NFL 20' => 'madden-nfl-20',
					'Mad Max' => 'mad-max',
					'Mafia 3' => 'mafia-3',
					'Magazine' => 'magazine',
					'Magimix' => 'magimix',
					'Magners' => 'magners',
					'Magnum' => 'magnum',
					'Make Up' => 'make-up',
					'Makeup Advent Calendar' => 'makeup-advent-calendar',
					'Make Up Brush' => 'make-up-brush',
					'Makita' => 'makita',
					'Makita Drill' => 'makita-drill',
					'Malibu' => 'malibu',
					'Maltesers' => 'maltesers',
					'MAM' => 'mam',
					'Mamas &amp; Papas' => 'mamas-and-papas',
					'Manchester United' => 'manchester-united',
					'Manfrotto' => 'manfrotto',
					'Manga' => 'manga',
					'Manuka Honey' => 'manuka-honey',
					'Marantz' => 'marantz',
					'Marc Jacobs' => 'marc-jacobs',
					'Marc Jacobs Daisy' => 'daisy',
					'Mario &amp; Sonic at the Olympic Games: Tokyo 2020' => 'mario-and-sonic-tokyo-2020',
					'Mario + Rabbids Kingdom Battle' => 'mario-rabbids-kingdom-battle',
					'Mario Kart' => 'mario-kart',
					'Mario Kart 8' => 'mario-kart-8',
					'Mario Kart 8 Deluxe' => 'mario-kart-8-deluxe',
					'Marmite' => 'marmite',
					'Mars' => 'mars',
					'Marshall' => 'marshall',
					'Marshall Headphones' => 'marshall-headphones',
					'Marvel' => 'marvel',
					'Marvel&#039;s Spider-Man (PS4)' => 'spider-man-2018',
					'Marvel&#039;s Spider-Man: Miles Morales' => 'spiderman-miles-morales',
					'Mascara' => 'mascara',
					'Massage' => 'massage',
					'Mass Effect' => 'mass-effect',
					'Mass Effect: Andromeda' => 'mass-effect-andromeda',
					'Mastercard' => 'mastercard',
					'Masterplug' => 'masterplug',
					'Maternity &amp; Pregnancy' => 'maternity',
					'Mattress' => 'mattress',
					'Mattress Protector' => 'mattress-protector',
					'Mattress Topper' => 'mattress-topper',
					'Mavic' => 'mavic',
					'Max Factor' => 'max-factor',
					'Maxi Cosi' => 'maxi-cosi',
					'Maximuscle' => 'maximuscle',
					'Maxtor' => 'maxtor',
					'Maybelline' => 'maybelline',
					'Mayo' => 'mayo',
					'Mazda' => 'mazda',
					'McAfee' => 'mcafee',
					'Meat &amp; Sausages' => 'meat',
					'Meccano' => 'meccano',
					'Mechanical Keyboard' => 'mechanical-keyboard',
					'Medal of Honor' => 'medal-of-honor',
					'Medela' => 'medela',
					'Media Player' => 'media-player',
					'Medievil' => 'medievil',
					'Medion' => 'medion',
					'Mega Bloks' => 'mega-bloks',
					'Megathread' => 'megathread',
					'Melissa &amp; Doug' => 'melissa',
					'Memory Cards' => 'memory-cards',
					'Memory Foam Mattress' => 'memory-foam',
					'Men&#039;s Boots' => 'mens-boots',
					'Men&#039;s Fragrance' => 'mens-fragrance',
					'Men&#039;s Shoes' => 'mens-shoes',
					'Men&#039;s Suit' => 'suit',
					'Mercedes' => 'mercedes',
					'Meridian' => 'meridian',
					'Merlin' => 'merlin',
					'Merrell' => 'merrell',
					'Messenger Bag' => 'messenger-bag',
					'Metal Gear Solid' => 'metal-gear-solid',
					'Metro Exodus' => 'metro-exodus',
					'Metroid' => 'metroid',
					'Metro Series' => 'metro-series',
					'Michael Kors' => 'michael-kors',
					'Michelin' => 'michelin',
					'Microphone' => 'microphone',
					'Micro SD Card' => 'micro-sd',
					'Micro SDHC' => 'micro-sdhc',
					'Micro SDXC' => 'micro-sdxc',
					'Microserver' => 'microserver',
					'Microsoft' => 'microsoft',
					'Microsoft Flight Simulator' => 'microsoft-flight-simulator',
					'Microsoft Office' => 'microsoft-office',
					'Microsoft Points' => 'microsoft-points',
					'Microsoft Software' => 'microsoft-software',
					'Microsoft Surface Book' => 'surface-book',
					'Microsoft Surface Laptop' => 'surface',
					'Microsoft Surface Pro 6' => 'surface-pro-6',
					'Microsoft Surface Pro 7' => 'surface-pro-7',
					'Microsoft Surface Tablet' => 'microsoft-surface-tablet',
					'Microwave' => 'microwave',
					'Middle Earth' => 'middle-earth',
					'Middle Earth: Shadow of Mordor' => 'shadow-of-mordor',
					'Middle Earth: Shadow of War' => 'middle-earth-shadow-of-war',
					'Miele' => 'miele',
					'Miele Vacuum Cleaner' => 'miele-vacuum-cleaner',
					'Milk' => 'milk',
					'Milk Frother' => 'milk-frother',
					'Milk Tray' => 'milk-tray',
					'Milwaukee' => 'milwaukee',
					'Mince' => 'mince',
					'Minecraft Game' => 'minecraft',
					'Mineral Water' => 'mineral-water',
					'Mini Fridge' => 'mini-fridge',
					'Minions' => 'minions',
					'Mini PC' => 'mini-pc',
					'Minky' => 'minky',
					'Mira' => 'mira',
					'Mirror' => 'mirror',
					'Mirror&#039;s Edge' => 'mirrors-edge',
					'Misc' => 'misc',
					'Misfit' => 'misfit',
					'Mitre Saw' => 'mitre-saw',
					'Mitsubishi' => 'mitsubishi',
					'Mixer &amp; Blender' => 'mixer-and-blender',
					'Mobile Contracts' => 'mobile-contract',
					'Mobile Phone' => 'mobile-phone',
					'Model Building' => 'model-building',
					'Moët' => 'moet',
					'Molton Brown' => 'molton-brown',
					'Money Saving Tips and Tricks' => 'money-saving-tips',
					'Monitor' => 'monitor',
					'Monopoly' => 'monopoly',
					'Monsoon' => 'monsoon',
					'Monster Energy' => 'monster-energy',
					'Monster High' => 'monster-high',
					'Monster Hunter' => 'monster-hunter',
					'Monster Hunter World' => 'monster-hunter-world',
					'Mont Blanc' => 'mont-blanc',
					'Mop' => 'mop',
					'Morphy Richards' => 'morphy-richards',
					'Mortal Kombat' => 'mortal-kombat',
					'Mortal Kombat 11' => 'mortal-kombat-11',
					'Mortgage' => 'mortgage',
					'Moschino' => 'moschino',
					'Moses Basket' => 'moses-basket',
					'MOT' => 'mot',
					'Motherboard' => 'motherboard',
					'Moto 360' => 'moto-360',
					'Moto E' => 'moto-e',
					'Moto G' => 'moto-g',
					'Moto G4' => 'moto-g4',
					'Moto G5' => 'moto-g5',
					'Moto G6' => 'moto-g6',
					'Moto G7' => 'moto-g7',
					'Motorcycle' => 'motorcycle',
					'Motorcycle Accessories' => 'motorcycle-accessories',
					'Motorcycle Helmet' => 'motorcycle-helmet',
					'Motorola' => 'motorola',
					'Motorola Smartphone' => 'motorola-smartphone',
					'Moto X' => 'moto-x',
					'Moto Z' => 'moto-z',
					'Mountain Bike' => 'mountain-bike',
					'Mouse &amp; Keyboard Bundles' => 'mouse-and-keyboard-bundle',
					'Mouse Mat' => 'mouse-mat',
					'Mouthwash' => 'mouthwash',
					'Movie and TV Box Set' => 'box-set',
					'Movies &amp; Series' => 'movie',
					'MP3 Player' => 'mp3-player',
					'Mr Kipling' => 'mr-kipling',
					'Mr Men' => 'mr-men',
					'MSI' => 'msi',
					'MSI Laptop' => 'msi-laptop',
					'Muc-Off' => 'muc-off',
					'Mug' => 'mug',
					'Muller' => 'muller',
					'Multi-Room Audio System' => 'multi-room-audio-system',
					'Multitool' => 'multitool',
					'Museums' => 'museums',
					'Music' => 'music',
					'Musical Instruments' => 'musical-instrument',
					'Music App' => 'music-app',
					'Music Streaming' => 'music-streaming',
					'My Little Pony' => 'my-little-pony',
					'Nail Gun' => 'nail-gun',
					'Nail Polish' => 'nail-polish',
					'Nails' => 'nails',
					'Nails Inc.' => 'nails-inc',
					'Nakd' => 'nakd',
					'Nando&#039;s' => 'nandos',
					'Nappy' => 'nappy',
					'NAS' => 'nas',
					'National Express Ticket' => 'national-express',
					'National Trust' => 'national-trust',
					'Nature Observation' => 'nature-observation',
					'NatWest' => 'natwest',
					'NBA 2K' => 'nba-2k',
					'NBA Live' => 'nba',
					'Necklace' => 'necklace',
					'Need for Speed' => 'need-for-speed',
					'Need for Speed: Payback' => 'need-for-speed-payback',
					'Need for Speed Heat' => 'need-for-speed-heat',
					'Neff' => 'neff',
					'Nerf Guns' => 'nerf',
					'Nescafé Azera' => 'azera',
					'Nescafé Coffee' => 'nescafe',
					'Nespresso' => 'nespresso',
					'Nespresso Coffee Machine' => 'nespresso-coffee-machine',
					'Nest Hello' => 'nest-hello',
					'Nestlé' => 'nestle',
					'Nest Learning Thermostat' => 'nest-learning-thermostat',
					'Nestlé Cheerios' => 'cheerios',
					'Nestlé Shreddies' => 'shreddies',
					'Netatmo' => 'netatmo',
					'Netflix' => 'netflix',
					'Netgear' => 'netgear',
					'Netgear Arlo' => 'arlo',
					'New Balance' => 'new-balance',
					'New Balance Trainers' => 'new-balance-trainers',
					'New Look' => 'new-look',
					'Newspapers' => 'newspapers',
					'Nextbase' => 'nextbase',
					'NFL' => 'nfl',
					'NHL' => 'nhl',
					'NHL 20' => 'nhl-20',
					'NHS' => 'nhs',
					'NieR: Automata' => 'nier',
					'Night Light' => 'night-light',
					'Nike' => 'nike',
					'Nike Air Max' => 'nike-air-max',
					'Nike Air Max 200' => 'nike-air-max-200',
					'Nike Air Max 270' => 'nike-air-max-270',
					'Nike Air Max 720' => 'nike-air-max-720',
					'Nike Free' => 'nike-free',
					'Nike Huarache' => 'nike-huarache',
					'Nike Jordan' => 'jordan',
					'Nike Presto' => 'nike-presto',
					'Nike Roshe' => 'nike-roshe',
					'Nike Trainers' => 'nike-shoes',
					'Nikon' => 'nikon',
					'Nikon Camera' => 'nikon-camera',
					'Nikon Coolpix' => 'nikon-coolpix',
					'Nikon D3400' => 'nikon-d3400',
					'Nikon Lens' => 'nikon-lens',
					'Nilfisk' => 'nilfisk',
					'Ni No Kuni' => 'ni-no-kuni',
					'Ni No Kuni: Wrath of the White Witch' => 'ni-no-kuni-white-witch',
					'Ni No Kuni II: Revenant Kingdom' => 'ni-no-kuni-2',
					'Nintendo' => 'nintendo',
					'Nintendo 2DS' => '2ds',
					'Nintendo 3DS' => '3ds',
					'Nintendo 3DS Game' => '3ds-games',
					'Nintendo 3DS XL' => 'nintendo-3ds-xl',
					'Nintendo Accessories' => 'nintendo-accessories',
					'Nintendo Classic Mini' => 'nintendo-classic-mini',
					'Nintendo DS Game' => 'ds-games',
					'Nintendo Labo' => 'switch-labo',
					'Nintendo Switch' => 'nintendo-switch',
					'Nintendo Switch Accessories' => 'switch-accessories',
					'Nintendo Switch Case' => 'switch-case',
					'Nintendo Switch Controller' => 'switch-controller',
					'Nintendo Switch Game' => 'switch-game',
					'Nintendo Switch Joy-Con' => 'switch-joy-con',
					'Nintendo Switch Lite' => 'nintendo-switch-lite',
					'Nintendo Switch Pro Controller' => 'switch-pro-controller',
					'Nioh' => 'nioh',
					'Nissan' => 'nissan',
					'Nivea' => 'nivea',
					'No7' => 'no7',
					'Noise Cancelling Headphones' => 'noise-cancelling-headphones',
					'Nokia' => 'nokia',
					'Nokia Smartphones' => 'nokia-mobile',
					'No Man&#039;s Sky' => 'no-man-s-sky',
					'Noodles' => 'noodles',
					'Norton' => 'norton',
					'Now' => 'now-tv',
					'Numatic' => 'numatic',
					'Nursery' => 'nursery',
					'Nutella' => 'nutella',
					'NutriBullet' => 'nutribullet',
					'Nutri Ninja' => 'nutri-ninja',
					'Nuts' => 'nuts',
					'Nvidia' => 'nvidia',
					'Nvidia GeForce' => 'geforce',
					'Nvidia Shield' => 'nvidia-shield',
					'NYX' => 'nyx',
					'NZXT' => 'nzxt',
					'O2' => 'o2',
					'O2 Refresh' => 'o2-refresh',
					'Oakley' => 'oakley',
					'Octonauts' => 'octonauts',
					'Oculus Game' => 'oculus-game',
					'Oculus Go' => 'oculus-go',
					'Oculus Quest' => 'oculus-quest',
					'Oculus Rift' => 'oculus',
					'Oculus Rift S' => 'oculus-rift-s',
					'Odeon' => 'odeon',
					'Office' => 'office',
					'Office Chair' => 'office-chair',
					'Official Announcements' => 'official-announcements',
					'Olay' => 'olay',
					'OLED TV' => 'oled',
					'Olive Oil' => 'olive-oil',
					'Olympus' => 'olympus',
					'Omega Seamaster' => 'omega-seamaster',
					'Omega Speedmaster' => 'omega-speedmaster',
					'Omega Watches' => 'omega-watch',
					'OnePlus 3' => 'oneplus-3',
					'OnePlus 5' => 'oneplus-5',
					'OnePlus 6' => 'oneplus-6',
					'OnePlus 6T' => 'oneplus-6t',
					'OnePlus 7' => 'oneplus-7',
					'OnePlus 7 Pro' => 'oneplus-7-pro',
					'OnePlus 7T' => 'oneplus-7t',
					'OnePlus 7T Pro' => 'one-plus-7t-pro',
					'OnePlus 8' => 'oneplus-8',
					'OnePlus 8 Pro' => 'oneplus-8-pro',
					'OnePlus 8T' => 'oneplus-8t',
					'OnePlus 9' => 'oneplus-9',
					'OnePlus 9 Pro' => 'oneplus-9-pro',
					'OnePlus Nord' => 'oneplus-nord',
					'OnePlus Nord N10 5G' => 'oneplus-n10',
					'OnePlus Nord N100' => 'oneplus-n100',
					'OnePlus Smartphone' => 'oneplus',
					'Onesie' => 'onesie',
					'Onkyo' => 'onkyo',
					'Online Courses' => 'online-courses',
					'Operating System' => 'operating-system',
					'Oppo Find X2 Lite' => 'oppo-find-x2-lite',
					'Oppo Find X2 Neo' => 'oppo-find-x2-neo',
					'Oppo Find X2 Pro' => 'oppo-find-x2-pro',
					'Oppo Reno' => 'oppo-reno',
					'Oppo Reno4 5G' => 'oppo-reno4',
					'Oppo Reno4 Z 5G' => 'oppo-reno4-z',
					'Oppo Smartphone' => 'oppo-smartphone',
					'Opticians' => 'opticians',
					'Optoma' => 'optoma',
					'Oral-B' => 'oral-b',
					'Oral-B Toothbrush' => 'oral-b-toothbrush',
					'Oreo' => 'oreo',
					'Origin' => 'origin',
					'Original Penguin' => 'penguin',
					'Orla Kiely' => 'orla-kiely',
					'Osprey' => 'osprey',
					'Osram' => 'osram',
					'Other' => 'other-deals',
					'Ottoman' => 'ottoman',
					'Oukitel' => 'oukitel',
					'Outdoor Clothing' => 'outdoor-clothing',
					'Outdoor Lighting' => 'outdoor-lighting',
					'Outdoor Sports &amp; Camping' => 'outdoor',
					'Outdoor Toys' => 'outdoor-toys',
					'Outlast' => 'outlast',
					'Outlet' => 'outlet',
					'Outwell' => 'outwell',
					'Oven' => 'oven',
					'Overcooked' => 'overcooked',
					'Overcooked 2' => 'overcooked-2',
					'Overwatch' => 'overwatch',
					'Oyster Card' => 'oyster',
					'Package Holidays' => 'holiday',
					'Paco Rabanne' => 'paco-rabanne',
					'Paco Rabanne 1 Million' => 'paco-rabanne-1-million',
					'Paco Rabanne Lady Million' => 'lady-million',
					'Paddling Pool' => 'paddling-pool',
					'Padlock' => 'padlock',
					'Paint' => 'paint',
					'Paint Brush' => 'paint-brush',
					'Pampers' => 'pampers',
					'Panasonic' => 'panasonic',
					'Panasonic Camera' => 'panasonic-camera',
					'Panasonic Lumix' => 'lumix',
					'Panasonic TV' => 'panasonic-tv',
					'Pandora' => 'pandora',
					'Panini' => 'panini',
					'Panini Stickers' => 'panini-stickers',
					'Papa Johns' => 'papa-johns',
					'Paper Mario' => 'paper-mario',
					'Parasol' => 'parasol',
					'Parcel and Delivery Services' => 'parcel',
					'Parka' => 'parka',
					'Parking' => 'parking',
					'Parrot' => 'parrot',
					'Paul Smith' => 'paul-smith',
					'PAW Patrol' => 'paw-patrol',
					'Payday' => 'payday',
					'Payday 2' => 'payday-2',
					'PAYG' => 'payg',
					'Pay Monthly' => 'pay-monthly',
					'PC' => 'pc',
					'PC Case' => 'pc-case',
					'PC Game' => 'pc-game',
					'PC Gaming Accessories' => 'pc-gaming-accessories',
					'PC Gaming Systems' => 'pc-gaming-systems',
					'PC Mouse' => 'mouse',
					'PC Parts' => 'pc-parts',
					'Peanut Butter' => 'peanut-butter',
					'Peanuts' => 'peanuts',
					'Pedometer' => 'pedometer',
					'Pentax' => 'pentax',
					'Peppa Pig' => 'peppa-pig',
					'PepperBonus' => 'pepperbonus',
					'Pepsi' => 'pepsi',
					'Perfume' => 'perfume',
					'Persil' => 'persil',
					'Persona' => 'persona',
					'Persona 5' => 'persona-5',
					'Personal Care &amp; Hygiene' => 'personal-care-hygiene',
					'Petrol and Diesel' => 'petrol',
					'Pet Supplies' => 'pets',
					'Peugeot' => 'peugeot',
					'PG Tips' => 'pg-tips',
					'Philips' => 'philips',
					'Philips Alarm Clock' => 'philips-alarm-clock',
					'Philips Avent' => 'avent',
					'Philips Hue' => 'philips-hue',
					'Philips Lumea' => 'lumea',
					'Philips OneBlade' => 'philips-one-blade',
					'Philips Senseo' => 'philips-senseo',
					'Philips Senseo Coffee Machine' => 'philips-senseo-coffee-machine',
					'Philips Shaver' => 'philips-shaver',
					'Philips Sonicare' => 'sonicare',
					'Philips TV' => 'philips-tv',
					'Phone Holder' => 'phone-holder',
					'Phones &amp; Accessories' => 'phone',
					'Photo &amp; Cameras' => 'photo-video',
					'Photo &amp; Video App' => 'photo-video-app',
					'Photo Editing' => 'photo-editing',
					'Photo Frame' => 'photo-frame',
					'Photo Paper' => 'photo-paper',
					'Piano' => 'piano',
					'Picnic &amp; Outdoor Cooking' => 'picnic',
					'Pikmin 3 Deluxe' => 'pikmin-3-deluxe',
					'Pillow' => 'pillow',
					'Pimm&#039;s' => 'pimms',
					'Pioneer' => 'pioneer',
					'Pirate Toys' => 'pirates',
					'PIR Lights' => 'pir',
					'Pixel C' => 'pixel-c',
					'Piz Buin' => 'piz-buin',
					'Pizza' => 'pizza',
					'Pizza Stone' => 'pizza-stone',
					'Planer' => 'planer',
					'Planet Earth' => 'planet-earth',
					'Plant' => 'plant',
					'Plant Pot' => 'plant-pots',
					'Plants vs. Zombies: Battle for Neighborville' => 'battle-for-neighborville',
					'Plants vs Zombies' => 'plants-vs-zombies',
					'Play-Doh' => 'play-doh',
					'PlayerUnknown&#039;s Battlegrounds' => 'playerunknown-s-battlegrounds',
					'Playhouse' => 'playhouse',
					'Playing Cards' => 'playing-cards',
					'Playmat' => 'playmat',
					'Playmobil' => 'playmobil',
					'Playmobil Advent Calendar' => 'playmobil-advent-calendar',
					'PlayStation' => 'playstation',
					'PlayStation 5 DualSense Controller' => 'ps5-controller',
					'PlayStation Accessories' => 'playstation-accessories',
					'PlayStation Classic' => 'playstation-classic',
					'PlayStation Move' => 'playstation-move',
					'PlayStation Now' => 'playstation-now',
					'PlayStation Plus' => 'playstation-plus',
					'PlayStation VR' => 'playstation-vr',
					'PlayStation VR Aim Controller' => 'aim-controller-ps4',
					'Pliers' => 'pliers',
					'Plumbing &amp; Fittings' => 'plumbing-and-fitting',
					'Plus Size' => 'plus-size',
					'PNY' => 'pny',
					'POCO F2 Pro' => 'poco-f2-pro',
					'POCO F3' => 'poco-f3',
					'Poco M3' => 'poco-m3',
					'POCO X3' => 'poco-x3',
					'POCO X3 Pro' => 'poco-x3-pro',
					'Pokémon' => 'pokemon',
					'Pokémon: Let&#039;s Go' => 'pokemon-lets-go',
					'Pokémon Go' => 'pokemon-go',
					'Pokemon Sword and Shield' => 'pokemon-sword-and-shield',
					'Pokémon Ultra Sun and Ultra Moon' => 'pokemon-ultra-sun-ultra-moon',
					'Poker' => 'poker',
					'Pokken Tournament' => 'pokken-tournament',
					'Polaroid' => 'polaroid',
					'Police Toys' => 'police',
					'Polo Shirt' => 'polo-shirt',
					'Pool' => 'pool',
					'Pool &amp; Snooker' => 'pool-table',
					'Popcorn' => 'popcorn',
					'Pork' => 'pork',
					'Porridge &amp; Oats' => 'porridge-and-oats',
					'Portable Wireless Speaker' => 'wireless-speaker',
					'Poster' => 'poster',
					'Pots and Pans' => 'pan',
					'Potty' => 'potty',
					'Power Bank' => 'power-bank',
					'Powerbeats Pro' => 'powerbeats-pro',
					'Power Dental Flosser' => 'floss',
					'Powerline' => 'powerline',
					'Power Rangers' => 'power-rangers',
					'Power Tool' => 'power-tool',
					'Prada' => 'prada',
					'Pram' => 'pram',
					'Pregnancy' => 'pregnancy',
					'Prescription Glasses' => 'prescription-glasses',
					'Pressure Cooker' => 'pressure-cooker',
					'Pressure Washer' => 'pressure-washer',
					'Price Glitch' => 'price-glitch',
					'Prime Gaming' => 'twitch',
					'Pringles' => 'pringles',
					'Printer &amp; Printer Supplies' => 'printer',
					'Printer Supplies' => 'printer-supplies',
					'Productivity App' => 'productivity-app',
					'Pro Evolution Soccer' => 'pro-evolution-soccer',
					'Pro Evolution Soccer 2018' => 'pro-evolution-soccer-2018',
					'Pro Evolution Soccer 2019' => 'pro-evolution-soccer-2019',
					'Pro Evolution Soccer 2020' => 'pes-2020',
					'Project Cars' => 'project-cars',
					'Project Cars 2' => 'project-cars-2',
					'Projector' => 'projector',
					'Protein' => 'protein',
					'Protein Bars' => 'protein-bars',
					'Protein Shaker' => 'shaker',
					'PS4' => 'ps4-slim',
					'PS4 Camera' => 'ps4-camera',
					'PS4 Controller' => 'ps4-controller',
					'PS4 Games' => 'ps4-games',
					'PS4 Headset' => 'ps4-headset',
					'PS4 Pro' => 'ps4-pro',
					'PS5' => 'ps5',
					'PS5 Games' => 'ps5-game',
					'PSU' => 'psu',
					'Public Transport' => 'public-transport',
					'Pukka' => 'pukka',
					'Pulse Light Epilator' => 'pulse-light-epilator',
					'Puma' => 'puma',
					'Puma Trainers' => 'puma-trainers',
					'Puppy Supplies' => 'puppy',
					'Purse' => 'purse',
					'Pushchair' => 'pushchair',
					'Pushchairs and Strollers' => 'baby-transport',
					'Puzzle' => 'puzzle',
					'PVR' => 'pvr',
					'Pyjamas' => 'pyjamas',
					'Pyrex' => 'pyrex',
					'Q Acoustics' => 'q-acoustics',
					'QNAP' => 'qnap',
					'Qualcast' => 'qualcast',
					'Quality Street' => 'quality-street',
					'Quantum Break' => 'quantum-break',
					'Quechua' => 'quechua',
					'Quick Charge' => 'quick-charge',
					'Quiksilver' => 'quiksilver',
					'Quinny' => 'quinny',
					'Quorn' => 'quorn',
					'Rab' => 'rab',
					'Radeon RX 480' => 'rx-480',
					'Radeon RX 5700' => 'radeon-rx-5700',
					'Radeon RX 5700 XT' => 'radeon-rx-5700-xt',
					'Radeon RX 6800' => 'radeon-rx-6800',
					'Radeon RX 6800 XT' => 'radeon-rx-6800-xt',
					'Radeon RX 6900 XT' => 'radeon-rx-6900-xt',
					'Radiator' => 'radiator',
					'Radio' => 'radio',
					'Radley' => 'radley',
					'Rage 2' => 'rage-2',
					'Railcard' => 'railcard',
					'Rainbow Six' => 'rainbow-six',
					'Rake' => 'rake',
					'Ralph Lauren' => 'ralph-lauren',
					'RAM' => 'ram',
					'Raspberry Pi' => 'raspberry-pi',
					'Ratchet' => 'ratchet',
					'Ratchet and Clank' => 'ratchet-and-clank',
					'Rattan Garden Furniture' => 'rattan',
					'RAVPower' => 'ravpower',
					'Ray Ban' => 'ray-ban',
					'Razer' => 'razer',
					'Razor' => 'razor',
					'Razor Blade' => 'razor-blade',
					'Real Madrid' => 'real-madrid',
					'Realme Smartphones' => 'realme-smartphone',
					'Real Techniques' => 'real-techniques',
					'Recliner' => 'recliner',
					'ReCore' => 'recore',
					'Recreational Sports' => 'recreational-sports',
					'Red Bull' => 'red-bull',
					'Red Dead Redemption' => 'red-dead-redemption',
					'Red Dead Redemption 2' => 'red-dead-redemption-2',
					'Redex' => 'redex',
					'Red Kite' => 'red-kite',
					'Reebok' => 'reebok',
					'Reese&#039;s' => 'reeses',
					'Regatta' => 'regatta',
					'Regina' => 'regina',
					'Remington' => 'remington',
					'Remote Control Car' => 'remote-control-car',
					'Renault' => 'renault',
					'Resident Evil' => 'resident-evil',
					'Resident Evil 2' => 'resident-evil-2',
					'Resident Evil 7' => 'resident-evil-7',
					'Restaurant, Café &amp; Pub' => 'restaurant',
					'Retailer Offers and Issues' => 'retailer-offers-and-issues',
					'Ribena' => 'ribena',
					'Rice' => 'rice',
					'Rice Cooker' => 'rice-cooker',
					'Rick and Morty' => 'rick-and-morty',
					'Ricoh' => 'ricoh',
					'Ride On' => 'ride-on',
					'Ring' => 'ring',
					'Ring Door View Cam' => 'ring-door-view-cam',
					'Ring Fit Adventures' => 'ring-fit-adventures',
					'Ring Stick Up Cam' => 'ring-stick-up-cam',
					'Ring Video Doorbell' => 'ring-video-doorbell',
					'Ring Video Doorbell 2' => 'ring-video-doorbell-2',
					'Ring Video Doorbell 3' => 'ring-video-doorbell-3',
					'Ring Video Doorbell Pro' => 'ring-video-doorbell-pro',
					'Road Bike' => 'road-bike',
					'Roaming' => 'roaming',
					'Robinsons' => 'robinsons',
					'Robotic Lawnmower' => 'robotic-lawnmower',
					'Robot Vacuum Cleaner' => 'robot-vacuum-cleaner',
					'Rock Band' => 'rock-band',
					'Rocket League' => 'rocket-league',
					'Rocking Horse' => 'rocking-horse',
					'Rogue One: A Star Wars Story' => 'rogue-one',
					'Roku' => 'roku',
					'Rolex' => 'rolex',
					'Rollerskates' => 'skate',
					'Ronseal' => 'ronseal',
					'Roof Box' => 'roof-box',
					'Roses' => 'roses',
					'Rotary' => 'rotary',
					'Router' => 'router',
					'Rowenta' => 'rowenta',
					'RTX 2060' => 'rtx-2060',
					'RTX 2070' => 'rtx-2070',
					'RTX 2080' => 'rtx-2080',
					'RTX 2080 Ti' => 'rtx-2080-ti',
					'RTX 3070' => 'rtx-3070',
					'RTX 3080' => 'rtx-3080',
					'RTX 3090' => 'rtx-3090',
					'Rug' => 'rug',
					'Rugby' => 'rugby',
					'Rum' => 'rum',
					'Running' => 'running',
					'Running Shoes' => 'running-shoes',
					'Russell Hobbs' => 'russell-hobbs',
					'RX 570' => 'rx-570',
					'RX 580' => 'rx-580',
					'RX 590' => 'rx-590',
					'RX Vega 56' => 'rx-vega-56',
					'RX Vega 64' => 'rx-vega-64',
					'Ryanair' => 'ryanair',
					'Ryobi' => 'ryobi',
					'Safari' => 'safari',
					'Safety Boots' => 'safety-boots',
					'Sage by Heston Blumenthal' => 'sage',
					'Saints Row' => 'saints-row',
					'Saitek' => 'saitek',
					'Sale' => 'sale',
					'Salmon' => 'salmon',
					'Salomon' => 'salomon',
					'Salter' => 'salter',
					'Samsonite' => 'samsonite',
					'Samsung' => 'samsung',
					'Samsung Ecobubble' => 'ecobubble',
					'Samsung Fridge' => 'samsung-fridge',
					'Samsung Galaxy' => 'samsung-galaxy',
					'Samsung Galaxy A10' => 'samsung-galaxy-a10',
					'Samsung Galaxy A20e' => 'samsung-galaxy-a20e',
					'Samsung Galaxy A40' => 'samsung-galaxy-a40',
					'Samsung Galaxy A42 5G' => 'samsung-galaxy-a42-5g',
					'Samsung Galaxy A50' => 'samsung-galaxy-a50',
					'Samsung Galaxy A51' => 'samsung-galaxy-a51',
					'Samsung Galaxy A52 5G' => 'samsung-galaxy-a52',
					'Samsung Galaxy A60' => 'samsung-galaxy-a60',
					'Samsung Galaxy A70' => 'samsung-galaxy-a70',
					'Samsung Galaxy A71' => 'samsung-galaxy-a71',
					'Samsung Galaxy A72' => 'samsung-galaxy-a72',
					'Samsung Galaxy A80' => 'samsung-galaxy-a80',
					'Samsung Galaxy A90' => 'samsung-galaxy-a90',
					'Samsung Galaxy Buds' => 'samsung-galaxy-buds',
					'Samsung Galaxy Buds+' => 'samsung-galaxy-buds-plus',
					'Samsung Galaxy Buds Live' => 'samsung-galaxy-buds-live',
					'Samsung Galaxy Buds Pro' => 'samsung-galaxy-buds-pro',
					'Samsung Galaxy Fold' => 'samsung-galaxy-fold',
					'Samsung Galaxy J5' => 'galaxy-j5',
					'Samsung Galaxy Note' => 'samsung-galaxy-note',
					'Samsung Galaxy Note 8' => 'samsung-galaxy-note-8',
					'Samsung Galaxy Note 9' => 'samsung-galaxy-note-9',
					'Samsung Galaxy Note 10' => 'samsung-galaxy-note-10',
					'Samsung Galaxy Note 10+' => 'samsung-galaxy-note-10-plus',
					'Samsung Galaxy Note20' => 'samsung-galaxy-note20',
					'Samsung Galaxy Note20 Ultra' => 'samsung-galaxy-note20-ultra',
					'Samsung Galaxy S6' => 'samsung-galaxy-s6',
					'Samsung Galaxy S7' => 'samsung-galaxy-s7',
					'Samsung Galaxy S7 Edge' => 'samsung-galaxy-s7-edge',
					'Samsung Galaxy S8' => 'samsung-galaxy-s8',
					'Samsung Galaxy S8+' => 'samsung-s8-plus',
					'Samsung Galaxy S9' => 'samsung-galaxy-s9',
					'Samsung Galaxy S9 Plus' => 'samsung-s9-plus',
					'Samsung Galaxy S10' => 'samsung-galaxy-s10',
					'Samsung Galaxy S10 Lite' => 'samsung-galaxy-s10-lite',
					'Samsung Galaxy S10 Plus' => 'samsung-galaxy-s10-plus',
					'Samsung Galaxy S10e' => 'samsung-galaxy-s10e',
					'Samsung Galaxy S20' => 'samsung-galaxy-s20',
					'Samsung Galaxy S20 FE' => 'samsung-galaxy-s20-fe',
					'Samsung Galaxy S20 Ultra' => 'samsung-galaxy-s20-ultra',
					'Samsung Galaxy S20+' => 'samsung-galaxy-s20-plus',
					'Samsung Galaxy S21 5G' => 'samsung-galaxy-s21-5g',
					'Samsung Galaxy S21 Ultra 5G' => 'samsung-galaxy-s21-ultra-5g',
					'Samsung Galaxy S21+ 5G' => 'samsung-galaxy-s21-plus-5g',
					'Samsung Galaxy Tab' => 'samsung-galaxy-tab',
					'Samsung Galaxy Tab A' => 'samsung-galaxy-tab-a',
					'Samsung Galaxy Tab A7' => 'samsung-galaxy-tab-a7',
					'Samsung Galaxy Tab S' => 'samsung-galaxy-tab-s',
					'Samsung Galaxy Tab S4' => 'samsung-galaxy-tab-s4',
					'Samsung Galaxy Tab S5e' => 'samsung-galaxy-tab-s5e',
					'Samsung Galaxy Tab S6' => 'samsung-galaxy-tab-s6',
					'Samsung Galaxy Watch' => 'samsung-galaxy-watch',
					'Samsung Galaxy Watch3' => 'samsung-galaxy-watch3',
					'Samsung Galaxy Watch Active2' => 'samsung-galaxy-watch-active-2',
					'Samsung Gear' => 'samsung-gear',
					'Samsung Gear S3' => 'gear-s3',
					'Samsung Gear VR' => 'samsung-gear-vr',
					'Samsung Headphones' => 'samsung-headphones',
					'Samsung Monitor' => 'samsung-monitor',
					'Samsung QLED TVs' => 'samsung-qled-tv',
					'Samsung Smartphone' => 'samsung-smartphone',
					'Samsung SSD' => 'samsung-ssd',
					'Samsung The Frame TV' => 'samsung-the-frame',
					'Samsung TV' => 'samsung-tv',
					'Samsung Washing Machine' => 'samsung-washing-machine',
					'Samsung Watch' => 'samsung-watch',
					'Sandals' => 'sandals',
					'Sander' => 'sander',
					'SanDisk' => 'sandisk',
					'SanDisk SSD' => 'sandisk-ssd',
					'Sand Pit' => 'sand-pit',
					'Sandwich Maker' => 'sandwich',
					'San Miguel' => 'san-miguel',
					'Santander' => 'santander',
					'Satchel' => 'satchel',
					'Sat Nav' => 'sat-nav',
					'Sauce' => 'sauce',
					'Saw' => 'saw',
					'Scalextric' => 'scalextric',
					'Scanner' => 'scanner',
					'School Bag' => 'school-bag',
					'School Supplies' => 'school',
					'School Uniform' => 'school-uniform',
					'Schwalbe' => 'schwalbe',
					'Scooby Doo' => 'scooby-doo',
					'Scooter' => 'scooter',
					'Scotch Whisky' => 'scotch',
					'Scrabble' => 'scrabble',
					'Screen Protector' => 'screen-protector',
					'Screenwash' => 'screenwash',
					'Screwdriver' => 'screwdriver',
					'Screws' => 'screws',
					'SD Cards' => 'sd-card',
					'SDHC' => 'sdhc',
					'SDXC' => 'sdxc',
					'Seagate' => 'seagate',
					'Sea Life' => 'sea-life',
					'Sea of Thieves' => 'sea-of-thieves',
					'Season Pass' => 'season-pass',
					'Seaworld' => 'seaworld',
					'Security Camera' => 'security-camera',
					'Seeds &amp; Bulbs' => 'seeds-and-bulbs',
					'Sega' => 'sega',
					'SEGA Mega Drive Mini' => 'sega-mega-drive-mini',
					'Segway' => 'segway',
					'Seiko' => 'seiko',
					'Sekiro: Shadows Die Twice' => 'sekiro',
					'Sekonda' => 'sekonda',
					'Selfie Stick' => 'selfie-stick',
					'Sennheiser' => 'sennheiser',
					'Sennheiser Headphones' => 'sennheiser-headphones',
					'Sensodyne' => 'sensodyne',
					'Server' => 'server',
					'Services &amp; Contracts' => 'services-contracts',
					'Services and Subscriptions' => 'service-contract',
					'Sewing' => 'sewing',
					'Sewing Machine' => 'sewing-machine',
					'Sex Toys' => 'sex-toys',
					'Shadow of the Tomb Raider' => 'shadow-of-the-tomb-raider',
					'Shampoo' => 'shampoo',
					'Shark' => 'shark',
					'Shark DuoClean' => 'shark-duoclean',
					'Shark Vacuum Cleaner' => 'shark-vacuum-cleaner',
					'Sharp' => 'sharp',
					'Sharpener' => 'sharpener',
					'Sharpie' => 'sharpie',
					'Shaver' => 'shaver',
					'Shaving &amp; Beard Care' => 'shaving',
					'Shaving, Trimming, &amp; Hair Removal' => 'hair-removal',
					'Shaving Foam' => 'shaving-foam',
					'Shears' => 'shears',
					'Sheba' => 'sheba',
					'Shed' => 'shed',
					'Shelter' => 'shelter',
					'Shelves' => 'shelves',
					'Shenmue I &amp; II' => 'shenmue-one-and-two',
					'Shenmue III' => 'shenmue-3',
					'Shenmue Series' => 'shenmue-series',
					'Shimano' => 'shimano',
					'Shirt' => 'shirt',
					'Shoe Rack' => 'shoe-rack',
					'Shoes' => 'shoe',
					'Shopkins' => 'shopkins',
					'Shortbread' => 'shortbread',
					'Shorts' => 'shorts',
					'Short Trip' => 'break',
					'Shoulder Bag' => 'shoulder-bag',
					'Shovel' => 'shovel',
					'Shower Curtain' => 'shower-curtain',
					'Shower Enclosure' => 'shower-enclosure',
					'Shower Fittings' => 'shower',
					'Shower Gel' => 'shower-gel',
					'Shower Head' => 'shower-head',
					'Shredder' => 'shredder',
					'Side-by-Side-Fridge' => 'side-by-side-fridge',
					'Sideboard' => 'sideboard',
					'Sid Meier&#039;s Civilization VI' => 'civilization-vi',
					'Siemens' => 'siemens',
					'Siemens Washing Machine' => 'siemens-washing-machine',
					'Sigma' => 'sigma',
					'Silentnight' => 'silentnight',
					'Silvercrest' => 'silvercrest',
					'Silver Cross' => 'silver-cross',
					'Sim Free' => 'sim-free',
					'Sim Only' => 'sim-only',
					'Simplehuman' => 'simplehuman',
					'Simpsons' => 'simpsons',
					'Single Malt' => 'single-malt',
					'Sink' => 'sink',
					'Sistema' => 'sistema',
					'Skateboard' => 'skateboard',
					'Skating' => 'skating',
					'Skechers' => 'skechers',
					'Skiing' => 'ski',
					'Skin Care' => 'skincare',
					'Skittles' => 'skittles',
					'Skoda' => 'skoda',
					'Skullcandy' => 'skullcandy',
					'Sky' => 'sky',
					'Sky Cinema' => 'sky-cinema',
					'Skylanders' => 'skylanders',
					'Skylanders Battlecast' => 'skylanders-battlecast',
					'Skylanders Imaginators' => 'skylanders-imaginators',
					'Sleeping Bag' => 'sleeping-bag',
					'Sleeping Dogs' => 'sleeping-dogs',
					'Sleepwear' => 'sleepwear',
					'Slide' => 'slide',
					'Slimming World' => 'slimming-world',
					'Slippers' => 'slippers',
					'Slow Cooker' => 'slow-cooker',
					'Smart Clock' => 'clock',
					'Smart Doorbells' => 'smart-doorbell',
					'Smart Home' => 'smart-home',
					'Smart Light' => 'smart-light',
					'Smart Lock' => 'smart-lock',
					'Smartphone Accessories' => 'smartphone-accessories',
					'Smartphone Case' => 'smartphone-case',
					'Smartphone under £200' => 'smartphone-under-200-pounds',
					'Smartphone under £400' => 'smartphone-under-400-pounds',
					'Smart Plugs' => 'smart-plugs',
					'Smart Speaker' => 'smart-speaker',
					'Smart Tech &amp; Gadgets' => 'smart-tech',
					'Smart Thermostat' => 'thermostat',
					'SmartThings' => 'smartthings',
					'Smart TV' => 'smart-tv',
					'Smart Watch' => 'smartwatch',
					'Smeg' => 'smeg',
					'Smirnoff' => 'smirnoff',
					'Smoke Alarm' => 'smoke-alarm',
					'Smoothie' => 'smoothie',
					'Smoothie Maker' => 'smoothie-maker',
					'Snacks' => 'snacks',
					'Sneakers' => 'sneakers',
					'SNES Nintendo Classic Mini' => 'snes-nintendo-classic',
					'Snickers' => 'snickers',
					'Sniper Elite' => 'sniper-elite',
					'Snowboard' => 'snowboard',
					'Snow Boots' => 'snow-boots',
					'Soap' => 'soap',
					'Soap and Glory' => 'soap-and-glory',
					'Socket Set' => 'socket-set',
					'Socks' => 'socks',
					'SodaStream' => 'soda-stream',
					'Sofa' => 'sofa',
					'Soft Drinks' => 'soft-drinks',
					'Soft Toy' => 'soft-toy',
					'Software' => 'software',
					'Software &amp; Apps' => 'software-apps',
					'Solar Lights' => 'solar-lights',
					'Soldering Iron' => 'soldering',
					'Sonic' => 'sonic',
					'Sonos' => 'sonos',
					'Sonos Beam' => 'sonos-beam',
					'Sonos Move' => 'sonos-move',
					'Sonos One' => 'sonos-one',
					'Sonos PLAY:1' => 'sonos-play-1',
					'Sonos PLAY:3' => 'sonos-play-3',
					'Sonos PLAY:5' => 'sonos-play-5',
					'Sonos PLAYBAR' => 'sonos-playbar',
					'Sonos PLAYBASE' => 'sonos-playbase',
					'Sony' => 'sony',
					'Sony Camera' => 'sony-camera',
					'Sony Headphones' => 'sony-headphones',
					'Sony Pulse 3D Wireless Headset' => 'pulse-3d-wireless-headsets',
					'Sony TV' => 'sony-tv',
					'Sony WF-1000XM3' => 'sony-wf1000xm3',
					'Sony WH-1000XM3' => 'sony-wh-1000xm3',
					'Sony WH-1000XM4' => 'sony-wh1000xm4',
					'Sony Xperia' => 'xperia',
					'Sony Xperia 5' => 'sony-xperia-5',
					'Sony Xperia 10' => 'sony-xperia-10',
					'Sony Xperia Xa' => 'sony-xperia-xa',
					'Sony Xperia Z3' => 'xperia-z3',
					'Sony Xperia Z5' => 'xperia-z5',
					'Soulcalibur' => 'soulcalibur',
					'Soundbar' => 'soundbar',
					'Soundbase' => 'soundbase',
					'Sound Card' => 'sound-card',
					'Soundmagic' => 'soundmagic',
					'Soup' => 'soup',
					'Soup Maker' => 'soup-maker',
					'Sous-Vide' => 'sousvide',
					'Southern Comfort' => 'southern-comfort',
					'South Park' => 'south-park',
					'Spa' => 'spa',
					'Spade' => 'spade',
					'Spanner' => 'spanner',
					'Speaker' => 'speakers',
					'Specialized' => 'specialized',
					'Speedo' => 'speedo',
					'Sphero' => 'sphero',
					'Spice Rack' => 'spice-rack',
					'Spiderman' => 'spiderman',
					'Spiralizer' => 'spiralizer',
					'Spirit &amp; Liqueur' => 'spirits',
					'Spirit Level' => 'spirit-level',
					'Splatoon' => 'splatoon',
					'Sports &amp; Outdoors' => 'sports-fitness',
					'Sports Events' => 'sports-events',
					'Sports Nutrition' => 'nutrition',
					'Spreads' => 'spreads',
					'Spyro Reignited Trilogy' => 'spyro-reignited-trilogy',
					'SSD' => 'ssd',
					'SSHD' => 'sshd',
					'Staedtler' => 'staedtler',
					'Stair Gate' => 'stair-gate',
					'Stanley' => 'stanley',
					'Stapler' => 'stapler',
					'Starbucks' => 'starbucks',
					'Starlink: Battle for Atlas' => 'starlink-battle-for-atlas',
					'Star Ocean' => 'star-ocean',
					'Star Trek' => 'star-trek',
					'Star Wars' => 'star-wars',
					'Star Wars: Battlefront' => 'star-wars-battlefront',
					'Star Wars: Battlefront II' => 'star-wars-battlefront-2',
					'Star Wars: Squadrons' => 'star-wars-squadrons',
					'Star Wars Jedi: Fallen Order' => 'star-wars-jedi-fallen-order',
					'Stationery' => 'stationery',
					'Stationery &amp; Office Supplies' => 'stationery-office-supplies',
					'Staycation' => 'staycation',
					'Steak' => 'steak',
					'Steam Cleaner' => 'steam-cleaner',
					'Steam Controller' => 'steam-controller',
					'Steamer' => 'steamer',
					'Steam Gaming' => 'steam',
					'Steam Iron' => 'steam-iron',
					'Steam Link' => 'steam-link',
					'Steam Mop' => 'steam-mop',
					'SteelSeries' => 'steelseries',
					'Steering Wheel' => 'steering-wheel',
					'Stella' => 'stella',
					'Stool' => 'stool',
					'Storage Box' => 'storage-box',
					'Stormtrooper' => 'stormtrooper',
					'Straightener' => 'straightener',
					'Streaming' => 'streaming',
					'Street Fighter' => 'street-fighter',
					'Street Fighter V' => 'street-fighter-v',
					'Streetwear' => 'streetwear',
					'Strimmer' => 'strimmer',
					'Strongbow' => 'strongbow',
					'Student Discount' => 'student-discount',
					'Subwoofer' => 'subwoofer',
					'Suitcase' => 'suitcase',
					'Suncare' => 'suncare',
					'Sun Cream' => 'sun-cream',
					'Sunglasses' => 'sunglasses',
					'Superdry' => 'superdry',
					'Superfast Broadband' => 'superfast-broadband',
					'Superking' => 'superking',
					'Super Mario' => 'mario',
					'Super Mario 3D All-Stars' => 'super-mario-3d-all-stars',
					'Super Mario 3D World' => 'super-mario-3d-world',
					'Super Mario Maker 2' => 'super-mario-maker-2',
					'Super Mario Odyssey' => 'super-mario-odyssey',
					'Super Mario Party' => 'mario-party',
					'Supermarket' => 'supermarket',
					'Super Smash Bros.' => 'super-smash-bros',
					'Surf' => 'surf',
					'Swarovski' => 'swarovski',
					'Sweets' => 'sweets',
					'Swimming' => 'swimming',
					'Swimming Goggles' => 'goggles',
					'Swimwear' => 'swimwear',
					'Swing' => 'swing',
					'Swingball' => 'swingball',
					'Syberia' => 'syberia',
					'Sylvanian' => 'sylvanian',
					'Synology' => 'synology',
					'T-Mobile' => 't-mobile',
					'T-Shirt' => 't-shirt',
					'Table Lamp' => 'table-lamp',
					'Tablet' => 'tablet',
					'Tablet Accessories' => 'tablet-accessories',
					'Table Tennis' => 'table-tennis',
					'Tableware' => 'tableware',
					'Tacx' => 'tacx',
					'Tado' => 'tado',
					'Tag Heuer' => 'tag-heuer',
					'Takeaway and Food Delivery' => 'takeaway',
					'Tales of Vesperia: Definitive Edition' => 'tales-of-vesperia-definitive-edition',
					'Talisker' => 'talisker',
					'Talkmobile' => 'talkmobile',
					'Tamron' => 'tamron',
					'Tangle Teezer' => 'tangle-teezer',
					'Tank Top' => 'tank-top',
					'Tannoy' => 'tannoy',
					'Tanqueray' => 'tanqueray',
					'Tape' => 'tape',
					'Tassimo' => 'tassimo',
					'Tassimo Coffee Machine' => 'tassimo-coffee-machine',
					'tastecard' => 'tastecard',
					'Taxi' => 'taxi',
					'Tea' => 'tea',
					'Team Sonic Racing' => 'team-sonic-racing',
					'Team Sports' => 'team-sports',
					'Teapot' => 'teapot',
					'Technika' => 'technika',
					'Techwood' => 'techwood',
					'Ted Baker' => 'ted-baker',
					'Teddy Bear' => 'teddy-bear',
					'Teenage Mutant Ninja Turtles' => 'turtle',
					'Teeth Care' => 'teeth-care',
					'Teeth Whitening' => 'teeth-whitening',
					'Tefal' => 'tefal',
					'Tefal Actifry' => 'actifry',
					'Tefal Pan' => 'tefal-pan',
					'Tekken' => 'tekken',
					'Tekken 7' => 'tekken-7',
					'Telegraph' => 'telegraph',
					'Telescope' => 'telescope',
					'Telltale' => 'telltale',
					'Tennis' => 'tennis',
					'Tent' => 'tent',
					'Tequila' => 'tequila',
					'Tesco Clothing' => 'tesco-clothing',
					'Tesla' => 'tesla',
					'Tetris' => 'tetris',
					'Tetris 99' => 'tetris-99',
					'Theatre &amp; Musical' => 'theatre',
					'The Beatles' => 'beatles',
					'The Big Bang Theory' => 'big-bang-theory',
					'The Crew' => 'the-crew',
					'The Dark Pictures: Anthology Man of Medan' => 'the-dark-pictures-anthology-man-of-medan',
					'The Elder Scrolls' => 'elder-scrolls',
					'The Elder Scrolls V: Skyrim' => 'skyrim',
					'The Evil Within' => 'the-evil-within',
					'The Evil Within 2' => 'the-evil-within-2',
					'The Last Guardian' => 'the-last-guardian',
					'The Last of Us' => 'the-last-of-us',
					'The Last of Us Part II' => 'the-last-of-us-part-2',
					'The Legend of Zelda' => 'zelda',
					'The Legend of Zelda: Breath of the Wild' => 'zelda-breath-of-the-wild',
					'The Legend of Zelda: Link&#039;s Awakening' => 'the-legend-of-zelda-links-awakening',
					'The Legend of Zelda: Skyward Sword HD' => 'the-legend-of-zelda-skyward-sword-hd',
					'Theme Park' => 'theme-park',
					'The North Face' => 'north-face',
					'The Outer Worlds' => 'the-outer-worlds',
					'Thermos Storage' => 'thermos',
					'The Sims' => 'sims',
					'The Sims 4' => 'the-sims-4',
					'The Sinking City' => 'the-sinking-city',
					'The Sun' => 'the-sun',
					'The Sunday Times' => 'sunday-times',
					'The Walking Dead' => 'walking-dead',
					'The Witcher' => 'witcher',
					'The Witcher 3' => 'the-witcher-3',
					'Thierry Mugler' => 'thierry-mugler',
					'Thomas Sabo' => 'thomas-sabo',
					'Thomas The Tank Engine' => 'thomas-the-tank',
					'Thornton&#039;s' => 'thorntons',
					'Thorpe Park' => 'thorpe-park',
					'Throw' => 'throw',
					'Thrustmaster' => 'thrustmaster',
					'Thule' => 'thule',
					'Tickets &amp; Shows' => 'tickets-shows',
					'Tie' => 'tie',
					'Tights' => 'tights',
					'TIGI' => 'tigi',
					'Tilda' => 'tilda',
					'Tile' => 'tile',
					'Timberland' => 'timberland',
					'Timex' => 'timex',
					'Tissot' => 'tissot',
					'Tissues' => 'tissues',
					'Titanfall' => 'titanfall',
					'Titanfall 2' => 'titanfall-2',
					'Toaster' => 'toaster',
					'Toblerone' => 'toblerone',
					'Toddler Bed' => 'toddler-bed',
					'Toilet Brush' => 'brush',
					'Toilet Cleaner' => 'toilet',
					'Toilet Roll' => 'toilet-roll',
					'Toilet Seat' => 'toilet-seat',
					'Tokyo Laundry' => 'tokyo-laundry',
					'Tomb Raider' => 'tomb-raider',
					'Tom Clancy&#039;s' => 'tom-clancy',
					'Tom Clancy&#039;s: Ghost Recon' => 'ghost-recon',
					'Tom Clancy&#039;s Ghost Recon: Wildlands' => 'ghost-recon-wildlands',
					'Tom Clancy&#039;s Ghost Recon Breakpoint' => 'tom-clancys-ghost-recon-breakpoint',
					'Tom Clancy&#039;s The Division' => 'tom-clancy-the-division',
					'Tom Clancy&#039;s The Division 2' => 'tom-clancy-the-division-2',
					'Tom Ford' => 'tom-ford',
					'Tommee Tippee' => 'tommee-tippee',
					'Tommy Hilfiger' => 'tommy-hilfiger',
					'Toms' => 'toms',
					'TomTom' => 'tomtom',
					'Tonic Water' => 'tonic-water',
					'Tony Hawk&#039;s Pro Skater 1 + 2' => 'tony-hawks-pro-skater-1-2',
					'Tools' => 'tool',
					'Toothbrush' => 'toothbrush',
					'Toothpaste' => 'toothpaste',
					'Torch' => 'torch',
					'Torque Wrench' => 'torque-wrench',
					'Toshiba' => 'toshiba',
					'Toshiba Laptop' => 'toshiba-laptop',
					'Toshiba TV' => 'toshiba-tv',
					'Total War' => 'total-war',
					'Tottenham Hotspur F. C.' => 'tottenham',
					'Towel' => 'towel',
					'Toy Box' => 'toy-box',
					'Toy Cars' => 'toy-cars',
					'Toy Castle' => 'castle',
					'Toy Digger' => 'digger',
					'Toy Helicopter' => 'helicopter',
					'Toy Kitchen' => 'toy-kitchen',
					'Toy Mask' => 'mask',
					'Toyota' => 'toyota',
					'Toys' => 'toy',
					'Toy Story' => 'toy-story',
					'Toy Tractor' => 'tractor',
					'Toy Train' => 'train',
					'TP-Link' => 'tp-link',
					'TP-Link Archer' => 'archer',
					'TP-Link Router' => 'tp-link-router',
					'Tracksuit' => 'tracksuit',
					'Trainers' => 'trainers',
					'Trains &amp; Buses' => 'train-and-bus-ticket',
					'Train Ticket' => 'train-ticket',
					'Trampoline' => 'trampoline',
					'Transcend' => 'transcend',
					'Transformers' => 'transformers',
					'Travel' => 'travel',
					'Travel App' => 'travel-app',
					'Travel Insurance' => 'travel-insurance',
					'Travelodge' => 'travelodge',
					'Travel System' => 'travel-system',
					'Treadmill' => 'treadmill',
					'TRESemmé' => 'tresemme',
					'Trespass' => 'trespass',
					'Triathlon' => 'triathlon',
					'Trike' => 'trike',
					'Trine 4' => 'trine-4',
					'Tripod' => 'tripod',
					'Tripp' => 'tripp',
					'Triton Shower' => 'triton',
					'Trolley Bag' => 'trolley',
					'Tropico 5' => 'tropico-5',
					'Tropico 6' => 'tropico-6',
					'Tropico Series' => 'tropico-deals',
					'Trousers' => 'trousers',
					'True Wireless Earbuds' => 'wireless-earphones',
					'Trunki' => 'trunki',
					'Tumble Dryer' => 'tumble-dryer',
					'Tuna' => 'tuna',
					'Turbo Trainer' => 'turbo-trainer',
					'Turntable' => 'turntable',
					'Turtle Beach' => 'turtle-beach',
					'TV' => 'tv',
					'TV &amp; Video' => 'tv-video',
					'TV Accessories' => 'tv-accessories',
					'TV Mount' => 'tv-mount',
					'TV Series' => 'tv-series',
					'TV Stand' => 'tv-stand',
					'Twinings' => 'twinings',
					'Twin Peaks' => 'twin-peaks',
					'Twix' => 'twix',
					'Typhoo' => 'typhoo',
					'Tyres' => 'tyres',
					'Ubisoft' => 'ubisoft',
					'UE BOOM' => 'ue-boom',
					'UE Boom 2' => 'ue-boom-2',
					'UEFA' => 'uefa',
					'UE Megablast' => 'ue-megablast',
					'UE Megaboom' => 'ue-megaboom',
					'UGG' => 'ugg',
					'Ulefone' => 'ulefone',
					'Ultrabook' => 'ultrabook',
					'Ultrawide Monitor' => 'ultrawide',
					'Umbrella' => 'umbrella',
					'UMI' => 'umidigi',
					'Uncharted' => 'uncharted',
					'Uncharted 4: A Thief&#039;s End' => 'uncharted-4',
					'Uncharted: The Lost Legacy' => 'uncharted-the-lost-legacy',
					'Under Armour' => 'under-armour',
					'Underwear' => 'underwear',
					'Unicorn' => 'unicorn',
					'UNiDAYS' => 'unidays',
					'Universal Remote' => 'universal-remote',
					'Uno' => 'uno',
					'Uplay' => 'uplay',
					'Urban Decay' => 'urban-decay',
					'Urban Sports' => 'urban-sports',
					'USB Cable' => 'usb-cable',
					'USB Hub' => 'usb-hub',
					'USB Memory Stick' => 'flash-drive',
					'USB Type C' => 'usb-type-c',
					'USN' => 'usn',
					'Vacuum Cleaner' => 'vacuum-cleaners',
					'Vacuum Flask' => 'flask',
					'Valkyria Chronicles' => 'valkyria-chronicles',
					'Valkyria Chronicles 4' => 'valkyria-chronicles-4',
					'Vango' => 'vango',
					'Vanish' => 'vanish',
					'Vans' => 'vans',
					'Vans Old Skool' => 'vans-old-skool',
					'Vans Shoes' => 'vans-shoes',
					'Vase' => 'vase',
					'Vaseline' => 'vaseline',
					'Vauxhall' => 'vauxhall',
					'VAX' => 'vax',
					'Vax Blade' => 'vax-blade',
					'Vax Vacuum Cleaner' => 'vax-vacuum',
					'Veet' => 'veet',
					'Vega 7' => 'vega-7',
					'Vegetables' => 'vegetables',
					'Vegetarian' => 'vegetarian',
					'Vehicles' => 'vehicles',
					'Velvet Comfort' => 'velvet',
					'Vera Wang' => 'vera-wang',
					'Verbatim' => 'verbatim',
					'Versace' => 'versace',
					'Vibrator' => 'vibrator',
					'Victorinox' => 'victorinox',
					'Video Games' => 'videogame',
					'Video Streaming' => 'video-streaming',
					'Viktor &amp; Rolf Spicebomb' => 'spicebomb',
					'Vileda' => 'vileda',
					'Villeroy &amp; Boch' => 'villeroy-boch',
					'Viners' => 'viners',
					'Vinyl' => 'vinyl',
					'Virgin' => 'virgin',
					'Vitamins &amp; Supplements' => 'vitamins',
					'Vitamix' => 'vitamix',
					'Vodafone' => 'vodafone',
					'Vodka' => 'vodka',
					'Volvo' => 'volvo',
					'VPN' => 'vpn',
					'VR Headset' => 'vr-headset',
					'VTech' => 'vtech',
					'VTech Toot Toot' => 'toot-toot',
					'Vue' => 'vue',
					'VW' => 'vw',
					'Wacom' => 'wacom',
					'Waffle Maker' => 'waffle-maker',
					'Wahl' => 'wahl',
					'Walkers' => 'walkers',
					'Walking Boots' => 'walking-boots',
					'Wall Art' => 'wall-art',
					'Wallet' => 'wallet',
					'Wallpaper' => 'wallpaper',
					'Wardrobe' => 'wardrobe',
					'Warhammer' => 'warhammer',
					'Washbag' => 'washbag',
					'Washer Dryer' => 'washer-dryer',
					'Washing Machine' => 'washing-machine',
					'Washing Powder' => 'washing-powder',
					'Watch' => 'watch',
					'Watch Dogs' => 'watch-dogs',
					'Watch Dogs 2' => 'watch-dogs-2',
					'Watch Dogs: Legion' => 'watch-dogs-legion',
					'Water Bottle' => 'water-bottle',
					'Water Butt' => 'water-butt',
					'Water Dispenser' => 'water-dispenser',
					'Water Filter' => 'water-filter',
					'Water Gun' => 'water-gun',
					'Waterproof Camera' => 'waterproof-camera',
					'Waterproof Jacket' => 'waterproof-jacket',
					'Watersports' => 'watersport',
					'Water Toys' => 'water-toys',
					'Wayfarer' => 'wayfarer',
					'WD40' => 'wd40',
					'Wearable' => 'wearable',
					'Weather Station' => 'weather-station',
					'Webcam' => 'webcam',
					'Weber' => 'weber',
					'Web Hosting' => 'web-hosting',
					'Wedding' => 'wedding',
					'Weed Killer' => 'weed',
					'Weekend Break' => 'weekend-break',
					'Weetabix' => 'weetabix',
					'Weightlifting' => 'weightlifting',
					'Weight Watchers' => 'weight-watchers',
					'Wellies' => 'wellies',
					'Wellness and Health' => 'wellness-and-health',
					'Wenger' => 'wenger',
					'Western Digital' => 'western-digital',
					'Wetsuit' => 'wetsuit',
					'Wheelbarrow' => 'wheelbarrow',
					'Wheelchair' => 'wheelchair',
					'Whey' => 'whey',
					'Whiskas' => 'whiskas',
					'Whisky' => 'whisky',
					'Whole Home Mesh Wi-Fi System' => 'whole-home-mesh-wifi-system',
					'Wi-Fi Camera' => 'wifi-camera',
					'Wi-Fi Dongle' => 'dongle',
					'Wi-Fi Extender' => 'wifi-extender',
					'Wii' => 'wii',
					'Wii Game' => 'wii-games',
					'Wii U Game' => 'wii-u-game',
					'Wii U Pro Controller' => 'wii-u-pro-controller',
					'Wild Turkey' => 'wild-turkey',
					'Wileyfox' => 'wileyfox',
					'Wilkinson Sword Hydro 5' => 'hydro-5',
					'Wilkinson Sword Razor' => 'wilkinson-sword',
					'Wimbledon Tennis' => 'wimbledon',
					'Window Cleaner' => 'window-cleaner',
					'Windows' => 'windows',
					'Windows 8' => 'windows-8',
					'Windows 10' => 'windows-10',
					'Wine' => 'wine',
					'Wine Advent Calendar' => 'wine-advent-calendar',
					'Wine Glasses' => 'wine-glasses',
					'Winter Jacket' => 'winter-jacket',
					'Wiper Blades' => 'wiper-blades',
					'Wireless Adapter' => 'wireless-adapter',
					'Wireless Charger' => 'wireless-charger',
					'Wireless Controller' => 'wireless-controller',
					'Wireless Headphones' => 'wireless-headphones',
					'Wireless Headset' => 'wireless-headset',
					'Wireless Keyboard' => 'wireless-keyboard',
					'Wireless Mouse' => 'wireless-mouse',
					'Wok' => 'wok',
					'Wolfenstein' => 'wolfenstein',
					'Wolfenstein 2: The New Colossus' => 'wolfenstein-2',
					'Women&#039;s Boots' => 'womens-boots',
					'Women&#039;s Fragrance' => 'womens-fragrance',
					'Women&#039;s Shoes' => 'womens-shoes',
					'Workbench' => 'workbench',
					'World of Warcraft' => 'world-of-warcraft',
					'World War Z' => 'world-war-z',
					'WORX' => 'worx',
					'Wreckfest' => 'wreckfest',
					'Wuaki' => 'wuaki',
					'WWE 2K' => 'wwe',
					'Xbox' => 'xbox',
					'Xbox 360 Game' => 'xbox-360-game',
					'Xbox Accessories' => 'xbox-accessories',
					'Xbox Controller' => 'xbox-controller',
					'Xbox Game Pass' => 'xbox-game-pass',
					'Xbox Gift Card' => 'xbox-gift-card',
					'Xbox Headset' => 'xbox-headset',
					'Xbox Kinect' => 'kinect',
					'Xbox Live' => 'xbox-live',
					'Xbox One Controller' => 'xbox-one-controller',
					'Xbox One Elite Controller' => 'xbox-one-elite-controller',
					'Xbox One Games' => 'xbox-one-games',
					'Xbox One S' => 'xbox-one-s',
					'Xbox One X' => 'xbox-one-x',
					'Xbox Series S' => 'xbox-series-s',
					'Xbox Series X' => 'xbox-series-x',
					'Xbox Series X Controller' => 'xbox-series-x-controller',
					'Xbox Series X Games' => 'xbox-series-x-game',
					'Xbox Wireless Adapter' => 'xbox-wireless-adapter',
					'Xbox Wireless Headset' => 'xbox-wireless-headset',
					'XCOM' => 'xcom',
					'XCOM 2' => 'xcom-2',
					'Xenoblade Chronicles' => 'xenoblade-chronicles',
					'XFX' => 'xfx',
					'Xiaomi' => 'xiaomi',
					'Xiaomi AirDots' => 'xiaomi-airdots',
					'Xiaomi Black Shark' => 'xiaomi-black-shark',
					'Xiaomi Black Shark 2' => 'xiaomi-black-shark-2',
					'Xiaomi Headphones' => 'xiaomi-headphones',
					'Xiaomi Laptop' => 'xiaomi-laptop',
					'Xiaomi Mi 5' => 'xiaomi-mi-5',
					'Xiaomi Mi 6' => 'xiaomi-mi-6',
					'Xiaomi Mi 8' => 'xiaomi-mi-8',
					'Xiaomi Mi 8 Lite' => 'xiaomi-mi-8-lite',
					'Xiaomi Mi 8 Pro' => 'xiaomi-mi-8-pro',
					'Xiaomi Mi 9' => 'xiaomi-mi-9',
					'Xiaomi Mi 9 Lite' => 'xiaomi-mi-9-lite',
					'Xiaomi Mi 9 SE' => 'xiaomi-mi-9-se',
					'Xiaomi Mi 9T' => 'xiaomi-mi-9t',
					'Xiaomi Mi 9T Pro' => 'xiaomi-mi-9t-pro',
					'Xiaomi Mi 10' => 'xiaomi-mi-10',
					'Xiaomi Mi 10 Lite' => 'xiaomi-mi-10-lite',
					'Xiaomi Mi 10T' => 'xiaomi-mi-10t',
					'Xiaomi Mi 10T Lite' => 'xiaomi-mi-10t-lite',
					'Xiaomi Mi 10T Pro' => 'xiaomi-mi-10t-pro',
					'Xiaomi Mi 11' => 'xiaomi-mi-11',
					'Xiaomi Mi 11 Lite 4G' => 'xiaomi-mi-11-lite-4g',
					'Xiaomi Mi 11 Lite 5G' => 'xiaomi-mi-11-lite-5g',
					'Xiaomi Mi 11 Pro' => 'xiaomi-mi-11-pro',
					'Xiaomi Mi 11 Ultra' => 'xiaomi-mi-11-ultra',
					'Xiaomi Mi 11i' => 'xiaomi-mi-11i',
					'Xiaomi Mi A1' => 'xiaomi-mi-a1',
					'Xiaomi Mi A2' => 'mi-a2',
					'Xiaomi Mi A3' => 'xiaomi-mi-a3',
					'Xiaomi Mi Band' => 'xiaomi-mi-band',
					'Xiaomi Mi Band 3' => 'xiaomi-mi-band-3',
					'Xiaomi Mi Band 4' => 'xiaomi-mi-band-4',
					'Xiaomi Mi Band 5' => 'xiaomi-mi-band-5',
					'Xiaomi Mi Box' => 'xiaomi-mi-box',
					'Xiaomi Mi Max 3' => 'xiaomi-mi-max3',
					'Xiaomi Mi Mix' => 'xiaomi-mi-mix',
					'Xiaomi Mi Mix 2' => 'xiaomi-mi-mix-2',
					'Xiaomi Mi Mix 2S' => 'xiaomi-mi-mix-2s',
					'Xiaomi Mi Mix 3' => 'xiaomi-mi-mix-3',
					'Xiaomi Mi Note' => 'xiaomi-mi-note',
					'Xiaomi Mi Note 10' => 'mi-note-10',
					'Xiaomi Mi Pad 4' => 'xiaomi-mi-pad-4',
					'Xiaomi Pocophone F1' => 'pocophone-f1',
					'Xiaomi Redmi' => 'redmi',
					'Xiaomi Redmi 4' => 'xiaomi-redmi-4',
					'Xiaomi Redmi 5' => 'redmi-5',
					'Xiaomi Redmi 6' => 'redmi-6',
					'Xiaomi Redmi 8' => 'redmi-8',
					'Xiaomi Redmi Note 4' => 'note-4',
					'Xiaomi Redmi Note 5' => 'redmi-note-5',
					'Xiaomi Redmi Note 6' => 'redmi-note-6',
					'Xiaomi Redmi Note 6 Pro' => 'xiaomi-redmi-note-6-pro',
					'Xiaomi Redmi Note 7' => 'redmi-note-7',
					'Xiaomi Redmi Note 8' => 'xiaomi-redmi-note-8',
					'Xiaomi Redmi Note 8 Pro' => 'xiaomi-redmi-note-8-pro',
					'Xiaomi Redmi Note 8T' => 'redmi-note-8t',
					'Xiaomi Redmi Note 9' => 'xiaomi-redmi-note-9',
					'Xiaomi Redmi Note 9 Pro' => 'xiaomi-redmi-note-9-pro',
					'Xiaomi Redmi Note 9S' => 'xiaomi-redmi-note-9s',
					'Xiaomi Roborock' => 'xiaomi-roborock',
					'Xiaomi Roborock S5' => 'xiaomi-roborock-s5',
					'Xiaomi Scooter' => 'xiaomi-scooter',
					'Xiaomi Smartphones' => 'xiaomi-smartphone',
					'Xiaomi Tablets' => 'xiaomi-tablet',
					'Yakuza' => 'yakuza',
					'Yale' => 'yale',
					'Yale Smart Lock' => 'yale-smart-lock',
					'Yamaha' => 'yamaha',
					'Yankee Candle' => 'yankee-candle',
					'Yeelight' => 'xiaomi-yeelight',
					'Yoga' => 'yoga',
					'Yoghurt' => 'yoghurt',
					'Yoshi' => 'yoshi',
					'Yoshi&#039;s Crafted World' => 'yoshis-crafted-world',
					'YouView' => 'youview',
					'Yves Saint Laurent' => 'yves-saint-laurent',
					'Zanussi' => 'zanussi',
					'Zippo' => 'zippo',
					'Zizzi' => 'zizzi',
					'Zoo' => 'zoo',
					'Zoostorm' => 'zoostorm',
					'ZOTAC' => 'zotac',
					'ZTE' => 'zte',
					'ZTE Smartphone' => 'zte-smartphone',
					'ZyXEL' => 'zyxel',
				)
			),
			'order' => array(
				'name' => 'Order by',
				'type' => 'list',
				'title' => 'Sort order of deals',
				'values' => array(
					'From the most to the least hot deal' => '-hot',
					'From the most recent deal to the oldest' => '-new',
				)
			)
		),
		'Discussion Monitoring' => array(
			'url' => array(
				'name' => 'Discussion URL',
				'type' => 'text',
				'required' => true,
				'title' => 'Discussion URL to monitor. Ex: https://www.hotukdeals.com/discussions/the-hukd-lego-thread-3599357',
				'exampleValue' => 'https://www.hotukdeals.com/discussions/the-hukd-lego-thread-3599357',
				),
			'only_with_url' => array(
				'name' => 'Exclude comments without URL',
				'type' => 'checkbox',
				'title' => 'Exclude comments that does not contains URL in the feed',
				'defaultValue' => false,
				)
			)


	);

	public $lang = array(
		'bridge-uri' => SELF::URI,
		'bridge-name' => SELF::NAME,
		'context-keyword' => 'Search by keyword(s))',
		'context-group' => 'Deals per group',
		'context-talk' => 'Discussion Monitoring',
		'uri-group' => 'tag/',
		'request-error' => 'Could not request HotUKDeals',
		'thread-error' => 'Unable to determine the thread ID. Check the URL you entered',
		'no-results' => 'Ooops, looks like we could',
		'relative-date-indicator' => array(
			'ago',
		),
		'price' => 'Price',
		'shipping' => 'Shipping',
		'origin' => 'Origin',
		'discount' => 'Discount',
		'title-keyword' => 'Search',
		'title-group' => 'Group',
		'title-talk' => 'Discussion Monitoring',
		'local-months' => array(
			'Jan',
			'Feb',
			'Mar',
			'Apr',
			'May',
			'Jun',
			'Jul',
			'Aug',
			'Sep',
			'Occ',
			'Nov',
			'Dec',
			'st',
			'nd',
			'rd',
			'th'
		),
		'local-time-relative' => array(
			'Found ',
			'm',
			'h,',
			'day',
			'days',
			'month',
			'year',
			'and '
		),
		'date-prefixes' => array(
			'Found ',
			'Refreshed ',
			'Made hot '
		),
		'relative-date-alt-prefixes' => array(
			'Made hot ',
			'Refreshed ',
			'Last updated '
		),
		'relative-date-ignore-suffix' => array(
			'/by.*$/'
		),
		'localdeal' => array(
			'Local',
			'Expires'
		)
	);

}
