#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-06-10 11:10:35 
# conf/config-kerberos.sh

### P A R A M S
MYREALM="$1"
MYDNS="$2"
MYKDC="$3"

### I N C L U D E S
. ./_include.sh

### M O D I F I E D   F I L E S ...
krb5conffile=krb5.conf

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### S O U R C E   F I L E S ...
krb5conffile0=_${krb5conffile}

### S T A R T

# C U S T O M I Z E   K R B 5 . C O N F
# make sure realm is upper case
MYKDC=`echo "${MYKDC}" | sed 's/\..*$//g'`

# substitute values for macros
echo "+customize ${krb5conffile}"
awk '{gsub("%REALM%","'${MYREALM}'");
	gsub("%DNS%","'${MYDNS}'");
	gsub("%KDC%","'${MYKDC}'");
	print}' ${krb5conffile0} > ${TMPDIR}/${krb5conffile}
#cat ${TMPDIR}/${krb5conffile} | grep -v "^#" | grep -v "^$"

# I N S T A L L
echo "install new ${krb5conffile} to ${ETCDIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${krb5conffile} ${ETCDIR} > /dev/null
case ${DISTRIBUTION} in
	Redhat|Fedora)
		restorecon ${ETCDIR}/${krb5conffile}
		;;
esac

# C L E A N U P
rm -f ${TMPDIR}/${krb5conffile}

# S T A T U S
[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
echo '1' > /var/lib/sadms/kerberos
