/***************************************************************************
 *   copyright           : (C) 2005 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <inttypes.h>
#include <stdio.h>

enum apo_version {
  APO_S55,
  APO_S65,
  APO_SL75
};

void apo_header_init(enum apo_version ver);

enum apo_entry_type {
  APO_STRING = 0,
  APO_TELNUM,
  APO_DATE,
  APO_LINK,
  APO_GROUP,
  APO_APPTYPE,
  APO_PRIO,
  APO_STATUS,
  APO_ALARM,

  /* these are strictly for unknown values */
  APO_2BYTE,
  APO_4BYTE
};

struct apo_entry_func {
  enum apo_entry_type type;

  /* @param hptr pointer to first valid byte after header type
   */
  uint16_t (*getSize) (void* hptr); /**< size of field */
  void (*printText) (void* hptr, FILE* stream); /**< print as text */
};

void* apo_header_align (void* ptr, void* base);

/** Get usable functions for a specific header type
 * @param htype the header type
 * @return pointer to a const struct
 */
struct apo_entry_func* apo_get_entry_funcs (uint16_t htype);

#define APO_ADDR   0x01 /* addresses */
#define APO_APP    0x02 /* appointments */
#define APO_CALREC 0x04 /* call records */
#define APO_NOTE   0x08 /* notes */
#define APO_REM    0x10 /* reminders */
#define APO_TASK   0x20 /* tasks */
#define APO_PRES   0x40 /* presence */

/** Get the file type that the nex header belongs to
 * @param ptr pointer to the header to check
 * @return bitmask of allowed file types
 */
uint8_t apo_get_type (void* ptr);

/** Get the textual description of the header type
 * @param fval the header type value
 * @return an acutally constant string
 */
char* apo_get_description (uint16_t htype);

/** Get the next header in the file
 * @param ptr pointer to current header
 * @param base pointer to start of file
 * @return pointer to next header or NULL if there is none
 */
void* apo_get_next_header (void* ptr, void* base);
