/*
 * Given one or more node IDs as argument, present the corresponding node data.
 */
#include "basil_mysql.h"

int main(int ac, char **av)
{
	const char query[] =	"SELECT cab_position, cab_row, "
				"	cage, slot, cpu, "
				"	x_coord, y_coord, z_coord "
				"FROM  processor "
				"WHERE processor_id = ?";
	enum query_params {
			PAR_NID,
			PARAM_COUNT	/* sentinel */
	};
	MYSQL_BIND	bind_parm[PARAM_COUNT];
	unsigned int	node_id;

	enum query_columns {
			COL_CAB, COL_ROW,
			COL_CAGE, COL_SLOT, COL_CHIP,
			COL_X, COL_Y, COL_Z,
			COLUMN_COUNT	/* sentinel */
	};
	MYSQL_BIND	bind_cols[COLUMN_COUNT];
	int		col_data[COLUMN_COUNT];
	my_bool		is_null[COLUMN_COUNT];
	my_bool		error[COLUMN_COUNT];

	MYSQL		*handle;
	MYSQL_STMT	*stmt;

	int		rc = -1, i;

	handle = cray_connect_sdb();
	if (handle == NULL)
		errx(1, "can not connect to XTAdmin database on the SDB");

	/* Initialize bind structures for query and result parameters */
	memset(bind_parm, 0, sizeof(bind_parm));
	bind_parm[PAR_NID].buffer_type = MYSQL_TYPE_LONG;
	bind_parm[PAR_NID].buffer      = (char *)&node_id;
	bind_parm[PAR_NID].is_unsigned = true;

	memset(bind_cols, 0, sizeof(bind_cols));
	for (i = 0; i < COLUMN_COUNT; i ++) {
		/*
		 * @buffer:	   address of variable to write into
		 * @buffer_type:   determines which variable type to use
		 * 		   - TINYINT  => MYSQL_TYPE_TINY
		 * 		   - SMALLINT => MYSQL_TYPE_SHORT
		 * 		   - INT      => MYSQL_TYPE_LONG
		 * 		   - BIGINT   => MYSQL_TYPE_LONGLONG
		 * 		   - FLOAT    => MYSQL_TYPE_FLOAT
		 * 		   - DOUBLE   => MYSQL_TYPE_DOUBLE
		 * 		   - VARCHAR
		 * 		     CHAR     => MYSQL_TYPE_STRING
		 * 		     TEXT
		 * @is_unsigned:   whether variable is unsigned
		 * @buffer_length: actual size of the @buffer in bytes
		 * @length:	   actual data length
		 * @is_null:	   indicates that result is NULL
		 * @error:	   to report potential truncation
		 */
		bind_cols[i].buffer_type = MYSQL_TYPE_LONG;
		bind_cols[i].buffer	 = (char *)&col_data[i];
		bind_cols[i].is_null	 = &is_null[i];
		bind_cols[i].error	 = &error[i];
	}

	stmt = prepare_stmt(handle, query, bind_parm, PARAM_COUNT,
					   bind_cols, COLUMN_COUNT);
	if (stmt == NULL)
		goto err;


	for (i = 0; i < ac - 1; i++) {
		if (sscanf(*++av, "%u", &node_id) != 1 &&
		    sscanf(*av, "nid%u", &node_id) != 1) {
			warnx("'%s' not in nid%%05d format", *av);
			continue;
		}

		if (!run_stmt(stmt, query, bind_cols, COLUMN_COUNT, true))
			goto err_close;

		if (i == 0)
			printf("   NID	 NODENAME    X   Y   Z\n");

		if (mysql_stmt_fetch(stmt) == 0) {
			printf("%6u c%d-%dc%ds%dn%d  %3d %3d %3d\n", node_id,
				col_data[COL_CAB], col_data[COL_ROW],
				col_data[COL_CAGE], col_data[COL_SLOT],
				col_data[COL_CHIP],
				col_data[COL_X], col_data[COL_Y],
				col_data[COL_Z]);
		} else {
			printf("%6u    NO RESULT\n", node_id);
		}
	}

	rc = 0;
err_close:	
	if (mysql_stmt_close(stmt))
		warnx("error closing statement: %s",
			mysql_stmt_error(stmt));
err:
	mysql_close(handle);

	return rc ? EXIT_FAILURE : EXIT_SUCCESS;
}
