-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Text_IO;

--  This package is needed because we want to store a reference to the log
--  file for each Simplifier. If the File_Type was stored with the other
--  data, that record would become limited private and we could not copy the
--  data (e.g. when compacting the Worker_Set).
package Log_Files is

   type Log_File is private;

   type Log_File_Set is array (Positive range <>) of Log_File;

   procedure Initialize (File_Set : out Log_File_Set);

   procedure Open (File_Name : in     String;
                   Index     :    out Positive;
                   File_Set  : in out Log_File_Set);

   procedure Close (Index    : in     Positive;
                    File_Set : in out Log_File_Set);

   function File_Type (Index    : Positive;
                       File_Set : Log_File_Set)
                      return access Ada.Text_IO.File_Type;

private

   type Ada_Text_IO_File_Type_Ptr is access Ada.Text_IO.File_Type;

   type Log_File is
      record
         In_Use : Boolean;
         FT     : Ada_Text_IO_File_Type_Ptr;
      end record;

end Log_Files;
