import matplotlib.pyplot as plt
import numpy as np


# First test case
###################
gridInit= np.loadtxt("GridInit.txt")
print("SH ", np.shape(gridInit))

gridNonConcav = np.loadtxt("NonConcaveZone.txt")
gridGather =  np.loadtxt("Grids.txt")
gridNotConcavReal = np.loadtxt("MeshNotConv.txt")

fig =plt.figure()
ax = fig.add_subplot()
for i in range(np.shape(gridInit)[0]):
    ax.add_patch(plt.Rectangle((gridInit[i,0], gridInit[i,1]), gridInit[i,2],gridInit[i,3], ls="--", ec="c", fc="none"))
for i in range(np.shape(gridNonConcav)[0]):
    ax.add_patch(plt.Rectangle((gridNonConcav[i,0], gridNonConcav[i,1]), gridNonConcav[i,2],gridNonConcav[i,3],  ec="r", fc="none"))
for i in range(np.shape(gridNotConcavReal)[0]):
    ax.add_patch(plt.Rectangle((gridNotConcavReal[i,0], gridNotConcavReal[i,1]), gridNotConcavReal[i,2],gridNotConcavReal[i,3],  ec="none", fill="green"))
plt.axis('equal')
plt.savefig("GridInit.png")
plt.close()
fig =plt.figure()
print("gridGather", gridGather)
ax = fig.add_subplot()
for i in range(np.shape(gridGather)[0]):
     ax.add_patch(plt.Rectangle((gridGather[i,0], gridGather[i,1]), gridGather[i,2],gridGather[i,3],  ec="r", fc="none"))
plt.axis('equal')
plt.savefig("GridGather.png")
plt.close('all')

# second test case
##################
gridInit= np.loadtxt("GridInit1.txt")
print("SH ", np.shape(gridInit))
gridGather =  np.loadtxt("Grids1.txt")
gridNotConcavReal = np.loadtxt("MeshNotConv1.txt")

fig =plt.figure()
ax = fig.add_subplot()
for i in range(np.shape(gridInit)[0]):
    ax.add_patch(plt.Rectangle((gridInit[i,0], gridInit[i,1]), gridInit[i,2],gridInit[i,3], ls="--", ec="c", fc="none"))
plt.axis('equal')
plt.plot([0,1],[1./3,1/3.], color= "r", label = "Concavity broken")
plt.plot([0,1],[2./3,2/3.], color= "r")
plt.vlines(x = 1./3.,  ymin = 0., ymax = 1., color = 'r')
plt.vlines(x = 2./3.,  ymin = 0., ymax = 1.,color = 'r')
plt.savefig("GridInit1.png")
plt.close()
fig =plt.figure()
ax = fig.add_subplot()
for i in range(np.shape(gridInit)[0]):
    ax.add_patch(plt.Rectangle((gridInit[i,0], gridInit[i,1]), gridInit[i,2],gridInit[i,3], ls="--", ec="c", fc="none"))
for i in range(np.shape(gridNotConcavReal)[0]):
    ax.add_patch(plt.Rectangle((gridNotConcavReal[i,0], gridNotConcavReal[i,1]), gridNotConcavReal[i,2],gridNotConcavReal[i,3],  ec="none", fill="green"))
plt.axis('equal')
plt.savefig("MeshSolNonConvave1.png")
plt.close()
fig =plt.figure()
print("gridGather", gridGather)
ax = fig.add_subplot()
for i in range(np.shape(gridGather)[0]):
     ax.add_patch(plt.Rectangle((gridGather[i,0], gridGather[i,1]), gridGather[i,2],gridGather[i,3],  ec="r", fc="none"))
plt.plot([0,1],[1./3,1/3.], color= "b", label = "Concavity broken")
plt.plot([0,1],[2./3,2/3.], color= "b")
plt.vlines(x = 1./3.,  ymin = 0., ymax = 1., color = 'b')
plt.vlines(x = 2./3.,  ymin = 0., ymax = 1.,color = 'b')
plt.axis('equal')
plt.savefig("GridGather1.png")
plt.close()
