/* ====================================================================
 * Copyright (c) 2003-2006, 2008  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CommitCmd.h"
#include "CommitParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"
#include "svn/CommitInfo.h"


CommitCmd::CommitCmd( CommitParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

CommitCmd::~CommitCmd()
{
  delete _cb;
}

void CommitCmd::run()
{
  sc::Error* err;

  _prgscb->started( _param, getCancel() );

  _client->setCommitBaton( _param->getBaton() );
  err = _client->commit( _param->getInfo(), _param->getPaths(), _param->getRecurse(),
    _param->getKeepLocks() );

  _param->setError( err );
  _prgscb->finished( _param );

  _cb->handleResult( _param, err );
}
