/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "sxinit"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "sxinit"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * config_link_arg;	/**< @brief Use a configuration link for an automated setup.  */
  char * config_link_orig;	/**< @brief Use a configuration link for an automated setup original value given at command line.  */
  const char *config_link_help; /**< @brief Use a configuration link for an automated setup help description.  */
  char * sxauthd_arg;	/**< @brief Use sxauthd credentials (provide https://[username@]host/ uri).  */
  char * sxauthd_orig;	/**< @brief Use sxauthd credentials (provide https://[username@]host/ uri) original value given at command line.  */
  const char *sxauthd_help; /**< @brief Use sxauthd credentials (provide https://[username@]host/ uri) help description.  */
  const char *list_help; /**< @brief List configured profiles and aliases help description.  */
  const char *info_help; /**< @brief Show information about a configured cluster help description.  */
  const char *delete_help; /**< @brief Delete a profile help description.  */
  int no_ssl_flag;	/**< @brief Disable secure communication (default=off).  */
  const char *no_ssl_help; /**< @brief Disable secure communication help description.  */
  char * pass_file_arg;	/**< @brief File containing user password (instead of stdin).  */
  char * pass_file_orig;	/**< @brief File containing user password (instead of stdin) original value given at command line.  */
  const char *pass_file_help; /**< @brief File containing user password (instead of stdin) help description.  */
  int port_arg;	/**< @brief Set the cluster destination TCP port (default 443 in secure mode and 80 in insecure mode).  */
  char * port_orig;	/**< @brief Set the cluster destination TCP port (default 443 in secure mode and 80 in insecure mode) original value given at command line.  */
  const char *port_help; /**< @brief Set the cluster destination TCP port (default 443 in secure mode and 80 in insecure mode) help description.  */
  char * host_list_arg;	/**< @brief List of SX hosts (IP addresses).  */
  char * host_list_orig;	/**< @brief List of SX hosts (IP addresses) original value given at command line.  */
  const char *host_list_help; /**< @brief List of SX hosts (IP addresses) help description.  */
  char * alias_arg;	/**< @brief Alias that will be used instead of full sx://[profile@]cluster/.  */
  char * alias_orig;	/**< @brief Alias that will be used instead of full sx://[profile@]cluster/ original value given at command line.  */
  const char *alias_help; /**< @brief Alias that will be used instead of full sx://[profile@]cluster/ help description.  */
  int batch_mode_flag;	/**< @brief Turn off interactive confirmations and assume yes for all questions (default=off).  */
  const char *batch_mode_help; /**< @brief Turn off interactive confirmations and assume yes for all questions help description.  */
  int force_reinit_flag;	/**< @brief Remove old cluster configuration and init from scratch (default=off).  */
  const char *force_reinit_help; /**< @brief Remove old cluster configuration and init from scratch help description.  */
  int key_flag;	/**< @brief Ask for a key instead of a password (default=off).  */
  const char *key_help; /**< @brief Ask for a key instead of a password help description.  */
  char * auth_file_arg;	/**< @brief File containing user key (instead of stdin).  */
  char * auth_file_orig;	/**< @brief File containing user key (instead of stdin) original value given at command line.  */
  const char *auth_file_help; /**< @brief File containing user key (instead of stdin) help description.  */
  int debug_flag;	/**< @brief Enable debug messages (default=off).  */
  const char *debug_help; /**< @brief Enable debug messages help description.  */
  char * config_dir_arg;	/**< @brief Path to SX configuration directory.  */
  char * config_dir_orig;	/**< @brief Path to SX configuration directory original value given at command line.  */
  const char *config_dir_help; /**< @brief Path to SX configuration directory help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int config_link_given ;	/**< @brief Whether config-link was given.  */
  unsigned int sxauthd_given ;	/**< @brief Whether sxauthd was given.  */
  unsigned int list_given ;	/**< @brief Whether list was given.  */
  unsigned int info_given ;	/**< @brief Whether info was given.  */
  unsigned int delete_given ;	/**< @brief Whether delete was given.  */
  unsigned int no_ssl_given ;	/**< @brief Whether no-ssl was given.  */
  unsigned int pass_file_given ;	/**< @brief Whether pass-file was given.  */
  unsigned int port_given ;	/**< @brief Whether port was given.  */
  unsigned int host_list_given ;	/**< @brief Whether host-list was given.  */
  unsigned int alias_given ;	/**< @brief Whether alias was given.  */
  unsigned int batch_mode_given ;	/**< @brief Whether batch-mode was given.  */
  unsigned int force_reinit_given ;	/**< @brief Whether force-reinit was given.  */
  unsigned int key_given ;	/**< @brief Whether key was given.  */
  unsigned int auth_file_given ;	/**< @brief Whether auth-file was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int config_dir_given ;	/**< @brief Whether config-dir was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *gengetopt_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
