from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


t_COMMENT = _Mock()

t_CPPCOMMENT = _Mock()

tokens = _Mock()

t_AND = '&'

t_ANDEQUAL = '&='

t_ARROW = '->'

t_CHARACTER = "(L)?\\'([^\\\\\\n]|(\\\\.))*?\\'"

t_COLON = ':'

t_COMMA = ','

t_DECREMENT = '--'

t_DIVEQUAL = '/='

t_DIVIDE = '/'

t_ELLIPSIS = '\\.\\.\\.'

t_EQ = '=='

t_EQUALS = '='

t_FLOAT = '((\\d+)(\\.\\d+)(e(\\+|-)?(\\d+))? | (\\d+)e(\\+|-)?(\\d+))([lL]|[fF])?'

t_GE = '>='

t_GT = '>'

t_ID = '[A-Za-z_][A-Za-z0-9_]*'

t_INCREMENT = '\\+\\+'

t_INTEGER = '\\d+([uU]|[lL]|[uU][lL]|[lL][uU])?'

t_LAND = '&&'

t_LBRACE = '\\{'

t_LBRACKET = '\\['

t_LE = '<='

t_LNOT = '!'

t_LOR = '\\|\\|'

t_LPAREN = '\\('

t_LSHIFT = '<<'

t_LSHIFTEQUAL = '<<='

t_LT = '<'

t_MINUS = '-'

t_MINUSEQUAL = '-='

t_MODEQUAL = '%='

t_MODULO = '%'

t_NE = '!='

t_NOT = '~'

t_OR = '\\|'

t_OREQUAL = '\\|='

t_PERIOD = '\\.'

t_PLUS = '\\+'

t_PLUSEQUAL = '\\+='

t_RBRACE = '\\}'

t_RBRACKET = '\\]'

t_RPAREN = '\\)'

t_RSHIFT = '>>'

t_RSHIFTEQUAL = '>>='

t_SEMI = ';'

t_STRING = '\\"([^\\\\\\n]|(\\\\.))*?\\"'

t_TERNARY = '\\?'

t_TIMES = '\\*'

t_TIMESEQUAL = '\\*='

t_XOR = '\\^'

t_XOREQUAL = '^='



