from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


ConfigDict = _Mock()

ElementsInfo = _Mock()

HelpDict = _Mock()

IconDict = _Mock()

MaterialEditor = _Mock()

Mca2Edf = _Mock()

McaWindow = _Mock()

OpenGL = _Mock()

PeakIdentifier = _Mock()

PyMca5 = _Mock()

PyMcaBatch = _Mock()

PyMcaDataDir = _Mock()

PyMcaDirs = _Mock()

PyMcaHKLImageWindow = _Mock()

PyMcaImageWindow = _Mock()

PyMcaMdi = _Mock()

PyMcaPostBatch = _Mock()

QDispatcher = _Mock()

QStackWidget = _Mock()

QString = _Mock()

RGBCorrelator = _Mock()

SOURCESLIST = _Mock()

ScanWindow = _Mock()

SceneGLWindow = _Mock()

StackSelector = _Mock()

SumRulesTool = _Mock()

XRFMCPyMca = _Mock()

XiaCorrect = _Mock()

backend = _Mock()

getopt = _Mock()

nativeFileDialogs = _Mock()

os = _Mock()

qt = _Mock()

sys = _Mock()

traceback = _Mock()

DEBUG = 0

OBJECT3D = _Mock()

QTVERSION = '4.8.7'

STACK = _Mock()

SUMRULES_FLAG = _Mock()

XIA_CORRECT = _Mock()

XRFMC_FLAG = _Mock()

__version__ = '5.1.2'

class Line(_Mock):
  pass
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class MyQTextBrowser(_Mock):
  pass
  AutoAll = -1
  AutoBulletList = 1
  AutoNone = 0
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  FixedColumnWidth = 3
  FixedPixelWidth = 2
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  NoWrap = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WidgetWidth = 1
  WinPanel = 3

class PixmapLabel(_Mock):
  pass
  AlignCenter = 132
  AlignRight = 2
  AlignVCenter = 128
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class Plot(_Mock):
  pass
  defaultBackend = 'matplotlib'

class PyMcaMain(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16

