package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceAutoRenewalAttribute invokes the vpc.ModifyInstanceAutoRenewalAttribute API synchronously
func (client *Client) ModifyInstanceAutoRenewalAttribute(request *ModifyInstanceAutoRenewalAttributeRequest) (response *ModifyInstanceAutoRenewalAttributeResponse, err error) {
	response = CreateModifyInstanceAutoRenewalAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceAutoRenewalAttributeWithChan invokes the vpc.ModifyInstanceAutoRenewalAttribute API asynchronously
func (client *Client) ModifyInstanceAutoRenewalAttributeWithChan(request *ModifyInstanceAutoRenewalAttributeRequest) (<-chan *ModifyInstanceAutoRenewalAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceAutoRenewalAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceAutoRenewalAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceAutoRenewalAttributeWithCallback invokes the vpc.ModifyInstanceAutoRenewalAttribute API asynchronously
func (client *Client) ModifyInstanceAutoRenewalAttributeWithCallback(request *ModifyInstanceAutoRenewalAttributeRequest, callback func(response *ModifyInstanceAutoRenewalAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceAutoRenewalAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceAutoRenewalAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceAutoRenewalAttributeRequest is the request struct for api ModifyInstanceAutoRenewalAttribute
type ModifyInstanceAutoRenewalAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Duration             requests.Integer `position:"Query" name:"Duration"`
	RenewalStatus        string           `position:"Query" name:"RenewalStatus"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	PricingCycle         string           `position:"Query" name:"PricingCycle"`
}

// ModifyInstanceAutoRenewalAttributeResponse is the response struct for api ModifyInstanceAutoRenewalAttribute
type ModifyInstanceAutoRenewalAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceAutoRenewalAttributeRequest creates a request to invoke ModifyInstanceAutoRenewalAttribute API
func CreateModifyInstanceAutoRenewalAttributeRequest() (request *ModifyInstanceAutoRenewalAttributeRequest) {
	request = &ModifyInstanceAutoRenewalAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyInstanceAutoRenewalAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceAutoRenewalAttributeResponse creates a response to parse from ModifyInstanceAutoRenewalAttribute response
func CreateModifyInstanceAutoRenewalAttributeResponse() (response *ModifyInstanceAutoRenewalAttributeResponse) {
	response = &ModifyInstanceAutoRenewalAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
