/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2008  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#define FHS_RETURN(code) { ret=(code);goto x; }

int fhs_lock(char *device, int ignore_stale);
int fhs_unlock(char *device);
char *fhs_error(char *buf, int maxlen, int err, char *device);

    
static int fhs_kill_stale(FILE *f, const char *lockfile){
    int pid, ret, err;
    char s[256];
    
    s[sizeof(s)-1]='\0';
    if (!fgets(s, sizeof(s)-1, f)) return 0;
    pid=atoi(s);
//    dbg("pid=%d\n", pid);
    if (!pid) return -4;
	ret = kill(pid, 0);
	err = errno;
	dbg("kill returns ret=%d errno=%d EINVAL=%d ESRCH=%d\n", ret, errno, EINVAL, ESRCH);
	if (!ret) {
		return -7;  	// process alive
	}else{
		if (err == EINVAL) return -4; // device is locked, details unknown
		if (err != ESRCH) return -7; // proces alive
	}

    if (unlink(lockfile)) {
		dbg("failed to unlink lockfile\n");
		return -1;
	}
	
	dbg("lockfile unlinked\n");
    return 0;
}


int fhs_lock(char *device, int ignore_stale){
    int ret = 0;
#ifndef WIN32
	//__CYGWIN__	
    gchar *c, *lockfile = NULL;
    FILE *f = NULL;
    
    c=strrchr(device, '/');
    if (!c) FHS_RETURN(-2); 
				
    lockfile=g_strdup_printf("/var/lock/LCK..%s", c+1);
    f=fopen(lockfile, "rt");
    if (f){
        if (!ignore_stale){
            FHS_RETURN(-3);
        }else{
            if (fhs_kill_stale(f, lockfile)){
                FHS_RETURN(-4);
            }
        }
        fclose(f); /* real unlink is here */
    }

    f=fopen(lockfile, "wt");
    if (!f){
        FHS_RETURN(-5);
    }else{
        fprintf(f, "%10d tucnak ", getpid()); 
        fprintf(f, "%d\n", (int)getuid());
    }
x:;
    if (f) fclose(f);
    if (lockfile) g_free(lockfile);
#endif    
    return ret;
}


int fhs_unlock(char *device){
    int ret = 0;
#ifndef WIN32
	//__CYGWIN__
    char *c, *lockfile = NULL;
    
    c=strrchr(device, '/');
    if (!c) FHS_RETURN(-2);
    
    lockfile=g_strdup_printf("/var/lock/LCK..%s", c+1);
    //dbg("fhs_unlock: unlink('%s')\n", lockfile);
    if (unlink(lockfile)) FHS_RETURN(-6);
x:;
    if (lockfile) g_free(lockfile);
#endif    
    return 0;
}


char *fhs_error(char *buf, int maxlen, int err, char *device){
    switch (err){
        case -1:
            strerror_r(errno, buf, maxlen);
            break;
        case -2:
    		g_snprintf(buf, maxlen, "Bad filename %s", device);
            break;
        case -3:
        case -4:
            g_snprintf(buf, maxlen, "Device %s is locked", device);
            break;
        case -5:
            g_snprintf(buf, maxlen, "Can't create lock file for %s", device);
            break;
        case -6:
            g_snprintf(buf, maxlen, "Can't delete lock file for %s", device);
            break;
        case -7:
            g_snprintf(buf, maxlen, "Device %s is locked, process alive", device);
            break;
        default:
            g_snprintf(buf, maxlen, "Unknown lock error %d on device %s", err, device);
            break;
    }
    return buf;
}
