/*
 * unity-webapps-base-js-object.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_WEBAPPS_BASE_JS_OBJECT_H)
#define UNITY_WEBAPPS_BASE_JS_OBJECT_H

#include <glib.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"

#include "unity-npapi-common.h"


typedef struct UnityWebappsJavascriptObjectWrapper_t
{
  NPObject object;
  
  NPP instance;
  
  char * name;
  
  // named methods, string -> UnityWebAppsNpapiMethodPtr
  GHashTable * methods;
  
  // string -> UnityWebAppsNpapiPropertyDescr *
  GHashTable * properties;
  
  // if array access is supported, right now only GET is allowed
  UnityWebAppsNpapiIndexedGetPtr array_access;
  
  // custom allocator / deallocator
  UnityWebappsDeallocatorPtr deallocator;
  
  // default invokable
  //TODO
  
  void * reserved;

} UnityWebappsJavascriptObjectWrapper;


NPObject *
unity_webapps_npapi_create_js_object (NPP instance, const char * const name);

void
unity_webapps_npapi_add_method (UnityWebappsJavascriptObjectWrapper * pWrapper
				, const char * const name
				, UnityWebAppsNpapiMethodPtr pMethod);

void
unity_webapps_npapi_add_property (UnityWebappsJavascriptObjectWrapper * pWrapper
				  , const char * const name
				  , UnityWebAppsNpapiPropertyGetPtr get
				  , UnityWebAppsNpapiPropertySetPtr set);

void
unity_webapps_npapi_add_array_support (UnityWebappsJavascriptObjectWrapper * pWrapper
				       , UnityWebAppsNpapiIndexedGetPtr access);

void
unity_webapps_npapi_set_deallocator (UnityWebappsJavascriptObjectWrapper * pWrapper
				     , UnityWebappsDeallocatorPtr deallocator);


#endif //UNITY_WEBAPPS_BASE_JS_OBJECT_H

