#!/bin/bash
# build script to compile unity-mir for armhf devices

set -e

usage() {
  echo "usage: $(basename $0) [-c] [-u]"
  echo "-c clean before building"
  echo "-u update partial chroot directory"
  echo "-h this message"
}

clean_build_dir() {
    rm -rf ${1}
    mkdir ${1}
}

BUILD_DIR=build-android-arm
NUM_JOBS=$(( $(grep -c ^processor /proc/cpuinfo) + 1 ))
_do_update_chroot=0

while getopts "cuh" OPTNAME
do
    case $OPTNAME in
      c )
        clean_build_dir ${BUILD_DIR}
        ;;
      u )
        _do_update_chroot=1
        ;;
      h )
        usage
        exit 0
        ;;
      * )
        echo "invalid option specified"
        usage
        exit 1
        ;;
    esac
done


if [ "${UNITYMIR_CHROOT_DIR}" = "" ]; then
    export UNITYMIR_CHROOT_DIR=$(pwd)/partial-armhf-chroot
fi

if [ ! -d ${UNITYMIR_CHROOT_DIR} ]; then 
    echo "no partial chroot dir detected. attempting to create one"
    _do_update_chroot=1
fi

if [ ! -d ${BUILD_DIR} ]; then 
    mkdir ${BUILD_DIR}
fi

if [ ${_do_update_chroot} -eq 1 ] ; then
    pushd scripts > /dev/null
        ./setup-partial-armhf-chroot.sh ${UNITYMIR_CHROOT_DIR}
    popd > /dev/null
    # force a clean build after an update, since CMake cache maybe out of date
    clean_build_dir ${BUILD_DIR}
fi

echo "Using UNITYMIR_CHROOT_DIR: ${UNITYMIR_CHROOT_DIR}"

pushd ${BUILD_DIR} > /dev/null 

    export CMAKE_PREFIX_PATH=${UNITYMIR_CHROOT_DIR}/usr/lib/arm-linux-gnueabihf/cmake
    export PKG_CONFIG_PATH="${UNITYMIR_CHROOT_DIR}/usr/lib/pkgconfig:${UNITYMIR_CHROOT_DIR}/usr/lib/arm-linux-gnueabihf/pkgconfig"
    export PKG_CONFIG_ALLOW_SYSTEM_CFLAGS=1
    export PKG_CONFIG_ALLOW_SYSTEM_LIBS=1
    export PKG_CONFIG_SYSROOT_DIR=${UNITYMIR_CHROOT_DIR}
    export PKG_CONFIG_EXECUTABLE=`which pkg-config`
    echo "Using PKG_CONFIG_PATH: $PKG_CONFIG_PATH"
    echo "Using PKG_CONFIG_EXECUTABLE: $PKG_CONFIG_EXECUTABLE"
    
    # These are used to make cmake select the host machine QT MOC compiler in the AutoMocInfo module
    export DEB_HOST_MULTIARCH=arm-linux-gnueabihf
    export DEB_BUILD_MULTIARCH=$(gcc -dumpmachine)

    cmake -DCMAKE_TOOLCHAIN_FILE=../cmake/LinuxCrossCompile.cmake ..
    make -j${NUM_JOBS}

popd ${BUILD_DIR} > /dev/null 
