/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	ValaList* indices;
	ValaExpression* _container;
};

static gint ValaElementAccess_private_offset;
static gpointer vala_element_access_parent_class = NULL;

static void vala_element_access_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gchar* vala_element_access_real_to_string (ValaCodeNode* base);
static void vala_element_access_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base,
                                                 ValaSymbol* sym);
static void vala_element_access_real_get_error_types (ValaCodeNode* base,
                                               ValaCollection* collection,
                                               ValaSourceReference* source_reference);
static gboolean vala_element_access_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);
static GType vala_element_access_get_type_once (void);

static inline gpointer
vala_element_access_get_instance_private (ValaElementAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaElementAccess_private_offset);
}

ValaExpression*
vala_element_access_get_container (ValaElementAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_element_access_set_container (ValaElementAccess* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp0_;
	_tmp1_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

void
vala_element_access_append_index (ValaElementAccess* self,
                                  ValaExpression* index)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	vala_collection_add ((ValaCollection*) _tmp0_, index);
	vala_code_node_set_parent_node ((ValaCodeNode*) index, (ValaCodeNode*) self);
}

ValaList*
vala_element_access_get_indices (ValaElementAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	result = _tmp0_;
	return result;
}

ValaElementAccess*
vala_element_access_construct (GType object_type,
                               ValaExpression* container,
                               ValaSourceReference* source_reference)
{
	ValaElementAccess* self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_element_access_set_container (self, container);
	return self;
}

ValaElementAccess*
vala_element_access_new (ValaExpression* container,
                         ValaSourceReference* source_reference)
{
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}

static void
vala_element_access_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_element_access_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}

static gchar*
vala_element_access_real_to_string (ValaCodeNode* base)
{
	ValaElementAccess * self;
	gchar* s = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaElementAccess*) base;
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s[", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	s = _tmp5_;
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _index_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _index_index = 0;
		_tmp6_ = self->priv->indices;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_index_list = _tmp7_;
		_tmp8_ = _index_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_index_size = _tmp10_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp11_ = _index_list;
			_tmp12_ = vala_list_get (_tmp11_, _index_index);
			index = (ValaExpression*) _tmp12_;
			if (first) {
				const gchar* _tmp13_;
				ValaExpression* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = s;
				_tmp14_ = index;
				_tmp15_ = vala_code_node_to_string ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
				_g_free0 (s);
				s = _tmp17_;
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				const gchar* _tmp18_;
				ValaExpression* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp18_ = s;
				_tmp19_ = index;
				_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf (", %s", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp18_, _tmp23_, NULL);
				_g_free0 (s);
				s = _tmp24_;
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp25_ = s;
	_tmp26_ = g_strconcat (_tmp25_, "]", NULL);
	result = _tmp26_;
	_g_free0 (s);
	return result;
}

static void
vala_element_access_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	_tmp2_ = self->priv->indices;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->indices;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_element_access_real_is_pure (ValaExpression* base)
{
	ValaElementAccess * self;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp5_ = _index_list;
			_tmp6_ = vala_list_get (_tmp5_, _index_index);
			index = (ValaExpression*) _tmp6_;
			_tmp7_ = index;
			if (!vala_expression_is_pure (_tmp7_)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp8_ = vala_element_access_get_container (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_pure (_tmp9_);
	return result;
}

static gboolean
vala_element_access_real_is_accessible (ValaExpression* base,
                                        ValaSymbol* sym)
{
	ValaElementAccess * self;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp5_ = _index_list;
			_tmp6_ = vala_list_get (_tmp5_, _index_index);
			index = (ValaExpression*) _tmp6_;
			_tmp7_ = index;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp8_ = vala_element_access_get_container (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_element_access_real_get_error_types (ValaCodeNode* base,
                                          ValaCollection* collection,
                                          ValaSourceReference* source_reference)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp9_, collection, source_reference);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}

static gboolean
vala_element_access_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaElementAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp14_ = FALSE;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaDataType* _tmp58_;
	ValaDataType* _tmp59_;
	ValaExpression* _tmp60_;
	ValaExpression* _tmp61_;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	ValaDataType* _tmp266_;
	ValaDataType* _tmp267_;
	gboolean _tmp268_;
	gboolean _tmp269_;
	gboolean result = FALSE;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_element_access_get_container (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_element_access_get_container (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp10_ = vala_element_access_get_container (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_element_access_get_container (self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp17_ = vala_element_access_get_container (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = VALA_IS_SIGNAL (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		ValaExpression* detail_expr = NULL;
		ValaList* _tmp26_;
		gpointer _tmp27_;
		ValaExpression* _tmp28_;
		ValaSemanticAnalyzer* _tmp29_;
		ValaSemanticAnalyzer* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaExpression* _tmp34_;
		gboolean _tmp35_ = FALSE;
		ValaExpression* _tmp36_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		_tmp21_ = vala_element_access_get_indices (self);
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != 1) {
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			vala_report_error (_tmp25_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp26_ = vala_element_access_get_indices (self);
		_tmp27_ = vala_list_get (_tmp26_, 0);
		detail_expr = (ValaExpression*) _tmp27_;
		_tmp28_ = detail_expr;
		_tmp29_ = vala_code_context_get_analyzer (context);
		_tmp30_ = _tmp29_;
		_tmp31_ = _tmp30_->string_type;
		_tmp32_ = vala_data_type_copy (_tmp31_);
		_tmp33_ = _tmp32_;
		vala_expression_set_target_type (_tmp28_, _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_tmp34_ = detail_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp34_, context);
		_tmp36_ = detail_expr;
		_tmp37_ = vala_expression_get_value_type (_tmp36_);
		_tmp38_ = _tmp37_;
		if (VALA_IS_NULL_TYPE (_tmp38_)) {
			_tmp35_ = TRUE;
		} else {
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaDataType* _tmp44_;
			_tmp39_ = detail_expr;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = _tmp43_->string_type;
			_tmp35_ = !vala_data_type_compatible (_tmp41_, _tmp44_);
		}
		if (_tmp35_) {
			ValaExpression* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaSourceReference* _tmp47_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp45_ = detail_expr;
			_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
			_tmp47_ = _tmp46_;
			vala_report_error (_tmp47_, "only string details are supported");
			result = FALSE;
			_vala_code_node_unref0 (detail_expr);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp48_;
		ValaList* _tmp49_;
		gint _index_size = 0;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _index_index = 0;
		_tmp48_ = vala_element_access_get_indices (self);
		_tmp49_ = _vala_iterable_ref0 (_tmp48_);
		_index_list = _tmp49_;
		_tmp50_ = _index_list;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_index_size = _tmp52_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaExpression* _tmp55_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp53_ = _index_list;
			_tmp54_ = vala_list_get (_tmp53_, _index_index);
			index = (ValaExpression*) _tmp54_;
			_tmp55_ = index;
			vala_code_node_check ((ValaCodeNode*) _tmp55_, context);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	index_int_type_check = TRUE;
	_tmp56_ = vala_element_access_get_container (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_expression_get_value_type (_tmp57_);
	_tmp59_ = _tmp58_;
	pointer_type = VALA_IS_POINTER_TYPE (_tmp59_) ? ((ValaPointerType*) _tmp59_) : NULL;
	_tmp60_ = vala_element_access_get_container (self);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_expression_get_value_type (_tmp61_);
	_tmp63_ = _tmp62_;
	if (VALA_IS_ARRAY_TYPE (_tmp63_)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaArrayType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		gboolean _tmp73_;
		gboolean _tmp74_;
		ValaArrayType* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		_tmp64_ = vala_element_access_get_container (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_expression_get_value_type (_tmp65_);
		_tmp67_ = _tmp66_;
		array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
		_tmp68_ = array_type;
		_tmp69_ = vala_array_type_get_element_type (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_data_type_copy (_tmp70_);
		_tmp72_ = _tmp71_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp72_);
		_vala_code_node_unref0 (_tmp72_);
		_tmp73_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (!_tmp74_) {
			ValaDataType* _tmp75_;
			ValaDataType* _tmp76_;
			_tmp75_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			vala_data_type_set_value_owned (_tmp76_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp77_;
			ValaExpression* _tmp78_;
			gboolean _tmp79_ = FALSE;
			gboolean _tmp80_ = FALSE;
			ValaProfile _tmp81_;
			ValaProfile _tmp82_;
			_tmp77_ = vala_element_access_get_container (self);
			_tmp78_ = _tmp77_;
			ma = VALA_IS_MEMBER_ACCESS (_tmp78_) ? ((ValaMemberAccess*) _tmp78_) : NULL;
			_tmp81_ = vala_code_context_get_profile (context);
			_tmp82_ = _tmp81_;
			if (_tmp82_ == VALA_PROFILE_GOBJECT) {
				ValaMemberAccess* _tmp83_;
				_tmp83_ = ma;
				_tmp80_ = _tmp83_ != NULL;
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
				ValaMemberAccess* _tmp84_;
				ValaSymbol* _tmp85_;
				ValaSymbol* _tmp86_;
				_tmp84_ = ma;
				_tmp85_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp79_ = VALA_IS_ARRAY_LENGTH_FIELD (_tmp86_);
			} else {
				_tmp79_ = FALSE;
			}
			if (_tmp79_) {
				ValaMemberAccess* _tmp87_;
				ValaExpression* _tmp88_;
				ValaExpression* _tmp89_;
				ValaMemberAccess* _tmp90_;
				ValaExpression* _tmp91_;
				ValaExpression* _tmp92_;
				_tmp87_ = ma;
				_tmp88_ = vala_member_access_get_inner (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_expression_set_lvalue (_tmp89_, TRUE);
				_tmp90_ = ma;
				_tmp91_ = vala_member_access_get_inner (_tmp90_);
				_tmp92_ = _tmp91_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp96_ = FALSE;
				gboolean _tmp97_ = FALSE;
				ValaMemberAccess* _tmp98_;
				_tmp98_ = ma;
				if (_tmp98_ != NULL) {
					ValaMemberAccess* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					_tmp99_ = ma;
					_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp97_ = VALA_IS_FIELD (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaMemberAccess* _tmp102_;
					ValaExpression* _tmp103_;
					ValaExpression* _tmp104_;
					_tmp102_ = ma;
					_tmp103_ = vala_member_access_get_inner (_tmp102_);
					_tmp104_ = _tmp103_;
					_tmp96_ = _tmp104_ != NULL;
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					ValaMemberAccess* _tmp105_;
					ValaExpression* _tmp106_;
					ValaExpression* _tmp107_;
					ValaSymbol* _tmp108_;
					ValaSymbol* _tmp109_;
					_tmp105_ = ma;
					_tmp106_ = vala_member_access_get_inner (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = vala_expression_get_symbol_reference (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp95_ = VALA_IS_VARIABLE (_tmp109_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaMemberAccess* _tmp110_;
					ValaExpression* _tmp111_;
					ValaExpression* _tmp112_;
					ValaDataType* _tmp113_;
					ValaDataType* _tmp114_;
					_tmp110_ = ma;
					_tmp111_ = vala_member_access_get_inner (_tmp110_);
					_tmp112_ = _tmp111_;
					_tmp113_ = vala_expression_get_value_type (_tmp112_);
					_tmp114_ = _tmp113_;
					_tmp94_ = VALA_IS_STRUCT_VALUE_TYPE (_tmp114_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaMemberAccess* _tmp115_;
					ValaExpression* _tmp116_;
					ValaExpression* _tmp117_;
					ValaDataType* _tmp118_;
					ValaDataType* _tmp119_;
					gboolean _tmp120_;
					gboolean _tmp121_;
					_tmp115_ = ma;
					_tmp116_ = vala_member_access_get_inner (_tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = vala_expression_get_value_type (_tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = vala_data_type_get_nullable (_tmp119_);
					_tmp121_ = _tmp120_;
					_tmp93_ = !_tmp121_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaMemberAccess* _tmp122_;
					ValaMemberAccess* _tmp123_;
					_tmp122_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp122_, TRUE);
					_tmp123_ = ma;
					vala_member_access_check_lvalue_access (_tmp123_);
				}
			}
		}
		_tmp124_ = array_type;
		_tmp125_ = vala_array_type_get_rank (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = vala_element_access_get_indices (self);
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		if (_tmp126_ < _tmp129_) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			ValaList* _tmp132_;
			gint _tmp133_;
			gint _tmp134_;
			ValaArrayType* _tmp135_;
			gint _tmp136_;
			gint _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_element_access_get_indices (self);
			_tmp133_ = vala_collection_get_size ((ValaCollection*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = array_type;
			_tmp136_ = vala_array_type_get_rank (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = g_strdup_printf ("%d extra indices for element access", _tmp134_ - _tmp137_);
			_tmp139_ = _tmp138_;
			vala_report_error (_tmp131_, _tmp139_);
			_g_free0 (_tmp139_);
		} else {
			ValaArrayType* _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			_tmp140_ = array_type;
			_tmp141_ = vala_array_type_get_rank (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_element_access_get_indices (self);
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			if (_tmp142_ > _tmp145_) {
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaArrayType* _tmp148_;
				gint _tmp149_;
				gint _tmp150_;
				ValaList* _tmp151_;
				gint _tmp152_;
				gint _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp147_ = _tmp146_;
				_tmp148_ = array_type;
				_tmp149_ = vala_array_type_get_rank (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = vala_element_access_get_indices (self);
				_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = g_strdup_printf ("%d missing indices for element access", _tmp150_ - _tmp153_);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp147_, _tmp155_);
				_g_free0 (_tmp155_);
			}
		}
	} else {
		gboolean _tmp156_ = FALSE;
		ValaPointerType* _tmp157_;
		_tmp157_ = pointer_type;
		if (_tmp157_ != NULL) {
			ValaPointerType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			_tmp158_ = pointer_type;
			_tmp159_ = vala_pointer_type_get_base_type (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp156_ = !vala_data_type_is_reference_type_or_type_parameter (_tmp160_);
		} else {
			_tmp156_ = FALSE;
		}
		if (_tmp156_) {
			ValaPointerType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			ValaDataType* _tmp165_;
			_tmp161_ = pointer_type;
			_tmp162_ = vala_pointer_type_get_base_type (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_data_type_copy (_tmp163_);
			_tmp165_ = _tmp164_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp165_);
			_vala_code_node_unref0 (_tmp165_);
		} else {
			gboolean _tmp166_ = FALSE;
			ValaExpression* _tmp167_;
			ValaExpression* _tmp168_;
			_tmp167_ = vala_element_access_get_container (self);
			_tmp168_ = _tmp167_;
			if (VALA_IS_MEMBER_ACCESS (_tmp168_)) {
				ValaExpression* _tmp169_;
				ValaExpression* _tmp170_;
				ValaSymbol* _tmp171_;
				ValaSymbol* _tmp172_;
				_tmp169_ = vala_element_access_get_container (self);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_expression_get_symbol_reference (_tmp170_);
				_tmp172_ = _tmp171_;
				_tmp166_ = VALA_IS_SIGNAL (_tmp172_);
			} else {
				_tmp166_ = FALSE;
			}
			if (_tmp166_) {
				ValaExpression* _tmp173_;
				ValaExpression* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaExpression* _tmp177_;
				ValaExpression* _tmp178_;
				ValaDataType* _tmp179_;
				ValaDataType* _tmp180_;
				index_int_type_check = FALSE;
				_tmp173_ = vala_element_access_get_container (self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_expression_get_symbol_reference (_tmp174_);
				_tmp176_ = _tmp175_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp176_);
				_tmp177_ = vala_element_access_get_container (self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_expression_get_value_type (_tmp178_);
				_tmp180_ = _tmp179_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp180_);
			} else {
				gboolean _tmp181_;
				gboolean _tmp182_;
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaDataType* _tmp240_;
				ValaDataType* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				gchar* _tmp245_;
				_tmp181_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp182_ = _tmp181_;
				if (_tmp182_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp183_;
					ValaExpression* _tmp184_;
					ValaDataType* _tmp185_;
					ValaDataType* _tmp186_;
					ValaSymbol* _tmp187_;
					ValaMethod* _tmp188_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp189_;
					ValaCodeNode* _tmp190_;
					gboolean _tmp191_ = FALSE;
					gboolean _tmp192_ = FALSE;
					ValaMethod* _tmp193_;
					_tmp183_ = vala_element_access_get_container (self);
					_tmp184_ = _tmp183_;
					_tmp185_ = vala_expression_get_value_type (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_data_type_get_member (_tmp186_, "set");
					_tmp188_ = VALA_IS_METHOD (_tmp187_) ? ((ValaMethod*) _tmp187_) : NULL;
					if (_tmp188_ == NULL) {
						_vala_code_node_unref0 (_tmp187_);
					}
					set_method = _tmp188_;
					_tmp189_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp190_ = _tmp189_;
					assignment = VALA_IS_ASSIGNMENT (_tmp190_) ? ((ValaAssignment*) _tmp190_) : NULL;
					_tmp193_ = set_method;
					if (_tmp193_ != NULL) {
						ValaMethod* _tmp194_;
						ValaDataType* _tmp195_;
						ValaDataType* _tmp196_;
						_tmp194_ = set_method;
						_tmp195_ = vala_callable_get_return_type ((ValaCallable*) _tmp194_);
						_tmp196_ = _tmp195_;
						_tmp192_ = VALA_IS_VOID_TYPE (_tmp196_);
					} else {
						_tmp192_ = FALSE;
					}
					if (_tmp192_) {
						ValaAssignment* _tmp197_;
						_tmp197_ = assignment;
						_tmp191_ = _tmp197_ != NULL;
					} else {
						_tmp191_ = FALSE;
					}
					if (_tmp191_) {
						gboolean _tmp198_;
						gboolean _tmp199_;
						_tmp198_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp199_ = _tmp198_;
						result = !_tmp199_;
						_vala_code_node_unref0 (set_method);
						return result;
					}
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp200_;
					ValaExpression* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaMethod* _tmp205_;
					ValaMethod* _tmp206_;
					_tmp200_ = vala_element_access_get_container (self);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_expression_get_value_type (_tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_data_type_get_member (_tmp203_, "get");
					_tmp205_ = VALA_IS_METHOD (_tmp204_) ? ((ValaMethod*) _tmp204_) : NULL;
					if (_tmp205_ == NULL) {
						_vala_code_node_unref0 (_tmp204_);
					}
					get_method = _tmp205_;
					_tmp206_ = get_method;
					if (_tmp206_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp207_;
						ValaExpression* _tmp208_;
						ValaSourceReference* _tmp209_;
						ValaSourceReference* _tmp210_;
						ValaMemberAccess* _tmp211_;
						ValaMemberAccess* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaSourceReference* _tmp214_;
						ValaMethodCall* _tmp215_;
						ValaMethodCall* _tmp216_;
						ValaMethodCall* _tmp226_;
						ValaDataType* _tmp227_;
						ValaDataType* _tmp228_;
						ValaMethodCall* _tmp229_;
						ValaDataType* _tmp230_;
						ValaDataType* _tmp231_;
						ValaCodeNode* _tmp232_;
						ValaCodeNode* _tmp233_;
						ValaMethodCall* _tmp234_;
						ValaMethodCall* _tmp235_;
						_tmp207_ = vala_element_access_get_container (self);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_member_access_new (_tmp208_, "get", _tmp210_);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_method_call_new ((ValaExpression*) _tmp212_, _tmp214_);
						_tmp216_ = _tmp215_;
						_vala_code_node_unref0 (_tmp212_);
						get_call = _tmp216_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp217_;
							ValaList* _tmp218_;
							gint _e_size = 0;
							ValaList* _tmp219_;
							gint _tmp220_;
							gint _tmp221_;
							gint _e_index = 0;
							_tmp217_ = vala_element_access_get_indices (self);
							_tmp218_ = _vala_iterable_ref0 (_tmp217_);
							_e_list = _tmp218_;
							_tmp219_ = _e_list;
							_tmp220_ = vala_collection_get_size ((ValaCollection*) _tmp219_);
							_tmp221_ = _tmp220_;
							_e_size = _tmp221_;
							_e_index = -1;
							while (TRUE) {
								ValaExpression* e = NULL;
								ValaList* _tmp222_;
								gpointer _tmp223_;
								ValaMethodCall* _tmp224_;
								ValaExpression* _tmp225_;
								_e_index = _e_index + 1;
								if (!(_e_index < _e_size)) {
									break;
								}
								_tmp222_ = _e_list;
								_tmp223_ = vala_list_get (_tmp222_, _e_index);
								e = (ValaExpression*) _tmp223_;
								_tmp224_ = get_call;
								_tmp225_ = e;
								vala_method_call_add_argument (_tmp224_, _tmp225_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp226_ = get_call;
						_tmp227_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp228_ = _tmp227_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp226_, _tmp228_);
						_tmp229_ = get_call;
						_tmp230_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp231_ = _tmp230_;
						vala_expression_set_target_type ((ValaExpression*) _tmp229_, _tmp231_);
						_tmp232_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp233_ = _tmp232_;
						_tmp234_ = get_call;
						vala_code_node_replace_expression (_tmp233_, (ValaExpression*) self, (ValaExpression*) _tmp234_);
						_tmp235_ = get_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp235_, context);
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_element_access_get_container (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_value_type (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = vala_code_node_to_string ((ValaCodeNode*) _tmp241_);
				_tmp243_ = _tmp242_;
				_tmp244_ = g_strdup_printf ("The expression `%s' does not denote an array", _tmp243_);
				_tmp245_ = _tmp244_;
				vala_report_error (_tmp237_, _tmp245_);
				_g_free0 (_tmp245_);
				_g_free0 (_tmp243_);
				result = FALSE;
				return result;
			}
		}
	}
	if (index_int_type_check) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp246_;
			ValaList* _tmp247_;
			gint _e_size = 0;
			ValaList* _tmp248_;
			gint _tmp249_;
			gint _tmp250_;
			gint _e_index = 0;
			_tmp246_ = vala_element_access_get_indices (self);
			_tmp247_ = _vala_iterable_ref0 (_tmp246_);
			_e_list = _tmp247_;
			_tmp248_ = _e_list;
			_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
			_tmp250_ = _tmp249_;
			_e_size = _tmp250_;
			_e_index = -1;
			while (TRUE) {
				ValaExpression* e = NULL;
				ValaList* _tmp251_;
				gpointer _tmp252_;
				ValaExpression* _tmp253_;
				ValaDataType* _tmp254_;
				ValaDataType* _tmp255_;
				gboolean _tmp256_ = FALSE;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				_e_index = _e_index + 1;
				if (!(_e_index < _e_size)) {
					break;
				}
				_tmp251_ = _e_list;
				_tmp252_ = vala_list_get (_tmp251_, _e_index);
				e = (ValaExpression*) _tmp252_;
				_tmp253_ = e;
				_tmp254_ = vala_expression_get_value_type (_tmp253_);
				_tmp255_ = _tmp254_;
				if (_tmp255_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					return result;
				}
				_tmp257_ = e;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				if (VALA_IS_INTEGER_TYPE (_tmp259_)) {
					_tmp256_ = TRUE;
				} else {
					ValaExpression* _tmp260_;
					ValaDataType* _tmp261_;
					ValaDataType* _tmp262_;
					_tmp260_ = e;
					_tmp261_ = vala_expression_get_value_type (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = VALA_IS_ENUM_VALUE_TYPE (_tmp262_);
				}
				if (!_tmp256_) {
					ValaExpression* _tmp263_;
					ValaSourceReference* _tmp264_;
					ValaSourceReference* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp263_ = e;
					_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp265_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	}
	_tmp266_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp267_ = _tmp266_;
	vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
	_tmp268_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp269_ = _tmp268_;
	result = !_tmp269_;
	return result;
}

static void
vala_element_access_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			ValaExpression* e = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_e_index = _e_index + 1;
			if (!(_e_index < _e_size)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = vala_list_get (_tmp7_, _e_index);
			e = (ValaExpression*) _tmp8_;
			_tmp9_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp9_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp7_ = _index_list;
			_tmp8_ = vala_list_get (_tmp7_, _index_index);
			index = (ValaExpression*) _tmp8_;
			_tmp9_ = index;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}

static void
vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp7_ = _index_list;
			_tmp8_ = vala_list_get (_tmp7_, _index_index);
			index = (ValaExpression*) _tmp8_;
			_tmp9_ = index;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}

static void
vala_element_access_class_init (ValaElementAccessClass * klass,
                                gpointer klass_data)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaElementAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_element_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_element_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_used_variables;
}

static void
vala_element_access_instance_init (ValaElementAccess * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_element_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}

static void
vala_element_access_finalize (ValaCodeNode * obj)
{
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}

/**
 * Represents an array access expression e.g. "a[1,2]".
 */
static GType
vala_element_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
	GType vala_element_access_type_id;
	vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
	ValaElementAccess_private_offset = g_type_add_instance_private (vala_element_access_type_id, sizeof (ValaElementAccessPrivate));
	return vala_element_access_type_id;
}

GType
vala_element_access_get_type (void)
{
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		GType vala_element_access_type_id;
		vala_element_access_type_id = vala_element_access_get_type_once ();
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}

