/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef CONTAINER_H
#define CONTAINER_H
/*******************
 * Class VDKContainer *
 *******************/
/*!
  \class VDKContainer
  \brief provides a base class for generic containers
 */
template <class T>
class VDKContainer
{
 protected:
  T* data;
  int count;  
 public:
  /*!
    makes a container
    \param size
   */
  VDKContainer(int count=0): 
    data(count > 0 ? new T[count]: 0),
    count(count)
    {
    }
  
  virtual ~VDKContainer()
    {
      if (data)
	delete[] data;
    }
  /*!
    Ordinal access operator
   */
  T& operator[](int n)
    {
      return data[n];
    }
  /*!
    Return container size
   */
  int size(){return count;}
  /*!
    Copy-initializer
  */
  VDKContainer(const VDKContainer<T>& c);
  /*!
    Assignement operator
   */
  VDKContainer<T>& operator=(const VDKContainer<T>& c);
  /*!
    Equality operator
  */
  int operator ==(const VDKContainer<T>& c);
  
};


template <class T>
VDKContainer<T>::VDKContainer(const VDKContainer<T>& c)
{  
  data=0;
  *this=c;
}


template <class T>
VDKContainer<T>& VDKContainer<T>::operator=(const VDKContainer<T>& c)
{
  if (this!= &c)
    {
      if(data)delete[]data;
      count=c.count;
      data= count >0 ?new T[count]:0;
      for (int i=0;i<count;i++)
	data[i]=c.data[i];
    }
  return *this;
}


template <class T>
int VDKContainer<T>::operator ==(const VDKContainer<T>& c)
{
  int i=0;
  if(count!=c.count)return 0;
  for (;(i<count) && (data[i]==c.data[i]);i++);
  return i==count ?1:0;
}

#endif



