/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_PWizard_main_form_h_
#define _vdkb_PWizard_main_form_h_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// vdk support
#include <vdk/vdk.h>

#define MAX_STEP 1
typedef
struct VDKBNewProjectInfo
{
VDKString prjname,author,email;
bool isValid,gpld;
int type;
};

// Vdkb_PWizard FORM  CLASS
class Vdkb_PWizardForm: public VDKForm
{
// gui object declarations
private:
// gui object declarations
  void GUISetup(void);
  void SetPaths (void);
  VDKFrame* steps[MAX_STEP+1];
  int activeStep;
  VDKBNewProjectInfo* info;
public:
	Vdkb_PWizardForm(VDKForm* owner, char* title,
		VDKBNewProjectInfo* info = NULL);
	~Vdkb_PWizardForm();
	void Setup(void);
/*
 gui setup include
 do not patch below here
*/
/*
vdkb_PWizard gui header
*/
protected: VDKBox* vbox4;
protected: VDKFrame* step1frame;
protected: VDKBox* step1;
protected: VDKEventBox* iconbox;
protected: VDKPixmap* vdk_pix;
protected: VDKPixmap* console_pix;
protected: VDKPixmap* gnome_pix;
protected: VDKRadioButtonGroup* prjtypegroup;
protected: VDKRadioButton* vdk;
protected: VDKRadioButton* console;
protected: VDKRadioButton* gnome;
protected: VDKFrame* frame1;
protected: VDKEventBox* labelbox;
protected: VDKLabel* prj_info_label;
protected: VDKFrame* step2frame;
protected: VDKFixed* step2;
protected: VDKLabel* label1;
protected: VDKLabel* label2;
protected: VDKLabel* label3;
protected: VDKEntry* prjroot;
protected: VDKEntry* prjname;
protected: VDKEntry* abspath;
protected: VDKCustomButton* browsedir;
protected: VDKSeparator* separator1;
protected: VDKTextView* filestree;
protected: VDKSeparator* separator2;
protected: VDKBox* buttonsbox;
	VDKEntry* author,*email;
	VDKCheckButton* gpld;
	/* 
	   protected: VDKCustomButton* prev;
	   protected: VDKCustomButton* next;
	   protected: VDKCustomButton* finish;
	   protected: VDKCustomButton* cancel;
	*/
 protected: VDKHLButton* prev;
 protected: VDKHLButton* next;
 protected: VDKHLButton* finish;
 protected: VDKHLButton* cancel;

public:
DECLARE_SIGNAL_MAP(Vdkb_PWizardForm);
bool OnprevClick(VDKObject* sender);
bool OnnextClick(VDKObject* sender);
bool OncancelClick(VDKObject* sender);
bool OnrbgroupToggled(VDKObject* sender);
bool OnbrowsedirClick(VDKObject* sender);
bool OnprjnameChanged(VDKObject* sender);
bool OnprjrootChanged(VDKObject* sender);
bool OnfinishClick(VDKObject* sender);
/*
declaring signal and events
dynamics tables
*/
DECLARE_SIGNAL_LIST(Vdkb_PWizardForm);
DECLARE_EVENT_LIST(Vdkb_PWizardForm);
};


#endif
// do not remove this mark: #!#
// end of file:vdkb_PWizard.h
