/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.navigation;

import java.awt.Component;
import java.awt.event.MouseEvent;
import org.j3d.renderer.java3d.navigation.NavigationProcessor;
import org.j3d.ui.navigation.NavigationMouseProcessor;
import org.j3d.ui.navigation.NavigationStateListener;

public class NavigationHandler
extends NavigationProcessor
implements NavigationMouseProcessor {
    private NavigationStateListener navigationListener;
    private int navigationState;
    private int previousState = 0;
    private int buttonOneState = 0;
    private int buttonTwoState = 0;
    private int buttonThreeState = 0;
    private boolean movementInProgress = false;
    private int activeButton;
    private float speed;
    private float screenWidth;
    private float screenHeight;
    private int startMousePosX;
    private int startMousePosY;
    private float[] vectorTmp = new float[3];

    public void setButtonNavigation(int n, int n2) {
        switch (n) {
            case 16: {
                this.buttonOneState = n2;
                break;
            }
            case 8: {
                this.buttonTwoState = n2;
                break;
            }
            case 4: {
                this.buttonThreeState = n2;
            }
        }
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationListener = navigationStateListener;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.movementInProgress) {
            return;
        }
        int n = mouseEvent.getModifiers();
        this.previousState = this.getNavigationState();
        this.activeButton = n & 0x10;
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 = this.buttonOneState;
        } else if ((n & 8) != 0) {
            n2 = this.buttonTwoState;
        } else if ((n & 4) != 0) {
            n2 = this.buttonThreeState;
        }
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.navigationState);
        }
        this.setNavigationState(n2);
        if (n2 == 0) {
            return;
        }
        this.startMousePosX = mouseEvent.getX();
        this.startMousePosY = mouseEvent.getY();
        Component component = (Component)mouseEvent.getSource();
        this.screenHeight = component.getHeight();
        this.screenWidth = component.getWidth();
        this.startMove();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        float f = (float)(this.startMousePosX - mouseEvent.getX()) / this.screenWidth;
        float f2 = (float)(mouseEvent.getY() - this.startMousePosY) / this.screenHeight;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        switch (this.getNavigationState()) {
            case 4: {
                this.vectorTmp[0] = f;
                this.vectorTmp[1] = 0.0f;
                this.vectorTmp[2] = f2;
                break;
            }
            case 3: {
                this.vectorTmp[0] = -f;
                this.vectorTmp[1] = f2;
                this.vectorTmp[2] = 0.0f;
                break;
            }
            case 2: {
                this.vectorTmp[0] = f;
                this.vectorTmp[1] = f2;
                this.vectorTmp[2] = 0.0f;
                break;
            }
            case 1: {
                this.vectorTmp[0] = f;
                this.vectorTmp[1] = 0.0f;
                this.vectorTmp[2] = f2;
                break;
            }
            case 5: {
                this.vectorTmp[0] = f;
                this.vectorTmp[1] = 0.0f;
                this.vectorTmp[2] = f2;
                break;
            }
        }
        this.move(this.vectorTmp, f3);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (this.movementInProgress && ((long)n & 0x10L) != (long)this.activeButton) {
            return;
        }
        this.stopMove();
        this.movementInProgress = false;
        this.setNavigationState(this.previousState);
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.previousState);
        }
    }
}

